/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
import $protobuf from "protobufjs/minimal.js";

const $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

const $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

export const proto = $root.proto = (() => {

    const proto = {};

    proto.ADVDeviceIdentity = (function() {

        function ADVDeviceIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVDeviceIdentity.prototype.rawId = 0;
        ADVDeviceIdentity.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        ADVDeviceIdentity.prototype.keyIndex = 0;
        ADVDeviceIdentity.prototype.accountType = 0;
        ADVDeviceIdentity.prototype.deviceType = 0;

        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        ADVDeviceIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                w.uint32(8).uint32(m.rawId);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(16).uint64(m.timestamp);
            if (m.keyIndex != null && Object.hasOwnProperty.call(m, "keyIndex"))
                w.uint32(24).uint32(m.keyIndex);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(32).int32(m.accountType);
            if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                w.uint32(40).int32(m.deviceType);
            return w;
        };

        ADVDeviceIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVDeviceIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.rawId = r.uint32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.uint64();
                        break;
                    }
                case 3: {
                        m.keyIndex = r.uint32();
                        break;
                    }
                case 4: {
                        m.accountType = r.int32();
                        break;
                    }
                case 5: {
                        m.deviceType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVDeviceIdentity";
        };

        return ADVDeviceIdentity;
    })();

    proto.ADVEncryptionType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "E2EE"] = 0;
        values[valuesById[1] = "HOSTED"] = 1;
        return values;
    })();

    proto.ADVKeyIndexList = (function() {

        function ADVKeyIndexList(p) {
            this.validIndexes = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVKeyIndexList.prototype.rawId = 0;
        ADVKeyIndexList.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        ADVKeyIndexList.prototype.currentIndex = 0;
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;
        ADVKeyIndexList.prototype.accountType = 0;

        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        ADVKeyIndexList.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                w.uint32(8).uint32(m.rawId);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(16).uint64(m.timestamp);
            if (m.currentIndex != null && Object.hasOwnProperty.call(m, "currentIndex"))
                w.uint32(24).uint32(m.currentIndex);
            if (m.validIndexes != null && m.validIndexes.length) {
                w.uint32(34).fork();
                for (var i = 0; i < m.validIndexes.length; ++i)
                    w.uint32(m.validIndexes[i]);
                w.ldelim();
            }
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(40).int32(m.accountType);
            return w;
        };

        ADVKeyIndexList.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVKeyIndexList();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.rawId = r.uint32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.uint64();
                        break;
                    }
                case 3: {
                        m.currentIndex = r.uint32();
                        break;
                    }
                case 4: {
                        if (!(m.validIndexes && m.validIndexes.length))
                            m.validIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.validIndexes.push(r.uint32());
                        } else
                            m.validIndexes.push(r.uint32());
                        break;
                    }
                case 5: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVKeyIndexList";
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        function ADVSignedDeviceIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedDeviceIdentity.prototype.details = $util.newBuffer([]);
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = $util.newBuffer([]);
        ADVSignedDeviceIdentity.prototype.accountSignature = $util.newBuffer([]);
        ADVSignedDeviceIdentity.prototype.deviceSignature = $util.newBuffer([]);

        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        ADVSignedDeviceIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.accountSignatureKey != null && Object.hasOwnProperty.call(m, "accountSignatureKey"))
                w.uint32(18).bytes(m.accountSignatureKey);
            if (m.accountSignature != null && Object.hasOwnProperty.call(m, "accountSignature"))
                w.uint32(26).bytes(m.accountSignature);
            if (m.deviceSignature != null && Object.hasOwnProperty.call(m, "deviceSignature"))
                w.uint32(34).bytes(m.deviceSignature);
            return w;
        };

        ADVSignedDeviceIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedDeviceIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.accountSignatureKey = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountSignature = r.bytes();
                        break;
                    }
                case 4: {
                        m.deviceSignature = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedDeviceIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentity";
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        function ADVSignedDeviceIdentityHMAC(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedDeviceIdentityHMAC.prototype.details = $util.newBuffer([]);
        ADVSignedDeviceIdentityHMAC.prototype.hmac = $util.newBuffer([]);
        ADVSignedDeviceIdentityHMAC.prototype.accountType = 0;

        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        ADVSignedDeviceIdentityHMAC.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.hmac != null && Object.hasOwnProperty.call(m, "hmac"))
                w.uint32(18).bytes(m.hmac);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(24).int32(m.accountType);
            return w;
        };

        ADVSignedDeviceIdentityHMAC.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.hmac = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedDeviceIdentityHMAC.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedDeviceIdentityHMAC";
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        function ADVSignedKeyIndexList(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ADVSignedKeyIndexList.prototype.details = $util.newBuffer([]);
        ADVSignedKeyIndexList.prototype.accountSignature = $util.newBuffer([]);
        ADVSignedKeyIndexList.prototype.accountSignatureKey = $util.newBuffer([]);

        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        ADVSignedKeyIndexList.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                w.uint32(10).bytes(m.details);
            if (m.accountSignature != null && Object.hasOwnProperty.call(m, "accountSignature"))
                w.uint32(18).bytes(m.accountSignature);
            if (m.accountSignatureKey != null && Object.hasOwnProperty.call(m, "accountSignatureKey"))
                w.uint32(26).bytes(m.accountSignatureKey);
            return w;
        };

        ADVSignedKeyIndexList.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ADVSignedKeyIndexList();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.details = r.bytes();
                        break;
                    }
                case 2: {
                        m.accountSignature = r.bytes();
                        break;
                    }
                case 3: {
                        m.accountSignatureKey = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ADVSignedKeyIndexList.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ADVSignedKeyIndexList";
        };

        return ADVSignedKeyIndexList;
    })();

    proto.AIQueryFanout = (function() {

        function AIQueryFanout(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIQueryFanout.prototype.messageKey = null;
        AIQueryFanout.prototype.message = null;
        AIQueryFanout.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        AIQueryFanout.create = function create(properties) {
            return new AIQueryFanout(properties);
        };

        AIQueryFanout.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
            if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                $root.proto.Message.encode(m.message, w.uint32(18).fork()).ldelim();
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(24).int64(m.timestamp);
            return w;
        };

        AIQueryFanout.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIQueryFanout();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.message = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.timestamp = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIQueryFanout.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIQueryFanout";
        };

        return AIQueryFanout;
    })();

    proto.AIRichResponseMessage = (function() {

        function AIRichResponseMessage(p) {
            this.submessages = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AIRichResponseMessage.prototype.messageType = 0;
        AIRichResponseMessage.prototype.submessages = $util.emptyArray;
        AIRichResponseMessage.prototype.unifiedResponse = null;

        AIRichResponseMessage.create = function create(properties) {
            return new AIRichResponseMessage(properties);
        };

        AIRichResponseMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.messageType != null && Object.hasOwnProperty.call(m, "messageType"))
                w.uint32(8).int32(m.messageType);
            if (m.submessages != null && m.submessages.length) {
                for (var i = 0; i < m.submessages.length; ++i)
                    $root.proto.AIRichResponseMessage.AIRichResponseSubMessage.encode(m.submessages[i], w.uint32(18).fork()).ldelim();
            }
            if (m.unifiedResponse != null && Object.hasOwnProperty.call(m, "unifiedResponse"))
                $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.encode(m.unifiedResponse, w.uint32(26).fork()).ldelim();
            return w;
        };

        AIRichResponseMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.messageType = r.int32();
                        break;
                    }
                case 2: {
                        if (!(m.submessages && m.submessages.length))
                            m.submessages = [];
                        m.submessages.push($root.proto.AIRichResponseMessage.AIRichResponseSubMessage.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.unifiedResponse = $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AIRichResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AIRichResponseMessage";
        };

        AIRichResponseMessage.AIRichResponseCodeMetadata = (function() {

            function AIRichResponseCodeMetadata(p) {
                this.codeBlocks = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseCodeMetadata.prototype.codeLanguage = "";
            AIRichResponseCodeMetadata.prototype.codeBlocks = $util.emptyArray;

            AIRichResponseCodeMetadata.create = function create(properties) {
                return new AIRichResponseCodeMetadata(properties);
            };

            AIRichResponseCodeMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.codeLanguage != null && Object.hasOwnProperty.call(m, "codeLanguage"))
                    w.uint32(10).string(m.codeLanguage);
                if (m.codeBlocks != null && m.codeBlocks.length) {
                    for (var i = 0; i < m.codeBlocks.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.encode(m.codeBlocks[i], w.uint32(18).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseCodeMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.codeLanguage = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.codeBlocks && m.codeBlocks.length))
                                m.codeBlocks = [];
                            m.codeBlocks.push($root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseCodeMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseCodeMetadata";
            };

            AIRichResponseCodeMetadata.AIRichResponseCodeBlock = (function() {

                function AIRichResponseCodeBlock(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseCodeBlock.prototype.highlightType = 0;
                AIRichResponseCodeBlock.prototype.codeContent = "";

                AIRichResponseCodeBlock.create = function create(properties) {
                    return new AIRichResponseCodeBlock(properties);
                };

                AIRichResponseCodeBlock.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.highlightType != null && Object.hasOwnProperty.call(m, "highlightType"))
                        w.uint32(8).int32(m.highlightType);
                    if (m.codeContent != null && Object.hasOwnProperty.call(m, "codeContent"))
                        w.uint32(18).string(m.codeContent);
                    return w;
                };

                AIRichResponseCodeBlock.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.highlightType = r.int32();
                                break;
                            }
                        case 2: {
                                m.codeContent = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseCodeBlock.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock";
                };

                return AIRichResponseCodeBlock;
            })();

            AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD"] = 2;
                values[valuesById[3] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING"] = 3;
                values[valuesById[4] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER"] = 4;
                values[valuesById[5] = "AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT"] = 5;
                return values;
            })();

            return AIRichResponseCodeMetadata;
        })();

        AIRichResponseMessage.AIRichResponseContentItemsMetadata = (function() {

            function AIRichResponseContentItemsMetadata(p) {
                this.itemsMetadata = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseContentItemsMetadata.prototype.itemsMetadata = $util.emptyArray;
            AIRichResponseContentItemsMetadata.prototype.contentType = 0;

            AIRichResponseContentItemsMetadata.create = function create(properties) {
                return new AIRichResponseContentItemsMetadata(properties);
            };

            AIRichResponseContentItemsMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.itemsMetadata != null && m.itemsMetadata.length) {
                    for (var i = 0; i < m.itemsMetadata.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.encode(m.itemsMetadata[i], w.uint32(10).fork()).ldelim();
                }
                if (m.contentType != null && Object.hasOwnProperty.call(m, "contentType"))
                    w.uint32(16).int32(m.contentType);
                return w;
            };

            AIRichResponseContentItemsMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.itemsMetadata && m.itemsMetadata.length))
                                m.itemsMetadata = [];
                            m.itemsMetadata.push($root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.decode(r, r.uint32()));
                            break;
                        }
                    case 2: {
                            m.contentType = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseContentItemsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata";
            };

            AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata = (function() {

                function AIRichResponseContentItemMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseContentItemMetadata.prototype.reelItem = null;

                let $oneOfFields;

                Object.defineProperty(AIRichResponseContentItemMetadata.prototype, "aIRichResponseContentItem", {
                    get: $util.oneOfGetter($oneOfFields = ["reelItem"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                AIRichResponseContentItemMetadata.create = function create(properties) {
                    return new AIRichResponseContentItemMetadata(properties);
                };

                AIRichResponseContentItemMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.reelItem != null && Object.hasOwnProperty.call(m, "reelItem"))
                        $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.encode(m.reelItem, w.uint32(10).fork()).ldelim();
                    return w;
                };

                AIRichResponseContentItemMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.reelItem = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseContentItemMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata";
                };

                return AIRichResponseContentItemMetadata;
            })();

            AIRichResponseContentItemsMetadata.AIRichResponseReelItem = (function() {

                function AIRichResponseReelItem(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseReelItem.prototype.title = "";
                AIRichResponseReelItem.prototype.profileIconUrl = "";
                AIRichResponseReelItem.prototype.thumbnailUrl = "";
                AIRichResponseReelItem.prototype.videoUrl = "";

                AIRichResponseReelItem.create = function create(properties) {
                    return new AIRichResponseReelItem(properties);
                };

                AIRichResponseReelItem.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.profileIconUrl != null && Object.hasOwnProperty.call(m, "profileIconUrl"))
                        w.uint32(18).string(m.profileIconUrl);
                    if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                        w.uint32(26).string(m.thumbnailUrl);
                    if (m.videoUrl != null && Object.hasOwnProperty.call(m, "videoUrl"))
                        w.uint32(34).string(m.videoUrl);
                    return w;
                };

                AIRichResponseReelItem.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.profileIconUrl = r.string();
                                break;
                            }
                        case 3: {
                                m.thumbnailUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.videoUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseReelItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem";
                };

                return AIRichResponseReelItem;
            })();

            AIRichResponseContentItemsMetadata.ContentType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "DEFAULT"] = 0;
                values[valuesById[1] = "CAROUSEL"] = 1;
                return values;
            })();

            return AIRichResponseContentItemsMetadata;
        })();

        AIRichResponseMessage.AIRichResponseDynamicMetadata = (function() {

            function AIRichResponseDynamicMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseDynamicMetadata.prototype.type = 0;
            AIRichResponseDynamicMetadata.prototype.version = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            AIRichResponseDynamicMetadata.prototype.url = "";
            AIRichResponseDynamicMetadata.prototype.loopCount = 0;

            AIRichResponseDynamicMetadata.create = function create(properties) {
                return new AIRichResponseDynamicMetadata(properties);
            };

            AIRichResponseDynamicMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(8).int32(m.type);
                if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                    w.uint32(16).uint64(m.version);
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(26).string(m.url);
                if (m.loopCount != null && Object.hasOwnProperty.call(m, "loopCount"))
                    w.uint32(32).uint32(m.loopCount);
                return w;
            };

            AIRichResponseDynamicMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.type = r.int32();
                            break;
                        }
                    case 2: {
                            m.version = r.uint64();
                            break;
                        }
                    case 3: {
                            m.url = r.string();
                            break;
                        }
                    case 4: {
                            m.loopCount = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseDynamicMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseDynamicMetadata";
            };

            AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF"] = 2;
                return values;
            })();

            return AIRichResponseDynamicMetadata;
        })();

        AIRichResponseMessage.AIRichResponseGridImageMetadata = (function() {

            function AIRichResponseGridImageMetadata(p) {
                this.imageUrls = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseGridImageMetadata.prototype.gridImageUrl = null;
            AIRichResponseGridImageMetadata.prototype.imageUrls = $util.emptyArray;

            AIRichResponseGridImageMetadata.create = function create(properties) {
                return new AIRichResponseGridImageMetadata(properties);
            };

            AIRichResponseGridImageMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.gridImageUrl != null && Object.hasOwnProperty.call(m, "gridImageUrl"))
                    $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(m.gridImageUrl, w.uint32(10).fork()).ldelim();
                if (m.imageUrls != null && m.imageUrls.length) {
                    for (var i = 0; i < m.imageUrls.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(m.imageUrls[i], w.uint32(18).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseGridImageMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.gridImageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            if (!(m.imageUrls && m.imageUrls.length))
                                m.imageUrls = [];
                            m.imageUrls.push($root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseGridImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseGridImageMetadata";
            };

            return AIRichResponseGridImageMetadata;
        })();

        AIRichResponseMessage.AIRichResponseImageURL = (function() {

            function AIRichResponseImageURL(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseImageURL.prototype.imagePreviewUrl = "";
            AIRichResponseImageURL.prototype.imageHighResUrl = "";
            AIRichResponseImageURL.prototype.sourceUrl = "";

            AIRichResponseImageURL.create = function create(properties) {
                return new AIRichResponseImageURL(properties);
            };

            AIRichResponseImageURL.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.imagePreviewUrl != null && Object.hasOwnProperty.call(m, "imagePreviewUrl"))
                    w.uint32(10).string(m.imagePreviewUrl);
                if (m.imageHighResUrl != null && Object.hasOwnProperty.call(m, "imageHighResUrl"))
                    w.uint32(18).string(m.imageHighResUrl);
                if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                    w.uint32(26).string(m.sourceUrl);
                return w;
            };

            AIRichResponseImageURL.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseImageURL();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.imagePreviewUrl = r.string();
                            break;
                        }
                    case 2: {
                            m.imageHighResUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.sourceUrl = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseImageURL.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseImageURL";
            };

            return AIRichResponseImageURL;
        })();

        AIRichResponseMessage.AIRichResponseInlineImageMetadata = (function() {

            function AIRichResponseInlineImageMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseInlineImageMetadata.prototype.imageUrl = null;
            AIRichResponseInlineImageMetadata.prototype.imageText = "";
            AIRichResponseInlineImageMetadata.prototype.alignment = 0;
            AIRichResponseInlineImageMetadata.prototype.tapLinkUrl = "";

            AIRichResponseInlineImageMetadata.create = function create(properties) {
                return new AIRichResponseInlineImageMetadata(properties);
            };

            AIRichResponseInlineImageMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.imageUrl != null && Object.hasOwnProperty.call(m, "imageUrl"))
                    $root.proto.AIRichResponseMessage.AIRichResponseImageURL.encode(m.imageUrl, w.uint32(10).fork()).ldelim();
                if (m.imageText != null && Object.hasOwnProperty.call(m, "imageText"))
                    w.uint32(18).string(m.imageText);
                if (m.alignment != null && Object.hasOwnProperty.call(m, "alignment"))
                    w.uint32(24).int32(m.alignment);
                if (m.tapLinkUrl != null && Object.hasOwnProperty.call(m, "tapLinkUrl"))
                    w.uint32(34).string(m.tapLinkUrl);
                return w;
            };

            AIRichResponseInlineImageMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.imageUrl = $root.proto.AIRichResponseMessage.AIRichResponseImageURL.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.imageText = r.string();
                            break;
                        }
                    case 3: {
                            m.alignment = r.int32();
                            break;
                        }
                    case 4: {
                            m.tapLinkUrl = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseInlineImageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata";
            };

            AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED"] = 0;
                values[valuesById[1] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED"] = 1;
                values[valuesById[2] = "AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED"] = 2;
                return values;
            })();

            return AIRichResponseInlineImageMetadata;
        })();

        AIRichResponseMessage.AIRichResponseLatexMetadata = (function() {

            function AIRichResponseLatexMetadata(p) {
                this.expressions = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseLatexMetadata.prototype.text = "";
            AIRichResponseLatexMetadata.prototype.expressions = $util.emptyArray;

            AIRichResponseLatexMetadata.create = function create(properties) {
                return new AIRichResponseLatexMetadata(properties);
            };

            AIRichResponseLatexMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.expressions != null && m.expressions.length) {
                    for (var i = 0; i < m.expressions.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.encode(m.expressions[i], w.uint32(18).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseLatexMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.expressions && m.expressions.length))
                                m.expressions = [];
                            m.expressions.push($root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseLatexMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseLatexMetadata";
            };

            AIRichResponseLatexMetadata.AIRichResponseLatexExpression = (function() {

                function AIRichResponseLatexExpression(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseLatexExpression.prototype.latexExpression = "";
                AIRichResponseLatexExpression.prototype.url = "";
                AIRichResponseLatexExpression.prototype.width = 0;
                AIRichResponseLatexExpression.prototype.height = 0;
                AIRichResponseLatexExpression.prototype.fontHeight = 0;
                AIRichResponseLatexExpression.prototype.imageTopPadding = 0;
                AIRichResponseLatexExpression.prototype.imageLeadingPadding = 0;
                AIRichResponseLatexExpression.prototype.imageBottomPadding = 0;
                AIRichResponseLatexExpression.prototype.imageTrailingPadding = 0;

                AIRichResponseLatexExpression.create = function create(properties) {
                    return new AIRichResponseLatexExpression(properties);
                };

                AIRichResponseLatexExpression.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.latexExpression != null && Object.hasOwnProperty.call(m, "latexExpression"))
                        w.uint32(10).string(m.latexExpression);
                    if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                        w.uint32(18).string(m.url);
                    if (m.width != null && Object.hasOwnProperty.call(m, "width"))
                        w.uint32(25).double(m.width);
                    if (m.height != null && Object.hasOwnProperty.call(m, "height"))
                        w.uint32(33).double(m.height);
                    if (m.fontHeight != null && Object.hasOwnProperty.call(m, "fontHeight"))
                        w.uint32(41).double(m.fontHeight);
                    if (m.imageTopPadding != null && Object.hasOwnProperty.call(m, "imageTopPadding"))
                        w.uint32(49).double(m.imageTopPadding);
                    if (m.imageLeadingPadding != null && Object.hasOwnProperty.call(m, "imageLeadingPadding"))
                        w.uint32(57).double(m.imageLeadingPadding);
                    if (m.imageBottomPadding != null && Object.hasOwnProperty.call(m, "imageBottomPadding"))
                        w.uint32(65).double(m.imageBottomPadding);
                    if (m.imageTrailingPadding != null && Object.hasOwnProperty.call(m, "imageTrailingPadding"))
                        w.uint32(73).double(m.imageTrailingPadding);
                    return w;
                };

                AIRichResponseLatexExpression.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.latexExpression = r.string();
                                break;
                            }
                        case 2: {
                                m.url = r.string();
                                break;
                            }
                        case 3: {
                                m.width = r.double();
                                break;
                            }
                        case 4: {
                                m.height = r.double();
                                break;
                            }
                        case 5: {
                                m.fontHeight = r.double();
                                break;
                            }
                        case 6: {
                                m.imageTopPadding = r.double();
                                break;
                            }
                        case 7: {
                                m.imageLeadingPadding = r.double();
                                break;
                            }
                        case 8: {
                                m.imageBottomPadding = r.double();
                                break;
                            }
                        case 9: {
                                m.imageTrailingPadding = r.double();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseLatexExpression.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression";
                };

                return AIRichResponseLatexExpression;
            })();

            return AIRichResponseLatexMetadata;
        })();

        AIRichResponseMessage.AIRichResponseMapMetadata = (function() {

            function AIRichResponseMapMetadata(p) {
                this.annotations = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseMapMetadata.prototype.centerLatitude = 0;
            AIRichResponseMapMetadata.prototype.centerLongitude = 0;
            AIRichResponseMapMetadata.prototype.latitudeDelta = 0;
            AIRichResponseMapMetadata.prototype.longitudeDelta = 0;
            AIRichResponseMapMetadata.prototype.annotations = $util.emptyArray;
            AIRichResponseMapMetadata.prototype.showInfoList = false;

            AIRichResponseMapMetadata.create = function create(properties) {
                return new AIRichResponseMapMetadata(properties);
            };

            AIRichResponseMapMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.centerLatitude != null && Object.hasOwnProperty.call(m, "centerLatitude"))
                    w.uint32(9).double(m.centerLatitude);
                if (m.centerLongitude != null && Object.hasOwnProperty.call(m, "centerLongitude"))
                    w.uint32(17).double(m.centerLongitude);
                if (m.latitudeDelta != null && Object.hasOwnProperty.call(m, "latitudeDelta"))
                    w.uint32(25).double(m.latitudeDelta);
                if (m.longitudeDelta != null && Object.hasOwnProperty.call(m, "longitudeDelta"))
                    w.uint32(33).double(m.longitudeDelta);
                if (m.annotations != null && m.annotations.length) {
                    for (var i = 0; i < m.annotations.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.encode(m.annotations[i], w.uint32(42).fork()).ldelim();
                }
                if (m.showInfoList != null && Object.hasOwnProperty.call(m, "showInfoList"))
                    w.uint32(48).bool(m.showInfoList);
                return w;
            };

            AIRichResponseMapMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.centerLatitude = r.double();
                            break;
                        }
                    case 2: {
                            m.centerLongitude = r.double();
                            break;
                        }
                    case 3: {
                            m.latitudeDelta = r.double();
                            break;
                        }
                    case 4: {
                            m.longitudeDelta = r.double();
                            break;
                        }
                    case 5: {
                            if (!(m.annotations && m.annotations.length))
                                m.annotations = [];
                            m.annotations.push($root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.decode(r, r.uint32()));
                            break;
                        }
                    case 6: {
                            m.showInfoList = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseMapMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseMapMetadata";
            };

            AIRichResponseMapMetadata.AIRichResponseMapAnnotation = (function() {

                function AIRichResponseMapAnnotation(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseMapAnnotation.prototype.annotationNumber = 0;
                AIRichResponseMapAnnotation.prototype.latitude = 0;
                AIRichResponseMapAnnotation.prototype.longitude = 0;
                AIRichResponseMapAnnotation.prototype.title = "";
                AIRichResponseMapAnnotation.prototype.body = "";

                AIRichResponseMapAnnotation.create = function create(properties) {
                    return new AIRichResponseMapAnnotation(properties);
                };

                AIRichResponseMapAnnotation.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.annotationNumber != null && Object.hasOwnProperty.call(m, "annotationNumber"))
                        w.uint32(8).uint32(m.annotationNumber);
                    if (m.latitude != null && Object.hasOwnProperty.call(m, "latitude"))
                        w.uint32(17).double(m.latitude);
                    if (m.longitude != null && Object.hasOwnProperty.call(m, "longitude"))
                        w.uint32(25).double(m.longitude);
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(34).string(m.title);
                    if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                        w.uint32(42).string(m.body);
                    return w;
                };

                AIRichResponseMapAnnotation.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.annotationNumber = r.uint32();
                                break;
                            }
                        case 2: {
                                m.latitude = r.double();
                                break;
                            }
                        case 3: {
                                m.longitude = r.double();
                                break;
                            }
                        case 4: {
                                m.title = r.string();
                                break;
                            }
                        case 5: {
                                m.body = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseMapAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation";
                };

                return AIRichResponseMapAnnotation;
            })();

            return AIRichResponseMapMetadata;
        })();

        AIRichResponseMessage.AIRichResponseMessageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_TYPE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_TYPE_STANDARD"] = 1;
            return values;
        })();

        AIRichResponseMessage.AIRichResponseSubMessage = (function() {

            function AIRichResponseSubMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseSubMessage.prototype.messageType = 0;
            AIRichResponseSubMessage.prototype.gridImageMetadata = null;
            AIRichResponseSubMessage.prototype.messageText = "";
            AIRichResponseSubMessage.prototype.imageMetadata = null;
            AIRichResponseSubMessage.prototype.codeMetadata = null;
            AIRichResponseSubMessage.prototype.tableMetadata = null;
            AIRichResponseSubMessage.prototype.dynamicMetadata = null;
            AIRichResponseSubMessage.prototype.latexMetadata = null;
            AIRichResponseSubMessage.prototype.mapMetadata = null;
            AIRichResponseSubMessage.prototype.contentItemsMetadata = null;

            AIRichResponseSubMessage.create = function create(properties) {
                return new AIRichResponseSubMessage(properties);
            };

            AIRichResponseSubMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.messageType != null && Object.hasOwnProperty.call(m, "messageType"))
                    w.uint32(8).int32(m.messageType);
                if (m.gridImageMetadata != null && Object.hasOwnProperty.call(m, "gridImageMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.encode(m.gridImageMetadata, w.uint32(18).fork()).ldelim();
                if (m.messageText != null && Object.hasOwnProperty.call(m, "messageText"))
                    w.uint32(26).string(m.messageText);
                if (m.imageMetadata != null && Object.hasOwnProperty.call(m, "imageMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.encode(m.imageMetadata, w.uint32(34).fork()).ldelim();
                if (m.codeMetadata != null && Object.hasOwnProperty.call(m, "codeMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.encode(m.codeMetadata, w.uint32(42).fork()).ldelim();
                if (m.tableMetadata != null && Object.hasOwnProperty.call(m, "tableMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.encode(m.tableMetadata, w.uint32(50).fork()).ldelim();
                if (m.dynamicMetadata != null && Object.hasOwnProperty.call(m, "dynamicMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.encode(m.dynamicMetadata, w.uint32(58).fork()).ldelim();
                if (m.latexMetadata != null && Object.hasOwnProperty.call(m, "latexMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.encode(m.latexMetadata, w.uint32(66).fork()).ldelim();
                if (m.mapMetadata != null && Object.hasOwnProperty.call(m, "mapMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.encode(m.mapMetadata, w.uint32(74).fork()).ldelim();
                if (m.contentItemsMetadata != null && Object.hasOwnProperty.call(m, "contentItemsMetadata"))
                    $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.encode(m.contentItemsMetadata, w.uint32(82).fork()).ldelim();
                return w;
            };

            AIRichResponseSubMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseSubMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.messageType = r.int32();
                            break;
                        }
                    case 2: {
                            m.gridImageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.messageText = r.string();
                            break;
                        }
                    case 4: {
                            m.imageMetadata = $root.proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.codeMetadata = $root.proto.AIRichResponseMessage.AIRichResponseCodeMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 6: {
                            m.tableMetadata = $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 7: {
                            m.dynamicMetadata = $root.proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 8: {
                            m.latexMetadata = $root.proto.AIRichResponseMessage.AIRichResponseLatexMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 9: {
                            m.mapMetadata = $root.proto.AIRichResponseMessage.AIRichResponseMapMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 10: {
                            m.contentItemsMetadata = $root.proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseSubMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseSubMessage";
            };

            return AIRichResponseSubMessage;
        })();

        AIRichResponseMessage.AIRichResponseSubMessageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "AI_RICH_RESPONSE_UNKNOWN"] = 0;
            values[valuesById[1] = "AI_RICH_RESPONSE_GRID_IMAGE"] = 1;
            values[valuesById[2] = "AI_RICH_RESPONSE_TEXT"] = 2;
            values[valuesById[3] = "AI_RICH_RESPONSE_INLINE_IMAGE"] = 3;
            values[valuesById[4] = "AI_RICH_RESPONSE_TABLE"] = 4;
            values[valuesById[5] = "AI_RICH_RESPONSE_CODE"] = 5;
            values[valuesById[6] = "AI_RICH_RESPONSE_DYNAMIC"] = 6;
            values[valuesById[7] = "AI_RICH_RESPONSE_MAP"] = 7;
            values[valuesById[8] = "AI_RICH_RESPONSE_LATEX"] = 8;
            values[valuesById[9] = "AI_RICH_RESPONSE_CONTENT_ITEMS"] = 9;
            return values;
        })();

        AIRichResponseMessage.AIRichResponseTableMetadata = (function() {

            function AIRichResponseTableMetadata(p) {
                this.rows = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseTableMetadata.prototype.rows = $util.emptyArray;

            AIRichResponseTableMetadata.create = function create(properties) {
                return new AIRichResponseTableMetadata(properties);
            };

            AIRichResponseTableMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.rows != null && m.rows.length) {
                    for (var i = 0; i < m.rows.length; ++i)
                        $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.encode(m.rows[i], w.uint32(10).fork()).ldelim();
                }
                return w;
            };

            AIRichResponseTableMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.rows && m.rows.length))
                                m.rows = [];
                            m.rows.push($root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseTableMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseTableMetadata";
            };

            AIRichResponseTableMetadata.AIRichResponseTableRow = (function() {

                function AIRichResponseTableRow(p) {
                    this.items = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AIRichResponseTableRow.prototype.items = $util.emptyArray;
                AIRichResponseTableRow.prototype.isHeading = false;

                AIRichResponseTableRow.create = function create(properties) {
                    return new AIRichResponseTableRow(properties);
                };

                AIRichResponseTableRow.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.items != null && m.items.length) {
                        for (var i = 0; i < m.items.length; ++i)
                            w.uint32(10).string(m.items[i]);
                    }
                    if (m.isHeading != null && Object.hasOwnProperty.call(m, "isHeading"))
                        w.uint32(16).bool(m.isHeading);
                    return w;
                };

                AIRichResponseTableRow.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                if (!(m.items && m.items.length))
                                    m.items = [];
                                m.items.push(r.string());
                                break;
                            }
                        case 2: {
                                m.isHeading = r.bool();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AIRichResponseTableRow.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow";
                };

                return AIRichResponseTableRow;
            })();

            return AIRichResponseTableMetadata;
        })();

        AIRichResponseMessage.AIRichResponseUnifiedResponse = (function() {

            function AIRichResponseUnifiedResponse(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AIRichResponseUnifiedResponse.prototype.data = $util.newBuffer([]);

            AIRichResponseUnifiedResponse.create = function create(properties) {
                return new AIRichResponseUnifiedResponse(properties);
            };

            AIRichResponseUnifiedResponse.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.data != null && Object.hasOwnProperty.call(m, "data"))
                    w.uint32(10).bytes(m.data);
                return w;
            };

            AIRichResponseUnifiedResponse.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AIRichResponseMessage.AIRichResponseUnifiedResponse();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.data = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AIRichResponseUnifiedResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.AIRichResponseMessage.AIRichResponseUnifiedResponse";
            };

            return AIRichResponseUnifiedResponse;
        })();

        return AIRichResponseMessage;
    })();

    proto.Account = (function() {

        function Account(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Account.prototype.lid = "";
        Account.prototype.username = "";
        Account.prototype.countryCode = "";
        Account.prototype.isUsernameDeleted = false;

        Account.create = function create(properties) {
            return new Account(properties);
        };

        Account.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.lid != null && Object.hasOwnProperty.call(m, "lid"))
                w.uint32(10).string(m.lid);
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(18).string(m.username);
            if (m.countryCode != null && Object.hasOwnProperty.call(m, "countryCode"))
                w.uint32(26).string(m.countryCode);
            if (m.isUsernameDeleted != null && Object.hasOwnProperty.call(m, "isUsernameDeleted"))
                w.uint32(32).bool(m.isUsernameDeleted);
            return w;
        };

        Account.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Account();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.lid = r.string();
                        break;
                    }
                case 2: {
                        m.username = r.string();
                        break;
                    }
                case 3: {
                        m.countryCode = r.string();
                        break;
                    }
                case 4: {
                        m.isUsernameDeleted = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Account.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Account";
        };

        return Account;
    })();

    proto.ActionLink = (function() {

        function ActionLink(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ActionLink.prototype.url = "";
        ActionLink.prototype.buttonTitle = "";

        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        ActionLink.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                w.uint32(10).string(m.url);
            if (m.buttonTitle != null && Object.hasOwnProperty.call(m, "buttonTitle"))
                w.uint32(18).string(m.buttonTitle);
            return w;
        };

        ActionLink.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ActionLink();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.url = r.string();
                        break;
                    }
                case 2: {
                        m.buttonTitle = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ActionLink.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ActionLink";
        };

        return ActionLink;
    })();

    proto.AutoDownloadSettings = (function() {

        function AutoDownloadSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AutoDownloadSettings.prototype.downloadImages = false;
        AutoDownloadSettings.prototype.downloadAudio = false;
        AutoDownloadSettings.prototype.downloadVideo = false;
        AutoDownloadSettings.prototype.downloadDocuments = false;

        AutoDownloadSettings.create = function create(properties) {
            return new AutoDownloadSettings(properties);
        };

        AutoDownloadSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.downloadImages != null && Object.hasOwnProperty.call(m, "downloadImages"))
                w.uint32(8).bool(m.downloadImages);
            if (m.downloadAudio != null && Object.hasOwnProperty.call(m, "downloadAudio"))
                w.uint32(16).bool(m.downloadAudio);
            if (m.downloadVideo != null && Object.hasOwnProperty.call(m, "downloadVideo"))
                w.uint32(24).bool(m.downloadVideo);
            if (m.downloadDocuments != null && Object.hasOwnProperty.call(m, "downloadDocuments"))
                w.uint32(32).bool(m.downloadDocuments);
            return w;
        };

        AutoDownloadSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AutoDownloadSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.downloadImages = r.bool();
                        break;
                    }
                case 2: {
                        m.downloadAudio = r.bool();
                        break;
                    }
                case 3: {
                        m.downloadVideo = r.bool();
                        break;
                    }
                case 4: {
                        m.downloadDocuments = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AutoDownloadSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AutoDownloadSettings";
        };

        return AutoDownloadSettings;
    })();

    proto.AvatarUserSettings = (function() {

        function AvatarUserSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        AvatarUserSettings.prototype.fbid = "";
        AvatarUserSettings.prototype.password = "";

        AvatarUserSettings.create = function create(properties) {
            return new AvatarUserSettings(properties);
        };

        AvatarUserSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fbid != null && Object.hasOwnProperty.call(m, "fbid"))
                w.uint32(10).string(m.fbid);
            if (m.password != null && Object.hasOwnProperty.call(m, "password"))
                w.uint32(18).string(m.password);
            return w;
        };

        AvatarUserSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.AvatarUserSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fbid = r.string();
                        break;
                    }
                case 2: {
                        m.password = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        AvatarUserSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.AvatarUserSettings";
        };

        return AvatarUserSettings;
    })();

    proto.BizAccountLinkInfo = (function() {

        function BizAccountLinkInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        BizAccountLinkInfo.prototype.whatsappAcctNumber = "";
        BizAccountLinkInfo.prototype.issueTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        BizAccountLinkInfo.prototype.hostStorage = 0;
        BizAccountLinkInfo.prototype.accountType = 0;

        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        BizAccountLinkInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(m, "whatsappBizAcctFbid"))
                w.uint32(8).uint64(m.whatsappBizAcctFbid);
            if (m.whatsappAcctNumber != null && Object.hasOwnProperty.call(m, "whatsappAcctNumber"))
                w.uint32(18).string(m.whatsappAcctNumber);
            if (m.issueTime != null && Object.hasOwnProperty.call(m, "issueTime"))
                w.uint32(24).uint64(m.issueTime);
            if (m.hostStorage != null && Object.hasOwnProperty.call(m, "hostStorage"))
                w.uint32(32).int32(m.hostStorage);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(40).int32(m.accountType);
            return w;
        };

        BizAccountLinkInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizAccountLinkInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.whatsappBizAcctFbid = r.uint64();
                        break;
                    }
                case 2: {
                        m.whatsappAcctNumber = r.string();
                        break;
                    }
                case 3: {
                        m.issueTime = r.uint64();
                        break;
                    }
                case 4: {
                        m.hostStorage = r.int32();
                        break;
                    }
                case 5: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizAccountLinkInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountLinkInfo";
        };

        BizAccountLinkInfo.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        BizAccountLinkInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        function BizAccountPayload(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizAccountPayload.prototype.vnameCert = null;
        BizAccountPayload.prototype.bizAcctLinkInfo = $util.newBuffer([]);

        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        BizAccountPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.vnameCert != null && Object.hasOwnProperty.call(m, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(m.vnameCert, w.uint32(10).fork()).ldelim();
            if (m.bizAcctLinkInfo != null && Object.hasOwnProperty.call(m, "bizAcctLinkInfo"))
                w.uint32(18).bytes(m.bizAcctLinkInfo);
            return w;
        };

        BizAccountPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizAccountPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.vnameCert = $root.proto.VerifiedNameCertificate.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.bizAcctLinkInfo = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizAccountPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizAccountPayload";
        };

        return BizAccountPayload;
    })();

    proto.BizIdentityInfo = (function() {

        function BizIdentityInfo(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BizIdentityInfo.prototype.vlevel = 0;
        BizIdentityInfo.prototype.vnameCert = null;
        BizIdentityInfo.prototype.signed = false;
        BizIdentityInfo.prototype.revoked = false;
        BizIdentityInfo.prototype.hostStorage = 0;
        BizIdentityInfo.prototype.actualActors = 0;
        BizIdentityInfo.prototype.privacyModeTs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        BizIdentityInfo.prototype.featureControls = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        BizIdentityInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.vlevel != null && Object.hasOwnProperty.call(m, "vlevel"))
                w.uint32(8).int32(m.vlevel);
            if (m.vnameCert != null && Object.hasOwnProperty.call(m, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(m.vnameCert, w.uint32(18).fork()).ldelim();
            if (m.signed != null && Object.hasOwnProperty.call(m, "signed"))
                w.uint32(24).bool(m.signed);
            if (m.revoked != null && Object.hasOwnProperty.call(m, "revoked"))
                w.uint32(32).bool(m.revoked);
            if (m.hostStorage != null && Object.hasOwnProperty.call(m, "hostStorage"))
                w.uint32(40).int32(m.hostStorage);
            if (m.actualActors != null && Object.hasOwnProperty.call(m, "actualActors"))
                w.uint32(48).int32(m.actualActors);
            if (m.privacyModeTs != null && Object.hasOwnProperty.call(m, "privacyModeTs"))
                w.uint32(56).uint64(m.privacyModeTs);
            if (m.featureControls != null && Object.hasOwnProperty.call(m, "featureControls"))
                w.uint32(64).uint64(m.featureControls);
            return w;
        };

        BizIdentityInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BizIdentityInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.vlevel = r.int32();
                        break;
                    }
                case 2: {
                        m.vnameCert = $root.proto.VerifiedNameCertificate.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.signed = r.bool();
                        break;
                    }
                case 4: {
                        m.revoked = r.bool();
                        break;
                    }
                case 5: {
                        m.hostStorage = r.int32();
                        break;
                    }
                case 6: {
                        m.actualActors = r.int32();
                        break;
                    }
                case 7: {
                        m.privacyModeTs = r.uint64();
                        break;
                    }
                case 8: {
                        m.featureControls = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BizIdentityInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BizIdentityInfo";
        };

        BizIdentityInfo.ActualActorsType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        BizIdentityInfo.HostStorageType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        BizIdentityInfo.VerifiedLevelValue = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.BotAgeCollectionMetadata = (function() {

        function BotAgeCollectionMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotAgeCollectionMetadata.prototype.ageCollectionEligible = false;
        BotAgeCollectionMetadata.prototype.shouldTriggerAgeCollectionOnClient = false;

        BotAgeCollectionMetadata.create = function create(properties) {
            return new BotAgeCollectionMetadata(properties);
        };

        BotAgeCollectionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.ageCollectionEligible != null && Object.hasOwnProperty.call(m, "ageCollectionEligible"))
                w.uint32(8).bool(m.ageCollectionEligible);
            if (m.shouldTriggerAgeCollectionOnClient != null && Object.hasOwnProperty.call(m, "shouldTriggerAgeCollectionOnClient"))
                w.uint32(16).bool(m.shouldTriggerAgeCollectionOnClient);
            return w;
        };

        BotAgeCollectionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotAgeCollectionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.ageCollectionEligible = r.bool();
                        break;
                    }
                case 2: {
                        m.shouldTriggerAgeCollectionOnClient = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotAgeCollectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAgeCollectionMetadata";
        };

        return BotAgeCollectionMetadata;
    })();

    proto.BotAvatarMetadata = (function() {

        function BotAvatarMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotAvatarMetadata.prototype.sentiment = 0;
        BotAvatarMetadata.prototype.behaviorGraph = "";
        BotAvatarMetadata.prototype.action = 0;
        BotAvatarMetadata.prototype.intensity = 0;
        BotAvatarMetadata.prototype.wordCount = 0;

        BotAvatarMetadata.create = function create(properties) {
            return new BotAvatarMetadata(properties);
        };

        BotAvatarMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sentiment != null && Object.hasOwnProperty.call(m, "sentiment"))
                w.uint32(8).uint32(m.sentiment);
            if (m.behaviorGraph != null && Object.hasOwnProperty.call(m, "behaviorGraph"))
                w.uint32(18).string(m.behaviorGraph);
            if (m.action != null && Object.hasOwnProperty.call(m, "action"))
                w.uint32(24).uint32(m.action);
            if (m.intensity != null && Object.hasOwnProperty.call(m, "intensity"))
                w.uint32(32).uint32(m.intensity);
            if (m.wordCount != null && Object.hasOwnProperty.call(m, "wordCount"))
                w.uint32(40).uint32(m.wordCount);
            return w;
        };

        BotAvatarMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotAvatarMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sentiment = r.uint32();
                        break;
                    }
                case 2: {
                        m.behaviorGraph = r.string();
                        break;
                    }
                case 3: {
                        m.action = r.uint32();
                        break;
                    }
                case 4: {
                        m.intensity = r.uint32();
                        break;
                    }
                case 5: {
                        m.wordCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotAvatarMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotAvatarMetadata";
        };

        return BotAvatarMetadata;
    })();

    proto.BotCapabilityMetadata = (function() {

        function BotCapabilityMetadata(p) {
            this.capabilities = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotCapabilityMetadata.prototype.capabilities = $util.emptyArray;

        BotCapabilityMetadata.create = function create(properties) {
            return new BotCapabilityMetadata(properties);
        };

        BotCapabilityMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.capabilities != null && m.capabilities.length) {
                for (var i = 0; i < m.capabilities.length; ++i)
                    w.uint32(8).int32(m.capabilities[i]);
            }
            return w;
        };

        BotCapabilityMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotCapabilityMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.capabilities && m.capabilities.length))
                            m.capabilities = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.capabilities.push(r.int32());
                        } else
                            m.capabilities.push(r.int32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotCapabilityMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotCapabilityMetadata";
        };

        BotCapabilityMetadata.BotCapabilityType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "PROGRESS_INDICATOR"] = 1;
            values[valuesById[2] = "RICH_RESPONSE_HEADING"] = 2;
            values[valuesById[3] = "RICH_RESPONSE_NESTED_LIST"] = 3;
            values[valuesById[4] = "AI_MEMORY"] = 4;
            values[valuesById[5] = "RICH_RESPONSE_THREAD_SURFING"] = 5;
            values[valuesById[6] = "RICH_RESPONSE_TABLE"] = 6;
            values[valuesById[7] = "RICH_RESPONSE_CODE"] = 7;
            values[valuesById[8] = "RICH_RESPONSE_STRUCTURED_RESPONSE"] = 8;
            values[valuesById[9] = "RICH_RESPONSE_INLINE_IMAGE"] = 9;
            values[valuesById[10] = "WA_IG_1P_PLUGIN_RANKING_CONTROL"] = 10;
            values[valuesById[11] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_1"] = 11;
            values[valuesById[12] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_2"] = 12;
            values[valuesById[13] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_3"] = 13;
            values[valuesById[14] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_4"] = 14;
            values[valuesById[15] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_5"] = 15;
            values[valuesById[16] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_6"] = 16;
            values[valuesById[17] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_7"] = 17;
            values[valuesById[18] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_8"] = 18;
            values[valuesById[19] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_9"] = 19;
            values[valuesById[20] = "WA_IG_1P_PLUGIN_RANKING_UPDATE_10"] = 20;
            values[valuesById[21] = "RICH_RESPONSE_SUB_HEADING"] = 21;
            values[valuesById[22] = "RICH_RESPONSE_GRID_IMAGE"] = 22;
            values[valuesById[23] = "AI_STUDIO_UGC_MEMORY"] = 23;
            values[valuesById[24] = "RICH_RESPONSE_LATEX"] = 24;
            values[valuesById[25] = "RICH_RESPONSE_MAPS"] = 25;
            values[valuesById[26] = "RICH_RESPONSE_INLINE_REELS"] = 26;
            values[valuesById[27] = "AGENTIC_PLANNING"] = 27;
            values[valuesById[28] = "ACCOUNT_LINKING"] = 28;
            values[valuesById[29] = "STREAMING_DISAGGREGATION"] = 29;
            values[valuesById[30] = "RICH_RESPONSE_GRID_IMAGE_3P"] = 30;
            values[valuesById[31] = "RICH_RESPONSE_LATEX_INLINE"] = 31;
            values[valuesById[32] = "QUERY_PLAN"] = 32;
            values[valuesById[33] = "PROACTIVE_MESSAGE"] = 33;
            values[valuesById[34] = "RICH_RESPONSE_UNIFIED_RESPONSE"] = 34;
            values[valuesById[35] = "PROMOTION_MESSAGE"] = 35;
            return values;
        })();

        return BotCapabilityMetadata;
    })();

    proto.BotImagineMetadata = (function() {

        function BotImagineMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotImagineMetadata.prototype.imagineType = 0;

        BotImagineMetadata.create = function create(properties) {
            return new BotImagineMetadata(properties);
        };

        BotImagineMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.imagineType != null && Object.hasOwnProperty.call(m, "imagineType"))
                w.uint32(8).int32(m.imagineType);
            return w;
        };

        BotImagineMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotImagineMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.imagineType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotImagineMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotImagineMetadata";
        };

        BotImagineMetadata.ImagineType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "IMAGINE"] = 1;
            values[valuesById[2] = "MEMU"] = 2;
            values[valuesById[3] = "FLASH"] = 3;
            values[valuesById[4] = "EDIT"] = 4;
            return values;
        })();

        return BotImagineMetadata;
    })();

    proto.BotLinkedAccount = (function() {

        function BotLinkedAccount(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotLinkedAccount.prototype.type = 0;

        BotLinkedAccount.create = function create(properties) {
            return new BotLinkedAccount(properties);
        };

        BotLinkedAccount.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                w.uint32(8).int32(m.type);
            return w;
        };

        BotLinkedAccount.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotLinkedAccount();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.type = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotLinkedAccount.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccount";
        };

        BotLinkedAccount.BotLinkedAccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "BOT_LINKED_ACCOUNT_TYPE_1P"] = 0;
            return values;
        })();

        return BotLinkedAccount;
    })();

    proto.BotLinkedAccountsMetadata = (function() {

        function BotLinkedAccountsMetadata(p) {
            this.accounts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotLinkedAccountsMetadata.prototype.accounts = $util.emptyArray;
        BotLinkedAccountsMetadata.prototype.acAuthTokens = $util.newBuffer([]);
        BotLinkedAccountsMetadata.prototype.acErrorCode = 0;

        BotLinkedAccountsMetadata.create = function create(properties) {
            return new BotLinkedAccountsMetadata(properties);
        };

        BotLinkedAccountsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.accounts != null && m.accounts.length) {
                for (var i = 0; i < m.accounts.length; ++i)
                    $root.proto.BotLinkedAccount.encode(m.accounts[i], w.uint32(10).fork()).ldelim();
            }
            if (m.acAuthTokens != null && Object.hasOwnProperty.call(m, "acAuthTokens"))
                w.uint32(18).bytes(m.acAuthTokens);
            if (m.acErrorCode != null && Object.hasOwnProperty.call(m, "acErrorCode"))
                w.uint32(24).int32(m.acErrorCode);
            return w;
        };

        BotLinkedAccountsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotLinkedAccountsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.accounts && m.accounts.length))
                            m.accounts = [];
                        m.accounts.push($root.proto.BotLinkedAccount.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        m.acAuthTokens = r.bytes();
                        break;
                    }
                case 3: {
                        m.acErrorCode = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotLinkedAccountsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotLinkedAccountsMetadata";
        };

        return BotLinkedAccountsMetadata;
    })();

    proto.BotMediaMetadata = (function() {

        function BotMediaMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMediaMetadata.prototype.fileSha256 = "";
        BotMediaMetadata.prototype.mediaKey = "";
        BotMediaMetadata.prototype.fileEncSha256 = "";
        BotMediaMetadata.prototype.directPath = "";
        BotMediaMetadata.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        BotMediaMetadata.prototype.mimetype = "";
        BotMediaMetadata.prototype.orientationType = 1;

        BotMediaMetadata.create = function create(properties) {
            return new BotMediaMetadata(properties);
        };

        BotMediaMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                w.uint32(10).string(m.fileSha256);
            if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                w.uint32(18).string(m.mediaKey);
            if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                w.uint32(26).string(m.fileEncSha256);
            if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                w.uint32(34).string(m.directPath);
            if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                w.uint32(40).int64(m.mediaKeyTimestamp);
            if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                w.uint32(50).string(m.mimetype);
            if (m.orientationType != null && Object.hasOwnProperty.call(m, "orientationType"))
                w.uint32(56).int32(m.orientationType);
            return w;
        };

        BotMediaMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMediaMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fileSha256 = r.string();
                        break;
                    }
                case 2: {
                        m.mediaKey = r.string();
                        break;
                    }
                case 3: {
                        m.fileEncSha256 = r.string();
                        break;
                    }
                case 4: {
                        m.directPath = r.string();
                        break;
                    }
                case 5: {
                        m.mediaKeyTimestamp = r.int64();
                        break;
                    }
                case 6: {
                        m.mimetype = r.string();
                        break;
                    }
                case 7: {
                        m.orientationType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMediaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMediaMetadata";
        };

        BotMediaMetadata.OrientationType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "CENTER"] = 1;
            values[valuesById[2] = "LEFT"] = 2;
            values[valuesById[3] = "RIGHT"] = 3;
            return values;
        })();

        return BotMediaMetadata;
    })();

    proto.BotMemoryFact = (function() {

        function BotMemoryFact(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemoryFact.prototype.fact = "";
        BotMemoryFact.prototype.factId = "";

        BotMemoryFact.create = function create(properties) {
            return new BotMemoryFact(properties);
        };

        BotMemoryFact.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.fact != null && Object.hasOwnProperty.call(m, "fact"))
                w.uint32(10).string(m.fact);
            if (m.factId != null && Object.hasOwnProperty.call(m, "factId"))
                w.uint32(18).string(m.factId);
            return w;
        };

        BotMemoryFact.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemoryFact();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.fact = r.string();
                        break;
                    }
                case 2: {
                        m.factId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemoryFact.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryFact";
        };

        return BotMemoryFact;
    })();

    proto.BotMemoryMetadata = (function() {

        function BotMemoryMetadata(p) {
            this.addedFacts = [];
            this.removedFacts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemoryMetadata.prototype.addedFacts = $util.emptyArray;
        BotMemoryMetadata.prototype.removedFacts = $util.emptyArray;
        BotMemoryMetadata.prototype.disclaimer = "";

        BotMemoryMetadata.create = function create(properties) {
            return new BotMemoryMetadata(properties);
        };

        BotMemoryMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.addedFacts != null && m.addedFacts.length) {
                for (var i = 0; i < m.addedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(m.addedFacts[i], w.uint32(10).fork()).ldelim();
            }
            if (m.removedFacts != null && m.removedFacts.length) {
                for (var i = 0; i < m.removedFacts.length; ++i)
                    $root.proto.BotMemoryFact.encode(m.removedFacts[i], w.uint32(18).fork()).ldelim();
            }
            if (m.disclaimer != null && Object.hasOwnProperty.call(m, "disclaimer"))
                w.uint32(26).string(m.disclaimer);
            return w;
        };

        BotMemoryMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemoryMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.addedFacts && m.addedFacts.length))
                            m.addedFacts = [];
                        m.addedFacts.push($root.proto.BotMemoryFact.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        if (!(m.removedFacts && m.removedFacts.length))
                            m.removedFacts = [];
                        m.removedFacts.push($root.proto.BotMemoryFact.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.disclaimer = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemoryMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemoryMetadata";
        };

        return BotMemoryMetadata;
    })();

    proto.BotMemuMetadata = (function() {

        function BotMemuMetadata(p) {
            this.faceImages = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMemuMetadata.prototype.faceImages = $util.emptyArray;

        BotMemuMetadata.create = function create(properties) {
            return new BotMemuMetadata(properties);
        };

        BotMemuMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.faceImages != null && m.faceImages.length) {
                for (var i = 0; i < m.faceImages.length; ++i)
                    $root.proto.BotMediaMetadata.encode(m.faceImages[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotMemuMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMemuMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.faceImages && m.faceImages.length))
                            m.faceImages = [];
                        m.faceImages.push($root.proto.BotMediaMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMemuMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMemuMetadata";
        };

        return BotMemuMetadata;
    })();

    proto.BotMetadata = (function() {

        function BotMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMetadata.prototype.avatarMetadata = null;
        BotMetadata.prototype.personaId = "";
        BotMetadata.prototype.pluginMetadata = null;
        BotMetadata.prototype.suggestedPromptMetadata = null;
        BotMetadata.prototype.invokerJid = "";
        BotMetadata.prototype.sessionMetadata = null;
        BotMetadata.prototype.memuMetadata = null;
        BotMetadata.prototype.timezone = "";
        BotMetadata.prototype.reminderMetadata = null;
        BotMetadata.prototype.modelMetadata = null;
        BotMetadata.prototype.messageDisclaimerText = "";
        BotMetadata.prototype.progressIndicatorMetadata = null;
        BotMetadata.prototype.capabilityMetadata = null;
        BotMetadata.prototype.imagineMetadata = null;
        BotMetadata.prototype.memoryMetadata = null;
        BotMetadata.prototype.renderingMetadata = null;
        BotMetadata.prototype.botMetricsMetadata = null;
        BotMetadata.prototype.botLinkedAccountsMetadata = null;
        BotMetadata.prototype.richResponseSourcesMetadata = null;
        BotMetadata.prototype.aiConversationContext = $util.newBuffer([]);
        BotMetadata.prototype.botPromotionMessageMetadata = null;
        BotMetadata.prototype.botModeSelectionMetadata = null;
        BotMetadata.prototype.botQuotaMetadata = null;
        BotMetadata.prototype.botAgeCollectionMetadata = null;

        BotMetadata.create = function create(properties) {
            return new BotMetadata(properties);
        };

        BotMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.avatarMetadata != null && Object.hasOwnProperty.call(m, "avatarMetadata"))
                $root.proto.BotAvatarMetadata.encode(m.avatarMetadata, w.uint32(10).fork()).ldelim();
            if (m.personaId != null && Object.hasOwnProperty.call(m, "personaId"))
                w.uint32(18).string(m.personaId);
            if (m.pluginMetadata != null && Object.hasOwnProperty.call(m, "pluginMetadata"))
                $root.proto.BotPluginMetadata.encode(m.pluginMetadata, w.uint32(26).fork()).ldelim();
            if (m.suggestedPromptMetadata != null && Object.hasOwnProperty.call(m, "suggestedPromptMetadata"))
                $root.proto.BotSuggestedPromptMetadata.encode(m.suggestedPromptMetadata, w.uint32(34).fork()).ldelim();
            if (m.invokerJid != null && Object.hasOwnProperty.call(m, "invokerJid"))
                w.uint32(42).string(m.invokerJid);
            if (m.sessionMetadata != null && Object.hasOwnProperty.call(m, "sessionMetadata"))
                $root.proto.BotSessionMetadata.encode(m.sessionMetadata, w.uint32(50).fork()).ldelim();
            if (m.memuMetadata != null && Object.hasOwnProperty.call(m, "memuMetadata"))
                $root.proto.BotMemuMetadata.encode(m.memuMetadata, w.uint32(58).fork()).ldelim();
            if (m.timezone != null && Object.hasOwnProperty.call(m, "timezone"))
                w.uint32(66).string(m.timezone);
            if (m.reminderMetadata != null && Object.hasOwnProperty.call(m, "reminderMetadata"))
                $root.proto.BotReminderMetadata.encode(m.reminderMetadata, w.uint32(74).fork()).ldelim();
            if (m.modelMetadata != null && Object.hasOwnProperty.call(m, "modelMetadata"))
                $root.proto.BotModelMetadata.encode(m.modelMetadata, w.uint32(82).fork()).ldelim();
            if (m.messageDisclaimerText != null && Object.hasOwnProperty.call(m, "messageDisclaimerText"))
                w.uint32(90).string(m.messageDisclaimerText);
            if (m.progressIndicatorMetadata != null && Object.hasOwnProperty.call(m, "progressIndicatorMetadata"))
                $root.proto.BotProgressIndicatorMetadata.encode(m.progressIndicatorMetadata, w.uint32(98).fork()).ldelim();
            if (m.capabilityMetadata != null && Object.hasOwnProperty.call(m, "capabilityMetadata"))
                $root.proto.BotCapabilityMetadata.encode(m.capabilityMetadata, w.uint32(106).fork()).ldelim();
            if (m.imagineMetadata != null && Object.hasOwnProperty.call(m, "imagineMetadata"))
                $root.proto.BotImagineMetadata.encode(m.imagineMetadata, w.uint32(114).fork()).ldelim();
            if (m.memoryMetadata != null && Object.hasOwnProperty.call(m, "memoryMetadata"))
                $root.proto.BotMemoryMetadata.encode(m.memoryMetadata, w.uint32(122).fork()).ldelim();
            if (m.renderingMetadata != null && Object.hasOwnProperty.call(m, "renderingMetadata"))
                $root.proto.BotRenderingMetadata.encode(m.renderingMetadata, w.uint32(130).fork()).ldelim();
            if (m.botMetricsMetadata != null && Object.hasOwnProperty.call(m, "botMetricsMetadata"))
                $root.proto.BotMetricsMetadata.encode(m.botMetricsMetadata, w.uint32(138).fork()).ldelim();
            if (m.botLinkedAccountsMetadata != null && Object.hasOwnProperty.call(m, "botLinkedAccountsMetadata"))
                $root.proto.BotLinkedAccountsMetadata.encode(m.botLinkedAccountsMetadata, w.uint32(146).fork()).ldelim();
            if (m.richResponseSourcesMetadata != null && Object.hasOwnProperty.call(m, "richResponseSourcesMetadata"))
                $root.proto.BotSourcesMetadata.encode(m.richResponseSourcesMetadata, w.uint32(154).fork()).ldelim();
            if (m.aiConversationContext != null && Object.hasOwnProperty.call(m, "aiConversationContext"))
                w.uint32(162).bytes(m.aiConversationContext);
            if (m.botPromotionMessageMetadata != null && Object.hasOwnProperty.call(m, "botPromotionMessageMetadata"))
                $root.proto.BotPromotionMessageMetadata.encode(m.botPromotionMessageMetadata, w.uint32(170).fork()).ldelim();
            if (m.botModeSelectionMetadata != null && Object.hasOwnProperty.call(m, "botModeSelectionMetadata"))
                $root.proto.BotModeSelectionMetadata.encode(m.botModeSelectionMetadata, w.uint32(178).fork()).ldelim();
            if (m.botQuotaMetadata != null && Object.hasOwnProperty.call(m, "botQuotaMetadata"))
                $root.proto.BotQuotaMetadata.encode(m.botQuotaMetadata, w.uint32(186).fork()).ldelim();
            if (m.botAgeCollectionMetadata != null && Object.hasOwnProperty.call(m, "botAgeCollectionMetadata"))
                $root.proto.BotAgeCollectionMetadata.encode(m.botAgeCollectionMetadata, w.uint32(194).fork()).ldelim();
            return w;
        };

        BotMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.avatarMetadata = $root.proto.BotAvatarMetadata.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.personaId = r.string();
                        break;
                    }
                case 3: {
                        m.pluginMetadata = $root.proto.BotPluginMetadata.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.suggestedPromptMetadata = $root.proto.BotSuggestedPromptMetadata.decode(r, r.uint32());
                        break;
                    }
                case 5: {
                        m.invokerJid = r.string();
                        break;
                    }
                case 6: {
                        m.sessionMetadata = $root.proto.BotSessionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.memuMetadata = $root.proto.BotMemuMetadata.decode(r, r.uint32());
                        break;
                    }
                case 8: {
                        m.timezone = r.string();
                        break;
                    }
                case 9: {
                        m.reminderMetadata = $root.proto.BotReminderMetadata.decode(r, r.uint32());
                        break;
                    }
                case 10: {
                        m.modelMetadata = $root.proto.BotModelMetadata.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.messageDisclaimerText = r.string();
                        break;
                    }
                case 12: {
                        m.progressIndicatorMetadata = $root.proto.BotProgressIndicatorMetadata.decode(r, r.uint32());
                        break;
                    }
                case 13: {
                        m.capabilityMetadata = $root.proto.BotCapabilityMetadata.decode(r, r.uint32());
                        break;
                    }
                case 14: {
                        m.imagineMetadata = $root.proto.BotImagineMetadata.decode(r, r.uint32());
                        break;
                    }
                case 15: {
                        m.memoryMetadata = $root.proto.BotMemoryMetadata.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.renderingMetadata = $root.proto.BotRenderingMetadata.decode(r, r.uint32());
                        break;
                    }
                case 17: {
                        m.botMetricsMetadata = $root.proto.BotMetricsMetadata.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.botLinkedAccountsMetadata = $root.proto.BotLinkedAccountsMetadata.decode(r, r.uint32());
                        break;
                    }
                case 19: {
                        m.richResponseSourcesMetadata = $root.proto.BotSourcesMetadata.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.aiConversationContext = r.bytes();
                        break;
                    }
                case 21: {
                        m.botPromotionMessageMetadata = $root.proto.BotPromotionMessageMetadata.decode(r, r.uint32());
                        break;
                    }
                case 22: {
                        m.botModeSelectionMetadata = $root.proto.BotModeSelectionMetadata.decode(r, r.uint32());
                        break;
                    }
                case 23: {
                        m.botQuotaMetadata = $root.proto.BotQuotaMetadata.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.botAgeCollectionMetadata = $root.proto.BotAgeCollectionMetadata.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetadata";
        };

        return BotMetadata;
    })();

    proto.BotMetricsEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "FAVICON"] = 1;
        values[valuesById[2] = "CHATLIST"] = 2;
        values[valuesById[3] = "AISEARCH_NULL_STATE_PAPER_PLANE"] = 3;
        values[valuesById[4] = "AISEARCH_NULL_STATE_SUGGESTION"] = 4;
        values[valuesById[5] = "AISEARCH_TYPE_AHEAD_SUGGESTION"] = 5;
        values[valuesById[6] = "AISEARCH_TYPE_AHEAD_PAPER_PLANE"] = 6;
        values[valuesById[7] = "AISEARCH_TYPE_AHEAD_RESULT_CHATLIST"] = 7;
        values[valuesById[8] = "AISEARCH_TYPE_AHEAD_RESULT_MESSAGES"] = 8;
        values[valuesById[9] = "AIVOICE_SEARCH_BAR"] = 9;
        values[valuesById[10] = "AIVOICE_FAVICON"] = 10;
        values[valuesById[11] = "AISTUDIO"] = 11;
        values[valuesById[12] = "DEEPLINK"] = 12;
        values[valuesById[13] = "NOTIFICATION"] = 13;
        values[valuesById[14] = "PROFILE_MESSAGE_BUTTON"] = 14;
        values[valuesById[15] = "FORWARD"] = 15;
        values[valuesById[16] = "APP_SHORTCUT"] = 16;
        values[valuesById[17] = "FF_FAMILY"] = 17;
        values[valuesById[18] = "AI_TAB"] = 18;
        values[valuesById[19] = "AI_HOME"] = 19;
        values[valuesById[20] = "AI_DEEPLINK_IMMERSIVE"] = 20;
        values[valuesById[21] = "AI_DEEPLINK"] = 21;
        values[valuesById[22] = "META_AI_CHAT_SHORTCUT_AI_STUDIO"] = 22;
        values[valuesById[23] = "UGC_CHAT_SHORTCUT_AI_STUDIO"] = 23;
        values[valuesById[24] = "NEW_CHAT_AI_STUDIO"] = 24;
        return values;
    })();

    proto.BotMetricsMetadata = (function() {

        function BotMetricsMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotMetricsMetadata.prototype.destinationId = "";
        BotMetricsMetadata.prototype.destinationEntryPoint = 1;
        BotMetricsMetadata.prototype.threadOrigin = 1;

        BotMetricsMetadata.create = function create(properties) {
            return new BotMetricsMetadata(properties);
        };

        BotMetricsMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.destinationId != null && Object.hasOwnProperty.call(m, "destinationId"))
                w.uint32(10).string(m.destinationId);
            if (m.destinationEntryPoint != null && Object.hasOwnProperty.call(m, "destinationEntryPoint"))
                w.uint32(16).int32(m.destinationEntryPoint);
            if (m.threadOrigin != null && Object.hasOwnProperty.call(m, "threadOrigin"))
                w.uint32(24).int32(m.threadOrigin);
            return w;
        };

        BotMetricsMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotMetricsMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.destinationId = r.string();
                        break;
                    }
                case 2: {
                        m.destinationEntryPoint = r.int32();
                        break;
                    }
                case 3: {
                        m.threadOrigin = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotMetricsMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotMetricsMetadata";
        };

        return BotMetricsMetadata;
    })();

    proto.BotMetricsThreadEntryPoint = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[1] = "AI_TAB_THREAD"] = 1;
        values[valuesById[2] = "AI_HOME_THREAD"] = 2;
        values[valuesById[3] = "AI_DEEPLINK_IMMERSIVE_THREAD"] = 3;
        values[valuesById[4] = "AI_DEEPLINK_THREAD"] = 4;
        return values;
    })();

    proto.BotModeSelectionMetadata = (function() {

        function BotModeSelectionMetadata(p) {
            this.mode = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotModeSelectionMetadata.prototype.mode = $util.emptyArray;

        BotModeSelectionMetadata.create = function create(properties) {
            return new BotModeSelectionMetadata(properties);
        };

        BotModeSelectionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.mode != null && m.mode.length) {
                for (var i = 0; i < m.mode.length; ++i)
                    w.uint32(8).int32(m.mode[i]);
            }
            return w;
        };

        BotModeSelectionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotModeSelectionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.mode && m.mode.length))
                            m.mode = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.mode.push(r.int32());
                        } else
                            m.mode.push(r.int32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotModeSelectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModeSelectionMetadata";
        };

        BotModeSelectionMetadata.BotUserSelectionMode = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_MODE"] = 0;
            values[valuesById[1] = "REASONING_MODE"] = 1;
            return values;
        })();

        return BotModeSelectionMetadata;
    })();

    proto.BotModelMetadata = (function() {

        function BotModelMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotModelMetadata.prototype.modelType = 0;
        BotModelMetadata.prototype.premiumModelStatus = 0;

        BotModelMetadata.create = function create(properties) {
            return new BotModelMetadata(properties);
        };

        BotModelMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.modelType != null && Object.hasOwnProperty.call(m, "modelType"))
                w.uint32(8).int32(m.modelType);
            if (m.premiumModelStatus != null && Object.hasOwnProperty.call(m, "premiumModelStatus"))
                w.uint32(16).int32(m.premiumModelStatus);
            return w;
        };

        BotModelMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotModelMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.modelType = r.int32();
                        break;
                    }
                case 2: {
                        m.premiumModelStatus = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotModelMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotModelMetadata";
        };

        BotModelMetadata.ModelType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "LLAMA_PROD"] = 1;
            values[valuesById[2] = "LLAMA_PROD_PREMIUM"] = 2;
            return values;
        })();

        BotModelMetadata.PremiumModelStatus = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_STATUS"] = 0;
            values[valuesById[1] = "AVAILABLE"] = 1;
            values[valuesById[2] = "QUOTA_EXCEED_LIMIT"] = 2;
            return values;
        })();

        return BotModelMetadata;
    })();

    proto.BotPluginMetadata = (function() {

        function BotPluginMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPluginMetadata.prototype.provider = 0;
        BotPluginMetadata.prototype.pluginType = 0;
        BotPluginMetadata.prototype.thumbnailCdnUrl = "";
        BotPluginMetadata.prototype.profilePhotoCdnUrl = "";
        BotPluginMetadata.prototype.searchProviderUrl = "";
        BotPluginMetadata.prototype.referenceIndex = 0;
        BotPluginMetadata.prototype.expectedLinksCount = 0;
        BotPluginMetadata.prototype.searchQuery = "";
        BotPluginMetadata.prototype.parentPluginMessageKey = null;
        BotPluginMetadata.prototype.deprecatedField = 0;
        BotPluginMetadata.prototype.parentPluginType = 0;
        BotPluginMetadata.prototype.faviconCdnUrl = "";

        BotPluginMetadata.create = function create(properties) {
            return new BotPluginMetadata(properties);
        };

        BotPluginMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                w.uint32(8).int32(m.provider);
            if (m.pluginType != null && Object.hasOwnProperty.call(m, "pluginType"))
                w.uint32(16).int32(m.pluginType);
            if (m.thumbnailCdnUrl != null && Object.hasOwnProperty.call(m, "thumbnailCdnUrl"))
                w.uint32(26).string(m.thumbnailCdnUrl);
            if (m.profilePhotoCdnUrl != null && Object.hasOwnProperty.call(m, "profilePhotoCdnUrl"))
                w.uint32(34).string(m.profilePhotoCdnUrl);
            if (m.searchProviderUrl != null && Object.hasOwnProperty.call(m, "searchProviderUrl"))
                w.uint32(42).string(m.searchProviderUrl);
            if (m.referenceIndex != null && Object.hasOwnProperty.call(m, "referenceIndex"))
                w.uint32(48).uint32(m.referenceIndex);
            if (m.expectedLinksCount != null && Object.hasOwnProperty.call(m, "expectedLinksCount"))
                w.uint32(56).uint32(m.expectedLinksCount);
            if (m.searchQuery != null && Object.hasOwnProperty.call(m, "searchQuery"))
                w.uint32(74).string(m.searchQuery);
            if (m.parentPluginMessageKey != null && Object.hasOwnProperty.call(m, "parentPluginMessageKey"))
                $root.proto.MessageKey.encode(m.parentPluginMessageKey, w.uint32(82).fork()).ldelim();
            if (m.deprecatedField != null && Object.hasOwnProperty.call(m, "deprecatedField"))
                w.uint32(88).int32(m.deprecatedField);
            if (m.parentPluginType != null && Object.hasOwnProperty.call(m, "parentPluginType"))
                w.uint32(96).int32(m.parentPluginType);
            if (m.faviconCdnUrl != null && Object.hasOwnProperty.call(m, "faviconCdnUrl"))
                w.uint32(106).string(m.faviconCdnUrl);
            return w;
        };

        BotPluginMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPluginMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.provider = r.int32();
                        break;
                    }
                case 2: {
                        m.pluginType = r.int32();
                        break;
                    }
                case 3: {
                        m.thumbnailCdnUrl = r.string();
                        break;
                    }
                case 4: {
                        m.profilePhotoCdnUrl = r.string();
                        break;
                    }
                case 5: {
                        m.searchProviderUrl = r.string();
                        break;
                    }
                case 6: {
                        m.referenceIndex = r.uint32();
                        break;
                    }
                case 7: {
                        m.expectedLinksCount = r.uint32();
                        break;
                    }
                case 9: {
                        m.searchQuery = r.string();
                        break;
                    }
                case 10: {
                        m.parentPluginMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.deprecatedField = r.int32();
                        break;
                    }
                case 12: {
                        m.parentPluginType = r.int32();
                        break;
                    }
                case 13: {
                        m.faviconCdnUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPluginMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPluginMetadata";
        };

        BotPluginMetadata.PluginType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_PLUGIN"] = 0;
            values[valuesById[1] = "REELS"] = 1;
            values[valuesById[2] = "SEARCH"] = 2;
            return values;
        })();

        BotPluginMetadata.SearchProvider = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "BING"] = 1;
            values[valuesById[2] = "GOOGLE"] = 2;
            values[valuesById[3] = "SUPPORT"] = 3;
            return values;
        })();

        return BotPluginMetadata;
    })();

    proto.BotProgressIndicatorMetadata = (function() {

        function BotProgressIndicatorMetadata(p) {
            this.stepsMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotProgressIndicatorMetadata.prototype.progressDescription = "";
        BotProgressIndicatorMetadata.prototype.stepsMetadata = $util.emptyArray;

        BotProgressIndicatorMetadata.create = function create(properties) {
            return new BotProgressIndicatorMetadata(properties);
        };

        BotProgressIndicatorMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.progressDescription != null && Object.hasOwnProperty.call(m, "progressDescription"))
                w.uint32(10).string(m.progressDescription);
            if (m.stepsMetadata != null && m.stepsMetadata.length) {
                for (var i = 0; i < m.stepsMetadata.length; ++i)
                    $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.encode(m.stepsMetadata[i], w.uint32(18).fork()).ldelim();
            }
            return w;
        };

        BotProgressIndicatorMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.progressDescription = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.stepsMetadata && m.stepsMetadata.length))
                            m.stepsMetadata = [];
                        m.stepsMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotProgressIndicatorMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata";
        };

        BotProgressIndicatorMetadata.BotPlanningStepMetadata = (function() {

            function BotPlanningStepMetadata(p) {
                this.sourcesMetadata = [];
                this.sections = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotPlanningStepMetadata.prototype.statusTitle = "";
            BotPlanningStepMetadata.prototype.statusBody = "";
            BotPlanningStepMetadata.prototype.sourcesMetadata = $util.emptyArray;
            BotPlanningStepMetadata.prototype.status = 0;
            BotPlanningStepMetadata.prototype.isReasoning = false;
            BotPlanningStepMetadata.prototype.isEnhancedSearch = false;
            BotPlanningStepMetadata.prototype.sections = $util.emptyArray;

            BotPlanningStepMetadata.create = function create(properties) {
                return new BotPlanningStepMetadata(properties);
            };

            BotPlanningStepMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.statusTitle != null && Object.hasOwnProperty.call(m, "statusTitle"))
                    w.uint32(10).string(m.statusTitle);
                if (m.statusBody != null && Object.hasOwnProperty.call(m, "statusBody"))
                    w.uint32(18).string(m.statusBody);
                if (m.sourcesMetadata != null && m.sourcesMetadata.length) {
                    for (var i = 0; i < m.sourcesMetadata.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.encode(m.sourcesMetadata[i], w.uint32(26).fork()).ldelim();
                }
                if (m.status != null && Object.hasOwnProperty.call(m, "status"))
                    w.uint32(32).int32(m.status);
                if (m.isReasoning != null && Object.hasOwnProperty.call(m, "isReasoning"))
                    w.uint32(40).bool(m.isReasoning);
                if (m.isEnhancedSearch != null && Object.hasOwnProperty.call(m, "isEnhancedSearch"))
                    w.uint32(48).bool(m.isEnhancedSearch);
                if (m.sections != null && m.sections.length) {
                    for (var i = 0; i < m.sections.length; ++i)
                        $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.encode(m.sections[i], w.uint32(58).fork()).ldelim();
                }
                return w;
            };

            BotPlanningStepMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.statusTitle = r.string();
                            break;
                        }
                    case 2: {
                            m.statusBody = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.sourcesMetadata && m.sourcesMetadata.length))
                                m.sourcesMetadata = [];
                            m.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.decode(r, r.uint32()));
                            break;
                        }
                    case 4: {
                            m.status = r.int32();
                            break;
                        }
                    case 5: {
                            m.isReasoning = r.bool();
                            break;
                        }
                    case 6: {
                            m.isEnhancedSearch = r.bool();
                            break;
                        }
                    case 7: {
                            if (!(m.sections && m.sections.length))
                                m.sections = [];
                            m.sections.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotPlanningStepMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata";
            };

            BotPlanningStepMetadata.BotPlanningSearchSourceMetadata = (function() {

                function BotPlanningSearchSourceMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningSearchSourceMetadata.prototype.title = "";
                BotPlanningSearchSourceMetadata.prototype.provider = 0;
                BotPlanningSearchSourceMetadata.prototype.sourceUrl = "";
                BotPlanningSearchSourceMetadata.prototype.favIconUrl = "";

                BotPlanningSearchSourceMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourceMetadata(properties);
                };

                BotPlanningSearchSourceMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                        w.uint32(16).int32(m.provider);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    if (m.favIconUrl != null && Object.hasOwnProperty.call(m, "favIconUrl"))
                        w.uint32(34).string(m.favIconUrl);
                    return w;
                };

                BotPlanningSearchSourceMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.provider = r.int32();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.favIconUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningSearchSourceMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata";
                };

                return BotPlanningSearchSourceMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata = (function() {

                function BotPlanningSearchSourcesMetadata(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningSearchSourcesMetadata.prototype.sourceTitle = "";
                BotPlanningSearchSourcesMetadata.prototype.provider = 0;
                BotPlanningSearchSourcesMetadata.prototype.sourceUrl = "";

                BotPlanningSearchSourcesMetadata.create = function create(properties) {
                    return new BotPlanningSearchSourcesMetadata(properties);
                };

                BotPlanningSearchSourcesMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.sourceTitle != null && Object.hasOwnProperty.call(m, "sourceTitle"))
                        w.uint32(10).string(m.sourceTitle);
                    if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                        w.uint32(16).int32(m.provider);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    return w;
                };

                BotPlanningSearchSourcesMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.sourceTitle = r.string();
                                break;
                            }
                        case 2: {
                                m.provider = r.int32();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningSearchSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata";
                };

                BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "OTHER"] = 1;
                    values[valuesById[2] = "GOOGLE"] = 2;
                    values[valuesById[3] = "BING"] = 3;
                    return values;
                })();

                return BotPlanningSearchSourcesMetadata;
            })();

            BotPlanningStepMetadata.BotPlanningStepSectionMetadata = (function() {

                function BotPlanningStepSectionMetadata(p) {
                    this.sourcesMetadata = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                BotPlanningStepSectionMetadata.prototype.sectionTitle = "";
                BotPlanningStepSectionMetadata.prototype.sectionBody = "";
                BotPlanningStepSectionMetadata.prototype.sourcesMetadata = $util.emptyArray;

                BotPlanningStepSectionMetadata.create = function create(properties) {
                    return new BotPlanningStepSectionMetadata(properties);
                };

                BotPlanningStepSectionMetadata.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.sectionTitle != null && Object.hasOwnProperty.call(m, "sectionTitle"))
                        w.uint32(10).string(m.sectionTitle);
                    if (m.sectionBody != null && Object.hasOwnProperty.call(m, "sectionBody"))
                        w.uint32(18).string(m.sectionBody);
                    if (m.sourcesMetadata != null && m.sourcesMetadata.length) {
                        for (var i = 0; i < m.sourcesMetadata.length; ++i)
                            $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.encode(m.sourcesMetadata[i], w.uint32(26).fork()).ldelim();
                    }
                    return w;
                };

                BotPlanningStepSectionMetadata.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.sectionTitle = r.string();
                                break;
                            }
                        case 2: {
                                m.sectionBody = r.string();
                                break;
                            }
                        case 3: {
                                if (!(m.sourcesMetadata && m.sourcesMetadata.length))
                                    m.sourcesMetadata = [];
                                m.sourcesMetadata.push($root.proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.decode(r, r.uint32()));
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                BotPlanningStepSectionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata";
                };

                return BotPlanningStepSectionMetadata;
            })();

            BotPlanningStepMetadata.BotSearchSourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_PROVIDER"] = 0;
                values[valuesById[1] = "OTHER"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "BING"] = 3;
                return values;
            })();

            BotPlanningStepMetadata.PlanningStepStatus = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "PLANNED"] = 1;
                values[valuesById[2] = "EXECUTING"] = 2;
                values[valuesById[3] = "FINISHED"] = 3;
                return values;
            })();

            return BotPlanningStepMetadata;
        })();

        return BotProgressIndicatorMetadata;
    })();

    proto.BotPromotionMessageMetadata = (function() {

        function BotPromotionMessageMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromotionMessageMetadata.prototype.promotionType = 0;
        BotPromotionMessageMetadata.prototype.buttonTitle = "";

        BotPromotionMessageMetadata.create = function create(properties) {
            return new BotPromotionMessageMetadata(properties);
        };

        BotPromotionMessageMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.promotionType != null && Object.hasOwnProperty.call(m, "promotionType"))
                w.uint32(8).int32(m.promotionType);
            if (m.buttonTitle != null && Object.hasOwnProperty.call(m, "buttonTitle"))
                w.uint32(18).string(m.buttonTitle);
            return w;
        };

        BotPromotionMessageMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromotionMessageMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.promotionType = r.int32();
                        break;
                    }
                case 2: {
                        m.buttonTitle = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromotionMessageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromotionMessageMetadata";
        };

        BotPromotionMessageMetadata.BotPromotionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
            values[valuesById[1] = "C50"] = 1;
            return values;
        })();

        return BotPromotionMessageMetadata;
    })();

    proto.BotPromptSuggestion = (function() {

        function BotPromptSuggestion(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromptSuggestion.prototype.prompt = "";
        BotPromptSuggestion.prototype.promptId = "";

        BotPromptSuggestion.create = function create(properties) {
            return new BotPromptSuggestion(properties);
        };

        BotPromptSuggestion.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.prompt != null && Object.hasOwnProperty.call(m, "prompt"))
                w.uint32(10).string(m.prompt);
            if (m.promptId != null && Object.hasOwnProperty.call(m, "promptId"))
                w.uint32(18).string(m.promptId);
            return w;
        };

        BotPromptSuggestion.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromptSuggestion();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.prompt = r.string();
                        break;
                    }
                case 2: {
                        m.promptId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromptSuggestion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestion";
        };

        return BotPromptSuggestion;
    })();

    proto.BotPromptSuggestions = (function() {

        function BotPromptSuggestions(p) {
            this.suggestions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotPromptSuggestions.prototype.suggestions = $util.emptyArray;

        BotPromptSuggestions.create = function create(properties) {
            return new BotPromptSuggestions(properties);
        };

        BotPromptSuggestions.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.suggestions != null && m.suggestions.length) {
                for (var i = 0; i < m.suggestions.length; ++i)
                    $root.proto.BotPromptSuggestion.encode(m.suggestions[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotPromptSuggestions.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotPromptSuggestions();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.suggestions && m.suggestions.length))
                            m.suggestions = [];
                        m.suggestions.push($root.proto.BotPromptSuggestion.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotPromptSuggestions.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotPromptSuggestions";
        };

        return BotPromptSuggestions;
    })();

    proto.BotQuotaMetadata = (function() {

        function BotQuotaMetadata(p) {
            this.botFeatureQuotaMetadata = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotQuotaMetadata.prototype.botFeatureQuotaMetadata = $util.emptyArray;

        BotQuotaMetadata.create = function create(properties) {
            return new BotQuotaMetadata(properties);
        };

        BotQuotaMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.botFeatureQuotaMetadata != null && m.botFeatureQuotaMetadata.length) {
                for (var i = 0; i < m.botFeatureQuotaMetadata.length; ++i)
                    $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.encode(m.botFeatureQuotaMetadata[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotQuotaMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotQuotaMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.botFeatureQuotaMetadata && m.botFeatureQuotaMetadata.length))
                            m.botFeatureQuotaMetadata = [];
                        m.botFeatureQuotaMetadata.push($root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotQuotaMetadata";
        };

        BotQuotaMetadata.BotFeatureQuotaMetadata = (function() {

            function BotFeatureQuotaMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotFeatureQuotaMetadata.prototype.featureType = 0;
            BotFeatureQuotaMetadata.prototype.remainingQuota = 0;
            BotFeatureQuotaMetadata.prototype.expirationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

            BotFeatureQuotaMetadata.create = function create(properties) {
                return new BotFeatureQuotaMetadata(properties);
            };

            BotFeatureQuotaMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.featureType != null && Object.hasOwnProperty.call(m, "featureType"))
                    w.uint32(8).int32(m.featureType);
                if (m.remainingQuota != null && Object.hasOwnProperty.call(m, "remainingQuota"))
                    w.uint32(16).uint32(m.remainingQuota);
                if (m.expirationTimestamp != null && Object.hasOwnProperty.call(m, "expirationTimestamp"))
                    w.uint32(24).uint64(m.expirationTimestamp);
                return w;
            };

            BotFeatureQuotaMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotQuotaMetadata.BotFeatureQuotaMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.featureType = r.int32();
                            break;
                        }
                    case 2: {
                            m.remainingQuota = r.uint32();
                            break;
                        }
                    case 3: {
                            m.expirationTimestamp = r.uint64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotFeatureQuotaMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotQuotaMetadata.BotFeatureQuotaMetadata";
            };

            BotFeatureQuotaMetadata.BotFeatureType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_FEATURE"] = 0;
                values[valuesById[1] = "REASONING_FEATURE"] = 1;
                return values;
            })();

            return BotFeatureQuotaMetadata;
        })();

        return BotQuotaMetadata;
    })();

    proto.BotReminderMetadata = (function() {

        function BotReminderMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotReminderMetadata.prototype.requestMessageKey = null;
        BotReminderMetadata.prototype.action = 1;
        BotReminderMetadata.prototype.name = "";
        BotReminderMetadata.prototype.nextTriggerTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        BotReminderMetadata.prototype.frequency = 1;

        BotReminderMetadata.create = function create(properties) {
            return new BotReminderMetadata(properties);
        };

        BotReminderMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.requestMessageKey != null && Object.hasOwnProperty.call(m, "requestMessageKey"))
                $root.proto.MessageKey.encode(m.requestMessageKey, w.uint32(10).fork()).ldelim();
            if (m.action != null && Object.hasOwnProperty.call(m, "action"))
                w.uint32(16).int32(m.action);
            if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                w.uint32(26).string(m.name);
            if (m.nextTriggerTimestamp != null && Object.hasOwnProperty.call(m, "nextTriggerTimestamp"))
                w.uint32(32).uint64(m.nextTriggerTimestamp);
            if (m.frequency != null && Object.hasOwnProperty.call(m, "frequency"))
                w.uint32(40).int32(m.frequency);
            return w;
        };

        BotReminderMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotReminderMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.requestMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.action = r.int32();
                        break;
                    }
                case 3: {
                        m.name = r.string();
                        break;
                    }
                case 4: {
                        m.nextTriggerTimestamp = r.uint64();
                        break;
                    }
                case 5: {
                        m.frequency = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotReminderMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotReminderMetadata";
        };

        BotReminderMetadata.ReminderAction = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "NOTIFY"] = 1;
            values[valuesById[2] = "CREATE"] = 2;
            values[valuesById[3] = "DELETE"] = 3;
            values[valuesById[4] = "UPDATE"] = 4;
            return values;
        })();

        BotReminderMetadata.ReminderFrequency = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "ONCE"] = 1;
            values[valuesById[2] = "DAILY"] = 2;
            values[valuesById[3] = "WEEKLY"] = 3;
            values[valuesById[4] = "BIWEEKLY"] = 4;
            values[valuesById[5] = "MONTHLY"] = 5;
            return values;
        })();

        return BotReminderMetadata;
    })();

    proto.BotRenderingMetadata = (function() {

        function BotRenderingMetadata(p) {
            this.keywords = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotRenderingMetadata.prototype.keywords = $util.emptyArray;

        BotRenderingMetadata.create = function create(properties) {
            return new BotRenderingMetadata(properties);
        };

        BotRenderingMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.keywords != null && m.keywords.length) {
                for (var i = 0; i < m.keywords.length; ++i)
                    $root.proto.BotRenderingMetadata.Keyword.encode(m.keywords[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotRenderingMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotRenderingMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.keywords && m.keywords.length))
                            m.keywords = [];
                        m.keywords.push($root.proto.BotRenderingMetadata.Keyword.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotRenderingMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotRenderingMetadata";
        };

        BotRenderingMetadata.Keyword = (function() {

            function Keyword(p) {
                this.associatedPrompts = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            Keyword.prototype.value = "";
            Keyword.prototype.associatedPrompts = $util.emptyArray;

            Keyword.create = function create(properties) {
                return new Keyword(properties);
            };

            Keyword.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.value != null && Object.hasOwnProperty.call(m, "value"))
                    w.uint32(10).string(m.value);
                if (m.associatedPrompts != null && m.associatedPrompts.length) {
                    for (var i = 0; i < m.associatedPrompts.length; ++i)
                        w.uint32(18).string(m.associatedPrompts[i]);
                }
                return w;
            };

            Keyword.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotRenderingMetadata.Keyword();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.value = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.associatedPrompts && m.associatedPrompts.length))
                                m.associatedPrompts = [];
                            m.associatedPrompts.push(r.string());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            Keyword.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotRenderingMetadata.Keyword";
            };

            return Keyword;
        })();

        return BotRenderingMetadata;
    })();

    proto.BotSessionMetadata = (function() {

        function BotSessionMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSessionMetadata.prototype.sessionId = "";
        BotSessionMetadata.prototype.sessionSource = 0;

        BotSessionMetadata.create = function create(properties) {
            return new BotSessionMetadata(properties);
        };

        BotSessionMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                w.uint32(10).string(m.sessionId);
            if (m.sessionSource != null && Object.hasOwnProperty.call(m, "sessionSource"))
                w.uint32(16).int32(m.sessionSource);
            return w;
        };

        BotSessionMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSessionMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sessionId = r.string();
                        break;
                    }
                case 2: {
                        m.sessionSource = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSessionMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSessionMetadata";
        };

        return BotSessionMetadata;
    })();

    proto.BotSessionSource = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "NONE"] = 0;
        values[valuesById[1] = "NULL_STATE"] = 1;
        values[valuesById[2] = "TYPEAHEAD"] = 2;
        values[valuesById[3] = "USER_INPUT"] = 3;
        values[valuesById[4] = "EMU_FLASH"] = 4;
        values[valuesById[5] = "EMU_FLASH_FOLLOWUP"] = 5;
        values[valuesById[6] = "VOICE"] = 6;
        return values;
    })();

    proto.BotSourcesMetadata = (function() {

        function BotSourcesMetadata(p) {
            this.sources = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSourcesMetadata.prototype.sources = $util.emptyArray;

        BotSourcesMetadata.create = function create(properties) {
            return new BotSourcesMetadata(properties);
        };

        BotSourcesMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sources != null && m.sources.length) {
                for (var i = 0; i < m.sources.length; ++i)
                    $root.proto.BotSourcesMetadata.BotSourceItem.encode(m.sources[i], w.uint32(10).fork()).ldelim();
            }
            return w;
        };

        BotSourcesMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSourcesMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.sources && m.sources.length))
                            m.sources = [];
                        m.sources.push($root.proto.BotSourcesMetadata.BotSourceItem.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSourcesMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSourcesMetadata";
        };

        BotSourcesMetadata.BotSourceItem = (function() {

            function BotSourceItem(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotSourceItem.prototype.provider = 0;
            BotSourceItem.prototype.thumbnailCdnUrl = "";
            BotSourceItem.prototype.sourceProviderUrl = "";
            BotSourceItem.prototype.sourceQuery = "";
            BotSourceItem.prototype.faviconCdnUrl = "";
            BotSourceItem.prototype.citationNumber = 0;

            BotSourceItem.create = function create(properties) {
                return new BotSourceItem(properties);
            };

            BotSourceItem.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.provider != null && Object.hasOwnProperty.call(m, "provider"))
                    w.uint32(8).int32(m.provider);
                if (m.thumbnailCdnUrl != null && Object.hasOwnProperty.call(m, "thumbnailCdnUrl"))
                    w.uint32(18).string(m.thumbnailCdnUrl);
                if (m.sourceProviderUrl != null && Object.hasOwnProperty.call(m, "sourceProviderUrl"))
                    w.uint32(26).string(m.sourceProviderUrl);
                if (m.sourceQuery != null && Object.hasOwnProperty.call(m, "sourceQuery"))
                    w.uint32(34).string(m.sourceQuery);
                if (m.faviconCdnUrl != null && Object.hasOwnProperty.call(m, "faviconCdnUrl"))
                    w.uint32(42).string(m.faviconCdnUrl);
                if (m.citationNumber != null && Object.hasOwnProperty.call(m, "citationNumber"))
                    w.uint32(48).uint32(m.citationNumber);
                return w;
            };

            BotSourceItem.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSourcesMetadata.BotSourceItem();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.provider = r.int32();
                            break;
                        }
                    case 2: {
                            m.thumbnailCdnUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.sourceProviderUrl = r.string();
                            break;
                        }
                    case 4: {
                            m.sourceQuery = r.string();
                            break;
                        }
                    case 5: {
                            m.faviconCdnUrl = r.string();
                            break;
                        }
                    case 6: {
                            m.citationNumber = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotSourceItem.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.BotSourcesMetadata.BotSourceItem";
            };

            BotSourceItem.SourceProvider = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "BING"] = 1;
                values[valuesById[2] = "GOOGLE"] = 2;
                values[valuesById[3] = "SUPPORT"] = 3;
                return values;
            })();

            return BotSourceItem;
        })();

        return BotSourcesMetadata;
    })();

    proto.BotSuggestedPromptMetadata = (function() {

        function BotSuggestedPromptMetadata(p) {
            this.suggestedPrompts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        BotSuggestedPromptMetadata.prototype.suggestedPrompts = $util.emptyArray;
        BotSuggestedPromptMetadata.prototype.selectedPromptIndex = 0;
        BotSuggestedPromptMetadata.prototype.promptSuggestions = null;
        BotSuggestedPromptMetadata.prototype.selectedPromptId = "";

        BotSuggestedPromptMetadata.create = function create(properties) {
            return new BotSuggestedPromptMetadata(properties);
        };

        BotSuggestedPromptMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.suggestedPrompts != null && m.suggestedPrompts.length) {
                for (var i = 0; i < m.suggestedPrompts.length; ++i)
                    w.uint32(10).string(m.suggestedPrompts[i]);
            }
            if (m.selectedPromptIndex != null && Object.hasOwnProperty.call(m, "selectedPromptIndex"))
                w.uint32(16).uint32(m.selectedPromptIndex);
            if (m.promptSuggestions != null && Object.hasOwnProperty.call(m, "promptSuggestions"))
                $root.proto.BotPromptSuggestions.encode(m.promptSuggestions, w.uint32(26).fork()).ldelim();
            if (m.selectedPromptId != null && Object.hasOwnProperty.call(m, "selectedPromptId"))
                w.uint32(34).string(m.selectedPromptId);
            return w;
        };

        BotSuggestedPromptMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.BotSuggestedPromptMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.suggestedPrompts && m.suggestedPrompts.length))
                            m.suggestedPrompts = [];
                        m.suggestedPrompts.push(r.string());
                        break;
                    }
                case 2: {
                        m.selectedPromptIndex = r.uint32();
                        break;
                    }
                case 3: {
                        m.promptSuggestions = $root.proto.BotPromptSuggestions.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.selectedPromptId = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        BotSuggestedPromptMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.BotSuggestedPromptMetadata";
        };

        return BotSuggestedPromptMetadata;
    })();

    proto.CallLogRecord = (function() {

        function CallLogRecord(p) {
            this.participants = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CallLogRecord.prototype.callResult = 0;
        CallLogRecord.prototype.isDndMode = false;
        CallLogRecord.prototype.silenceReason = 0;
        CallLogRecord.prototype.duration = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        CallLogRecord.prototype.startTime = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        CallLogRecord.prototype.isIncoming = false;
        CallLogRecord.prototype.isVideo = false;
        CallLogRecord.prototype.isCallLink = false;
        CallLogRecord.prototype.callLinkToken = "";
        CallLogRecord.prototype.scheduledCallId = "";
        CallLogRecord.prototype.callId = "";
        CallLogRecord.prototype.callCreatorJid = "";
        CallLogRecord.prototype.groupJid = "";
        CallLogRecord.prototype.participants = $util.emptyArray;
        CallLogRecord.prototype.callType = 0;

        CallLogRecord.create = function create(properties) {
            return new CallLogRecord(properties);
        };

        CallLogRecord.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.callResult != null && Object.hasOwnProperty.call(m, "callResult"))
                w.uint32(8).int32(m.callResult);
            if (m.isDndMode != null && Object.hasOwnProperty.call(m, "isDndMode"))
                w.uint32(16).bool(m.isDndMode);
            if (m.silenceReason != null && Object.hasOwnProperty.call(m, "silenceReason"))
                w.uint32(24).int32(m.silenceReason);
            if (m.duration != null && Object.hasOwnProperty.call(m, "duration"))
                w.uint32(32).int64(m.duration);
            if (m.startTime != null && Object.hasOwnProperty.call(m, "startTime"))
                w.uint32(40).int64(m.startTime);
            if (m.isIncoming != null && Object.hasOwnProperty.call(m, "isIncoming"))
                w.uint32(48).bool(m.isIncoming);
            if (m.isVideo != null && Object.hasOwnProperty.call(m, "isVideo"))
                w.uint32(56).bool(m.isVideo);
            if (m.isCallLink != null && Object.hasOwnProperty.call(m, "isCallLink"))
                w.uint32(64).bool(m.isCallLink);
            if (m.callLinkToken != null && Object.hasOwnProperty.call(m, "callLinkToken"))
                w.uint32(74).string(m.callLinkToken);
            if (m.scheduledCallId != null && Object.hasOwnProperty.call(m, "scheduledCallId"))
                w.uint32(82).string(m.scheduledCallId);
            if (m.callId != null && Object.hasOwnProperty.call(m, "callId"))
                w.uint32(90).string(m.callId);
            if (m.callCreatorJid != null && Object.hasOwnProperty.call(m, "callCreatorJid"))
                w.uint32(98).string(m.callCreatorJid);
            if (m.groupJid != null && Object.hasOwnProperty.call(m, "groupJid"))
                w.uint32(106).string(m.groupJid);
            if (m.participants != null && m.participants.length) {
                for (var i = 0; i < m.participants.length; ++i)
                    $root.proto.CallLogRecord.ParticipantInfo.encode(m.participants[i], w.uint32(114).fork()).ldelim();
            }
            if (m.callType != null && Object.hasOwnProperty.call(m, "callType"))
                w.uint32(120).int32(m.callType);
            return w;
        };

        CallLogRecord.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CallLogRecord();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.callResult = r.int32();
                        break;
                    }
                case 2: {
                        m.isDndMode = r.bool();
                        break;
                    }
                case 3: {
                        m.silenceReason = r.int32();
                        break;
                    }
                case 4: {
                        m.duration = r.int64();
                        break;
                    }
                case 5: {
                        m.startTime = r.int64();
                        break;
                    }
                case 6: {
                        m.isIncoming = r.bool();
                        break;
                    }
                case 7: {
                        m.isVideo = r.bool();
                        break;
                    }
                case 8: {
                        m.isCallLink = r.bool();
                        break;
                    }
                case 9: {
                        m.callLinkToken = r.string();
                        break;
                    }
                case 10: {
                        m.scheduledCallId = r.string();
                        break;
                    }
                case 11: {
                        m.callId = r.string();
                        break;
                    }
                case 12: {
                        m.callCreatorJid = r.string();
                        break;
                    }
                case 13: {
                        m.groupJid = r.string();
                        break;
                    }
                case 14: {
                        if (!(m.participants && m.participants.length))
                            m.participants = [];
                        m.participants.push($root.proto.CallLogRecord.ParticipantInfo.decode(r, r.uint32()));
                        break;
                    }
                case 15: {
                        m.callType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CallLogRecord.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CallLogRecord";
        };

        CallLogRecord.CallResult = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CONNECTED"] = 0;
            values[valuesById[1] = "REJECTED"] = 1;
            values[valuesById[2] = "CANCELLED"] = 2;
            values[valuesById[3] = "ACCEPTEDELSEWHERE"] = 3;
            values[valuesById[4] = "MISSED"] = 4;
            values[valuesById[5] = "INVALID"] = 5;
            values[valuesById[6] = "UNAVAILABLE"] = 6;
            values[valuesById[7] = "UPCOMING"] = 7;
            values[valuesById[8] = "FAILED"] = 8;
            values[valuesById[9] = "ABANDONED"] = 9;
            values[valuesById[10] = "ONGOING"] = 10;
            return values;
        })();

        CallLogRecord.CallType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "REGULAR"] = 0;
            values[valuesById[1] = "SCHEDULED_CALL"] = 1;
            values[valuesById[2] = "VOICE_CHAT"] = 2;
            return values;
        })();

        CallLogRecord.ParticipantInfo = (function() {

            function ParticipantInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ParticipantInfo.prototype.userJid = "";
            ParticipantInfo.prototype.callResult = 0;

            ParticipantInfo.create = function create(properties) {
                return new ParticipantInfo(properties);
            };

            ParticipantInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.userJid != null && Object.hasOwnProperty.call(m, "userJid"))
                    w.uint32(10).string(m.userJid);
                if (m.callResult != null && Object.hasOwnProperty.call(m, "callResult"))
                    w.uint32(16).int32(m.callResult);
                return w;
            };

            ParticipantInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CallLogRecord.ParticipantInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.userJid = r.string();
                            break;
                        }
                    case 2: {
                            m.callResult = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ParticipantInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.CallLogRecord.ParticipantInfo";
            };

            return ParticipantInfo;
        })();

        CallLogRecord.SilenceReason = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "SCHEDULED"] = 1;
            values[valuesById[2] = "PRIVACY"] = 2;
            values[valuesById[3] = "LIGHTWEIGHT"] = 3;
            return values;
        })();

        return CallLogRecord;
    })();

    proto.CertChain = (function() {

        function CertChain(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CertChain.prototype.leaf = null;
        CertChain.prototype.intermediate = null;

        CertChain.create = function create(properties) {
            return new CertChain(properties);
        };

        CertChain.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.leaf != null && Object.hasOwnProperty.call(m, "leaf"))
                $root.proto.CertChain.NoiseCertificate.encode(m.leaf, w.uint32(10).fork()).ldelim();
            if (m.intermediate != null && Object.hasOwnProperty.call(m, "intermediate"))
                $root.proto.CertChain.NoiseCertificate.encode(m.intermediate, w.uint32(18).fork()).ldelim();
            return w;
        };

        CertChain.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.leaf = $root.proto.CertChain.NoiseCertificate.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.intermediate = $root.proto.CertChain.NoiseCertificate.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CertChain.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CertChain";
        };

        CertChain.NoiseCertificate = (function() {

            function NoiseCertificate(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            NoiseCertificate.prototype.details = $util.newBuffer([]);
            NoiseCertificate.prototype.signature = $util.newBuffer([]);

            NoiseCertificate.create = function create(properties) {
                return new NoiseCertificate(properties);
            };

            NoiseCertificate.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.details != null && Object.hasOwnProperty.call(m, "details"))
                    w.uint32(10).bytes(m.details);
                if (m.signature != null && Object.hasOwnProperty.call(m, "signature"))
                    w.uint32(18).bytes(m.signature);
                return w;
            };

            NoiseCertificate.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain.NoiseCertificate();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.details = r.bytes();
                            break;
                        }
                    case 2: {
                            m.signature = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            NoiseCertificate.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.CertChain.NoiseCertificate";
            };

            NoiseCertificate.Details = (function() {

                function Details(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Details.prototype.serial = 0;
                Details.prototype.issuerSerial = 0;
                Details.prototype.key = $util.newBuffer([]);
                Details.prototype.notBefore = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
                Details.prototype.notAfter = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

                Details.create = function create(properties) {
                    return new Details(properties);
                };

                Details.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.serial != null && Object.hasOwnProperty.call(m, "serial"))
                        w.uint32(8).uint32(m.serial);
                    if (m.issuerSerial != null && Object.hasOwnProperty.call(m, "issuerSerial"))
                        w.uint32(16).uint32(m.issuerSerial);
                    if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                        w.uint32(26).bytes(m.key);
                    if (m.notBefore != null && Object.hasOwnProperty.call(m, "notBefore"))
                        w.uint32(32).uint64(m.notBefore);
                    if (m.notAfter != null && Object.hasOwnProperty.call(m, "notAfter"))
                        w.uint32(40).uint64(m.notAfter);
                    return w;
                };

                Details.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CertChain.NoiseCertificate.Details();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.serial = r.uint32();
                                break;
                            }
                        case 2: {
                                m.issuerSerial = r.uint32();
                                break;
                            }
                        case 3: {
                                m.key = r.bytes();
                                break;
                            }
                        case 4: {
                                m.notBefore = r.uint64();
                                break;
                            }
                        case 5: {
                                m.notAfter = r.uint64();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Details.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.CertChain.NoiseCertificate.Details";
                };

                return Details;
            })();

            return NoiseCertificate;
        })();

        return CertChain;
    })();

    proto.ChatLockSettings = (function() {

        function ChatLockSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ChatLockSettings.prototype.hideLockedChats = false;
        ChatLockSettings.prototype.secretCode = null;

        ChatLockSettings.create = function create(properties) {
            return new ChatLockSettings(properties);
        };

        ChatLockSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.hideLockedChats != null && Object.hasOwnProperty.call(m, "hideLockedChats"))
                w.uint32(8).bool(m.hideLockedChats);
            if (m.secretCode != null && Object.hasOwnProperty.call(m, "secretCode"))
                $root.proto.UserPassword.encode(m.secretCode, w.uint32(18).fork()).ldelim();
            return w;
        };

        ChatLockSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatLockSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.hideLockedChats = r.bool();
                        break;
                    }
                case 2: {
                        m.secretCode = $root.proto.UserPassword.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ChatLockSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ChatLockSettings";
        };

        return ChatLockSettings;
    })();

    proto.ChatRowOpaqueData = (function() {

        function ChatRowOpaqueData(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ChatRowOpaqueData.prototype.draftMessage = null;

        ChatRowOpaqueData.create = function create(properties) {
            return new ChatRowOpaqueData(properties);
        };

        ChatRowOpaqueData.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.draftMessage != null && Object.hasOwnProperty.call(m, "draftMessage"))
                $root.proto.ChatRowOpaqueData.DraftMessage.encode(m.draftMessage, w.uint32(10).fork()).ldelim();
            return w;
        };

        ChatRowOpaqueData.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.draftMessage = $root.proto.ChatRowOpaqueData.DraftMessage.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ChatRowOpaqueData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ChatRowOpaqueData";
        };

        ChatRowOpaqueData.DraftMessage = (function() {

            function DraftMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DraftMessage.prototype.text = "";
            DraftMessage.prototype.omittedUrl = "";
            DraftMessage.prototype.ctwaContextLinkData = null;
            DraftMessage.prototype.ctwaContext = null;
            DraftMessage.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            DraftMessage.create = function create(properties) {
                return new DraftMessage(properties);
            };

            DraftMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.omittedUrl != null && Object.hasOwnProperty.call(m, "omittedUrl"))
                    w.uint32(18).string(m.omittedUrl);
                if (m.ctwaContextLinkData != null && Object.hasOwnProperty.call(m, "ctwaContextLinkData"))
                    $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.encode(m.ctwaContextLinkData, w.uint32(26).fork()).ldelim();
                if (m.ctwaContext != null && Object.hasOwnProperty.call(m, "ctwaContext"))
                    $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.encode(m.ctwaContext, w.uint32(34).fork()).ldelim();
                if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                    w.uint32(40).int64(m.timestamp);
                return w;
            };

            DraftMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            m.omittedUrl = r.string();
                            break;
                        }
                    case 3: {
                            m.ctwaContextLinkData = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.ctwaContext = $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.timestamp = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DraftMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage";
            };

            DraftMessage.CtwaContextData = (function() {

                function CtwaContextData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CtwaContextData.prototype.conversionSource = "";
                CtwaContextData.prototype.conversionData = $util.newBuffer([]);
                CtwaContextData.prototype.sourceUrl = "";
                CtwaContextData.prototype.sourceId = "";
                CtwaContextData.prototype.sourceType = "";
                CtwaContextData.prototype.title = "";
                CtwaContextData.prototype.description = "";
                CtwaContextData.prototype.thumbnail = "";
                CtwaContextData.prototype.thumbnailUrl = "";
                CtwaContextData.prototype.mediaType = 0;
                CtwaContextData.prototype.mediaUrl = "";
                CtwaContextData.prototype.isSuspiciousLink = false;

                CtwaContextData.create = function create(properties) {
                    return new CtwaContextData(properties);
                };

                CtwaContextData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                        w.uint32(10).string(m.conversionSource);
                    if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                        w.uint32(18).bytes(m.conversionData);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(26).string(m.sourceUrl);
                    if (m.sourceId != null && Object.hasOwnProperty.call(m, "sourceId"))
                        w.uint32(34).string(m.sourceId);
                    if (m.sourceType != null && Object.hasOwnProperty.call(m, "sourceType"))
                        w.uint32(42).string(m.sourceType);
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(50).string(m.title);
                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                        w.uint32(58).string(m.description);
                    if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                        w.uint32(66).string(m.thumbnail);
                    if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                        w.uint32(74).string(m.thumbnailUrl);
                    if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                        w.uint32(80).int32(m.mediaType);
                    if (m.mediaUrl != null && Object.hasOwnProperty.call(m, "mediaUrl"))
                        w.uint32(90).string(m.mediaUrl);
                    if (m.isSuspiciousLink != null && Object.hasOwnProperty.call(m, "isSuspiciousLink"))
                        w.uint32(96).bool(m.isSuspiciousLink);
                    return w;
                };

                CtwaContextData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.conversionSource = r.string();
                                break;
                            }
                        case 2: {
                                m.conversionData = r.bytes();
                                break;
                            }
                        case 3: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 4: {
                                m.sourceId = r.string();
                                break;
                            }
                        case 5: {
                                m.sourceType = r.string();
                                break;
                            }
                        case 6: {
                                m.title = r.string();
                                break;
                            }
                        case 7: {
                                m.description = r.string();
                                break;
                            }
                        case 8: {
                                m.thumbnail = r.string();
                                break;
                            }
                        case 9: {
                                m.thumbnailUrl = r.string();
                                break;
                            }
                        case 10: {
                                m.mediaType = r.int32();
                                break;
                            }
                        case 11: {
                                m.mediaUrl = r.string();
                                break;
                            }
                        case 12: {
                                m.isSuspiciousLink = r.bool();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CtwaContextData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage.CtwaContextData";
                };

                CtwaContextData.ContextInfoExternalAdReplyInfoMediaType = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "NONE"] = 0;
                    values[valuesById[1] = "IMAGE"] = 1;
                    values[valuesById[2] = "VIDEO"] = 2;
                    return values;
                })();

                return CtwaContextData;
            })();

            DraftMessage.CtwaContextLinkData = (function() {

                function CtwaContextLinkData(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CtwaContextLinkData.prototype.context = "";
                CtwaContextLinkData.prototype.sourceUrl = "";
                CtwaContextLinkData.prototype.icebreaker = "";
                CtwaContextLinkData.prototype.phone = "";

                CtwaContextLinkData.create = function create(properties) {
                    return new CtwaContextLinkData(properties);
                };

                CtwaContextLinkData.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.context != null && Object.hasOwnProperty.call(m, "context"))
                        w.uint32(10).string(m.context);
                    if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                        w.uint32(18).string(m.sourceUrl);
                    if (m.icebreaker != null && Object.hasOwnProperty.call(m, "icebreaker"))
                        w.uint32(26).string(m.icebreaker);
                    if (m.phone != null && Object.hasOwnProperty.call(m, "phone"))
                        w.uint32(34).string(m.phone);
                    return w;
                };

                CtwaContextLinkData.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.context = r.string();
                                break;
                            }
                        case 2: {
                                m.sourceUrl = r.string();
                                break;
                            }
                        case 3: {
                                m.icebreaker = r.string();
                                break;
                            }
                        case 4: {
                                m.phone = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CtwaContextLinkData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData";
                };

                return CtwaContextLinkData;
            })();

            return DraftMessage;
        })();

        return ChatRowOpaqueData;
    })();

    proto.Citation = (function() {

        function Citation(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Citation.prototype.title = "";
        Citation.prototype.subtitle = "";
        Citation.prototype.cmsId = "";
        Citation.prototype.imageUrl = "";

        Citation.create = function create(properties) {
            return new Citation(properties);
        };

        Citation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            w.uint32(10).string(m.title);
            w.uint32(18).string(m.subtitle);
            w.uint32(26).string(m.cmsId);
            w.uint32(34).string(m.imageUrl);
            return w;
        };

        Citation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Citation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.title = r.string();
                        break;
                    }
                case 2: {
                        m.subtitle = r.string();
                        break;
                    }
                case 3: {
                        m.cmsId = r.string();
                        break;
                    }
                case 4: {
                        m.imageUrl = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            if (!m.hasOwnProperty("title"))
                throw $util.ProtocolError("missing required 'title'", { instance: m });
            if (!m.hasOwnProperty("subtitle"))
                throw $util.ProtocolError("missing required 'subtitle'", { instance: m });
            if (!m.hasOwnProperty("cmsId"))
                throw $util.ProtocolError("missing required 'cmsId'", { instance: m });
            if (!m.hasOwnProperty("imageUrl"))
                throw $util.ProtocolError("missing required 'imageUrl'", { instance: m });
            return m;
        };

        Citation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Citation";
        };

        return Citation;
    })();

    proto.ClientPairingProps = (function() {

        function ClientPairingProps(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ClientPairingProps.prototype.isChatDbLidMigrated = false;
        ClientPairingProps.prototype.isSyncdPureLidSession = false;

        ClientPairingProps.create = function create(properties) {
            return new ClientPairingProps(properties);
        };

        ClientPairingProps.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.isChatDbLidMigrated != null && Object.hasOwnProperty.call(m, "isChatDbLidMigrated"))
                w.uint32(8).bool(m.isChatDbLidMigrated);
            if (m.isSyncdPureLidSession != null && Object.hasOwnProperty.call(m, "isSyncdPureLidSession"))
                w.uint32(16).bool(m.isSyncdPureLidSession);
            return w;
        };

        ClientPairingProps.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPairingProps();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.isChatDbLidMigrated = r.bool();
                        break;
                    }
                case 2: {
                        m.isSyncdPureLidSession = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ClientPairingProps.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ClientPairingProps";
        };

        return ClientPairingProps;
    })();

    proto.ClientPayload = (function() {

        function ClientPayload(p) {
            this.shards = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ClientPayload.prototype.username = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        ClientPayload.prototype.passive = false;
        ClientPayload.prototype.userAgent = null;
        ClientPayload.prototype.webInfo = null;
        ClientPayload.prototype.pushName = "";
        ClientPayload.prototype.sessionId = 0;
        ClientPayload.prototype.shortConnect = false;
        ClientPayload.prototype.connectType = 0;
        ClientPayload.prototype.connectReason = 0;
        ClientPayload.prototype.shards = $util.emptyArray;
        ClientPayload.prototype.dnsSource = null;
        ClientPayload.prototype.connectAttemptCount = 0;
        ClientPayload.prototype.device = 0;
        ClientPayload.prototype.devicePairingData = null;
        ClientPayload.prototype.product = 0;
        ClientPayload.prototype.fbCat = $util.newBuffer([]);
        ClientPayload.prototype.fbUserAgent = $util.newBuffer([]);
        ClientPayload.prototype.oc = false;
        ClientPayload.prototype.lc = 0;
        ClientPayload.prototype.iosAppExtension = 0;
        ClientPayload.prototype.fbAppId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        ClientPayload.prototype.fbDeviceId = $util.newBuffer([]);
        ClientPayload.prototype.pull = false;
        ClientPayload.prototype.paddingBytes = $util.newBuffer([]);
        ClientPayload.prototype.yearClass = 0;
        ClientPayload.prototype.memClass = 0;
        ClientPayload.prototype.interopData = null;
        ClientPayload.prototype.trafficAnonymization = 0;
        ClientPayload.prototype.lidDbMigrated = false;
        ClientPayload.prototype.accountType = 0;

        ClientPayload.create = function create(properties) {
            return new ClientPayload(properties);
        };

        ClientPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(8).uint64(m.username);
            if (m.passive != null && Object.hasOwnProperty.call(m, "passive"))
                w.uint32(24).bool(m.passive);
            if (m.userAgent != null && Object.hasOwnProperty.call(m, "userAgent"))
                $root.proto.ClientPayload.UserAgent.encode(m.userAgent, w.uint32(42).fork()).ldelim();
            if (m.webInfo != null && Object.hasOwnProperty.call(m, "webInfo"))
                $root.proto.ClientPayload.WebInfo.encode(m.webInfo, w.uint32(50).fork()).ldelim();
            if (m.pushName != null && Object.hasOwnProperty.call(m, "pushName"))
                w.uint32(58).string(m.pushName);
            if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                w.uint32(77).sfixed32(m.sessionId);
            if (m.shortConnect != null && Object.hasOwnProperty.call(m, "shortConnect"))
                w.uint32(80).bool(m.shortConnect);
            if (m.connectType != null && Object.hasOwnProperty.call(m, "connectType"))
                w.uint32(96).int32(m.connectType);
            if (m.connectReason != null && Object.hasOwnProperty.call(m, "connectReason"))
                w.uint32(104).int32(m.connectReason);
            if (m.shards != null && m.shards.length) {
                for (var i = 0; i < m.shards.length; ++i)
                    w.uint32(112).int32(m.shards[i]);
            }
            if (m.dnsSource != null && Object.hasOwnProperty.call(m, "dnsSource"))
                $root.proto.ClientPayload.DNSSource.encode(m.dnsSource, w.uint32(122).fork()).ldelim();
            if (m.connectAttemptCount != null && Object.hasOwnProperty.call(m, "connectAttemptCount"))
                w.uint32(128).uint32(m.connectAttemptCount);
            if (m.device != null && Object.hasOwnProperty.call(m, "device"))
                w.uint32(144).uint32(m.device);
            if (m.devicePairingData != null && Object.hasOwnProperty.call(m, "devicePairingData"))
                $root.proto.ClientPayload.DevicePairingRegistrationData.encode(m.devicePairingData, w.uint32(154).fork()).ldelim();
            if (m.product != null && Object.hasOwnProperty.call(m, "product"))
                w.uint32(160).int32(m.product);
            if (m.fbCat != null && Object.hasOwnProperty.call(m, "fbCat"))
                w.uint32(170).bytes(m.fbCat);
            if (m.fbUserAgent != null && Object.hasOwnProperty.call(m, "fbUserAgent"))
                w.uint32(178).bytes(m.fbUserAgent);
            if (m.oc != null && Object.hasOwnProperty.call(m, "oc"))
                w.uint32(184).bool(m.oc);
            if (m.lc != null && Object.hasOwnProperty.call(m, "lc"))
                w.uint32(192).int32(m.lc);
            if (m.iosAppExtension != null && Object.hasOwnProperty.call(m, "iosAppExtension"))
                w.uint32(240).int32(m.iosAppExtension);
            if (m.fbAppId != null && Object.hasOwnProperty.call(m, "fbAppId"))
                w.uint32(248).uint64(m.fbAppId);
            if (m.fbDeviceId != null && Object.hasOwnProperty.call(m, "fbDeviceId"))
                w.uint32(258).bytes(m.fbDeviceId);
            if (m.pull != null && Object.hasOwnProperty.call(m, "pull"))
                w.uint32(264).bool(m.pull);
            if (m.paddingBytes != null && Object.hasOwnProperty.call(m, "paddingBytes"))
                w.uint32(274).bytes(m.paddingBytes);
            if (m.yearClass != null && Object.hasOwnProperty.call(m, "yearClass"))
                w.uint32(288).int32(m.yearClass);
            if (m.memClass != null && Object.hasOwnProperty.call(m, "memClass"))
                w.uint32(296).int32(m.memClass);
            if (m.interopData != null && Object.hasOwnProperty.call(m, "interopData"))
                $root.proto.ClientPayload.InteropData.encode(m.interopData, w.uint32(306).fork()).ldelim();
            if (m.trafficAnonymization != null && Object.hasOwnProperty.call(m, "trafficAnonymization"))
                w.uint32(320).int32(m.trafficAnonymization);
            if (m.lidDbMigrated != null && Object.hasOwnProperty.call(m, "lidDbMigrated"))
                w.uint32(328).bool(m.lidDbMigrated);
            if (m.accountType != null && Object.hasOwnProperty.call(m, "accountType"))
                w.uint32(336).int32(m.accountType);
            return w;
        };

        ClientPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.username = r.uint64();
                        break;
                    }
                case 3: {
                        m.passive = r.bool();
                        break;
                    }
                case 5: {
                        m.userAgent = $root.proto.ClientPayload.UserAgent.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.webInfo = $root.proto.ClientPayload.WebInfo.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.pushName = r.string();
                        break;
                    }
                case 9: {
                        m.sessionId = r.sfixed32();
                        break;
                    }
                case 10: {
                        m.shortConnect = r.bool();
                        break;
                    }
                case 12: {
                        m.connectType = r.int32();
                        break;
                    }
                case 13: {
                        m.connectReason = r.int32();
                        break;
                    }
                case 14: {
                        if (!(m.shards && m.shards.length))
                            m.shards = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.shards.push(r.int32());
                        } else
                            m.shards.push(r.int32());
                        break;
                    }
                case 15: {
                        m.dnsSource = $root.proto.ClientPayload.DNSSource.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.connectAttemptCount = r.uint32();
                        break;
                    }
                case 18: {
                        m.device = r.uint32();
                        break;
                    }
                case 19: {
                        m.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.product = r.int32();
                        break;
                    }
                case 21: {
                        m.fbCat = r.bytes();
                        break;
                    }
                case 22: {
                        m.fbUserAgent = r.bytes();
                        break;
                    }
                case 23: {
                        m.oc = r.bool();
                        break;
                    }
                case 24: {
                        m.lc = r.int32();
                        break;
                    }
                case 30: {
                        m.iosAppExtension = r.int32();
                        break;
                    }
                case 31: {
                        m.fbAppId = r.uint64();
                        break;
                    }
                case 32: {
                        m.fbDeviceId = r.bytes();
                        break;
                    }
                case 33: {
                        m.pull = r.bool();
                        break;
                    }
                case 34: {
                        m.paddingBytes = r.bytes();
                        break;
                    }
                case 36: {
                        m.yearClass = r.int32();
                        break;
                    }
                case 37: {
                        m.memClass = r.int32();
                        break;
                    }
                case 38: {
                        m.interopData = $root.proto.ClientPayload.InteropData.decode(r, r.uint32());
                        break;
                    }
                case 40: {
                        m.trafficAnonymization = r.int32();
                        break;
                    }
                case 41: {
                        m.lidDbMigrated = r.bool();
                        break;
                    }
                case 42: {
                        m.accountType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ClientPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ClientPayload";
        };

        ClientPayload.AccountType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "GUEST"] = 1;
            return values;
        })();

        ClientPayload.ConnectReason = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "PUSH"] = 0;
            values[valuesById[1] = "USER_ACTIVATED"] = 1;
            values[valuesById[2] = "SCHEDULED"] = 2;
            values[valuesById[3] = "ERROR_RECONNECT"] = 3;
            values[valuesById[4] = "NETWORK_SWITCH"] = 4;
            values[valuesById[5] = "PING_RECONNECT"] = 5;
            values[valuesById[6] = "UNKNOWN"] = 6;
            return values;
        })();

        ClientPayload.ConnectType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CELLULAR_UNKNOWN"] = 0;
            values[valuesById[1] = "WIFI_UNKNOWN"] = 1;
            values[valuesById[100] = "CELLULAR_EDGE"] = 100;
            values[valuesById[101] = "CELLULAR_IDEN"] = 101;
            values[valuesById[102] = "CELLULAR_UMTS"] = 102;
            values[valuesById[103] = "CELLULAR_EVDO"] = 103;
            values[valuesById[104] = "CELLULAR_GPRS"] = 104;
            values[valuesById[105] = "CELLULAR_HSDPA"] = 105;
            values[valuesById[106] = "CELLULAR_HSUPA"] = 106;
            values[valuesById[107] = "CELLULAR_HSPA"] = 107;
            values[valuesById[108] = "CELLULAR_CDMA"] = 108;
            values[valuesById[109] = "CELLULAR_1XRTT"] = 109;
            values[valuesById[110] = "CELLULAR_EHRPD"] = 110;
            values[valuesById[111] = "CELLULAR_LTE"] = 111;
            values[valuesById[112] = "CELLULAR_HSPAP"] = 112;
            return values;
        })();

        ClientPayload.DNSSource = (function() {

            function DNSSource(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DNSSource.prototype.dnsMethod = 0;
            DNSSource.prototype.appCached = false;

            DNSSource.create = function create(properties) {
                return new DNSSource(properties);
            };

            DNSSource.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.dnsMethod != null && Object.hasOwnProperty.call(m, "dnsMethod"))
                    w.uint32(120).int32(m.dnsMethod);
                if (m.appCached != null && Object.hasOwnProperty.call(m, "appCached"))
                    w.uint32(128).bool(m.appCached);
                return w;
            };

            DNSSource.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.DNSSource();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 15: {
                            m.dnsMethod = r.int32();
                            break;
                        }
                    case 16: {
                            m.appCached = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DNSSource.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.DNSSource";
            };

            DNSSource.DNSResolutionMethod = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "SYSTEM"] = 0;
                values[valuesById[1] = "GOOGLE"] = 1;
                values[valuesById[2] = "HARDCODED"] = 2;
                values[valuesById[3] = "OVERRIDE"] = 3;
                values[valuesById[4] = "FALLBACK"] = 4;
                values[valuesById[5] = "MNS"] = 5;
                return values;
            })();

            return DNSSource;
        })();

        ClientPayload.DevicePairingRegistrationData = (function() {

            function DevicePairingRegistrationData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DevicePairingRegistrationData.prototype.eRegid = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.eKeytype = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.eIdent = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.eSkeyId = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.eSkeyVal = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.eSkeySig = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.buildHash = $util.newBuffer([]);
            DevicePairingRegistrationData.prototype.deviceProps = $util.newBuffer([]);

            DevicePairingRegistrationData.create = function create(properties) {
                return new DevicePairingRegistrationData(properties);
            };

            DevicePairingRegistrationData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.eRegid != null && Object.hasOwnProperty.call(m, "eRegid"))
                    w.uint32(10).bytes(m.eRegid);
                if (m.eKeytype != null && Object.hasOwnProperty.call(m, "eKeytype"))
                    w.uint32(18).bytes(m.eKeytype);
                if (m.eIdent != null && Object.hasOwnProperty.call(m, "eIdent"))
                    w.uint32(26).bytes(m.eIdent);
                if (m.eSkeyId != null && Object.hasOwnProperty.call(m, "eSkeyId"))
                    w.uint32(34).bytes(m.eSkeyId);
                if (m.eSkeyVal != null && Object.hasOwnProperty.call(m, "eSkeyVal"))
                    w.uint32(42).bytes(m.eSkeyVal);
                if (m.eSkeySig != null && Object.hasOwnProperty.call(m, "eSkeySig"))
                    w.uint32(50).bytes(m.eSkeySig);
                if (m.buildHash != null && Object.hasOwnProperty.call(m, "buildHash"))
                    w.uint32(58).bytes(m.buildHash);
                if (m.deviceProps != null && Object.hasOwnProperty.call(m, "deviceProps"))
                    w.uint32(66).bytes(m.deviceProps);
                return w;
            };

            DevicePairingRegistrationData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.eRegid = r.bytes();
                            break;
                        }
                    case 2: {
                            m.eKeytype = r.bytes();
                            break;
                        }
                    case 3: {
                            m.eIdent = r.bytes();
                            break;
                        }
                    case 4: {
                            m.eSkeyId = r.bytes();
                            break;
                        }
                    case 5: {
                            m.eSkeyVal = r.bytes();
                            break;
                        }
                    case 6: {
                            m.eSkeySig = r.bytes();
                            break;
                        }
                    case 7: {
                            m.buildHash = r.bytes();
                            break;
                        }
                    case 8: {
                            m.deviceProps = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DevicePairingRegistrationData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.DevicePairingRegistrationData";
            };

            return DevicePairingRegistrationData;
        })();

        ClientPayload.IOSAppExtension = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SHARE_EXTENSION"] = 0;
            values[valuesById[1] = "SERVICE_EXTENSION"] = 1;
            values[valuesById[2] = "INTENTS_EXTENSION"] = 2;
            return values;
        })();

        ClientPayload.InteropData = (function() {

            function InteropData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InteropData.prototype.accountId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            InteropData.prototype.token = $util.newBuffer([]);
            InteropData.prototype.enableReadReceipts = false;

            InteropData.create = function create(properties) {
                return new InteropData(properties);
            };

            InteropData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.accountId != null && Object.hasOwnProperty.call(m, "accountId"))
                    w.uint32(8).uint64(m.accountId);
                if (m.token != null && Object.hasOwnProperty.call(m, "token"))
                    w.uint32(18).bytes(m.token);
                if (m.enableReadReceipts != null && Object.hasOwnProperty.call(m, "enableReadReceipts"))
                    w.uint32(24).bool(m.enableReadReceipts);
                return w;
            };

            InteropData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.InteropData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.accountId = r.uint64();
                            break;
                        }
                    case 2: {
                            m.token = r.bytes();
                            break;
                        }
                    case 3: {
                            m.enableReadReceipts = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InteropData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.InteropData";
            };

            return InteropData;
        })();

        ClientPayload.Product = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WHATSAPP"] = 0;
            values[valuesById[1] = "MESSENGER"] = 1;
            values[valuesById[2] = "INTEROP"] = 2;
            values[valuesById[3] = "INTEROP_MSGR"] = 3;
            values[valuesById[4] = "WHATSAPP_LID"] = 4;
            return values;
        })();

        ClientPayload.TrafficAnonymization = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "OFF"] = 0;
            values[valuesById[1] = "STANDARD"] = 1;
            return values;
        })();

        ClientPayload.UserAgent = (function() {

            function UserAgent(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            UserAgent.prototype.platform = 0;
            UserAgent.prototype.appVersion = null;
            UserAgent.prototype.mcc = "";
            UserAgent.prototype.mnc = "";
            UserAgent.prototype.osVersion = "";
            UserAgent.prototype.manufacturer = "";
            UserAgent.prototype.device = "";
            UserAgent.prototype.osBuildNumber = "";
            UserAgent.prototype.phoneId = "";
            UserAgent.prototype.releaseChannel = 0;
            UserAgent.prototype.localeLanguageIso6391 = "";
            UserAgent.prototype.localeCountryIso31661Alpha2 = "";
            UserAgent.prototype.deviceBoard = "";
            UserAgent.prototype.deviceExpId = "";
            UserAgent.prototype.deviceType = 0;
            UserAgent.prototype.deviceModelType = "";

            UserAgent.create = function create(properties) {
                return new UserAgent(properties);
            };

            UserAgent.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.platform != null && Object.hasOwnProperty.call(m, "platform"))
                    w.uint32(8).int32(m.platform);
                if (m.appVersion != null && Object.hasOwnProperty.call(m, "appVersion"))
                    $root.proto.ClientPayload.UserAgent.AppVersion.encode(m.appVersion, w.uint32(18).fork()).ldelim();
                if (m.mcc != null && Object.hasOwnProperty.call(m, "mcc"))
                    w.uint32(26).string(m.mcc);
                if (m.mnc != null && Object.hasOwnProperty.call(m, "mnc"))
                    w.uint32(34).string(m.mnc);
                if (m.osVersion != null && Object.hasOwnProperty.call(m, "osVersion"))
                    w.uint32(42).string(m.osVersion);
                if (m.manufacturer != null && Object.hasOwnProperty.call(m, "manufacturer"))
                    w.uint32(50).string(m.manufacturer);
                if (m.device != null && Object.hasOwnProperty.call(m, "device"))
                    w.uint32(58).string(m.device);
                if (m.osBuildNumber != null && Object.hasOwnProperty.call(m, "osBuildNumber"))
                    w.uint32(66).string(m.osBuildNumber);
                if (m.phoneId != null && Object.hasOwnProperty.call(m, "phoneId"))
                    w.uint32(74).string(m.phoneId);
                if (m.releaseChannel != null && Object.hasOwnProperty.call(m, "releaseChannel"))
                    w.uint32(80).int32(m.releaseChannel);
                if (m.localeLanguageIso6391 != null && Object.hasOwnProperty.call(m, "localeLanguageIso6391"))
                    w.uint32(90).string(m.localeLanguageIso6391);
                if (m.localeCountryIso31661Alpha2 != null && Object.hasOwnProperty.call(m, "localeCountryIso31661Alpha2"))
                    w.uint32(98).string(m.localeCountryIso31661Alpha2);
                if (m.deviceBoard != null && Object.hasOwnProperty.call(m, "deviceBoard"))
                    w.uint32(106).string(m.deviceBoard);
                if (m.deviceExpId != null && Object.hasOwnProperty.call(m, "deviceExpId"))
                    w.uint32(114).string(m.deviceExpId);
                if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                    w.uint32(120).int32(m.deviceType);
                if (m.deviceModelType != null && Object.hasOwnProperty.call(m, "deviceModelType"))
                    w.uint32(130).string(m.deviceModelType);
                return w;
            };

            UserAgent.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.UserAgent();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.platform = r.int32();
                            break;
                        }
                    case 2: {
                            m.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.mcc = r.string();
                            break;
                        }
                    case 4: {
                            m.mnc = r.string();
                            break;
                        }
                    case 5: {
                            m.osVersion = r.string();
                            break;
                        }
                    case 6: {
                            m.manufacturer = r.string();
                            break;
                        }
                    case 7: {
                            m.device = r.string();
                            break;
                        }
                    case 8: {
                            m.osBuildNumber = r.string();
                            break;
                        }
                    case 9: {
                            m.phoneId = r.string();
                            break;
                        }
                    case 10: {
                            m.releaseChannel = r.int32();
                            break;
                        }
                    case 11: {
                            m.localeLanguageIso6391 = r.string();
                            break;
                        }
                    case 12: {
                            m.localeCountryIso31661Alpha2 = r.string();
                            break;
                        }
                    case 13: {
                            m.deviceBoard = r.string();
                            break;
                        }
                    case 14: {
                            m.deviceExpId = r.string();
                            break;
                        }
                    case 15: {
                            m.deviceType = r.int32();
                            break;
                        }
                    case 16: {
                            m.deviceModelType = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            UserAgent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.UserAgent";
            };

            UserAgent.AppVersion = (function() {

                function AppVersion(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                AppVersion.prototype.primary = 0;
                AppVersion.prototype.secondary = 0;
                AppVersion.prototype.tertiary = 0;
                AppVersion.prototype.quaternary = 0;
                AppVersion.prototype.quinary = 0;

                AppVersion.create = function create(properties) {
                    return new AppVersion(properties);
                };

                AppVersion.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.primary != null && Object.hasOwnProperty.call(m, "primary"))
                        w.uint32(8).uint32(m.primary);
                    if (m.secondary != null && Object.hasOwnProperty.call(m, "secondary"))
                        w.uint32(16).uint32(m.secondary);
                    if (m.tertiary != null && Object.hasOwnProperty.call(m, "tertiary"))
                        w.uint32(24).uint32(m.tertiary);
                    if (m.quaternary != null && Object.hasOwnProperty.call(m, "quaternary"))
                        w.uint32(32).uint32(m.quaternary);
                    if (m.quinary != null && Object.hasOwnProperty.call(m, "quinary"))
                        w.uint32(40).uint32(m.quinary);
                    return w;
                };

                AppVersion.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.primary = r.uint32();
                                break;
                            }
                        case 2: {
                                m.secondary = r.uint32();
                                break;
                            }
                        case 3: {
                                m.tertiary = r.uint32();
                                break;
                            }
                        case 4: {
                                m.quaternary = r.uint32();
                                break;
                            }
                        case 5: {
                                m.quinary = r.uint32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                AppVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ClientPayload.UserAgent.AppVersion";
                };

                return AppVersion;
            })();

            UserAgent.DeviceType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "PHONE"] = 0;
                values[valuesById[1] = "TABLET"] = 1;
                values[valuesById[2] = "DESKTOP"] = 2;
                values[valuesById[3] = "WEARABLE"] = 3;
                values[valuesById[4] = "VR"] = 4;
                return values;
            })();

            UserAgent.Platform = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "ANDROID"] = 0;
                values[valuesById[1] = "IOS"] = 1;
                values[valuesById[2] = "WINDOWS_PHONE"] = 2;
                values[valuesById[3] = "BLACKBERRY"] = 3;
                values[valuesById[4] = "BLACKBERRYX"] = 4;
                values[valuesById[5] = "S40"] = 5;
                values[valuesById[6] = "S60"] = 6;
                values[valuesById[7] = "PYTHON_CLIENT"] = 7;
                values[valuesById[8] = "TIZEN"] = 8;
                values[valuesById[9] = "ENTERPRISE"] = 9;
                values[valuesById[10] = "SMB_ANDROID"] = 10;
                values[valuesById[11] = "KAIOS"] = 11;
                values[valuesById[12] = "SMB_IOS"] = 12;
                values[valuesById[13] = "WINDOWS"] = 13;
                values[valuesById[14] = "WEB"] = 14;
                values[valuesById[15] = "PORTAL"] = 15;
                values[valuesById[16] = "GREEN_ANDROID"] = 16;
                values[valuesById[17] = "GREEN_IPHONE"] = 17;
                values[valuesById[18] = "BLUE_ANDROID"] = 18;
                values[valuesById[19] = "BLUE_IPHONE"] = 19;
                values[valuesById[20] = "FBLITE_ANDROID"] = 20;
                values[valuesById[21] = "MLITE_ANDROID"] = 21;
                values[valuesById[22] = "IGLITE_ANDROID"] = 22;
                values[valuesById[23] = "PAGE"] = 23;
                values[valuesById[24] = "MACOS"] = 24;
                values[valuesById[25] = "OCULUS_MSG"] = 25;
                values[valuesById[26] = "OCULUS_CALL"] = 26;
                values[valuesById[27] = "MILAN"] = 27;
                values[valuesById[28] = "CAPI"] = 28;
                values[valuesById[29] = "WEAROS"] = 29;
                values[valuesById[30] = "ARDEVICE"] = 30;
                values[valuesById[31] = "VRDEVICE"] = 31;
                values[valuesById[32] = "BLUE_WEB"] = 32;
                values[valuesById[33] = "IPAD"] = 33;
                values[valuesById[34] = "TEST"] = 34;
                values[valuesById[35] = "SMART_GLASSES"] = 35;
                return values;
            })();

            UserAgent.ReleaseChannel = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "RELEASE"] = 0;
                values[valuesById[1] = "BETA"] = 1;
                values[valuesById[2] = "ALPHA"] = 2;
                values[valuesById[3] = "DEBUG"] = 3;
                return values;
            })();

            return UserAgent;
        })();

        ClientPayload.WebInfo = (function() {

            function WebInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            WebInfo.prototype.refToken = "";
            WebInfo.prototype.version = "";
            WebInfo.prototype.webdPayload = null;
            WebInfo.prototype.webSubPlatform = 0;

            WebInfo.create = function create(properties) {
                return new WebInfo(properties);
            };

            WebInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.refToken != null && Object.hasOwnProperty.call(m, "refToken"))
                    w.uint32(10).string(m.refToken);
                if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                    w.uint32(18).string(m.version);
                if (m.webdPayload != null && Object.hasOwnProperty.call(m, "webdPayload"))
                    $root.proto.ClientPayload.WebInfo.WebdPayload.encode(m.webdPayload, w.uint32(26).fork()).ldelim();
                if (m.webSubPlatform != null && Object.hasOwnProperty.call(m, "webSubPlatform"))
                    w.uint32(32).int32(m.webSubPlatform);
                return w;
            };

            WebInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.WebInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.refToken = r.string();
                            break;
                        }
                    case 2: {
                            m.version = r.string();
                            break;
                        }
                    case 3: {
                            m.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.webSubPlatform = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            WebInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ClientPayload.WebInfo";
            };

            WebInfo.WebSubPlatform = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "WEB_BROWSER"] = 0;
                values[valuesById[1] = "APP_STORE"] = 1;
                values[valuesById[2] = "WIN_STORE"] = 2;
                values[valuesById[3] = "DARWIN"] = 3;
                values[valuesById[4] = "WIN32"] = 4;
                values[valuesById[5] = "WIN_HYBRID"] = 5;
                return values;
            })();

            WebInfo.WebdPayload = (function() {

                function WebdPayload(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                WebdPayload.prototype.usesParticipantInKey = false;
                WebdPayload.prototype.supportsStarredMessages = false;
                WebdPayload.prototype.supportsDocumentMessages = false;
                WebdPayload.prototype.supportsUrlMessages = false;
                WebdPayload.prototype.supportsMediaRetry = false;
                WebdPayload.prototype.supportsE2EImage = false;
                WebdPayload.prototype.supportsE2EVideo = false;
                WebdPayload.prototype.supportsE2EAudio = false;
                WebdPayload.prototype.supportsE2EDocument = false;
                WebdPayload.prototype.documentTypes = "";
                WebdPayload.prototype.features = $util.newBuffer([]);

                WebdPayload.create = function create(properties) {
                    return new WebdPayload(properties);
                };

                WebdPayload.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.usesParticipantInKey != null && Object.hasOwnProperty.call(m, "usesParticipantInKey"))
                        w.uint32(8).bool(m.usesParticipantInKey);
                    if (m.supportsStarredMessages != null && Object.hasOwnProperty.call(m, "supportsStarredMessages"))
                        w.uint32(16).bool(m.supportsStarredMessages);
                    if (m.supportsDocumentMessages != null && Object.hasOwnProperty.call(m, "supportsDocumentMessages"))
                        w.uint32(24).bool(m.supportsDocumentMessages);
                    if (m.supportsUrlMessages != null && Object.hasOwnProperty.call(m, "supportsUrlMessages"))
                        w.uint32(32).bool(m.supportsUrlMessages);
                    if (m.supportsMediaRetry != null && Object.hasOwnProperty.call(m, "supportsMediaRetry"))
                        w.uint32(40).bool(m.supportsMediaRetry);
                    if (m.supportsE2EImage != null && Object.hasOwnProperty.call(m, "supportsE2EImage"))
                        w.uint32(48).bool(m.supportsE2EImage);
                    if (m.supportsE2EVideo != null && Object.hasOwnProperty.call(m, "supportsE2EVideo"))
                        w.uint32(56).bool(m.supportsE2EVideo);
                    if (m.supportsE2EAudio != null && Object.hasOwnProperty.call(m, "supportsE2EAudio"))
                        w.uint32(64).bool(m.supportsE2EAudio);
                    if (m.supportsE2EDocument != null && Object.hasOwnProperty.call(m, "supportsE2EDocument"))
                        w.uint32(72).bool(m.supportsE2EDocument);
                    if (m.documentTypes != null && Object.hasOwnProperty.call(m, "documentTypes"))
                        w.uint32(82).string(m.documentTypes);
                    if (m.features != null && Object.hasOwnProperty.call(m, "features"))
                        w.uint32(90).bytes(m.features);
                    return w;
                };

                WebdPayload.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.usesParticipantInKey = r.bool();
                                break;
                            }
                        case 2: {
                                m.supportsStarredMessages = r.bool();
                                break;
                            }
                        case 3: {
                                m.supportsDocumentMessages = r.bool();
                                break;
                            }
                        case 4: {
                                m.supportsUrlMessages = r.bool();
                                break;
                            }
                        case 5: {
                                m.supportsMediaRetry = r.bool();
                                break;
                            }
                        case 6: {
                                m.supportsE2EImage = r.bool();
                                break;
                            }
                        case 7: {
                                m.supportsE2EVideo = r.bool();
                                break;
                            }
                        case 8: {
                                m.supportsE2EAudio = r.bool();
                                break;
                            }
                        case 9: {
                                m.supportsE2EDocument = r.bool();
                                break;
                            }
                        case 10: {
                                m.documentTypes = r.string();
                                break;
                            }
                        case 11: {
                                m.features = r.bytes();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                WebdPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ClientPayload.WebInfo.WebdPayload";
                };

                return WebdPayload;
            })();

            return WebInfo;
        })();

        return ClientPayload;
    })();

    proto.CommentMetadata = (function() {

        function CommentMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CommentMetadata.prototype.commentParentKey = null;
        CommentMetadata.prototype.replyCount = 0;

        CommentMetadata.create = function create(properties) {
            return new CommentMetadata(properties);
        };

        CommentMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.commentParentKey != null && Object.hasOwnProperty.call(m, "commentParentKey"))
                $root.proto.MessageKey.encode(m.commentParentKey, w.uint32(10).fork()).ldelim();
            if (m.replyCount != null && Object.hasOwnProperty.call(m, "replyCount"))
                w.uint32(16).uint32(m.replyCount);
            return w;
        };

        CommentMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CommentMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.commentParentKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.replyCount = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CommentMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CommentMetadata";
        };

        return CommentMetadata;
    })();

    proto.CompanionCommitment = (function() {

        function CompanionCommitment(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CompanionCommitment.prototype.hash = $util.newBuffer([]);

        CompanionCommitment.create = function create(properties) {
            return new CompanionCommitment(properties);
        };

        CompanionCommitment.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.hash != null && Object.hasOwnProperty.call(m, "hash"))
                w.uint32(10).bytes(m.hash);
            return w;
        };

        CompanionCommitment.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CompanionCommitment();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.hash = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CompanionCommitment.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CompanionCommitment";
        };

        return CompanionCommitment;
    })();

    proto.CompanionEphemeralIdentity = (function() {

        function CompanionEphemeralIdentity(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        CompanionEphemeralIdentity.prototype.publicKey = $util.newBuffer([]);
        CompanionEphemeralIdentity.prototype.deviceType = 0;
        CompanionEphemeralIdentity.prototype.ref = "";

        CompanionEphemeralIdentity.create = function create(properties) {
            return new CompanionEphemeralIdentity(properties);
        };

        CompanionEphemeralIdentity.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.publicKey != null && Object.hasOwnProperty.call(m, "publicKey"))
                w.uint32(10).bytes(m.publicKey);
            if (m.deviceType != null && Object.hasOwnProperty.call(m, "deviceType"))
                w.uint32(16).int32(m.deviceType);
            if (m.ref != null && Object.hasOwnProperty.call(m, "ref"))
                w.uint32(26).string(m.ref);
            return w;
        };

        CompanionEphemeralIdentity.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.CompanionEphemeralIdentity();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.publicKey = r.bytes();
                        break;
                    }
                case 2: {
                        m.deviceType = r.int32();
                        break;
                    }
                case 3: {
                        m.ref = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        CompanionEphemeralIdentity.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.CompanionEphemeralIdentity";
        };

        return CompanionEphemeralIdentity;
    })();

    proto.Config = (function() {

        function Config(p) {
            this.field = {};
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Config.prototype.field = $util.emptyObject;
        Config.prototype.version = 0;

        Config.create = function create(properties) {
            return new Config(properties);
        };

        Config.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.field != null && Object.hasOwnProperty.call(m, "field")) {
                for (var ks = Object.keys(m.field), i = 0; i < ks.length; ++i) {
                    w.uint32(10).fork().uint32(8).uint32(ks[i]);
                    $root.proto.Field.encode(m.field[ks[i]], w.uint32(18).fork()).ldelim().ldelim();
                }
            }
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                w.uint32(16).uint32(m.version);
            return w;
        };

        Config.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Config(), k, value;
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (m.field === $util.emptyObject)
                            m.field = {};
                        var c2 = r.uint32() + r.pos;
                        k = 0;
                        value = null;
                        while (r.pos < c2) {
                            var tag2 = r.uint32();
                            switch (tag2 >>> 3) {
                            case 1:
                                k = r.uint32();
                                break;
                            case 2:
                                value = $root.proto.Field.decode(r, r.uint32());
                                break;
                            default:
                                r.skipType(tag2 & 7);
                                break;
                            }
                        }
                        m.field[k] = value;
                        break;
                    }
                case 2: {
                        m.version = r.uint32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Config.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Config";
        };

        return Config;
    })();

    proto.ContextInfo = (function() {

        function ContextInfo(p) {
            this.mentionedJid = [];
            this.groupMentions = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ContextInfo.prototype.stanzaId = "";
        ContextInfo.prototype.participant = "";
        ContextInfo.prototype.quotedMessage = null;
        ContextInfo.prototype.remoteJid = "";
        ContextInfo.prototype.mentionedJid = $util.emptyArray;
        ContextInfo.prototype.conversionSource = "";
        ContextInfo.prototype.conversionData = $util.newBuffer([]);
        ContextInfo.prototype.conversionDelaySeconds = 0;
        ContextInfo.prototype.forwardingScore = 0;
        ContextInfo.prototype.isForwarded = false;
        ContextInfo.prototype.quotedAd = null;
        ContextInfo.prototype.placeholderKey = null;
        ContextInfo.prototype.expiration = 0;
        ContextInfo.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        ContextInfo.prototype.ephemeralSharedSecret = $util.newBuffer([]);
        ContextInfo.prototype.externalAdReply = null;
        ContextInfo.prototype.entryPointConversionSource = "";
        ContextInfo.prototype.entryPointConversionApp = "";
        ContextInfo.prototype.entryPointConversionDelaySeconds = 0;
        ContextInfo.prototype.disappearingMode = null;
        ContextInfo.prototype.actionLink = null;
        ContextInfo.prototype.groupSubject = "";
        ContextInfo.prototype.parentGroupJid = "";
        ContextInfo.prototype.trustBannerType = "";
        ContextInfo.prototype.trustBannerAction = 0;
        ContextInfo.prototype.isSampled = false;
        ContextInfo.prototype.groupMentions = $util.emptyArray;
        ContextInfo.prototype.utm = null;
        ContextInfo.prototype.forwardedNewsletterMessageInfo = null;
        ContextInfo.prototype.businessMessageForwardInfo = null;
        ContextInfo.prototype.smbClientCampaignId = "";
        ContextInfo.prototype.smbServerCampaignId = "";
        ContextInfo.prototype.dataSharingContext = null;
        ContextInfo.prototype.alwaysShowAdAttribution = false;
        ContextInfo.prototype.featureEligibilities = null;
        ContextInfo.prototype.entryPointConversionExternalSource = "";
        ContextInfo.prototype.entryPointConversionExternalMedium = "";
        ContextInfo.prototype.ctwaSignals = "";
        ContextInfo.prototype.ctwaPayload = $util.newBuffer([]);
        ContextInfo.prototype.forwardedAiBotMessageInfo = null;
        ContextInfo.prototype.statusAttributionType = 0;
        ContextInfo.prototype.urlTrackingMap = null;
        ContextInfo.prototype.pairedMediaType = 0;
        ContextInfo.prototype.rankingVersion = 0;
        ContextInfo.prototype.memberLabel = null;
        ContextInfo.prototype.isQuestion = false;
        ContextInfo.prototype.statusSourceType = 0;

        ContextInfo.create = function create(properties) {
            return new ContextInfo(properties);
        };

        ContextInfo.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                w.uint32(10).string(m.stanzaId);
            if (m.participant != null && Object.hasOwnProperty.call(m, "participant"))
                w.uint32(18).string(m.participant);
            if (m.quotedMessage != null && Object.hasOwnProperty.call(m, "quotedMessage"))
                $root.proto.Message.encode(m.quotedMessage, w.uint32(26).fork()).ldelim();
            if (m.remoteJid != null && Object.hasOwnProperty.call(m, "remoteJid"))
                w.uint32(34).string(m.remoteJid);
            if (m.mentionedJid != null && m.mentionedJid.length) {
                for (var i = 0; i < m.mentionedJid.length; ++i)
                    w.uint32(122).string(m.mentionedJid[i]);
            }
            if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                w.uint32(146).string(m.conversionSource);
            if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                w.uint32(154).bytes(m.conversionData);
            if (m.conversionDelaySeconds != null && Object.hasOwnProperty.call(m, "conversionDelaySeconds"))
                w.uint32(160).uint32(m.conversionDelaySeconds);
            if (m.forwardingScore != null && Object.hasOwnProperty.call(m, "forwardingScore"))
                w.uint32(168).uint32(m.forwardingScore);
            if (m.isForwarded != null && Object.hasOwnProperty.call(m, "isForwarded"))
                w.uint32(176).bool(m.isForwarded);
            if (m.quotedAd != null && Object.hasOwnProperty.call(m, "quotedAd"))
                $root.proto.ContextInfo.AdReplyInfo.encode(m.quotedAd, w.uint32(186).fork()).ldelim();
            if (m.placeholderKey != null && Object.hasOwnProperty.call(m, "placeholderKey"))
                $root.proto.MessageKey.encode(m.placeholderKey, w.uint32(194).fork()).ldelim();
            if (m.expiration != null && Object.hasOwnProperty.call(m, "expiration"))
                w.uint32(200).uint32(m.expiration);
            if (m.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(m, "ephemeralSettingTimestamp"))
                w.uint32(208).int64(m.ephemeralSettingTimestamp);
            if (m.ephemeralSharedSecret != null && Object.hasOwnProperty.call(m, "ephemeralSharedSecret"))
                w.uint32(218).bytes(m.ephemeralSharedSecret);
            if (m.externalAdReply != null && Object.hasOwnProperty.call(m, "externalAdReply"))
                $root.proto.ContextInfo.ExternalAdReplyInfo.encode(m.externalAdReply, w.uint32(226).fork()).ldelim();
            if (m.entryPointConversionSource != null && Object.hasOwnProperty.call(m, "entryPointConversionSource"))
                w.uint32(234).string(m.entryPointConversionSource);
            if (m.entryPointConversionApp != null && Object.hasOwnProperty.call(m, "entryPointConversionApp"))
                w.uint32(242).string(m.entryPointConversionApp);
            if (m.entryPointConversionDelaySeconds != null && Object.hasOwnProperty.call(m, "entryPointConversionDelaySeconds"))
                w.uint32(248).uint32(m.entryPointConversionDelaySeconds);
            if (m.disappearingMode != null && Object.hasOwnProperty.call(m, "disappearingMode"))
                $root.proto.DisappearingMode.encode(m.disappearingMode, w.uint32(258).fork()).ldelim();
            if (m.actionLink != null && Object.hasOwnProperty.call(m, "actionLink"))
                $root.proto.ActionLink.encode(m.actionLink, w.uint32(266).fork()).ldelim();
            if (m.groupSubject != null && Object.hasOwnProperty.call(m, "groupSubject"))
                w.uint32(274).string(m.groupSubject);
            if (m.parentGroupJid != null && Object.hasOwnProperty.call(m, "parentGroupJid"))
                w.uint32(282).string(m.parentGroupJid);
            if (m.trustBannerType != null && Object.hasOwnProperty.call(m, "trustBannerType"))
                w.uint32(298).string(m.trustBannerType);
            if (m.trustBannerAction != null && Object.hasOwnProperty.call(m, "trustBannerAction"))
                w.uint32(304).uint32(m.trustBannerAction);
            if (m.isSampled != null && Object.hasOwnProperty.call(m, "isSampled"))
                w.uint32(312).bool(m.isSampled);
            if (m.groupMentions != null && m.groupMentions.length) {
                for (var i = 0; i < m.groupMentions.length; ++i)
                    $root.proto.GroupMention.encode(m.groupMentions[i], w.uint32(322).fork()).ldelim();
            }
            if (m.utm != null && Object.hasOwnProperty.call(m, "utm"))
                $root.proto.ContextInfo.UTMInfo.encode(m.utm, w.uint32(330).fork()).ldelim();
            if (m.forwardedNewsletterMessageInfo != null && Object.hasOwnProperty.call(m, "forwardedNewsletterMessageInfo"))
                $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.encode(m.forwardedNewsletterMessageInfo, w.uint32(346).fork()).ldelim();
            if (m.businessMessageForwardInfo != null && Object.hasOwnProperty.call(m, "businessMessageForwardInfo"))
                $root.proto.ContextInfo.BusinessMessageForwardInfo.encode(m.businessMessageForwardInfo, w.uint32(354).fork()).ldelim();
            if (m.smbClientCampaignId != null && Object.hasOwnProperty.call(m, "smbClientCampaignId"))
                w.uint32(362).string(m.smbClientCampaignId);
            if (m.smbServerCampaignId != null && Object.hasOwnProperty.call(m, "smbServerCampaignId"))
                w.uint32(370).string(m.smbServerCampaignId);
            if (m.dataSharingContext != null && Object.hasOwnProperty.call(m, "dataSharingContext"))
                $root.proto.ContextInfo.DataSharingContext.encode(m.dataSharingContext, w.uint32(378).fork()).ldelim();
            if (m.alwaysShowAdAttribution != null && Object.hasOwnProperty.call(m, "alwaysShowAdAttribution"))
                w.uint32(384).bool(m.alwaysShowAdAttribution);
            if (m.featureEligibilities != null && Object.hasOwnProperty.call(m, "featureEligibilities"))
                $root.proto.ContextInfo.FeatureEligibilities.encode(m.featureEligibilities, w.uint32(394).fork()).ldelim();
            if (m.entryPointConversionExternalSource != null && Object.hasOwnProperty.call(m, "entryPointConversionExternalSource"))
                w.uint32(402).string(m.entryPointConversionExternalSource);
            if (m.entryPointConversionExternalMedium != null && Object.hasOwnProperty.call(m, "entryPointConversionExternalMedium"))
                w.uint32(410).string(m.entryPointConversionExternalMedium);
            if (m.ctwaSignals != null && Object.hasOwnProperty.call(m, "ctwaSignals"))
                w.uint32(434).string(m.ctwaSignals);
            if (m.ctwaPayload != null && Object.hasOwnProperty.call(m, "ctwaPayload"))
                w.uint32(442).bytes(m.ctwaPayload);
            if (m.forwardedAiBotMessageInfo != null && Object.hasOwnProperty.call(m, "forwardedAiBotMessageInfo"))
                $root.proto.ContextInfo.ForwardedAIBotMessageInfo.encode(m.forwardedAiBotMessageInfo, w.uint32(450).fork()).ldelim();
            if (m.statusAttributionType != null && Object.hasOwnProperty.call(m, "statusAttributionType"))
                w.uint32(456).int32(m.statusAttributionType);
            if (m.urlTrackingMap != null && Object.hasOwnProperty.call(m, "urlTrackingMap"))
                $root.proto.UrlTrackingMap.encode(m.urlTrackingMap, w.uint32(466).fork()).ldelim();
            if (m.pairedMediaType != null && Object.hasOwnProperty.call(m, "pairedMediaType"))
                w.uint32(472).int32(m.pairedMediaType);
            if (m.rankingVersion != null && Object.hasOwnProperty.call(m, "rankingVersion"))
                w.uint32(480).uint32(m.rankingVersion);
            if (m.memberLabel != null && Object.hasOwnProperty.call(m, "memberLabel"))
                $root.proto.MemberLabel.encode(m.memberLabel, w.uint32(498).fork()).ldelim();
            if (m.isQuestion != null && Object.hasOwnProperty.call(m, "isQuestion"))
                w.uint32(504).bool(m.isQuestion);
            if (m.statusSourceType != null && Object.hasOwnProperty.call(m, "statusSourceType"))
                w.uint32(512).int32(m.statusSourceType);
            return w;
        };

        ContextInfo.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.stanzaId = r.string();
                        break;
                    }
                case 2: {
                        m.participant = r.string();
                        break;
                    }
                case 3: {
                        m.quotedMessage = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.remoteJid = r.string();
                        break;
                    }
                case 15: {
                        if (!(m.mentionedJid && m.mentionedJid.length))
                            m.mentionedJid = [];
                        m.mentionedJid.push(r.string());
                        break;
                    }
                case 18: {
                        m.conversionSource = r.string();
                        break;
                    }
                case 19: {
                        m.conversionData = r.bytes();
                        break;
                    }
                case 20: {
                        m.conversionDelaySeconds = r.uint32();
                        break;
                    }
                case 21: {
                        m.forwardingScore = r.uint32();
                        break;
                    }
                case 22: {
                        m.isForwarded = r.bool();
                        break;
                    }
                case 23: {
                        m.quotedAd = $root.proto.ContextInfo.AdReplyInfo.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.placeholderKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 25: {
                        m.expiration = r.uint32();
                        break;
                    }
                case 26: {
                        m.ephemeralSettingTimestamp = r.int64();
                        break;
                    }
                case 27: {
                        m.ephemeralSharedSecret = r.bytes();
                        break;
                    }
                case 28: {
                        m.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.decode(r, r.uint32());
                        break;
                    }
                case 29: {
                        m.entryPointConversionSource = r.string();
                        break;
                    }
                case 30: {
                        m.entryPointConversionApp = r.string();
                        break;
                    }
                case 31: {
                        m.entryPointConversionDelaySeconds = r.uint32();
                        break;
                    }
                case 32: {
                        m.disappearingMode = $root.proto.DisappearingMode.decode(r, r.uint32());
                        break;
                    }
                case 33: {
                        m.actionLink = $root.proto.ActionLink.decode(r, r.uint32());
                        break;
                    }
                case 34: {
                        m.groupSubject = r.string();
                        break;
                    }
                case 35: {
                        m.parentGroupJid = r.string();
                        break;
                    }
                case 37: {
                        m.trustBannerType = r.string();
                        break;
                    }
                case 38: {
                        m.trustBannerAction = r.uint32();
                        break;
                    }
                case 39: {
                        m.isSampled = r.bool();
                        break;
                    }
                case 40: {
                        if (!(m.groupMentions && m.groupMentions.length))
                            m.groupMentions = [];
                        m.groupMentions.push($root.proto.GroupMention.decode(r, r.uint32()));
                        break;
                    }
                case 41: {
                        m.utm = $root.proto.ContextInfo.UTMInfo.decode(r, r.uint32());
                        break;
                    }
                case 43: {
                        m.forwardedNewsletterMessageInfo = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 44: {
                        m.businessMessageForwardInfo = $root.proto.ContextInfo.BusinessMessageForwardInfo.decode(r, r.uint32());
                        break;
                    }
                case 45: {
                        m.smbClientCampaignId = r.string();
                        break;
                    }
                case 46: {
                        m.smbServerCampaignId = r.string();
                        break;
                    }
                case 47: {
                        m.dataSharingContext = $root.proto.ContextInfo.DataSharingContext.decode(r, r.uint32());
                        break;
                    }
                case 48: {
                        m.alwaysShowAdAttribution = r.bool();
                        break;
                    }
                case 49: {
                        m.featureEligibilities = $root.proto.ContextInfo.FeatureEligibilities.decode(r, r.uint32());
                        break;
                    }
                case 50: {
                        m.entryPointConversionExternalSource = r.string();
                        break;
                    }
                case 51: {
                        m.entryPointConversionExternalMedium = r.string();
                        break;
                    }
                case 54: {
                        m.ctwaSignals = r.string();
                        break;
                    }
                case 55: {
                        m.ctwaPayload = r.bytes();
                        break;
                    }
                case 56: {
                        m.forwardedAiBotMessageInfo = $root.proto.ContextInfo.ForwardedAIBotMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 57: {
                        m.statusAttributionType = r.int32();
                        break;
                    }
                case 58: {
                        m.urlTrackingMap = $root.proto.UrlTrackingMap.decode(r, r.uint32());
                        break;
                    }
                case 59: {
                        m.pairedMediaType = r.int32();
                        break;
                    }
                case 60: {
                        m.rankingVersion = r.uint32();
                        break;
                    }
                case 62: {
                        m.memberLabel = $root.proto.MemberLabel.decode(r, r.uint32());
                        break;
                    }
                case 63: {
                        m.isQuestion = r.bool();
                        break;
                    }
                case 64: {
                        m.statusSourceType = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ContextInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ContextInfo";
        };

        ContextInfo.AdReplyInfo = (function() {

            function AdReplyInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AdReplyInfo.prototype.advertiserName = "";
            AdReplyInfo.prototype.mediaType = 0;
            AdReplyInfo.prototype.jpegThumbnail = $util.newBuffer([]);
            AdReplyInfo.prototype.caption = "";

            AdReplyInfo.create = function create(properties) {
                return new AdReplyInfo(properties);
            };

            AdReplyInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.advertiserName != null && Object.hasOwnProperty.call(m, "advertiserName"))
                    w.uint32(10).string(m.advertiserName);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(16).int32(m.mediaType);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(138).string(m.caption);
                return w;
            };

            AdReplyInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.AdReplyInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.advertiserName = r.string();
                            break;
                        }
                    case 2: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.caption = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AdReplyInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.AdReplyInfo";
            };

            AdReplyInfo.MediaType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return AdReplyInfo;
        })();

        ContextInfo.BusinessMessageForwardInfo = (function() {

            function BusinessMessageForwardInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BusinessMessageForwardInfo.prototype.businessOwnerJid = "";

            BusinessMessageForwardInfo.create = function create(properties) {
                return new BusinessMessageForwardInfo(properties);
            };

            BusinessMessageForwardInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.businessOwnerJid != null && Object.hasOwnProperty.call(m, "businessOwnerJid"))
                    w.uint32(10).string(m.businessOwnerJid);
                return w;
            };

            BusinessMessageForwardInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.BusinessMessageForwardInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.businessOwnerJid = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BusinessMessageForwardInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.BusinessMessageForwardInfo";
            };

            return BusinessMessageForwardInfo;
        })();

        ContextInfo.DataSharingContext = (function() {

            function DataSharingContext(p) {
                this.parameters = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DataSharingContext.prototype.showMmDisclosure = false;
            DataSharingContext.prototype.encryptedSignalTokenConsented = "";
            DataSharingContext.prototype.parameters = $util.emptyArray;

            DataSharingContext.create = function create(properties) {
                return new DataSharingContext(properties);
            };

            DataSharingContext.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.showMmDisclosure != null && Object.hasOwnProperty.call(m, "showMmDisclosure"))
                    w.uint32(8).bool(m.showMmDisclosure);
                if (m.encryptedSignalTokenConsented != null && Object.hasOwnProperty.call(m, "encryptedSignalTokenConsented"))
                    w.uint32(18).string(m.encryptedSignalTokenConsented);
                if (m.parameters != null && m.parameters.length) {
                    for (var i = 0; i < m.parameters.length; ++i)
                        $root.proto.ContextInfo.DataSharingContext.Parameters.encode(m.parameters[i], w.uint32(26).fork()).ldelim();
                }
                return w;
            };

            DataSharingContext.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.DataSharingContext();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.showMmDisclosure = r.bool();
                            break;
                        }
                    case 2: {
                            m.encryptedSignalTokenConsented = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.parameters && m.parameters.length))
                                m.parameters = [];
                            m.parameters.push($root.proto.ContextInfo.DataSharingContext.Parameters.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DataSharingContext.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.DataSharingContext";
            };

            DataSharingContext.Parameters = (function() {

                function Parameters(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Parameters.prototype.key = "";
                Parameters.prototype.stringData = "";
                Parameters.prototype.intData = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
                Parameters.prototype.floatData = 0;
                Parameters.prototype.contents = null;

                Parameters.create = function create(properties) {
                    return new Parameters(properties);
                };

                Parameters.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                        w.uint32(10).string(m.key);
                    if (m.stringData != null && Object.hasOwnProperty.call(m, "stringData"))
                        w.uint32(18).string(m.stringData);
                    if (m.intData != null && Object.hasOwnProperty.call(m, "intData"))
                        w.uint32(24).int64(m.intData);
                    if (m.floatData != null && Object.hasOwnProperty.call(m, "floatData"))
                        w.uint32(37).float(m.floatData);
                    if (m.contents != null && Object.hasOwnProperty.call(m, "contents"))
                        $root.proto.ContextInfo.DataSharingContext.Parameters.encode(m.contents, w.uint32(42).fork()).ldelim();
                    return w;
                };

                Parameters.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.DataSharingContext.Parameters();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.key = r.string();
                                break;
                            }
                        case 2: {
                                m.stringData = r.string();
                                break;
                            }
                        case 3: {
                                m.intData = r.int64();
                                break;
                            }
                        case 4: {
                                m.floatData = r.float();
                                break;
                            }
                        case 5: {
                                m.contents = $root.proto.ContextInfo.DataSharingContext.Parameters.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Parameters.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.ContextInfo.DataSharingContext.Parameters";
                };

                return Parameters;
            })();

            return DataSharingContext;
        })();

        ContextInfo.ExternalAdReplyInfo = (function() {

            function ExternalAdReplyInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ExternalAdReplyInfo.prototype.title = "";
            ExternalAdReplyInfo.prototype.body = "";
            ExternalAdReplyInfo.prototype.mediaType = 0;
            ExternalAdReplyInfo.prototype.thumbnailUrl = "";
            ExternalAdReplyInfo.prototype.mediaUrl = "";
            ExternalAdReplyInfo.prototype.thumbnail = $util.newBuffer([]);
            ExternalAdReplyInfo.prototype.sourceType = "";
            ExternalAdReplyInfo.prototype.sourceId = "";
            ExternalAdReplyInfo.prototype.sourceUrl = "";
            ExternalAdReplyInfo.prototype.containsAutoReply = false;
            ExternalAdReplyInfo.prototype.renderLargerThumbnail = false;
            ExternalAdReplyInfo.prototype.showAdAttribution = false;
            ExternalAdReplyInfo.prototype.ctwaClid = "";
            ExternalAdReplyInfo.prototype.ref = "";
            ExternalAdReplyInfo.prototype.clickToWhatsappCall = false;
            ExternalAdReplyInfo.prototype.adContextPreviewDismissed = false;
            ExternalAdReplyInfo.prototype.sourceApp = "";
            ExternalAdReplyInfo.prototype.automatedGreetingMessageShown = false;
            ExternalAdReplyInfo.prototype.greetingMessageBody = "";
            ExternalAdReplyInfo.prototype.ctaPayload = "";
            ExternalAdReplyInfo.prototype.disableNudge = false;
            ExternalAdReplyInfo.prototype.originalImageUrl = "";
            ExternalAdReplyInfo.prototype.automatedGreetingMessageCtaType = "";
            ExternalAdReplyInfo.prototype.wtwaAdFormat = false;
            ExternalAdReplyInfo.prototype.adType = 0;

            ExternalAdReplyInfo.create = function create(properties) {
                return new ExternalAdReplyInfo(properties);
            };

            ExternalAdReplyInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    w.uint32(18).string(m.body);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(24).int32(m.mediaType);
                if (m.thumbnailUrl != null && Object.hasOwnProperty.call(m, "thumbnailUrl"))
                    w.uint32(34).string(m.thumbnailUrl);
                if (m.mediaUrl != null && Object.hasOwnProperty.call(m, "mediaUrl"))
                    w.uint32(42).string(m.mediaUrl);
                if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                    w.uint32(50).bytes(m.thumbnail);
                if (m.sourceType != null && Object.hasOwnProperty.call(m, "sourceType"))
                    w.uint32(58).string(m.sourceType);
                if (m.sourceId != null && Object.hasOwnProperty.call(m, "sourceId"))
                    w.uint32(66).string(m.sourceId);
                if (m.sourceUrl != null && Object.hasOwnProperty.call(m, "sourceUrl"))
                    w.uint32(74).string(m.sourceUrl);
                if (m.containsAutoReply != null && Object.hasOwnProperty.call(m, "containsAutoReply"))
                    w.uint32(80).bool(m.containsAutoReply);
                if (m.renderLargerThumbnail != null && Object.hasOwnProperty.call(m, "renderLargerThumbnail"))
                    w.uint32(88).bool(m.renderLargerThumbnail);
                if (m.showAdAttribution != null && Object.hasOwnProperty.call(m, "showAdAttribution"))
                    w.uint32(96).bool(m.showAdAttribution);
                if (m.ctwaClid != null && Object.hasOwnProperty.call(m, "ctwaClid"))
                    w.uint32(106).string(m.ctwaClid);
                if (m.ref != null && Object.hasOwnProperty.call(m, "ref"))
                    w.uint32(114).string(m.ref);
                if (m.clickToWhatsappCall != null && Object.hasOwnProperty.call(m, "clickToWhatsappCall"))
                    w.uint32(120).bool(m.clickToWhatsappCall);
                if (m.adContextPreviewDismissed != null && Object.hasOwnProperty.call(m, "adContextPreviewDismissed"))
                    w.uint32(128).bool(m.adContextPreviewDismissed);
                if (m.sourceApp != null && Object.hasOwnProperty.call(m, "sourceApp"))
                    w.uint32(138).string(m.sourceApp);
                if (m.automatedGreetingMessageShown != null && Object.hasOwnProperty.call(m, "automatedGreetingMessageShown"))
                    w.uint32(144).bool(m.automatedGreetingMessageShown);
                if (m.greetingMessageBody != null && Object.hasOwnProperty.call(m, "greetingMessageBody"))
                    w.uint32(154).string(m.greetingMessageBody);
                if (m.ctaPayload != null && Object.hasOwnProperty.call(m, "ctaPayload"))
                    w.uint32(162).string(m.ctaPayload);
                if (m.disableNudge != null && Object.hasOwnProperty.call(m, "disableNudge"))
                    w.uint32(168).bool(m.disableNudge);
                if (m.originalImageUrl != null && Object.hasOwnProperty.call(m, "originalImageUrl"))
                    w.uint32(178).string(m.originalImageUrl);
                if (m.automatedGreetingMessageCtaType != null && Object.hasOwnProperty.call(m, "automatedGreetingMessageCtaType"))
                    w.uint32(186).string(m.automatedGreetingMessageCtaType);
                if (m.wtwaAdFormat != null && Object.hasOwnProperty.call(m, "wtwaAdFormat"))
                    w.uint32(192).bool(m.wtwaAdFormat);
                if (m.adType != null && Object.hasOwnProperty.call(m, "adType"))
                    w.uint32(200).int32(m.adType);
                return w;
            };

            ExternalAdReplyInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ExternalAdReplyInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    case 2: {
                            m.body = r.string();
                            break;
                        }
                    case 3: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 4: {
                            m.thumbnailUrl = r.string();
                            break;
                        }
                    case 5: {
                            m.mediaUrl = r.string();
                            break;
                        }
                    case 6: {
                            m.thumbnail = r.bytes();
                            break;
                        }
                    case 7: {
                            m.sourceType = r.string();
                            break;
                        }
                    case 8: {
                            m.sourceId = r.string();
                            break;
                        }
                    case 9: {
                            m.sourceUrl = r.string();
                            break;
                        }
                    case 10: {
                            m.containsAutoReply = r.bool();
                            break;
                        }
                    case 11: {
                            m.renderLargerThumbnail = r.bool();
                            break;
                        }
                    case 12: {
                            m.showAdAttribution = r.bool();
                            break;
                        }
                    case 13: {
                            m.ctwaClid = r.string();
                            break;
                        }
                    case 14: {
                            m.ref = r.string();
                            break;
                        }
                    case 15: {
                            m.clickToWhatsappCall = r.bool();
                            break;
                        }
                    case 16: {
                            m.adContextPreviewDismissed = r.bool();
                            break;
                        }
                    case 17: {
                            m.sourceApp = r.string();
                            break;
                        }
                    case 18: {
                            m.automatedGreetingMessageShown = r.bool();
                            break;
                        }
                    case 19: {
                            m.greetingMessageBody = r.string();
                            break;
                        }
                    case 20: {
                            m.ctaPayload = r.string();
                            break;
                        }
                    case 21: {
                            m.disableNudge = r.bool();
                            break;
                        }
                    case 22: {
                            m.originalImageUrl = r.string();
                            break;
                        }
                    case 23: {
                            m.automatedGreetingMessageCtaType = r.string();
                            break;
                        }
                    case 24: {
                            m.wtwaAdFormat = r.bool();
                            break;
                        }
                    case 25: {
                            m.adType = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ExternalAdReplyInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.ExternalAdReplyInfo";
            };

            ExternalAdReplyInfo.AdType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "CTWA"] = 0;
                values[valuesById[1] = "CAWC"] = 1;
                return values;
            })();

            ExternalAdReplyInfo.MediaType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return ExternalAdReplyInfo;
        })();

        ContextInfo.FeatureEligibilities = (function() {

            function FeatureEligibilities(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            FeatureEligibilities.prototype.cannotBeReactedTo = false;
            FeatureEligibilities.prototype.cannotBeRanked = false;
            FeatureEligibilities.prototype.canRequestFeedback = false;
            FeatureEligibilities.prototype.canBeReshared = false;

            FeatureEligibilities.create = function create(properties) {
                return new FeatureEligibilities(properties);
            };

            FeatureEligibilities.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.cannotBeReactedTo != null && Object.hasOwnProperty.call(m, "cannotBeReactedTo"))
                    w.uint32(8).bool(m.cannotBeReactedTo);
                if (m.cannotBeRanked != null && Object.hasOwnProperty.call(m, "cannotBeRanked"))
                    w.uint32(16).bool(m.cannotBeRanked);
                if (m.canRequestFeedback != null && Object.hasOwnProperty.call(m, "canRequestFeedback"))
                    w.uint32(24).bool(m.canRequestFeedback);
                if (m.canBeReshared != null && Object.hasOwnProperty.call(m, "canBeReshared"))
                    w.uint32(32).bool(m.canBeReshared);
                return w;
            };

            FeatureEligibilities.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.FeatureEligibilities();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.cannotBeReactedTo = r.bool();
                            break;
                        }
                    case 2: {
                            m.cannotBeRanked = r.bool();
                            break;
                        }
                    case 3: {
                            m.canRequestFeedback = r.bool();
                            break;
                        }
                    case 4: {
                            m.canBeReshared = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            FeatureEligibilities.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.FeatureEligibilities";
            };

            return FeatureEligibilities;
        })();

        ContextInfo.ForwardedAIBotMessageInfo = (function() {

            function ForwardedAIBotMessageInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ForwardedAIBotMessageInfo.prototype.botName = "";
            ForwardedAIBotMessageInfo.prototype.botJid = "";
            ForwardedAIBotMessageInfo.prototype.creatorName = "";

            ForwardedAIBotMessageInfo.create = function create(properties) {
                return new ForwardedAIBotMessageInfo(properties);
            };

            ForwardedAIBotMessageInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.botName != null && Object.hasOwnProperty.call(m, "botName"))
                    w.uint32(10).string(m.botName);
                if (m.botJid != null && Object.hasOwnProperty.call(m, "botJid"))
                    w.uint32(18).string(m.botJid);
                if (m.creatorName != null && Object.hasOwnProperty.call(m, "creatorName"))
                    w.uint32(26).string(m.creatorName);
                return w;
            };

            ForwardedAIBotMessageInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ForwardedAIBotMessageInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.botName = r.string();
                            break;
                        }
                    case 2: {
                            m.botJid = r.string();
                            break;
                        }
                    case 3: {
                            m.creatorName = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ForwardedAIBotMessageInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.ForwardedAIBotMessageInfo";
            };

            return ForwardedAIBotMessageInfo;
        })();

        ContextInfo.ForwardedNewsletterMessageInfo = (function() {

            function ForwardedNewsletterMessageInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ForwardedNewsletterMessageInfo.prototype.newsletterJid = "";
            ForwardedNewsletterMessageInfo.prototype.serverMessageId = 0;
            ForwardedNewsletterMessageInfo.prototype.newsletterName = "";
            ForwardedNewsletterMessageInfo.prototype.contentType = 1;
            ForwardedNewsletterMessageInfo.prototype.accessibilityText = "";

            ForwardedNewsletterMessageInfo.create = function create(properties) {
                return new ForwardedNewsletterMessageInfo(properties);
            };

            ForwardedNewsletterMessageInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.newsletterJid != null && Object.hasOwnProperty.call(m, "newsletterJid"))
                    w.uint32(10).string(m.newsletterJid);
                if (m.serverMessageId != null && Object.hasOwnProperty.call(m, "serverMessageId"))
                    w.uint32(16).int32(m.serverMessageId);
                if (m.newsletterName != null && Object.hasOwnProperty.call(m, "newsletterName"))
                    w.uint32(26).string(m.newsletterName);
                if (m.contentType != null && Object.hasOwnProperty.call(m, "contentType"))
                    w.uint32(32).int32(m.contentType);
                if (m.accessibilityText != null && Object.hasOwnProperty.call(m, "accessibilityText"))
                    w.uint32(42).string(m.accessibilityText);
                return w;
            };

            ForwardedNewsletterMessageInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.ForwardedNewsletterMessageInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.newsletterJid = r.string();
                            break;
                        }
                    case 2: {
                            m.serverMessageId = r.int32();
                            break;
                        }
                    case 3: {
                            m.newsletterName = r.string();
                            break;
                        }
                    case 4: {
                            m.contentType = r.int32();
                            break;
                        }
                    case 5: {
                            m.accessibilityText = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ForwardedNewsletterMessageInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.ForwardedNewsletterMessageInfo";
            };

            ForwardedNewsletterMessageInfo.ContentType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "UPDATE"] = 1;
                values[valuesById[2] = "UPDATE_CARD"] = 2;
                values[valuesById[3] = "LINK_CARD"] = 3;
                return values;
            })();

            return ForwardedNewsletterMessageInfo;
        })();

        ContextInfo.PairedMediaType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NOT_PAIRED_MEDIA"] = 0;
            values[valuesById[1] = "SD_VIDEO_PARENT"] = 1;
            values[valuesById[2] = "HD_VIDEO_CHILD"] = 2;
            values[valuesById[3] = "SD_IMAGE_PARENT"] = 3;
            values[valuesById[4] = "HD_IMAGE_CHILD"] = 4;
            values[valuesById[5] = "MOTION_PHOTO_PARENT"] = 5;
            values[valuesById[6] = "MOTION_PHOTO_CHILD"] = 6;
            return values;
        })();

        ContextInfo.StatusAttributionType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "RESHARED_FROM_MENTION"] = 1;
            values[valuesById[2] = "RESHARED_FROM_POST"] = 2;
            return values;
        })();

        ContextInfo.StatusSourceType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "IMAGE"] = 0;
            values[valuesById[1] = "VIDEO"] = 1;
            values[valuesById[2] = "GIF"] = 2;
            values[valuesById[3] = "AUDIO"] = 3;
            values[valuesById[4] = "TEXT"] = 4;
            values[valuesById[5] = "MUSIC_STANDALONE"] = 5;
            return values;
        })();

        ContextInfo.UTMInfo = (function() {

            function UTMInfo(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            UTMInfo.prototype.utmSource = "";
            UTMInfo.prototype.utmCampaign = "";

            UTMInfo.create = function create(properties) {
                return new UTMInfo(properties);
            };

            UTMInfo.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.utmSource != null && Object.hasOwnProperty.call(m, "utmSource"))
                    w.uint32(10).string(m.utmSource);
                if (m.utmCampaign != null && Object.hasOwnProperty.call(m, "utmCampaign"))
                    w.uint32(18).string(m.utmCampaign);
                return w;
            };

            UTMInfo.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ContextInfo.UTMInfo();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.utmSource = r.string();
                            break;
                        }
                    case 2: {
                            m.utmCampaign = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            UTMInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.ContextInfo.UTMInfo";
            };

            return UTMInfo;
        })();

        return ContextInfo;
    })();

    proto.Conversation = (function() {

        function Conversation(p) {
            this.messages = [];
            this.participant = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Conversation.prototype.id = "";
        Conversation.prototype.messages = $util.emptyArray;
        Conversation.prototype.newJid = "";
        Conversation.prototype.oldJid = "";
        Conversation.prototype.lastMsgTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        Conversation.prototype.unreadCount = 0;
        Conversation.prototype.readOnly = false;
        Conversation.prototype.endOfHistoryTransfer = false;
        Conversation.prototype.ephemeralExpiration = 0;
        Conversation.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        Conversation.prototype.endOfHistoryTransferType = 0;
        Conversation.prototype.conversationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        Conversation.prototype.name = "";
        Conversation.prototype.pHash = "";
        Conversation.prototype.notSpam = false;
        Conversation.prototype.archived = false;
        Conversation.prototype.disappearingMode = null;
        Conversation.prototype.unreadMentionCount = 0;
        Conversation.prototype.markedAsUnread = false;
        Conversation.prototype.participant = $util.emptyArray;
        Conversation.prototype.tcToken = $util.newBuffer([]);
        Conversation.prototype.tcTokenTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        Conversation.prototype.contactPrimaryIdentityKey = $util.newBuffer([]);
        Conversation.prototype.pinned = 0;
        Conversation.prototype.muteEndTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        Conversation.prototype.wallpaper = null;
        Conversation.prototype.mediaVisibility = 0;
        Conversation.prototype.tcTokenSenderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        Conversation.prototype.suspended = false;
        Conversation.prototype.terminated = false;
        Conversation.prototype.createdAt = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        Conversation.prototype.createdBy = "";
        Conversation.prototype.description = "";
        Conversation.prototype.support = false;
        Conversation.prototype.isParentGroup = false;
        Conversation.prototype.parentGroupId = "";
        Conversation.prototype.isDefaultSubgroup = false;
        Conversation.prototype.displayName = "";
        Conversation.prototype.pnJid = "";
        Conversation.prototype.shareOwnPn = false;
        Conversation.prototype.pnhDuplicateLidThread = false;
        Conversation.prototype.lidJid = "";
        Conversation.prototype.username = "";
        Conversation.prototype.lidOriginType = "";
        Conversation.prototype.commentsCount = 0;
        Conversation.prototype.locked = false;
        Conversation.prototype.systemMessageToInsert = 1;
        Conversation.prototype.capiCreatedGroup = false;
        Conversation.prototype.accountLid = "";
        Conversation.prototype.limitSharing = false;
        Conversation.prototype.limitSharingSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        Conversation.prototype.limitSharingTrigger = 0;
        Conversation.prototype.limitSharingInitiatedByMe = false;

        Conversation.create = function create(properties) {
            return new Conversation(properties);
        };

        Conversation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            w.uint32(10).string(m.id);
            if (m.messages != null && m.messages.length) {
                for (var i = 0; i < m.messages.length; ++i)
                    $root.proto.HistorySyncMsg.encode(m.messages[i], w.uint32(18).fork()).ldelim();
            }
            if (m.newJid != null && Object.hasOwnProperty.call(m, "newJid"))
                w.uint32(26).string(m.newJid);
            if (m.oldJid != null && Object.hasOwnProperty.call(m, "oldJid"))
                w.uint32(34).string(m.oldJid);
            if (m.lastMsgTimestamp != null && Object.hasOwnProperty.call(m, "lastMsgTimestamp"))
                w.uint32(40).uint64(m.lastMsgTimestamp);
            if (m.unreadCount != null && Object.hasOwnProperty.call(m, "unreadCount"))
                w.uint32(48).uint32(m.unreadCount);
            if (m.readOnly != null && Object.hasOwnProperty.call(m, "readOnly"))
                w.uint32(56).bool(m.readOnly);
            if (m.endOfHistoryTransfer != null && Object.hasOwnProperty.call(m, "endOfHistoryTransfer"))
                w.uint32(64).bool(m.endOfHistoryTransfer);
            if (m.ephemeralExpiration != null && Object.hasOwnProperty.call(m, "ephemeralExpiration"))
                w.uint32(72).uint32(m.ephemeralExpiration);
            if (m.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(m, "ephemeralSettingTimestamp"))
                w.uint32(80).int64(m.ephemeralSettingTimestamp);
            if (m.endOfHistoryTransferType != null && Object.hasOwnProperty.call(m, "endOfHistoryTransferType"))
                w.uint32(88).int32(m.endOfHistoryTransferType);
            if (m.conversationTimestamp != null && Object.hasOwnProperty.call(m, "conversationTimestamp"))
                w.uint32(96).uint64(m.conversationTimestamp);
            if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                w.uint32(106).string(m.name);
            if (m.pHash != null && Object.hasOwnProperty.call(m, "pHash"))
                w.uint32(114).string(m.pHash);
            if (m.notSpam != null && Object.hasOwnProperty.call(m, "notSpam"))
                w.uint32(120).bool(m.notSpam);
            if (m.archived != null && Object.hasOwnProperty.call(m, "archived"))
                w.uint32(128).bool(m.archived);
            if (m.disappearingMode != null && Object.hasOwnProperty.call(m, "disappearingMode"))
                $root.proto.DisappearingMode.encode(m.disappearingMode, w.uint32(138).fork()).ldelim();
            if (m.unreadMentionCount != null && Object.hasOwnProperty.call(m, "unreadMentionCount"))
                w.uint32(144).uint32(m.unreadMentionCount);
            if (m.markedAsUnread != null && Object.hasOwnProperty.call(m, "markedAsUnread"))
                w.uint32(152).bool(m.markedAsUnread);
            if (m.participant != null && m.participant.length) {
                for (var i = 0; i < m.participant.length; ++i)
                    $root.proto.GroupParticipant.encode(m.participant[i], w.uint32(162).fork()).ldelim();
            }
            if (m.tcToken != null && Object.hasOwnProperty.call(m, "tcToken"))
                w.uint32(170).bytes(m.tcToken);
            if (m.tcTokenTimestamp != null && Object.hasOwnProperty.call(m, "tcTokenTimestamp"))
                w.uint32(176).uint64(m.tcTokenTimestamp);
            if (m.contactPrimaryIdentityKey != null && Object.hasOwnProperty.call(m, "contactPrimaryIdentityKey"))
                w.uint32(186).bytes(m.contactPrimaryIdentityKey);
            if (m.pinned != null && Object.hasOwnProperty.call(m, "pinned"))
                w.uint32(192).uint32(m.pinned);
            if (m.muteEndTime != null && Object.hasOwnProperty.call(m, "muteEndTime"))
                w.uint32(200).uint64(m.muteEndTime);
            if (m.wallpaper != null && Object.hasOwnProperty.call(m, "wallpaper"))
                $root.proto.WallpaperSettings.encode(m.wallpaper, w.uint32(210).fork()).ldelim();
            if (m.mediaVisibility != null && Object.hasOwnProperty.call(m, "mediaVisibility"))
                w.uint32(216).int32(m.mediaVisibility);
            if (m.tcTokenSenderTimestamp != null && Object.hasOwnProperty.call(m, "tcTokenSenderTimestamp"))
                w.uint32(224).uint64(m.tcTokenSenderTimestamp);
            if (m.suspended != null && Object.hasOwnProperty.call(m, "suspended"))
                w.uint32(232).bool(m.suspended);
            if (m.terminated != null && Object.hasOwnProperty.call(m, "terminated"))
                w.uint32(240).bool(m.terminated);
            if (m.createdAt != null && Object.hasOwnProperty.call(m, "createdAt"))
                w.uint32(248).uint64(m.createdAt);
            if (m.createdBy != null && Object.hasOwnProperty.call(m, "createdBy"))
                w.uint32(258).string(m.createdBy);
            if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                w.uint32(266).string(m.description);
            if (m.support != null && Object.hasOwnProperty.call(m, "support"))
                w.uint32(272).bool(m.support);
            if (m.isParentGroup != null && Object.hasOwnProperty.call(m, "isParentGroup"))
                w.uint32(280).bool(m.isParentGroup);
            if (m.isDefaultSubgroup != null && Object.hasOwnProperty.call(m, "isDefaultSubgroup"))
                w.uint32(288).bool(m.isDefaultSubgroup);
            if (m.parentGroupId != null && Object.hasOwnProperty.call(m, "parentGroupId"))
                w.uint32(298).string(m.parentGroupId);
            if (m.displayName != null && Object.hasOwnProperty.call(m, "displayName"))
                w.uint32(306).string(m.displayName);
            if (m.pnJid != null && Object.hasOwnProperty.call(m, "pnJid"))
                w.uint32(314).string(m.pnJid);
            if (m.shareOwnPn != null && Object.hasOwnProperty.call(m, "shareOwnPn"))
                w.uint32(320).bool(m.shareOwnPn);
            if (m.pnhDuplicateLidThread != null && Object.hasOwnProperty.call(m, "pnhDuplicateLidThread"))
                w.uint32(328).bool(m.pnhDuplicateLidThread);
            if (m.lidJid != null && Object.hasOwnProperty.call(m, "lidJid"))
                w.uint32(338).string(m.lidJid);
            if (m.username != null && Object.hasOwnProperty.call(m, "username"))
                w.uint32(346).string(m.username);
            if (m.lidOriginType != null && Object.hasOwnProperty.call(m, "lidOriginType"))
                w.uint32(354).string(m.lidOriginType);
            if (m.commentsCount != null && Object.hasOwnProperty.call(m, "commentsCount"))
                w.uint32(360).uint32(m.commentsCount);
            if (m.locked != null && Object.hasOwnProperty.call(m, "locked"))
                w.uint32(368).bool(m.locked);
            if (m.systemMessageToInsert != null && Object.hasOwnProperty.call(m, "systemMessageToInsert"))
                w.uint32(376).int32(m.systemMessageToInsert);
            if (m.capiCreatedGroup != null && Object.hasOwnProperty.call(m, "capiCreatedGroup"))
                w.uint32(384).bool(m.capiCreatedGroup);
            if (m.accountLid != null && Object.hasOwnProperty.call(m, "accountLid"))
                w.uint32(394).string(m.accountLid);
            if (m.limitSharing != null && Object.hasOwnProperty.call(m, "limitSharing"))
                w.uint32(400).bool(m.limitSharing);
            if (m.limitSharingSettingTimestamp != null && Object.hasOwnProperty.call(m, "limitSharingSettingTimestamp"))
                w.uint32(408).int64(m.limitSharingSettingTimestamp);
            if (m.limitSharingTrigger != null && Object.hasOwnProperty.call(m, "limitSharingTrigger"))
                w.uint32(416).int32(m.limitSharingTrigger);
            if (m.limitSharingInitiatedByMe != null && Object.hasOwnProperty.call(m, "limitSharingInitiatedByMe"))
                w.uint32(424).bool(m.limitSharingInitiatedByMe);
            return w;
        };

        Conversation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Conversation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.id = r.string();
                        break;
                    }
                case 2: {
                        if (!(m.messages && m.messages.length))
                            m.messages = [];
                        m.messages.push($root.proto.HistorySyncMsg.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        m.newJid = r.string();
                        break;
                    }
                case 4: {
                        m.oldJid = r.string();
                        break;
                    }
                case 5: {
                        m.lastMsgTimestamp = r.uint64();
                        break;
                    }
                case 6: {
                        m.unreadCount = r.uint32();
                        break;
                    }
                case 7: {
                        m.readOnly = r.bool();
                        break;
                    }
                case 8: {
                        m.endOfHistoryTransfer = r.bool();
                        break;
                    }
                case 9: {
                        m.ephemeralExpiration = r.uint32();
                        break;
                    }
                case 10: {
                        m.ephemeralSettingTimestamp = r.int64();
                        break;
                    }
                case 11: {
                        m.endOfHistoryTransferType = r.int32();
                        break;
                    }
                case 12: {
                        m.conversationTimestamp = r.uint64();
                        break;
                    }
                case 13: {
                        m.name = r.string();
                        break;
                    }
                case 14: {
                        m.pHash = r.string();
                        break;
                    }
                case 15: {
                        m.notSpam = r.bool();
                        break;
                    }
                case 16: {
                        m.archived = r.bool();
                        break;
                    }
                case 17: {
                        m.disappearingMode = $root.proto.DisappearingMode.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.unreadMentionCount = r.uint32();
                        break;
                    }
                case 19: {
                        m.markedAsUnread = r.bool();
                        break;
                    }
                case 20: {
                        if (!(m.participant && m.participant.length))
                            m.participant = [];
                        m.participant.push($root.proto.GroupParticipant.decode(r, r.uint32()));
                        break;
                    }
                case 21: {
                        m.tcToken = r.bytes();
                        break;
                    }
                case 22: {
                        m.tcTokenTimestamp = r.uint64();
                        break;
                    }
                case 23: {
                        m.contactPrimaryIdentityKey = r.bytes();
                        break;
                    }
                case 24: {
                        m.pinned = r.uint32();
                        break;
                    }
                case 25: {
                        m.muteEndTime = r.uint64();
                        break;
                    }
                case 26: {
                        m.wallpaper = $root.proto.WallpaperSettings.decode(r, r.uint32());
                        break;
                    }
                case 27: {
                        m.mediaVisibility = r.int32();
                        break;
                    }
                case 28: {
                        m.tcTokenSenderTimestamp = r.uint64();
                        break;
                    }
                case 29: {
                        m.suspended = r.bool();
                        break;
                    }
                case 30: {
                        m.terminated = r.bool();
                        break;
                    }
                case 31: {
                        m.createdAt = r.uint64();
                        break;
                    }
                case 32: {
                        m.createdBy = r.string();
                        break;
                    }
                case 33: {
                        m.description = r.string();
                        break;
                    }
                case 34: {
                        m.support = r.bool();
                        break;
                    }
                case 35: {
                        m.isParentGroup = r.bool();
                        break;
                    }
                case 37: {
                        m.parentGroupId = r.string();
                        break;
                    }
                case 36: {
                        m.isDefaultSubgroup = r.bool();
                        break;
                    }
                case 38: {
                        m.displayName = r.string();
                        break;
                    }
                case 39: {
                        m.pnJid = r.string();
                        break;
                    }
                case 40: {
                        m.shareOwnPn = r.bool();
                        break;
                    }
                case 41: {
                        m.pnhDuplicateLidThread = r.bool();
                        break;
                    }
                case 42: {
                        m.lidJid = r.string();
                        break;
                    }
                case 43: {
                        m.username = r.string();
                        break;
                    }
                case 44: {
                        m.lidOriginType = r.string();
                        break;
                    }
                case 45: {
                        m.commentsCount = r.uint32();
                        break;
                    }
                case 46: {
                        m.locked = r.bool();
                        break;
                    }
                case 47: {
                        m.systemMessageToInsert = r.int32();
                        break;
                    }
                case 48: {
                        m.capiCreatedGroup = r.bool();
                        break;
                    }
                case 49: {
                        m.accountLid = r.string();
                        break;
                    }
                case 50: {
                        m.limitSharing = r.bool();
                        break;
                    }
                case 51: {
                        m.limitSharingSettingTimestamp = r.int64();
                        break;
                    }
                case 52: {
                        m.limitSharingTrigger = r.int32();
                        break;
                    }
                case 53: {
                        m.limitSharingInitiatedByMe = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            if (!m.hasOwnProperty("id"))
                throw $util.ProtocolError("missing required 'id'", { instance: m });
            return m;
        };

        Conversation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Conversation";
        };

        Conversation.EndOfHistoryTransferType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY"] = 0;
            values[valuesById[1] = "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY"] = 1;
            values[valuesById[2] = "COMPLETE_ON_DEMAND_SYNC_BUT_MORE_MSG_REMAIN_ON_PRIMARY"] = 2;
            return values;
        })();

        return Conversation;
    })();

    proto.DeviceCapabilities = (function() {

        function DeviceCapabilities(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceCapabilities.prototype.chatLockSupportLevel = 0;
        DeviceCapabilities.prototype.lidMigration = null;

        DeviceCapabilities.create = function create(properties) {
            return new DeviceCapabilities(properties);
        };

        DeviceCapabilities.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.chatLockSupportLevel != null && Object.hasOwnProperty.call(m, "chatLockSupportLevel"))
                w.uint32(8).int32(m.chatLockSupportLevel);
            if (m.lidMigration != null && Object.hasOwnProperty.call(m, "lidMigration"))
                $root.proto.DeviceCapabilities.LIDMigration.encode(m.lidMigration, w.uint32(18).fork()).ldelim();
            return w;
        };

        DeviceCapabilities.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceCapabilities();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.chatLockSupportLevel = r.int32();
                        break;
                    }
                case 2: {
                        m.lidMigration = $root.proto.DeviceCapabilities.LIDMigration.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceCapabilities.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceCapabilities";
        };

        DeviceCapabilities.ChatLockSupportLevel = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "MINIMAL"] = 1;
            values[valuesById[2] = "FULL"] = 2;
            return values;
        })();

        DeviceCapabilities.LIDMigration = (function() {

            function LIDMigration(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            LIDMigration.prototype.chatDbMigrationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

            LIDMigration.create = function create(properties) {
                return new LIDMigration(properties);
            };

            LIDMigration.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.chatDbMigrationTimestamp != null && Object.hasOwnProperty.call(m, "chatDbMigrationTimestamp"))
                    w.uint32(8).uint64(m.chatDbMigrationTimestamp);
                return w;
            };

            LIDMigration.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceCapabilities.LIDMigration();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.chatDbMigrationTimestamp = r.uint64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            LIDMigration.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.DeviceCapabilities.LIDMigration";
            };

            return LIDMigration;
        })();

        return DeviceCapabilities;
    })();

    proto.DeviceConsistencyCodeMessage = (function() {

        function DeviceConsistencyCodeMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceConsistencyCodeMessage.prototype.generation = 0;
        DeviceConsistencyCodeMessage.prototype.signature = $util.newBuffer([]);

        DeviceConsistencyCodeMessage.create = function create(properties) {
            return new DeviceConsistencyCodeMessage(properties);
        };

        DeviceConsistencyCodeMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.generation != null && Object.hasOwnProperty.call(m, "generation"))
                w.uint32(8).uint32(m.generation);
            if (m.signature != null && Object.hasOwnProperty.call(m, "signature"))
                w.uint32(18).bytes(m.signature);
            return w;
        };

        DeviceConsistencyCodeMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceConsistencyCodeMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.generation = r.uint32();
                        break;
                    }
                case 2: {
                        m.signature = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceConsistencyCodeMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceConsistencyCodeMessage";
        };

        return DeviceConsistencyCodeMessage;
    })();

    proto.DeviceListMetadata = (function() {

        function DeviceListMetadata(p) {
            this.senderKeyIndexes = [];
            this.recipientKeyIndexes = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceListMetadata.prototype.senderKeyHash = $util.newBuffer([]);
        DeviceListMetadata.prototype.senderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        DeviceListMetadata.prototype.senderKeyIndexes = $util.emptyArray;
        DeviceListMetadata.prototype.senderAccountType = 0;
        DeviceListMetadata.prototype.receiverAccountType = 0;
        DeviceListMetadata.prototype.recipientKeyHash = $util.newBuffer([]);
        DeviceListMetadata.prototype.recipientTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        DeviceListMetadata.prototype.recipientKeyIndexes = $util.emptyArray;

        DeviceListMetadata.create = function create(properties) {
            return new DeviceListMetadata(properties);
        };

        DeviceListMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.senderKeyHash != null && Object.hasOwnProperty.call(m, "senderKeyHash"))
                w.uint32(10).bytes(m.senderKeyHash);
            if (m.senderTimestamp != null && Object.hasOwnProperty.call(m, "senderTimestamp"))
                w.uint32(16).uint64(m.senderTimestamp);
            if (m.senderKeyIndexes != null && m.senderKeyIndexes.length) {
                w.uint32(26).fork();
                for (var i = 0; i < m.senderKeyIndexes.length; ++i)
                    w.uint32(m.senderKeyIndexes[i]);
                w.ldelim();
            }
            if (m.senderAccountType != null && Object.hasOwnProperty.call(m, "senderAccountType"))
                w.uint32(32).int32(m.senderAccountType);
            if (m.receiverAccountType != null && Object.hasOwnProperty.call(m, "receiverAccountType"))
                w.uint32(40).int32(m.receiverAccountType);
            if (m.recipientKeyHash != null && Object.hasOwnProperty.call(m, "recipientKeyHash"))
                w.uint32(66).bytes(m.recipientKeyHash);
            if (m.recipientTimestamp != null && Object.hasOwnProperty.call(m, "recipientTimestamp"))
                w.uint32(72).uint64(m.recipientTimestamp);
            if (m.recipientKeyIndexes != null && m.recipientKeyIndexes.length) {
                w.uint32(82).fork();
                for (var i = 0; i < m.recipientKeyIndexes.length; ++i)
                    w.uint32(m.recipientKeyIndexes[i]);
                w.ldelim();
            }
            return w;
        };

        DeviceListMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceListMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.senderKeyHash = r.bytes();
                        break;
                    }
                case 2: {
                        m.senderTimestamp = r.uint64();
                        break;
                    }
                case 3: {
                        if (!(m.senderKeyIndexes && m.senderKeyIndexes.length))
                            m.senderKeyIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.senderKeyIndexes.push(r.uint32());
                        } else
                            m.senderKeyIndexes.push(r.uint32());
                        break;
                    }
                case 4: {
                        m.senderAccountType = r.int32();
                        break;
                    }
                case 5: {
                        m.receiverAccountType = r.int32();
                        break;
                    }
                case 8: {
                        m.recipientKeyHash = r.bytes();
                        break;
                    }
                case 9: {
                        m.recipientTimestamp = r.uint64();
                        break;
                    }
                case 10: {
                        if (!(m.recipientKeyIndexes && m.recipientKeyIndexes.length))
                            m.recipientKeyIndexes = [];
                        if ((t & 7) === 2) {
                            var c2 = r.uint32() + r.pos;
                            while (r.pos < c2)
                                m.recipientKeyIndexes.push(r.uint32());
                        } else
                            m.recipientKeyIndexes.push(r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceListMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceListMetadata";
        };

        return DeviceListMetadata;
    })();

    proto.DeviceProps = (function() {

        function DeviceProps(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DeviceProps.prototype.os = "";
        DeviceProps.prototype.version = null;
        DeviceProps.prototype.platformType = 0;
        DeviceProps.prototype.requireFullSync = false;
        DeviceProps.prototype.historySyncConfig = null;

        DeviceProps.create = function create(properties) {
            return new DeviceProps(properties);
        };

        DeviceProps.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.os != null && Object.hasOwnProperty.call(m, "os"))
                w.uint32(10).string(m.os);
            if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                $root.proto.DeviceProps.AppVersion.encode(m.version, w.uint32(18).fork()).ldelim();
            if (m.platformType != null && Object.hasOwnProperty.call(m, "platformType"))
                w.uint32(24).int32(m.platformType);
            if (m.requireFullSync != null && Object.hasOwnProperty.call(m, "requireFullSync"))
                w.uint32(32).bool(m.requireFullSync);
            if (m.historySyncConfig != null && Object.hasOwnProperty.call(m, "historySyncConfig"))
                $root.proto.DeviceProps.HistorySyncConfig.encode(m.historySyncConfig, w.uint32(42).fork()).ldelim();
            return w;
        };

        DeviceProps.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceProps();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.os = r.string();
                        break;
                    }
                case 2: {
                        m.version = $root.proto.DeviceProps.AppVersion.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.platformType = r.int32();
                        break;
                    }
                case 4: {
                        m.requireFullSync = r.bool();
                        break;
                    }
                case 5: {
                        m.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DeviceProps.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DeviceProps";
        };

        DeviceProps.AppVersion = (function() {

            function AppVersion(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppVersion.prototype.primary = 0;
            AppVersion.prototype.secondary = 0;
            AppVersion.prototype.tertiary = 0;
            AppVersion.prototype.quaternary = 0;
            AppVersion.prototype.quinary = 0;

            AppVersion.create = function create(properties) {
                return new AppVersion(properties);
            };

            AppVersion.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.primary != null && Object.hasOwnProperty.call(m, "primary"))
                    w.uint32(8).uint32(m.primary);
                if (m.secondary != null && Object.hasOwnProperty.call(m, "secondary"))
                    w.uint32(16).uint32(m.secondary);
                if (m.tertiary != null && Object.hasOwnProperty.call(m, "tertiary"))
                    w.uint32(24).uint32(m.tertiary);
                if (m.quaternary != null && Object.hasOwnProperty.call(m, "quaternary"))
                    w.uint32(32).uint32(m.quaternary);
                if (m.quinary != null && Object.hasOwnProperty.call(m, "quinary"))
                    w.uint32(40).uint32(m.quinary);
                return w;
            };

            AppVersion.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceProps.AppVersion();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.primary = r.uint32();
                            break;
                        }
                    case 2: {
                            m.secondary = r.uint32();
                            break;
                        }
                    case 3: {
                            m.tertiary = r.uint32();
                            break;
                        }
                    case 4: {
                            m.quaternary = r.uint32();
                            break;
                        }
                    case 5: {
                            m.quinary = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppVersion.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.DeviceProps.AppVersion";
            };

            return AppVersion;
        })();

        DeviceProps.HistorySyncConfig = (function() {

            function HistorySyncConfig(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HistorySyncConfig.prototype.fullSyncDaysLimit = 0;
            HistorySyncConfig.prototype.fullSyncSizeMbLimit = 0;
            HistorySyncConfig.prototype.storageQuotaMb = 0;
            HistorySyncConfig.prototype.inlineInitialPayloadInE2EeMsg = false;
            HistorySyncConfig.prototype.recentSyncDaysLimit = 0;
            HistorySyncConfig.prototype.supportCallLogHistory = false;
            HistorySyncConfig.prototype.supportBotUserAgentChatHistory = false;
            HistorySyncConfig.prototype.supportCagReactionsAndPolls = false;
            HistorySyncConfig.prototype.supportBizHostedMsg = false;
            HistorySyncConfig.prototype.supportRecentSyncChunkMessageCountTuning = false;
            HistorySyncConfig.prototype.supportHostedGroupMsg = false;
            HistorySyncConfig.prototype.supportFbidBotChatHistory = false;
            HistorySyncConfig.prototype.supportAddOnHistorySyncMigration = false;
            HistorySyncConfig.prototype.supportMessageAssociation = false;

            HistorySyncConfig.create = function create(properties) {
                return new HistorySyncConfig(properties);
            };

            HistorySyncConfig.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.fullSyncDaysLimit != null && Object.hasOwnProperty.call(m, "fullSyncDaysLimit"))
                    w.uint32(8).uint32(m.fullSyncDaysLimit);
                if (m.fullSyncSizeMbLimit != null && Object.hasOwnProperty.call(m, "fullSyncSizeMbLimit"))
                    w.uint32(16).uint32(m.fullSyncSizeMbLimit);
                if (m.storageQuotaMb != null && Object.hasOwnProperty.call(m, "storageQuotaMb"))
                    w.uint32(24).uint32(m.storageQuotaMb);
                if (m.inlineInitialPayloadInE2EeMsg != null && Object.hasOwnProperty.call(m, "inlineInitialPayloadInE2EeMsg"))
                    w.uint32(32).bool(m.inlineInitialPayloadInE2EeMsg);
                if (m.recentSyncDaysLimit != null && Object.hasOwnProperty.call(m, "recentSyncDaysLimit"))
                    w.uint32(40).uint32(m.recentSyncDaysLimit);
                if (m.supportCallLogHistory != null && Object.hasOwnProperty.call(m, "supportCallLogHistory"))
                    w.uint32(48).bool(m.supportCallLogHistory);
                if (m.supportBotUserAgentChatHistory != null && Object.hasOwnProperty.call(m, "supportBotUserAgentChatHistory"))
                    w.uint32(56).bool(m.supportBotUserAgentChatHistory);
                if (m.supportCagReactionsAndPolls != null && Object.hasOwnProperty.call(m, "supportCagReactionsAndPolls"))
                    w.uint32(64).bool(m.supportCagReactionsAndPolls);
                if (m.supportBizHostedMsg != null && Object.hasOwnProperty.call(m, "supportBizHostedMsg"))
                    w.uint32(72).bool(m.supportBizHostedMsg);
                if (m.supportRecentSyncChunkMessageCountTuning != null && Object.hasOwnProperty.call(m, "supportRecentSyncChunkMessageCountTuning"))
                    w.uint32(80).bool(m.supportRecentSyncChunkMessageCountTuning);
                if (m.supportHostedGroupMsg != null && Object.hasOwnProperty.call(m, "supportHostedGroupMsg"))
                    w.uint32(88).bool(m.supportHostedGroupMsg);
                if (m.supportFbidBotChatHistory != null && Object.hasOwnProperty.call(m, "supportFbidBotChatHistory"))
                    w.uint32(96).bool(m.supportFbidBotChatHistory);
                if (m.supportAddOnHistorySyncMigration != null && Object.hasOwnProperty.call(m, "supportAddOnHistorySyncMigration"))
                    w.uint32(104).bool(m.supportAddOnHistorySyncMigration);
                if (m.supportMessageAssociation != null && Object.hasOwnProperty.call(m, "supportMessageAssociation"))
                    w.uint32(112).bool(m.supportMessageAssociation);
                return w;
            };

            HistorySyncConfig.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DeviceProps.HistorySyncConfig();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.fullSyncDaysLimit = r.uint32();
                            break;
                        }
                    case 2: {
                            m.fullSyncSizeMbLimit = r.uint32();
                            break;
                        }
                    case 3: {
                            m.storageQuotaMb = r.uint32();
                            break;
                        }
                    case 4: {
                            m.inlineInitialPayloadInE2EeMsg = r.bool();
                            break;
                        }
                    case 5: {
                            m.recentSyncDaysLimit = r.uint32();
                            break;
                        }
                    case 6: {
                            m.supportCallLogHistory = r.bool();
                            break;
                        }
                    case 7: {
                            m.supportBotUserAgentChatHistory = r.bool();
                            break;
                        }
                    case 8: {
                            m.supportCagReactionsAndPolls = r.bool();
                            break;
                        }
                    case 9: {
                            m.supportBizHostedMsg = r.bool();
                            break;
                        }
                    case 10: {
                            m.supportRecentSyncChunkMessageCountTuning = r.bool();
                            break;
                        }
                    case 11: {
                            m.supportHostedGroupMsg = r.bool();
                            break;
                        }
                    case 12: {
                            m.supportFbidBotChatHistory = r.bool();
                            break;
                        }
                    case 13: {
                            m.supportAddOnHistorySyncMigration = r.bool();
                            break;
                        }
                    case 14: {
                            m.supportMessageAssociation = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HistorySyncConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.DeviceProps.HistorySyncConfig";
            };

            return HistorySyncConfig;
        })();

        DeviceProps.PlatformType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHROME"] = 1;
            values[valuesById[2] = "FIREFOX"] = 2;
            values[valuesById[3] = "IE"] = 3;
            values[valuesById[4] = "OPERA"] = 4;
            values[valuesById[5] = "SAFARI"] = 5;
            values[valuesById[6] = "EDGE"] = 6;
            values[valuesById[7] = "DESKTOP"] = 7;
            values[valuesById[8] = "IPAD"] = 8;
            values[valuesById[9] = "ANDROID_TABLET"] = 9;
            values[valuesById[10] = "OHANA"] = 10;
            values[valuesById[11] = "ALOHA"] = 11;
            values[valuesById[12] = "CATALINA"] = 12;
            values[valuesById[13] = "TCL_TV"] = 13;
            values[valuesById[14] = "IOS_PHONE"] = 14;
            values[valuesById[15] = "IOS_CATALYST"] = 15;
            values[valuesById[16] = "ANDROID_PHONE"] = 16;
            values[valuesById[17] = "ANDROID_AMBIGUOUS"] = 17;
            values[valuesById[18] = "WEAR_OS"] = 18;
            values[valuesById[19] = "AR_WRIST"] = 19;
            values[valuesById[20] = "AR_DEVICE"] = 20;
            values[valuesById[21] = "UWP"] = 21;
            values[valuesById[22] = "VR"] = 22;
            values[valuesById[23] = "CLOUD_API"] = 23;
            values[valuesById[24] = "SMARTGLASSES"] = 24;
            return values;
        })();

        return DeviceProps;
    })();

    proto.DisappearingMode = (function() {

        function DisappearingMode(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        DisappearingMode.prototype.initiator = 0;
        DisappearingMode.prototype.trigger = 0;
        DisappearingMode.prototype.initiatorDeviceJid = "";
        DisappearingMode.prototype.initiatedByMe = false;

        DisappearingMode.create = function create(properties) {
            return new DisappearingMode(properties);
        };

        DisappearingMode.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.initiator != null && Object.hasOwnProperty.call(m, "initiator"))
                w.uint32(8).int32(m.initiator);
            if (m.trigger != null && Object.hasOwnProperty.call(m, "trigger"))
                w.uint32(16).int32(m.trigger);
            if (m.initiatorDeviceJid != null && Object.hasOwnProperty.call(m, "initiatorDeviceJid"))
                w.uint32(26).string(m.initiatorDeviceJid);
            if (m.initiatedByMe != null && Object.hasOwnProperty.call(m, "initiatedByMe"))
                w.uint32(32).bool(m.initiatedByMe);
            return w;
        };

        DisappearingMode.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.DisappearingMode();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.initiator = r.int32();
                        break;
                    }
                case 2: {
                        m.trigger = r.int32();
                        break;
                    }
                case 3: {
                        m.initiatorDeviceJid = r.string();
                        break;
                    }
                case 4: {
                        m.initiatedByMe = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        DisappearingMode.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.DisappearingMode";
        };

        DisappearingMode.Initiator = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CHANGED_IN_CHAT"] = 0;
            values[valuesById[1] = "INITIATED_BY_ME"] = 1;
            values[valuesById[2] = "INITIATED_BY_OTHER"] = 2;
            values[valuesById[3] = "BIZ_UPGRADE_FB_HOSTING"] = 3;
            return values;
        })();

        DisappearingMode.Trigger = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHAT_SETTING"] = 1;
            values[valuesById[2] = "ACCOUNT_SETTING"] = 2;
            values[valuesById[3] = "BULK_CHANGE"] = 3;
            values[valuesById[4] = "BIZ_SUPPORTS_FB_HOSTING"] = 4;
            values[valuesById[5] = "UNKNOWN_GROUPS"] = 5;
            return values;
        })();

        return DisappearingMode;
    })();

    proto.EmbeddedContent = (function() {

        function EmbeddedContent(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EmbeddedContent.prototype.embeddedMessage = null;
        EmbeddedContent.prototype.embeddedMusic = null;

        let $oneOfFields;

        Object.defineProperty(EmbeddedContent.prototype, "content", {
            get: $util.oneOfGetter($oneOfFields = ["embeddedMessage", "embeddedMusic"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        EmbeddedContent.create = function create(properties) {
            return new EmbeddedContent(properties);
        };

        EmbeddedContent.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.embeddedMessage != null && Object.hasOwnProperty.call(m, "embeddedMessage"))
                $root.proto.EmbeddedMessage.encode(m.embeddedMessage, w.uint32(10).fork()).ldelim();
            if (m.embeddedMusic != null && Object.hasOwnProperty.call(m, "embeddedMusic"))
                $root.proto.EmbeddedMusic.encode(m.embeddedMusic, w.uint32(18).fork()).ldelim();
            return w;
        };

        EmbeddedContent.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EmbeddedContent();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.embeddedMessage = $root.proto.EmbeddedMessage.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.embeddedMusic = $root.proto.EmbeddedMusic.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EmbeddedContent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EmbeddedContent";
        };

        return EmbeddedContent;
    })();

    proto.EmbeddedMessage = (function() {

        function EmbeddedMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EmbeddedMessage.prototype.stanzaId = "";
        EmbeddedMessage.prototype.message = null;

        EmbeddedMessage.create = function create(properties) {
            return new EmbeddedMessage(properties);
        };

        EmbeddedMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                w.uint32(10).string(m.stanzaId);
            if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                $root.proto.Message.encode(m.message, w.uint32(18).fork()).ldelim();
            return w;
        };

        EmbeddedMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EmbeddedMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.stanzaId = r.string();
                        break;
                    }
                case 2: {
                        m.message = $root.proto.Message.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EmbeddedMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EmbeddedMessage";
        };

        return EmbeddedMessage;
    })();

    proto.EmbeddedMusic = (function() {

        function EmbeddedMusic(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EmbeddedMusic.prototype.musicContentMediaId = "";
        EmbeddedMusic.prototype.songId = "";
        EmbeddedMusic.prototype.author = "";
        EmbeddedMusic.prototype.title = "";
        EmbeddedMusic.prototype.artworkDirectPath = "";
        EmbeddedMusic.prototype.artworkSha256 = $util.newBuffer([]);
        EmbeddedMusic.prototype.artworkEncSha256 = $util.newBuffer([]);
        EmbeddedMusic.prototype.artworkMediaKey = $util.newBuffer([]);
        EmbeddedMusic.prototype.artistAttribution = "";
        EmbeddedMusic.prototype.countryBlocklist = $util.newBuffer([]);
        EmbeddedMusic.prototype.isExplicit = false;

        EmbeddedMusic.create = function create(properties) {
            return new EmbeddedMusic(properties);
        };

        EmbeddedMusic.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.musicContentMediaId != null && Object.hasOwnProperty.call(m, "musicContentMediaId"))
                w.uint32(10).string(m.musicContentMediaId);
            if (m.songId != null && Object.hasOwnProperty.call(m, "songId"))
                w.uint32(18).string(m.songId);
            if (m.author != null && Object.hasOwnProperty.call(m, "author"))
                w.uint32(26).string(m.author);
            if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                w.uint32(34).string(m.title);
            if (m.artworkDirectPath != null && Object.hasOwnProperty.call(m, "artworkDirectPath"))
                w.uint32(42).string(m.artworkDirectPath);
            if (m.artworkSha256 != null && Object.hasOwnProperty.call(m, "artworkSha256"))
                w.uint32(50).bytes(m.artworkSha256);
            if (m.artworkEncSha256 != null && Object.hasOwnProperty.call(m, "artworkEncSha256"))
                w.uint32(58).bytes(m.artworkEncSha256);
            if (m.artistAttribution != null && Object.hasOwnProperty.call(m, "artistAttribution"))
                w.uint32(66).string(m.artistAttribution);
            if (m.countryBlocklist != null && Object.hasOwnProperty.call(m, "countryBlocklist"))
                w.uint32(74).bytes(m.countryBlocklist);
            if (m.isExplicit != null && Object.hasOwnProperty.call(m, "isExplicit"))
                w.uint32(80).bool(m.isExplicit);
            if (m.artworkMediaKey != null && Object.hasOwnProperty.call(m, "artworkMediaKey"))
                w.uint32(90).bytes(m.artworkMediaKey);
            return w;
        };

        EmbeddedMusic.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EmbeddedMusic();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.musicContentMediaId = r.string();
                        break;
                    }
                case 2: {
                        m.songId = r.string();
                        break;
                    }
                case 3: {
                        m.author = r.string();
                        break;
                    }
                case 4: {
                        m.title = r.string();
                        break;
                    }
                case 5: {
                        m.artworkDirectPath = r.string();
                        break;
                    }
                case 6: {
                        m.artworkSha256 = r.bytes();
                        break;
                    }
                case 7: {
                        m.artworkEncSha256 = r.bytes();
                        break;
                    }
                case 11: {
                        m.artworkMediaKey = r.bytes();
                        break;
                    }
                case 8: {
                        m.artistAttribution = r.string();
                        break;
                    }
                case 9: {
                        m.countryBlocklist = r.bytes();
                        break;
                    }
                case 10: {
                        m.isExplicit = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EmbeddedMusic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EmbeddedMusic";
        };

        return EmbeddedMusic;
    })();

    proto.EncryptedPairingRequest = (function() {

        function EncryptedPairingRequest(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EncryptedPairingRequest.prototype.encryptedPayload = $util.newBuffer([]);
        EncryptedPairingRequest.prototype.iv = $util.newBuffer([]);

        EncryptedPairingRequest.create = function create(properties) {
            return new EncryptedPairingRequest(properties);
        };

        EncryptedPairingRequest.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.encryptedPayload != null && Object.hasOwnProperty.call(m, "encryptedPayload"))
                w.uint32(10).bytes(m.encryptedPayload);
            if (m.iv != null && Object.hasOwnProperty.call(m, "iv"))
                w.uint32(18).bytes(m.iv);
            return w;
        };

        EncryptedPairingRequest.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EncryptedPairingRequest();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.encryptedPayload = r.bytes();
                        break;
                    }
                case 2: {
                        m.iv = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EncryptedPairingRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EncryptedPairingRequest";
        };

        return EncryptedPairingRequest;
    })();

    proto.EphemeralSetting = (function() {

        function EphemeralSetting(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EphemeralSetting.prototype.duration = 0;
        EphemeralSetting.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        EphemeralSetting.create = function create(properties) {
            return new EphemeralSetting(properties);
        };

        EphemeralSetting.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.duration != null && Object.hasOwnProperty.call(m, "duration"))
                w.uint32(13).sfixed32(m.duration);
            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                w.uint32(17).sfixed64(m.timestamp);
            return w;
        };

        EphemeralSetting.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EphemeralSetting();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.duration = r.sfixed32();
                        break;
                    }
                case 2: {
                        m.timestamp = r.sfixed64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EphemeralSetting.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EphemeralSetting";
        };

        return EphemeralSetting;
    })();

    proto.EventAdditionalMetadata = (function() {

        function EventAdditionalMetadata(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EventAdditionalMetadata.prototype.isStale = false;

        EventAdditionalMetadata.create = function create(properties) {
            return new EventAdditionalMetadata(properties);
        };

        EventAdditionalMetadata.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.isStale != null && Object.hasOwnProperty.call(m, "isStale"))
                w.uint32(8).bool(m.isStale);
            return w;
        };

        EventAdditionalMetadata.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EventAdditionalMetadata();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.isStale = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EventAdditionalMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EventAdditionalMetadata";
        };

        return EventAdditionalMetadata;
    })();

    proto.EventResponse = (function() {

        function EventResponse(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        EventResponse.prototype.eventResponseMessageKey = null;
        EventResponse.prototype.timestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        EventResponse.prototype.eventResponseMessage = null;
        EventResponse.prototype.unread = false;

        EventResponse.create = function create(properties) {
            return new EventResponse(properties);
        };

        EventResponse.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.eventResponseMessageKey != null && Object.hasOwnProperty.call(m, "eventResponseMessageKey"))
                $root.proto.MessageKey.encode(m.eventResponseMessageKey, w.uint32(10).fork()).ldelim();
            if (m.timestampMs != null && Object.hasOwnProperty.call(m, "timestampMs"))
                w.uint32(16).int64(m.timestampMs);
            if (m.eventResponseMessage != null && Object.hasOwnProperty.call(m, "eventResponseMessage"))
                $root.proto.Message.EventResponseMessage.encode(m.eventResponseMessage, w.uint32(26).fork()).ldelim();
            if (m.unread != null && Object.hasOwnProperty.call(m, "unread"))
                w.uint32(32).bool(m.unread);
            return w;
        };

        EventResponse.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.EventResponse();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.eventResponseMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.timestampMs = r.int64();
                        break;
                    }
                case 3: {
                        m.eventResponseMessage = $root.proto.Message.EventResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.unread = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        EventResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.EventResponse";
        };

        return EventResponse;
    })();

    proto.ExitCode = (function() {

        function ExitCode(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ExitCode.prototype.code = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        ExitCode.prototype.text = "";

        ExitCode.create = function create(properties) {
            return new ExitCode(properties);
        };

        ExitCode.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.code != null && Object.hasOwnProperty.call(m, "code"))
                w.uint32(8).uint64(m.code);
            if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                w.uint32(18).string(m.text);
            return w;
        };

        ExitCode.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ExitCode();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.code = r.uint64();
                        break;
                    }
                case 2: {
                        m.text = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ExitCode.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ExitCode";
        };

        return ExitCode;
    })();

    proto.ExternalBlobReference = (function() {

        function ExternalBlobReference(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        ExternalBlobReference.prototype.mediaKey = $util.newBuffer([]);
        ExternalBlobReference.prototype.directPath = "";
        ExternalBlobReference.prototype.handle = "";
        ExternalBlobReference.prototype.fileSizeBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        ExternalBlobReference.prototype.fileSha256 = $util.newBuffer([]);
        ExternalBlobReference.prototype.fileEncSha256 = $util.newBuffer([]);

        ExternalBlobReference.create = function create(properties) {
            return new ExternalBlobReference(properties);
        };

        ExternalBlobReference.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                w.uint32(10).bytes(m.mediaKey);
            if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                w.uint32(18).string(m.directPath);
            if (m.handle != null && Object.hasOwnProperty.call(m, "handle"))
                w.uint32(26).string(m.handle);
            if (m.fileSizeBytes != null && Object.hasOwnProperty.call(m, "fileSizeBytes"))
                w.uint32(32).uint64(m.fileSizeBytes);
            if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                w.uint32(42).bytes(m.fileSha256);
            if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                w.uint32(50).bytes(m.fileEncSha256);
            return w;
        };

        ExternalBlobReference.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.ExternalBlobReference();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.mediaKey = r.bytes();
                        break;
                    }
                case 2: {
                        m.directPath = r.string();
                        break;
                    }
                case 3: {
                        m.handle = r.string();
                        break;
                    }
                case 4: {
                        m.fileSizeBytes = r.uint64();
                        break;
                    }
                case 5: {
                        m.fileSha256 = r.bytes();
                        break;
                    }
                case 6: {
                        m.fileEncSha256 = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        ExternalBlobReference.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.ExternalBlobReference";
        };

        return ExternalBlobReference;
    })();

    proto.Field = (function() {

        function Field(p) {
            this.subfield = {};
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Field.prototype.minVersion = 0;
        Field.prototype.maxVersion = 0;
        Field.prototype.notReportableMinVersion = 0;
        Field.prototype.isMessage = false;
        Field.prototype.subfield = $util.emptyObject;

        Field.create = function create(properties) {
            return new Field(properties);
        };

        Field.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.minVersion != null && Object.hasOwnProperty.call(m, "minVersion"))
                w.uint32(8).uint32(m.minVersion);
            if (m.maxVersion != null && Object.hasOwnProperty.call(m, "maxVersion"))
                w.uint32(16).uint32(m.maxVersion);
            if (m.notReportableMinVersion != null && Object.hasOwnProperty.call(m, "notReportableMinVersion"))
                w.uint32(24).uint32(m.notReportableMinVersion);
            if (m.isMessage != null && Object.hasOwnProperty.call(m, "isMessage"))
                w.uint32(32).bool(m.isMessage);
            if (m.subfield != null && Object.hasOwnProperty.call(m, "subfield")) {
                for (var ks = Object.keys(m.subfield), i = 0; i < ks.length; ++i) {
                    w.uint32(42).fork().uint32(8).uint32(ks[i]);
                    $root.proto.Field.encode(m.subfield[ks[i]], w.uint32(18).fork()).ldelim().ldelim();
                }
            }
            return w;
        };

        Field.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Field(), k, value;
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.minVersion = r.uint32();
                        break;
                    }
                case 2: {
                        m.maxVersion = r.uint32();
                        break;
                    }
                case 3: {
                        m.notReportableMinVersion = r.uint32();
                        break;
                    }
                case 4: {
                        m.isMessage = r.bool();
                        break;
                    }
                case 5: {
                        if (m.subfield === $util.emptyObject)
                            m.subfield = {};
                        var c2 = r.uint32() + r.pos;
                        k = 0;
                        value = null;
                        while (r.pos < c2) {
                            var tag2 = r.uint32();
                            switch (tag2 >>> 3) {
                            case 1:
                                k = r.uint32();
                                break;
                            case 2:
                                value = $root.proto.Field.decode(r, r.uint32());
                                break;
                            default:
                                r.skipType(tag2 & 7);
                                break;
                            }
                        }
                        m.subfield[k] = value;
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Field.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Field";
        };

        return Field;
    })();

    proto.GlobalSettings = (function() {

        function GlobalSettings(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        GlobalSettings.prototype.lightThemeWallpaper = null;
        GlobalSettings.prototype.mediaVisibility = 0;
        GlobalSettings.prototype.darkThemeWallpaper = null;
        GlobalSettings.prototype.autoDownloadWiFi = null;
        GlobalSettings.prototype.autoDownloadCellular = null;
        GlobalSettings.prototype.autoDownloadRoaming = null;
        GlobalSettings.prototype.showIndividualNotificationsPreview = false;
        GlobalSettings.prototype.showGroupNotificationsPreview = false;
        GlobalSettings.prototype.disappearingModeDuration = 0;
        GlobalSettings.prototype.disappearingModeTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        GlobalSettings.prototype.avatarUserSettings = null;
        GlobalSettings.prototype.fontSize = 0;
        GlobalSettings.prototype.securityNotifications = false;
        GlobalSettings.prototype.autoUnarchiveChats = false;
        GlobalSettings.prototype.videoQualityMode = 0;
        GlobalSettings.prototype.photoQualityMode = 0;
        GlobalSettings.prototype.individualNotificationSettings = null;
        GlobalSettings.prototype.groupNotificationSettings = null;
        GlobalSettings.prototype.chatLockSettings = null;
        GlobalSettings.prototype.chatDbLidMigrationTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        GlobalSettings.create = function create(properties) {
            return new GlobalSettings(properties);
        };

        GlobalSettings.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.lightThemeWallpaper != null && Object.hasOwnProperty.call(m, "lightThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(m.lightThemeWallpaper, w.uint32(10).fork()).ldelim();
            if (m.mediaVisibility != null && Object.hasOwnProperty.call(m, "mediaVisibility"))
                w.uint32(16).int32(m.mediaVisibility);
            if (m.darkThemeWallpaper != null && Object.hasOwnProperty.call(m, "darkThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(m.darkThemeWallpaper, w.uint32(26).fork()).ldelim();
            if (m.autoDownloadWiFi != null && Object.hasOwnProperty.call(m, "autoDownloadWiFi"))
                $root.proto.AutoDownloadSettings.encode(m.autoDownloadWiFi, w.uint32(34).fork()).ldelim();
            if (m.autoDownloadCellular != null && Object.hasOwnProperty.call(m, "autoDownloadCellular"))
                $root.proto.AutoDownloadSettings.encode(m.autoDownloadCellular, w.uint32(42).fork()).ldelim();
            if (m.autoDownloadRoaming != null && Object.hasOwnProperty.call(m, "autoDownloadRoaming"))
                $root.proto.AutoDownloadSettings.encode(m.autoDownloadRoaming, w.uint32(50).fork()).ldelim();
            if (m.showIndividualNotificationsPreview != null && Object.hasOwnProperty.call(m, "showIndividualNotificationsPreview"))
                w.uint32(56).bool(m.showIndividualNotificationsPreview);
            if (m.showGroupNotificationsPreview != null && Object.hasOwnProperty.call(m, "showGroupNotificationsPreview"))
                w.uint32(64).bool(m.showGroupNotificationsPreview);
            if (m.disappearingModeDuration != null && Object.hasOwnProperty.call(m, "disappearingModeDuration"))
                w.uint32(72).int32(m.disappearingModeDuration);
            if (m.disappearingModeTimestamp != null && Object.hasOwnProperty.call(m, "disappearingModeTimestamp"))
                w.uint32(80).int64(m.disappearingModeTimestamp);
            if (m.avatarUserSettings != null && Object.hasOwnProperty.call(m, "avatarUserSettings"))
                $root.proto.AvatarUserSettings.encode(m.avatarUserSettings, w.uint32(90).fork()).ldelim();
            if (m.fontSize != null && Object.hasOwnProperty.call(m, "fontSize"))
                w.uint32(96).int32(m.fontSize);
            if (m.securityNotifications != null && Object.hasOwnProperty.call(m, "securityNotifications"))
                w.uint32(104).bool(m.securityNotifications);
            if (m.autoUnarchiveChats != null && Object.hasOwnProperty.call(m, "autoUnarchiveChats"))
                w.uint32(112).bool(m.autoUnarchiveChats);
            if (m.videoQualityMode != null && Object.hasOwnProperty.call(m, "videoQualityMode"))
                w.uint32(120).int32(m.videoQualityMode);
            if (m.photoQualityMode != null && Object.hasOwnProperty.call(m, "photoQualityMode"))
                w.uint32(128).int32(m.photoQualityMode);
            if (m.individualNotificationSettings != null && Object.hasOwnProperty.call(m, "individualNotificationSettings"))
                $root.proto.NotificationSettings.encode(m.individualNotificationSettings, w.uint32(138).fork()).ldelim();
            if (m.groupNotificationSettings != null && Object.hasOwnProperty.call(m, "groupNotificationSettings"))
                $root.proto.NotificationSettings.encode(m.groupNotificationSettings, w.uint32(146).fork()).ldelim();
            if (m.chatLockSettings != null && Object.hasOwnProperty.call(m, "chatLockSettings"))
                $root.proto.ChatLockSettings.encode(m.chatLockSettings, w.uint32(154).fork()).ldelim();
            if (m.chatDbLidMigrationTimestamp != null && Object.hasOwnProperty.call(m, "chatDbLidMigrationTimestamp"))
                w.uint32(160).int64(m.chatDbLidMigrationTimestamp);
            return w;
        };

        GlobalSettings.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.GlobalSettings();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.lightThemeWallpaper = $root.proto.WallpaperSettings.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.mediaVisibility = r.int32();
                        break;
                    }
                case 3: {
                        m.darkThemeWallpaper = $root.proto.WallpaperSettings.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.autoDownloadWiFi = $root.proto.AutoDownloadSettings.decode(r, r.uint32());
                        break;
                    }
                case 5: {
                        m.autoDownloadCellular = $root.proto.AutoDownloadSettings.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.autoDownloadRoaming = $root.proto.AutoDownloadSettings.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.showIndividualNotificationsPreview = r.bool();
                        break;
                    }
                case 8: {
                        m.showGroupNotificationsPreview = r.bool();
                        break;
                    }
                case 9: {
                        m.disappearingModeDuration = r.int32();
                        break;
                    }
                case 10: {
                        m.disappearingModeTimestamp = r.int64();
                        break;
                    }
                case 11: {
                        m.avatarUserSettings = $root.proto.AvatarUserSettings.decode(r, r.uint32());
                        break;
                    }
                case 12: {
                        m.fontSize = r.int32();
                        break;
                    }
                case 13: {
                        m.securityNotifications = r.bool();
                        break;
                    }
                case 14: {
                        m.autoUnarchiveChats = r.bool();
                        break;
                    }
                case 15: {
                        m.videoQualityMode = r.int32();
                        break;
                    }
                case 16: {
                        m.photoQualityMode = r.int32();
                        break;
                    }
                case 17: {
                        m.individualNotificationSettings = $root.proto.NotificationSettings.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.groupNotificationSettings = $root.proto.NotificationSettings.decode(r, r.uint32());
                        break;
                    }
                case 19: {
                        m.chatLockSettings = $root.proto.ChatLockSettings.decode(r, r.uint32());
                        break;
                    }
                case 20: {
                        m.chatDbLidMigrationTimestamp = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        GlobalSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.GlobalSettings";
        };

        return GlobalSettings;
    })();

    proto.GroupMention = (function() {

        function GroupMention(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        GroupMention.prototype.groupJid = "";
        GroupMention.prototype.groupSubject = "";

        GroupMention.create = function create(properties) {
            return new GroupMention(properties);
        };

        GroupMention.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.groupJid != null && Object.hasOwnProperty.call(m, "groupJid"))
                w.uint32(10).string(m.groupJid);
            if (m.groupSubject != null && Object.hasOwnProperty.call(m, "groupSubject"))
                w.uint32(18).string(m.groupSubject);
            return w;
        };

        GroupMention.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.GroupMention();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.groupJid = r.string();
                        break;
                    }
                case 2: {
                        m.groupSubject = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        GroupMention.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.GroupMention";
        };

        return GroupMention;
    })();

    proto.GroupParticipant = (function() {

        function GroupParticipant(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        GroupParticipant.prototype.userJid = "";
        GroupParticipant.prototype.rank = 0;

        GroupParticipant.create = function create(properties) {
            return new GroupParticipant(properties);
        };

        GroupParticipant.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            w.uint32(10).string(m.userJid);
            if (m.rank != null && Object.hasOwnProperty.call(m, "rank"))
                w.uint32(16).int32(m.rank);
            return w;
        };

        GroupParticipant.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.GroupParticipant();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.userJid = r.string();
                        break;
                    }
                case 2: {
                        m.rank = r.int32();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            if (!m.hasOwnProperty("userJid"))
                throw $util.ProtocolError("missing required 'userJid'", { instance: m });
            return m;
        };

        GroupParticipant.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.GroupParticipant";
        };

        GroupParticipant.Rank = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "REGULAR"] = 0;
            values[valuesById[1] = "ADMIN"] = 1;
            values[valuesById[2] = "SUPERADMIN"] = 2;
            return values;
        })();

        return GroupParticipant;
    })();

    proto.HandshakeMessage = (function() {

        function HandshakeMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        HandshakeMessage.prototype.clientHello = null;
        HandshakeMessage.prototype.serverHello = null;
        HandshakeMessage.prototype.clientFinish = null;

        HandshakeMessage.create = function create(properties) {
            return new HandshakeMessage(properties);
        };

        HandshakeMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.clientHello != null && Object.hasOwnProperty.call(m, "clientHello"))
                $root.proto.HandshakeMessage.ClientHello.encode(m.clientHello, w.uint32(18).fork()).ldelim();
            if (m.serverHello != null && Object.hasOwnProperty.call(m, "serverHello"))
                $root.proto.HandshakeMessage.ServerHello.encode(m.serverHello, w.uint32(26).fork()).ldelim();
            if (m.clientFinish != null && Object.hasOwnProperty.call(m, "clientFinish"))
                $root.proto.HandshakeMessage.ClientFinish.encode(m.clientFinish, w.uint32(34).fork()).ldelim();
            return w;
        };

        HandshakeMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HandshakeMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 2: {
                        m.clientHello = $root.proto.HandshakeMessage.ClientHello.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.serverHello = $root.proto.HandshakeMessage.ServerHello.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.clientFinish = $root.proto.HandshakeMessage.ClientFinish.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        HandshakeMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.HandshakeMessage";
        };

        HandshakeMessage.ClientFinish = (function() {

            function ClientFinish(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ClientFinish.prototype["static"] = $util.newBuffer([]);
            ClientFinish.prototype.payload = $util.newBuffer([]);

            ClientFinish.create = function create(properties) {
                return new ClientFinish(properties);
            };

            ClientFinish.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m["static"] != null && Object.hasOwnProperty.call(m, "static"))
                    w.uint32(10).bytes(m["static"]);
                if (m.payload != null && Object.hasOwnProperty.call(m, "payload"))
                    w.uint32(18).bytes(m.payload);
                return w;
            };

            ClientFinish.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HandshakeMessage.ClientFinish();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m["static"] = r.bytes();
                            break;
                        }
                    case 2: {
                            m.payload = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ClientFinish.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.HandshakeMessage.ClientFinish";
            };

            return ClientFinish;
        })();

        HandshakeMessage.ClientHello = (function() {

            function ClientHello(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ClientHello.prototype.ephemeral = $util.newBuffer([]);
            ClientHello.prototype["static"] = $util.newBuffer([]);
            ClientHello.prototype.payload = $util.newBuffer([]);

            ClientHello.create = function create(properties) {
                return new ClientHello(properties);
            };

            ClientHello.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.ephemeral != null && Object.hasOwnProperty.call(m, "ephemeral"))
                    w.uint32(10).bytes(m.ephemeral);
                if (m["static"] != null && Object.hasOwnProperty.call(m, "static"))
                    w.uint32(18).bytes(m["static"]);
                if (m.payload != null && Object.hasOwnProperty.call(m, "payload"))
                    w.uint32(26).bytes(m.payload);
                return w;
            };

            ClientHello.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HandshakeMessage.ClientHello();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.ephemeral = r.bytes();
                            break;
                        }
                    case 2: {
                            m["static"] = r.bytes();
                            break;
                        }
                    case 3: {
                            m.payload = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ClientHello.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.HandshakeMessage.ClientHello";
            };

            return ClientHello;
        })();

        HandshakeMessage.ServerHello = (function() {

            function ServerHello(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ServerHello.prototype.ephemeral = $util.newBuffer([]);
            ServerHello.prototype["static"] = $util.newBuffer([]);
            ServerHello.prototype.payload = $util.newBuffer([]);

            ServerHello.create = function create(properties) {
                return new ServerHello(properties);
            };

            ServerHello.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.ephemeral != null && Object.hasOwnProperty.call(m, "ephemeral"))
                    w.uint32(10).bytes(m.ephemeral);
                if (m["static"] != null && Object.hasOwnProperty.call(m, "static"))
                    w.uint32(18).bytes(m["static"]);
                if (m.payload != null && Object.hasOwnProperty.call(m, "payload"))
                    w.uint32(26).bytes(m.payload);
                return w;
            };

            ServerHello.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HandshakeMessage.ServerHello();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.ephemeral = r.bytes();
                            break;
                        }
                    case 2: {
                            m["static"] = r.bytes();
                            break;
                        }
                    case 3: {
                            m.payload = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ServerHello.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.HandshakeMessage.ServerHello";
            };

            return ServerHello;
        })();

        return HandshakeMessage;
    })();

    proto.HistorySync = (function() {

        function HistorySync(p) {
            this.conversations = [];
            this.statusV3Messages = [];
            this.pushnames = [];
            this.recentStickers = [];
            this.pastParticipants = [];
            this.callLogRecords = [];
            this.phoneNumberToLidMappings = [];
            this.accounts = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        HistorySync.prototype.syncType = 0;
        HistorySync.prototype.conversations = $util.emptyArray;
        HistorySync.prototype.statusV3Messages = $util.emptyArray;
        HistorySync.prototype.chunkOrder = 0;
        HistorySync.prototype.progress = 0;
        HistorySync.prototype.pushnames = $util.emptyArray;
        HistorySync.prototype.globalSettings = null;
        HistorySync.prototype.threadIdUserSecret = $util.newBuffer([]);
        HistorySync.prototype.threadDsTimeframeOffset = 0;
        HistorySync.prototype.recentStickers = $util.emptyArray;
        HistorySync.prototype.pastParticipants = $util.emptyArray;
        HistorySync.prototype.callLogRecords = $util.emptyArray;
        HistorySync.prototype.aiWaitListState = 0;
        HistorySync.prototype.phoneNumberToLidMappings = $util.emptyArray;
        HistorySync.prototype.companionMetaNonce = "";
        HistorySync.prototype.shareableChatIdentifierEncryptionKey = $util.newBuffer([]);
        HistorySync.prototype.accounts = $util.emptyArray;

        HistorySync.create = function create(properties) {
            return new HistorySync(properties);
        };

        HistorySync.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            w.uint32(8).int32(m.syncType);
            if (m.conversations != null && m.conversations.length) {
                for (var i = 0; i < m.conversations.length; ++i)
                    $root.proto.Conversation.encode(m.conversations[i], w.uint32(18).fork()).ldelim();
            }
            if (m.statusV3Messages != null && m.statusV3Messages.length) {
                for (var i = 0; i < m.statusV3Messages.length; ++i)
                    $root.proto.WebMessageInfo.encode(m.statusV3Messages[i], w.uint32(26).fork()).ldelim();
            }
            if (m.chunkOrder != null && Object.hasOwnProperty.call(m, "chunkOrder"))
                w.uint32(40).uint32(m.chunkOrder);
            if (m.progress != null && Object.hasOwnProperty.call(m, "progress"))
                w.uint32(48).uint32(m.progress);
            if (m.pushnames != null && m.pushnames.length) {
                for (var i = 0; i < m.pushnames.length; ++i)
                    $root.proto.Pushname.encode(m.pushnames[i], w.uint32(58).fork()).ldelim();
            }
            if (m.globalSettings != null && Object.hasOwnProperty.call(m, "globalSettings"))
                $root.proto.GlobalSettings.encode(m.globalSettings, w.uint32(66).fork()).ldelim();
            if (m.threadIdUserSecret != null && Object.hasOwnProperty.call(m, "threadIdUserSecret"))
                w.uint32(74).bytes(m.threadIdUserSecret);
            if (m.threadDsTimeframeOffset != null && Object.hasOwnProperty.call(m, "threadDsTimeframeOffset"))
                w.uint32(80).uint32(m.threadDsTimeframeOffset);
            if (m.recentStickers != null && m.recentStickers.length) {
                for (var i = 0; i < m.recentStickers.length; ++i)
                    $root.proto.StickerMetadata.encode(m.recentStickers[i], w.uint32(90).fork()).ldelim();
            }
            if (m.pastParticipants != null && m.pastParticipants.length) {
                for (var i = 0; i < m.pastParticipants.length; ++i)
                    $root.proto.PastParticipants.encode(m.pastParticipants[i], w.uint32(98).fork()).ldelim();
            }
            if (m.callLogRecords != null && m.callLogRecords.length) {
                for (var i = 0; i < m.callLogRecords.length; ++i)
                    $root.proto.CallLogRecord.encode(m.callLogRecords[i], w.uint32(106).fork()).ldelim();
            }
            if (m.aiWaitListState != null && Object.hasOwnProperty.call(m, "aiWaitListState"))
                w.uint32(112).int32(m.aiWaitListState);
            if (m.phoneNumberToLidMappings != null && m.phoneNumberToLidMappings.length) {
                for (var i = 0; i < m.phoneNumberToLidMappings.length; ++i)
                    $root.proto.PhoneNumberToLIDMapping.encode(m.phoneNumberToLidMappings[i], w.uint32(122).fork()).ldelim();
            }
            if (m.companionMetaNonce != null && Object.hasOwnProperty.call(m, "companionMetaNonce"))
                w.uint32(130).string(m.companionMetaNonce);
            if (m.shareableChatIdentifierEncryptionKey != null && Object.hasOwnProperty.call(m, "shareableChatIdentifierEncryptionKey"))
                w.uint32(138).bytes(m.shareableChatIdentifierEncryptionKey);
            if (m.accounts != null && m.accounts.length) {
                for (var i = 0; i < m.accounts.length; ++i)
                    $root.proto.Account.encode(m.accounts[i], w.uint32(146).fork()).ldelim();
            }
            return w;
        };

        HistorySync.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HistorySync();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.syncType = r.int32();
                        break;
                    }
                case 2: {
                        if (!(m.conversations && m.conversations.length))
                            m.conversations = [];
                        m.conversations.push($root.proto.Conversation.decode(r, r.uint32()));
                        break;
                    }
                case 3: {
                        if (!(m.statusV3Messages && m.statusV3Messages.length))
                            m.statusV3Messages = [];
                        m.statusV3Messages.push($root.proto.WebMessageInfo.decode(r, r.uint32()));
                        break;
                    }
                case 5: {
                        m.chunkOrder = r.uint32();
                        break;
                    }
                case 6: {
                        m.progress = r.uint32();
                        break;
                    }
                case 7: {
                        if (!(m.pushnames && m.pushnames.length))
                            m.pushnames = [];
                        m.pushnames.push($root.proto.Pushname.decode(r, r.uint32()));
                        break;
                    }
                case 8: {
                        m.globalSettings = $root.proto.GlobalSettings.decode(r, r.uint32());
                        break;
                    }
                case 9: {
                        m.threadIdUserSecret = r.bytes();
                        break;
                    }
                case 10: {
                        m.threadDsTimeframeOffset = r.uint32();
                        break;
                    }
                case 11: {
                        if (!(m.recentStickers && m.recentStickers.length))
                            m.recentStickers = [];
                        m.recentStickers.push($root.proto.StickerMetadata.decode(r, r.uint32()));
                        break;
                    }
                case 12: {
                        if (!(m.pastParticipants && m.pastParticipants.length))
                            m.pastParticipants = [];
                        m.pastParticipants.push($root.proto.PastParticipants.decode(r, r.uint32()));
                        break;
                    }
                case 13: {
                        if (!(m.callLogRecords && m.callLogRecords.length))
                            m.callLogRecords = [];
                        m.callLogRecords.push($root.proto.CallLogRecord.decode(r, r.uint32()));
                        break;
                    }
                case 14: {
                        m.aiWaitListState = r.int32();
                        break;
                    }
                case 15: {
                        if (!(m.phoneNumberToLidMappings && m.phoneNumberToLidMappings.length))
                            m.phoneNumberToLidMappings = [];
                        m.phoneNumberToLidMappings.push($root.proto.PhoneNumberToLIDMapping.decode(r, r.uint32()));
                        break;
                    }
                case 16: {
                        m.companionMetaNonce = r.string();
                        break;
                    }
                case 17: {
                        m.shareableChatIdentifierEncryptionKey = r.bytes();
                        break;
                    }
                case 18: {
                        if (!(m.accounts && m.accounts.length))
                            m.accounts = [];
                        m.accounts.push($root.proto.Account.decode(r, r.uint32()));
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            if (!m.hasOwnProperty("syncType"))
                throw $util.ProtocolError("missing required 'syncType'", { instance: m });
            return m;
        };

        HistorySync.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.HistorySync";
        };

        HistorySync.BotAIWaitListState = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "IN_WAITLIST"] = 0;
            values[valuesById[1] = "AI_AVAILABLE"] = 1;
            return values;
        })();

        HistorySync.HistorySyncType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "INITIAL_BOOTSTRAP"] = 0;
            values[valuesById[1] = "INITIAL_STATUS_V3"] = 1;
            values[valuesById[2] = "FULL"] = 2;
            values[valuesById[3] = "RECENT"] = 3;
            values[valuesById[4] = "PUSH_NAME"] = 4;
            values[valuesById[5] = "NON_BLOCKING_DATA"] = 5;
            values[valuesById[6] = "ON_DEMAND"] = 6;
            return values;
        })();

        return HistorySync;
    })();

    proto.HistorySyncMsg = (function() {

        function HistorySyncMsg(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        HistorySyncMsg.prototype.message = null;
        HistorySyncMsg.prototype.msgOrderId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        HistorySyncMsg.create = function create(properties) {
            return new HistorySyncMsg(properties);
        };

        HistorySyncMsg.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                $root.proto.WebMessageInfo.encode(m.message, w.uint32(10).fork()).ldelim();
            if (m.msgOrderId != null && Object.hasOwnProperty.call(m, "msgOrderId"))
                w.uint32(16).uint64(m.msgOrderId);
            return w;
        };

        HistorySyncMsg.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HistorySyncMsg();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.message = $root.proto.WebMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.msgOrderId = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        HistorySyncMsg.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.HistorySyncMsg";
        };

        return HistorySyncMsg;
    })();

    proto.HydratedTemplateButton = (function() {

        function HydratedTemplateButton(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        HydratedTemplateButton.prototype.index = 0;
        HydratedTemplateButton.prototype.quickReplyButton = null;
        HydratedTemplateButton.prototype.urlButton = null;
        HydratedTemplateButton.prototype.callButton = null;

        let $oneOfFields;

        Object.defineProperty(HydratedTemplateButton.prototype, "hydratedButton", {
            get: $util.oneOfGetter($oneOfFields = ["quickReplyButton", "urlButton", "callButton"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        HydratedTemplateButton.create = function create(properties) {
            return new HydratedTemplateButton(properties);
        };

        HydratedTemplateButton.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.quickReplyButton != null && Object.hasOwnProperty.call(m, "quickReplyButton"))
                $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.encode(m.quickReplyButton, w.uint32(10).fork()).ldelim();
            if (m.urlButton != null && Object.hasOwnProperty.call(m, "urlButton"))
                $root.proto.HydratedTemplateButton.HydratedURLButton.encode(m.urlButton, w.uint32(18).fork()).ldelim();
            if (m.callButton != null && Object.hasOwnProperty.call(m, "callButton"))
                $root.proto.HydratedTemplateButton.HydratedCallButton.encode(m.callButton, w.uint32(26).fork()).ldelim();
            if (m.index != null && Object.hasOwnProperty.call(m, "index"))
                w.uint32(32).uint32(m.index);
            return w;
        };

        HydratedTemplateButton.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HydratedTemplateButton();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 4: {
                        m.index = r.uint32();
                        break;
                    }
                case 1: {
                        m.quickReplyButton = $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.urlButton = $root.proto.HydratedTemplateButton.HydratedURLButton.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.callButton = $root.proto.HydratedTemplateButton.HydratedCallButton.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        HydratedTemplateButton.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.HydratedTemplateButton";
        };

        HydratedTemplateButton.HydratedCallButton = (function() {

            function HydratedCallButton(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HydratedCallButton.prototype.displayText = "";
            HydratedCallButton.prototype.phoneNumber = "";

            HydratedCallButton.create = function create(properties) {
                return new HydratedCallButton(properties);
            };

            HydratedCallButton.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.displayText != null && Object.hasOwnProperty.call(m, "displayText"))
                    w.uint32(10).string(m.displayText);
                if (m.phoneNumber != null && Object.hasOwnProperty.call(m, "phoneNumber"))
                    w.uint32(18).string(m.phoneNumber);
                return w;
            };

            HydratedCallButton.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HydratedTemplateButton.HydratedCallButton();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.displayText = r.string();
                            break;
                        }
                    case 2: {
                            m.phoneNumber = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HydratedCallButton.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.HydratedTemplateButton.HydratedCallButton";
            };

            return HydratedCallButton;
        })();

        HydratedTemplateButton.HydratedQuickReplyButton = (function() {

            function HydratedQuickReplyButton(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HydratedQuickReplyButton.prototype.displayText = "";
            HydratedQuickReplyButton.prototype.id = "";

            HydratedQuickReplyButton.create = function create(properties) {
                return new HydratedQuickReplyButton(properties);
            };

            HydratedQuickReplyButton.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.displayText != null && Object.hasOwnProperty.call(m, "displayText"))
                    w.uint32(10).string(m.displayText);
                if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                    w.uint32(18).string(m.id);
                return w;
            };

            HydratedQuickReplyButton.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HydratedTemplateButton.HydratedQuickReplyButton();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.displayText = r.string();
                            break;
                        }
                    case 2: {
                            m.id = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HydratedQuickReplyButton.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.HydratedTemplateButton.HydratedQuickReplyButton";
            };

            return HydratedQuickReplyButton;
        })();

        HydratedTemplateButton.HydratedURLButton = (function() {

            function HydratedURLButton(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HydratedURLButton.prototype.displayText = "";
            HydratedURLButton.prototype.url = "";
            HydratedURLButton.prototype.consentedUsersUrl = "";
            HydratedURLButton.prototype.webviewPresentation = 1;

            HydratedURLButton.create = function create(properties) {
                return new HydratedURLButton(properties);
            };

            HydratedURLButton.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.displayText != null && Object.hasOwnProperty.call(m, "displayText"))
                    w.uint32(10).string(m.displayText);
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(18).string(m.url);
                if (m.consentedUsersUrl != null && Object.hasOwnProperty.call(m, "consentedUsersUrl"))
                    w.uint32(26).string(m.consentedUsersUrl);
                if (m.webviewPresentation != null && Object.hasOwnProperty.call(m, "webviewPresentation"))
                    w.uint32(32).int32(m.webviewPresentation);
                return w;
            };

            HydratedURLButton.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.HydratedTemplateButton.HydratedURLButton();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.displayText = r.string();
                            break;
                        }
                    case 2: {
                            m.url = r.string();
                            break;
                        }
                    case 3: {
                            m.consentedUsersUrl = r.string();
                            break;
                        }
                    case 4: {
                            m.webviewPresentation = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HydratedURLButton.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.HydratedTemplateButton.HydratedURLButton";
            };

            HydratedURLButton.WebviewPresentationType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "FULL"] = 1;
                values[valuesById[2] = "TALL"] = 2;
                values[valuesById[3] = "COMPACT"] = 3;
                return values;
            })();

            return HydratedURLButton;
        })();

        return HydratedTemplateButton;
    })();

    proto.IdentityKeyPairStructure = (function() {

        function IdentityKeyPairStructure(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        IdentityKeyPairStructure.prototype.publicKey = $util.newBuffer([]);
        IdentityKeyPairStructure.prototype.privateKey = $util.newBuffer([]);

        IdentityKeyPairStructure.create = function create(properties) {
            return new IdentityKeyPairStructure(properties);
        };

        IdentityKeyPairStructure.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.publicKey != null && Object.hasOwnProperty.call(m, "publicKey"))
                w.uint32(10).bytes(m.publicKey);
            if (m.privateKey != null && Object.hasOwnProperty.call(m, "privateKey"))
                w.uint32(18).bytes(m.privateKey);
            return w;
        };

        IdentityKeyPairStructure.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.IdentityKeyPairStructure();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.publicKey = r.bytes();
                        break;
                    }
                case 2: {
                        m.privateKey = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        IdentityKeyPairStructure.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.IdentityKeyPairStructure";
        };

        return IdentityKeyPairStructure;
    })();

    proto.InteractiveAnnotation = (function() {

        function InteractiveAnnotation(p) {
            this.polygonVertices = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        InteractiveAnnotation.prototype.polygonVertices = $util.emptyArray;
        InteractiveAnnotation.prototype.shouldSkipConfirmation = false;
        InteractiveAnnotation.prototype.embeddedContent = null;
        InteractiveAnnotation.prototype.statusLinkType = 1;
        InteractiveAnnotation.prototype.location = null;
        InteractiveAnnotation.prototype.newsletter = null;
        InteractiveAnnotation.prototype.embeddedAction = null;
        InteractiveAnnotation.prototype.tapAction = null;

        let $oneOfFields;

        Object.defineProperty(InteractiveAnnotation.prototype, "action", {
            get: $util.oneOfGetter($oneOfFields = ["location", "newsletter", "embeddedAction", "tapAction"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        InteractiveAnnotation.create = function create(properties) {
            return new InteractiveAnnotation(properties);
        };

        InteractiveAnnotation.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.polygonVertices != null && m.polygonVertices.length) {
                for (var i = 0; i < m.polygonVertices.length; ++i)
                    $root.proto.Point.encode(m.polygonVertices[i], w.uint32(10).fork()).ldelim();
            }
            if (m.location != null && Object.hasOwnProperty.call(m, "location"))
                $root.proto.Location.encode(m.location, w.uint32(18).fork()).ldelim();
            if (m.newsletter != null && Object.hasOwnProperty.call(m, "newsletter"))
                $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.encode(m.newsletter, w.uint32(26).fork()).ldelim();
            if (m.shouldSkipConfirmation != null && Object.hasOwnProperty.call(m, "shouldSkipConfirmation"))
                w.uint32(32).bool(m.shouldSkipConfirmation);
            if (m.embeddedContent != null && Object.hasOwnProperty.call(m, "embeddedContent"))
                $root.proto.EmbeddedContent.encode(m.embeddedContent, w.uint32(42).fork()).ldelim();
            if (m.embeddedAction != null && Object.hasOwnProperty.call(m, "embeddedAction"))
                w.uint32(48).bool(m.embeddedAction);
            if (m.tapAction != null && Object.hasOwnProperty.call(m, "tapAction"))
                $root.proto.TapLinkAction.encode(m.tapAction, w.uint32(58).fork()).ldelim();
            if (m.statusLinkType != null && Object.hasOwnProperty.call(m, "statusLinkType"))
                w.uint32(64).int32(m.statusLinkType);
            return w;
        };

        InteractiveAnnotation.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.InteractiveAnnotation();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.polygonVertices && m.polygonVertices.length))
                            m.polygonVertices = [];
                        m.polygonVertices.push($root.proto.Point.decode(r, r.uint32()));
                        break;
                    }
                case 4: {
                        m.shouldSkipConfirmation = r.bool();
                        break;
                    }
                case 5: {
                        m.embeddedContent = $root.proto.EmbeddedContent.decode(r, r.uint32());
                        break;
                    }
                case 8: {
                        m.statusLinkType = r.int32();
                        break;
                    }
                case 2: {
                        m.location = $root.proto.Location.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.newsletter = $root.proto.ContextInfo.ForwardedNewsletterMessageInfo.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.embeddedAction = r.bool();
                        break;
                    }
                case 7: {
                        m.tapAction = $root.proto.TapLinkAction.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        InteractiveAnnotation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.InteractiveAnnotation";
        };

        InteractiveAnnotation.StatusLinkType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "RASTERIZED_LINK_PREVIEW"] = 1;
            values[valuesById[2] = "RASTERIZED_LINK_TRUNCATED"] = 2;
            values[valuesById[3] = "RASTERIZED_LINK_FULL_URL"] = 3;
            return values;
        })();

        return InteractiveAnnotation;
    })();

    proto.KeepInChat = (function() {

        function KeepInChat(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        KeepInChat.prototype.keepType = 0;
        KeepInChat.prototype.serverTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        KeepInChat.prototype.key = null;
        KeepInChat.prototype.deviceJid = "";
        KeepInChat.prototype.clientTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        KeepInChat.prototype.serverTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        KeepInChat.create = function create(properties) {
            return new KeepInChat(properties);
        };

        KeepInChat.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.keepType != null && Object.hasOwnProperty.call(m, "keepType"))
                w.uint32(8).int32(m.keepType);
            if (m.serverTimestamp != null && Object.hasOwnProperty.call(m, "serverTimestamp"))
                w.uint32(16).int64(m.serverTimestamp);
            if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                $root.proto.MessageKey.encode(m.key, w.uint32(26).fork()).ldelim();
            if (m.deviceJid != null && Object.hasOwnProperty.call(m, "deviceJid"))
                w.uint32(34).string(m.deviceJid);
            if (m.clientTimestampMs != null && Object.hasOwnProperty.call(m, "clientTimestampMs"))
                w.uint32(40).int64(m.clientTimestampMs);
            if (m.serverTimestampMs != null && Object.hasOwnProperty.call(m, "serverTimestampMs"))
                w.uint32(48).int64(m.serverTimestampMs);
            return w;
        };

        KeepInChat.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.KeepInChat();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.keepType = r.int32();
                        break;
                    }
                case 2: {
                        m.serverTimestamp = r.int64();
                        break;
                    }
                case 3: {
                        m.key = $root.proto.MessageKey.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.deviceJid = r.string();
                        break;
                    }
                case 5: {
                        m.clientTimestampMs = r.int64();
                        break;
                    }
                case 6: {
                        m.serverTimestampMs = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        KeepInChat.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.KeepInChat";
        };

        return KeepInChat;
    })();

    proto.KeepType = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "UNKNOWN"] = 0;
        values[valuesById[1] = "KEEP_FOR_ALL"] = 1;
        values[valuesById[2] = "UNDO_KEEP_FOR_ALL"] = 2;
        return values;
    })();

    proto.KeyExchangeMessage = (function() {

        function KeyExchangeMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        KeyExchangeMessage.prototype.id = 0;
        KeyExchangeMessage.prototype.baseKey = $util.newBuffer([]);
        KeyExchangeMessage.prototype.ratchetKey = $util.newBuffer([]);
        KeyExchangeMessage.prototype.identityKey = $util.newBuffer([]);
        KeyExchangeMessage.prototype.baseKeySignature = $util.newBuffer([]);

        KeyExchangeMessage.create = function create(properties) {
            return new KeyExchangeMessage(properties);
        };

        KeyExchangeMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                w.uint32(8).uint32(m.id);
            if (m.baseKey != null && Object.hasOwnProperty.call(m, "baseKey"))
                w.uint32(18).bytes(m.baseKey);
            if (m.ratchetKey != null && Object.hasOwnProperty.call(m, "ratchetKey"))
                w.uint32(26).bytes(m.ratchetKey);
            if (m.identityKey != null && Object.hasOwnProperty.call(m, "identityKey"))
                w.uint32(34).bytes(m.identityKey);
            if (m.baseKeySignature != null && Object.hasOwnProperty.call(m, "baseKeySignature"))
                w.uint32(42).bytes(m.baseKeySignature);
            return w;
        };

        KeyExchangeMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.KeyExchangeMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.id = r.uint32();
                        break;
                    }
                case 2: {
                        m.baseKey = r.bytes();
                        break;
                    }
                case 3: {
                        m.ratchetKey = r.bytes();
                        break;
                    }
                case 4: {
                        m.identityKey = r.bytes();
                        break;
                    }
                case 5: {
                        m.baseKeySignature = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        KeyExchangeMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.KeyExchangeMessage";
        };

        return KeyExchangeMessage;
    })();

    proto.KeyId = (function() {

        function KeyId(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        KeyId.prototype.id = $util.newBuffer([]);

        KeyId.create = function create(properties) {
            return new KeyId(properties);
        };

        KeyId.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                w.uint32(10).bytes(m.id);
            return w;
        };

        KeyId.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.KeyId();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.id = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        KeyId.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.KeyId";
        };

        return KeyId;
    })();

    proto.LIDMigrationMapping = (function() {

        function LIDMigrationMapping(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        LIDMigrationMapping.prototype.pn = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        LIDMigrationMapping.prototype.assignedLid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
        LIDMigrationMapping.prototype.latestLid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        LIDMigrationMapping.create = function create(properties) {
            return new LIDMigrationMapping(properties);
        };

        LIDMigrationMapping.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            w.uint32(8).uint64(m.pn);
            w.uint32(16).uint64(m.assignedLid);
            if (m.latestLid != null && Object.hasOwnProperty.call(m, "latestLid"))
                w.uint32(24).uint64(m.latestLid);
            return w;
        };

        LIDMigrationMapping.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.LIDMigrationMapping();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.pn = r.uint64();
                        break;
                    }
                case 2: {
                        m.assignedLid = r.uint64();
                        break;
                    }
                case 3: {
                        m.latestLid = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            if (!m.hasOwnProperty("pn"))
                throw $util.ProtocolError("missing required 'pn'", { instance: m });
            if (!m.hasOwnProperty("assignedLid"))
                throw $util.ProtocolError("missing required 'assignedLid'", { instance: m });
            return m;
        };

        LIDMigrationMapping.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.LIDMigrationMapping";
        };

        return LIDMigrationMapping;
    })();

    proto.LIDMigrationMappingSyncMessage = (function() {

        function LIDMigrationMappingSyncMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        LIDMigrationMappingSyncMessage.prototype.encodedMappingPayload = $util.newBuffer([]);

        LIDMigrationMappingSyncMessage.create = function create(properties) {
            return new LIDMigrationMappingSyncMessage(properties);
        };

        LIDMigrationMappingSyncMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.encodedMappingPayload != null && Object.hasOwnProperty.call(m, "encodedMappingPayload"))
                w.uint32(10).bytes(m.encodedMappingPayload);
            return w;
        };

        LIDMigrationMappingSyncMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.LIDMigrationMappingSyncMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.encodedMappingPayload = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        LIDMigrationMappingSyncMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.LIDMigrationMappingSyncMessage";
        };

        return LIDMigrationMappingSyncMessage;
    })();

    proto.LIDMigrationMappingSyncPayload = (function() {

        function LIDMigrationMappingSyncPayload(p) {
            this.pnToLidMappings = [];
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        LIDMigrationMappingSyncPayload.prototype.pnToLidMappings = $util.emptyArray;
        LIDMigrationMappingSyncPayload.prototype.chatDbMigrationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        LIDMigrationMappingSyncPayload.create = function create(properties) {
            return new LIDMigrationMappingSyncPayload(properties);
        };

        LIDMigrationMappingSyncPayload.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.pnToLidMappings != null && m.pnToLidMappings.length) {
                for (var i = 0; i < m.pnToLidMappings.length; ++i)
                    $root.proto.LIDMigrationMapping.encode(m.pnToLidMappings[i], w.uint32(10).fork()).ldelim();
            }
            if (m.chatDbMigrationTimestamp != null && Object.hasOwnProperty.call(m, "chatDbMigrationTimestamp"))
                w.uint32(16).uint64(m.chatDbMigrationTimestamp);
            return w;
        };

        LIDMigrationMappingSyncPayload.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.LIDMigrationMappingSyncPayload();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        if (!(m.pnToLidMappings && m.pnToLidMappings.length))
                            m.pnToLidMappings = [];
                        m.pnToLidMappings.push($root.proto.LIDMigrationMapping.decode(r, r.uint32()));
                        break;
                    }
                case 2: {
                        m.chatDbMigrationTimestamp = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        LIDMigrationMappingSyncPayload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.LIDMigrationMappingSyncPayload";
        };

        return LIDMigrationMappingSyncPayload;
    })();

    proto.LegacyMessage = (function() {

        function LegacyMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        LegacyMessage.prototype.eventResponseMessage = null;
        LegacyMessage.prototype.pollVote = null;

        LegacyMessage.create = function create(properties) {
            return new LegacyMessage(properties);
        };

        LegacyMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.eventResponseMessage != null && Object.hasOwnProperty.call(m, "eventResponseMessage"))
                $root.proto.Message.EventResponseMessage.encode(m.eventResponseMessage, w.uint32(10).fork()).ldelim();
            if (m.pollVote != null && Object.hasOwnProperty.call(m, "pollVote"))
                $root.proto.Message.PollVoteMessage.encode(m.pollVote, w.uint32(18).fork()).ldelim();
            return w;
        };

        LegacyMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.LegacyMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.eventResponseMessage = $root.proto.Message.EventResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 2: {
                        m.pollVote = $root.proto.Message.PollVoteMessage.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        LegacyMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.LegacyMessage";
        };

        return LegacyMessage;
    })();

    proto.LimitSharing = (function() {

        function LimitSharing(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        LimitSharing.prototype.sharingLimited = false;
        LimitSharing.prototype.trigger = 0;
        LimitSharing.prototype.limitSharingSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
        LimitSharing.prototype.initiatedByMe = false;

        LimitSharing.create = function create(properties) {
            return new LimitSharing(properties);
        };

        LimitSharing.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.sharingLimited != null && Object.hasOwnProperty.call(m, "sharingLimited"))
                w.uint32(8).bool(m.sharingLimited);
            if (m.trigger != null && Object.hasOwnProperty.call(m, "trigger"))
                w.uint32(16).int32(m.trigger);
            if (m.limitSharingSettingTimestamp != null && Object.hasOwnProperty.call(m, "limitSharingSettingTimestamp"))
                w.uint32(24).int64(m.limitSharingSettingTimestamp);
            if (m.initiatedByMe != null && Object.hasOwnProperty.call(m, "initiatedByMe"))
                w.uint32(32).bool(m.initiatedByMe);
            return w;
        };

        LimitSharing.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.LimitSharing();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.sharingLimited = r.bool();
                        break;
                    }
                case 2: {
                        m.trigger = r.int32();
                        break;
                    }
                case 3: {
                        m.limitSharingSettingTimestamp = r.int64();
                        break;
                    }
                case 4: {
                        m.initiatedByMe = r.bool();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        LimitSharing.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.LimitSharing";
        };

        LimitSharing.TriggerType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHAT_SETTING"] = 1;
            values[valuesById[2] = "BIZ_SUPPORTS_FB_HOSTING"] = 2;
            values[valuesById[3] = "UNKNOWN_GROUP"] = 3;
            return values;
        })();

        return LimitSharing;
    })();

    proto.LocalizedName = (function() {

        function LocalizedName(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        LocalizedName.prototype.lg = "";
        LocalizedName.prototype.lc = "";
        LocalizedName.prototype.verifiedName = "";

        LocalizedName.create = function create(properties) {
            return new LocalizedName(properties);
        };

        LocalizedName.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.lg != null && Object.hasOwnProperty.call(m, "lg"))
                w.uint32(10).string(m.lg);
            if (m.lc != null && Object.hasOwnProperty.call(m, "lc"))
                w.uint32(18).string(m.lc);
            if (m.verifiedName != null && Object.hasOwnProperty.call(m, "verifiedName"))
                w.uint32(26).string(m.verifiedName);
            return w;
        };

        LocalizedName.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.LocalizedName();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.lg = r.string();
                        break;
                    }
                case 2: {
                        m.lc = r.string();
                        break;
                    }
                case 3: {
                        m.verifiedName = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        LocalizedName.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.LocalizedName";
        };

        return LocalizedName;
    })();

    proto.Location = (function() {

        function Location(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Location.prototype.degreesLatitude = 0;
        Location.prototype.degreesLongitude = 0;
        Location.prototype.name = "";

        Location.create = function create(properties) {
            return new Location(properties);
        };

        Location.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.degreesLatitude != null && Object.hasOwnProperty.call(m, "degreesLatitude"))
                w.uint32(9).double(m.degreesLatitude);
            if (m.degreesLongitude != null && Object.hasOwnProperty.call(m, "degreesLongitude"))
                w.uint32(17).double(m.degreesLongitude);
            if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                w.uint32(26).string(m.name);
            return w;
        };

        Location.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Location();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.degreesLatitude = r.double();
                        break;
                    }
                case 2: {
                        m.degreesLongitude = r.double();
                        break;
                    }
                case 3: {
                        m.name = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Location.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Location";
        };

        return Location;
    })();

    proto.MediaData = (function() {

        function MediaData(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        MediaData.prototype.localPath = "";

        MediaData.create = function create(properties) {
            return new MediaData(properties);
        };

        MediaData.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.localPath != null && Object.hasOwnProperty.call(m, "localPath"))
                w.uint32(10).string(m.localPath);
            return w;
        };

        MediaData.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.MediaData();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.localPath = r.string();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        MediaData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.MediaData";
        };

        return MediaData;
    })();

    proto.MediaNotifyMessage = (function() {

        function MediaNotifyMessage(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        MediaNotifyMessage.prototype.expressPathUrl = "";
        MediaNotifyMessage.prototype.fileEncSha256 = $util.newBuffer([]);
        MediaNotifyMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        MediaNotifyMessage.create = function create(properties) {
            return new MediaNotifyMessage(properties);
        };

        MediaNotifyMessage.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.expressPathUrl != null && Object.hasOwnProperty.call(m, "expressPathUrl"))
                w.uint32(10).string(m.expressPathUrl);
            if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                w.uint32(18).bytes(m.fileEncSha256);
            if (m.fileLength != null && Object.hasOwnProperty.call(m, "fileLength"))
                w.uint32(24).uint64(m.fileLength);
            return w;
        };

        MediaNotifyMessage.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.MediaNotifyMessage();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.expressPathUrl = r.string();
                        break;
                    }
                case 2: {
                        m.fileEncSha256 = r.bytes();
                        break;
                    }
                case 3: {
                        m.fileLength = r.uint64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        MediaNotifyMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.MediaNotifyMessage";
        };

        return MediaNotifyMessage;
    })();

    proto.MediaRetryNotification = (function() {

        function MediaRetryNotification(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        MediaRetryNotification.prototype.stanzaId = "";
        MediaRetryNotification.prototype.directPath = "";
        MediaRetryNotification.prototype.result = 0;
        MediaRetryNotification.prototype.messageSecret = $util.newBuffer([]);

        MediaRetryNotification.create = function create(properties) {
            return new MediaRetryNotification(properties);
        };

        MediaRetryNotification.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                w.uint32(10).string(m.stanzaId);
            if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                w.uint32(18).string(m.directPath);
            if (m.result != null && Object.hasOwnProperty.call(m, "result"))
                w.uint32(24).int32(m.result);
            if (m.messageSecret != null && Object.hasOwnProperty.call(m, "messageSecret"))
                w.uint32(34).bytes(m.messageSecret);
            return w;
        };

        MediaRetryNotification.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.MediaRetryNotification();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.stanzaId = r.string();
                        break;
                    }
                case 2: {
                        m.directPath = r.string();
                        break;
                    }
                case 3: {
                        m.result = r.int32();
                        break;
                    }
                case 4: {
                        m.messageSecret = r.bytes();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        MediaRetryNotification.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.MediaRetryNotification";
        };

        MediaRetryNotification.ResultType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "GENERAL_ERROR"] = 0;
            values[valuesById[1] = "SUCCESS"] = 1;
            values[valuesById[2] = "NOT_FOUND"] = 2;
            values[valuesById[3] = "DECRYPTION_ERROR"] = 3;
            return values;
        })();

        return MediaRetryNotification;
    })();

    proto.MediaVisibility = (function() {
        const valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "DEFAULT"] = 0;
        values[valuesById[1] = "OFF"] = 1;
        values[valuesById[2] = "ON"] = 2;
        return values;
    })();

    proto.MemberLabel = (function() {

        function MemberLabel(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        MemberLabel.prototype.label = "";
        MemberLabel.prototype.labelTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        MemberLabel.create = function create(properties) {
            return new MemberLabel(properties);
        };

        MemberLabel.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.label != null && Object.hasOwnProperty.call(m, "label"))
                w.uint32(10).string(m.label);
            if (m.labelTimestamp != null && Object.hasOwnProperty.call(m, "labelTimestamp"))
                w.uint32(16).int64(m.labelTimestamp);
            return w;
        };

        MemberLabel.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.MemberLabel();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.label = r.string();
                        break;
                    }
                case 2: {
                        m.labelTimestamp = r.int64();
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        MemberLabel.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.MemberLabel";
        };

        return MemberLabel;
    })();

    proto.Message = (function() {

        function Message(p) {
            if (p)
                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                    if (p[ks[i]] != null)
                        this[ks[i]] = p[ks[i]];
        }

        Message.prototype.conversation = "";
        Message.prototype.senderKeyDistributionMessage = null;
        Message.prototype.imageMessage = null;
        Message.prototype.contactMessage = null;
        Message.prototype.locationMessage = null;
        Message.prototype.extendedTextMessage = null;
        Message.prototype.documentMessage = null;
        Message.prototype.audioMessage = null;
        Message.prototype.videoMessage = null;
        Message.prototype.call = null;
        Message.prototype.chat = null;
        Message.prototype.protocolMessage = null;
        Message.prototype.contactsArrayMessage = null;
        Message.prototype.highlyStructuredMessage = null;
        Message.prototype.fastRatchetKeySenderKeyDistributionMessage = null;
        Message.prototype.sendPaymentMessage = null;
        Message.prototype.liveLocationMessage = null;
        Message.prototype.requestPaymentMessage = null;
        Message.prototype.declinePaymentRequestMessage = null;
        Message.prototype.cancelPaymentRequestMessage = null;
        Message.prototype.templateMessage = null;
        Message.prototype.stickerMessage = null;
        Message.prototype.groupInviteMessage = null;
        Message.prototype.templateButtonReplyMessage = null;
        Message.prototype.productMessage = null;
        Message.prototype.deviceSentMessage = null;
        Message.prototype.messageContextInfo = null;
        Message.prototype.listMessage = null;
        Message.prototype.viewOnceMessage = null;
        Message.prototype.orderMessage = null;
        Message.prototype.listResponseMessage = null;
        Message.prototype.ephemeralMessage = null;
        Message.prototype.invoiceMessage = null;
        Message.prototype.buttonsMessage = null;
        Message.prototype.buttonsResponseMessage = null;
        Message.prototype.paymentInviteMessage = null;
        Message.prototype.interactiveMessage = null;
        Message.prototype.reactionMessage = null;
        Message.prototype.stickerSyncRmrMessage = null;
        Message.prototype.interactiveResponseMessage = null;
        Message.prototype.pollCreationMessage = null;
        Message.prototype.pollUpdateMessage = null;
        Message.prototype.keepInChatMessage = null;
        Message.prototype.documentWithCaptionMessage = null;
        Message.prototype.requestPhoneNumberMessage = null;
        Message.prototype.viewOnceMessageV2 = null;
        Message.prototype.encReactionMessage = null;
        Message.prototype.editedMessage = null;
        Message.prototype.viewOnceMessageV2Extension = null;
        Message.prototype.pollCreationMessageV2 = null;
        Message.prototype.scheduledCallCreationMessage = null;
        Message.prototype.groupMentionedMessage = null;
        Message.prototype.pinInChatMessage = null;
        Message.prototype.pollCreationMessageV3 = null;
        Message.prototype.scheduledCallEditMessage = null;
        Message.prototype.ptvMessage = null;
        Message.prototype.botInvokeMessage = null;
        Message.prototype.callLogMesssage = null;
        Message.prototype.messageHistoryBundle = null;
        Message.prototype.encCommentMessage = null;
        Message.prototype.bcallMessage = null;
        Message.prototype.lottieStickerMessage = null;
        Message.prototype.eventMessage = null;
        Message.prototype.encEventResponseMessage = null;
        Message.prototype.commentMessage = null;
        Message.prototype.newsletterAdminInviteMessage = null;
        Message.prototype.placeholderMessage = null;
        Message.prototype.secretEncryptedMessage = null;
        Message.prototype.albumMessage = null;
        Message.prototype.eventCoverImage = null;
        Message.prototype.stickerPackMessage = null;
        Message.prototype.statusMentionMessage = null;
        Message.prototype.pollResultSnapshotMessage = null;
        Message.prototype.pollCreationOptionImageMessage = null;
        Message.prototype.associatedChildMessage = null;
        Message.prototype.groupStatusMentionMessage = null;
        Message.prototype.pollCreationMessageV4 = null;
        Message.prototype.pollCreationMessageV5 = null;
        Message.prototype.statusAddYours = null;
        Message.prototype.groupStatusMessage = null;
        Message.prototype.richResponseMessage = null;
        Message.prototype.statusNotificationMessage = null;
        Message.prototype.limitSharingMessage = null;
        Message.prototype.botTaskMessage = null;
        Message.prototype.questionMessage = null;
        Message.prototype.messageHistoryNotice = null;

        Message.create = function create(properties) {
            return new Message(properties);
        };

        Message.encode = function encode(m, w) {
            if (!w)
                w = $Writer.create();
            if (m.conversation != null && Object.hasOwnProperty.call(m, "conversation"))
                w.uint32(10).string(m.conversation);
            if (m.senderKeyDistributionMessage != null && Object.hasOwnProperty.call(m, "senderKeyDistributionMessage"))
                $root.proto.Message.SenderKeyDistributionMessage.encode(m.senderKeyDistributionMessage, w.uint32(18).fork()).ldelim();
            if (m.imageMessage != null && Object.hasOwnProperty.call(m, "imageMessage"))
                $root.proto.Message.ImageMessage.encode(m.imageMessage, w.uint32(26).fork()).ldelim();
            if (m.contactMessage != null && Object.hasOwnProperty.call(m, "contactMessage"))
                $root.proto.Message.ContactMessage.encode(m.contactMessage, w.uint32(34).fork()).ldelim();
            if (m.locationMessage != null && Object.hasOwnProperty.call(m, "locationMessage"))
                $root.proto.Message.LocationMessage.encode(m.locationMessage, w.uint32(42).fork()).ldelim();
            if (m.extendedTextMessage != null && Object.hasOwnProperty.call(m, "extendedTextMessage"))
                $root.proto.Message.ExtendedTextMessage.encode(m.extendedTextMessage, w.uint32(50).fork()).ldelim();
            if (m.documentMessage != null && Object.hasOwnProperty.call(m, "documentMessage"))
                $root.proto.Message.DocumentMessage.encode(m.documentMessage, w.uint32(58).fork()).ldelim();
            if (m.audioMessage != null && Object.hasOwnProperty.call(m, "audioMessage"))
                $root.proto.Message.AudioMessage.encode(m.audioMessage, w.uint32(66).fork()).ldelim();
            if (m.videoMessage != null && Object.hasOwnProperty.call(m, "videoMessage"))
                $root.proto.Message.VideoMessage.encode(m.videoMessage, w.uint32(74).fork()).ldelim();
            if (m.call != null && Object.hasOwnProperty.call(m, "call"))
                $root.proto.Message.Call.encode(m.call, w.uint32(82).fork()).ldelim();
            if (m.chat != null && Object.hasOwnProperty.call(m, "chat"))
                $root.proto.Message.Chat.encode(m.chat, w.uint32(90).fork()).ldelim();
            if (m.protocolMessage != null && Object.hasOwnProperty.call(m, "protocolMessage"))
                $root.proto.Message.ProtocolMessage.encode(m.protocolMessage, w.uint32(98).fork()).ldelim();
            if (m.contactsArrayMessage != null && Object.hasOwnProperty.call(m, "contactsArrayMessage"))
                $root.proto.Message.ContactsArrayMessage.encode(m.contactsArrayMessage, w.uint32(106).fork()).ldelim();
            if (m.highlyStructuredMessage != null && Object.hasOwnProperty.call(m, "highlyStructuredMessage"))
                $root.proto.Message.HighlyStructuredMessage.encode(m.highlyStructuredMessage, w.uint32(114).fork()).ldelim();
            if (m.fastRatchetKeySenderKeyDistributionMessage != null && Object.hasOwnProperty.call(m, "fastRatchetKeySenderKeyDistributionMessage"))
                $root.proto.Message.SenderKeyDistributionMessage.encode(m.fastRatchetKeySenderKeyDistributionMessage, w.uint32(122).fork()).ldelim();
            if (m.sendPaymentMessage != null && Object.hasOwnProperty.call(m, "sendPaymentMessage"))
                $root.proto.Message.SendPaymentMessage.encode(m.sendPaymentMessage, w.uint32(130).fork()).ldelim();
            if (m.liveLocationMessage != null && Object.hasOwnProperty.call(m, "liveLocationMessage"))
                $root.proto.Message.LiveLocationMessage.encode(m.liveLocationMessage, w.uint32(146).fork()).ldelim();
            if (m.requestPaymentMessage != null && Object.hasOwnProperty.call(m, "requestPaymentMessage"))
                $root.proto.Message.RequestPaymentMessage.encode(m.requestPaymentMessage, w.uint32(178).fork()).ldelim();
            if (m.declinePaymentRequestMessage != null && Object.hasOwnProperty.call(m, "declinePaymentRequestMessage"))
                $root.proto.Message.DeclinePaymentRequestMessage.encode(m.declinePaymentRequestMessage, w.uint32(186).fork()).ldelim();
            if (m.cancelPaymentRequestMessage != null && Object.hasOwnProperty.call(m, "cancelPaymentRequestMessage"))
                $root.proto.Message.CancelPaymentRequestMessage.encode(m.cancelPaymentRequestMessage, w.uint32(194).fork()).ldelim();
            if (m.templateMessage != null && Object.hasOwnProperty.call(m, "templateMessage"))
                $root.proto.Message.TemplateMessage.encode(m.templateMessage, w.uint32(202).fork()).ldelim();
            if (m.stickerMessage != null && Object.hasOwnProperty.call(m, "stickerMessage"))
                $root.proto.Message.StickerMessage.encode(m.stickerMessage, w.uint32(210).fork()).ldelim();
            if (m.groupInviteMessage != null && Object.hasOwnProperty.call(m, "groupInviteMessage"))
                $root.proto.Message.GroupInviteMessage.encode(m.groupInviteMessage, w.uint32(226).fork()).ldelim();
            if (m.templateButtonReplyMessage != null && Object.hasOwnProperty.call(m, "templateButtonReplyMessage"))
                $root.proto.Message.TemplateButtonReplyMessage.encode(m.templateButtonReplyMessage, w.uint32(234).fork()).ldelim();
            if (m.productMessage != null && Object.hasOwnProperty.call(m, "productMessage"))
                $root.proto.Message.ProductMessage.encode(m.productMessage, w.uint32(242).fork()).ldelim();
            if (m.deviceSentMessage != null && Object.hasOwnProperty.call(m, "deviceSentMessage"))
                $root.proto.Message.DeviceSentMessage.encode(m.deviceSentMessage, w.uint32(250).fork()).ldelim();
            if (m.messageContextInfo != null && Object.hasOwnProperty.call(m, "messageContextInfo"))
                $root.proto.MessageContextInfo.encode(m.messageContextInfo, w.uint32(282).fork()).ldelim();
            if (m.listMessage != null && Object.hasOwnProperty.call(m, "listMessage"))
                $root.proto.Message.ListMessage.encode(m.listMessage, w.uint32(290).fork()).ldelim();
            if (m.viewOnceMessage != null && Object.hasOwnProperty.call(m, "viewOnceMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.viewOnceMessage, w.uint32(298).fork()).ldelim();
            if (m.orderMessage != null && Object.hasOwnProperty.call(m, "orderMessage"))
                $root.proto.Message.OrderMessage.encode(m.orderMessage, w.uint32(306).fork()).ldelim();
            if (m.listResponseMessage != null && Object.hasOwnProperty.call(m, "listResponseMessage"))
                $root.proto.Message.ListResponseMessage.encode(m.listResponseMessage, w.uint32(314).fork()).ldelim();
            if (m.ephemeralMessage != null && Object.hasOwnProperty.call(m, "ephemeralMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.ephemeralMessage, w.uint32(322).fork()).ldelim();
            if (m.invoiceMessage != null && Object.hasOwnProperty.call(m, "invoiceMessage"))
                $root.proto.Message.InvoiceMessage.encode(m.invoiceMessage, w.uint32(330).fork()).ldelim();
            if (m.buttonsMessage != null && Object.hasOwnProperty.call(m, "buttonsMessage"))
                $root.proto.Message.ButtonsMessage.encode(m.buttonsMessage, w.uint32(338).fork()).ldelim();
            if (m.buttonsResponseMessage != null && Object.hasOwnProperty.call(m, "buttonsResponseMessage"))
                $root.proto.Message.ButtonsResponseMessage.encode(m.buttonsResponseMessage, w.uint32(346).fork()).ldelim();
            if (m.paymentInviteMessage != null && Object.hasOwnProperty.call(m, "paymentInviteMessage"))
                $root.proto.Message.PaymentInviteMessage.encode(m.paymentInviteMessage, w.uint32(354).fork()).ldelim();
            if (m.interactiveMessage != null && Object.hasOwnProperty.call(m, "interactiveMessage"))
                $root.proto.Message.InteractiveMessage.encode(m.interactiveMessage, w.uint32(362).fork()).ldelim();
            if (m.reactionMessage != null && Object.hasOwnProperty.call(m, "reactionMessage"))
                $root.proto.Message.ReactionMessage.encode(m.reactionMessage, w.uint32(370).fork()).ldelim();
            if (m.stickerSyncRmrMessage != null && Object.hasOwnProperty.call(m, "stickerSyncRmrMessage"))
                $root.proto.Message.StickerSyncRMRMessage.encode(m.stickerSyncRmrMessage, w.uint32(378).fork()).ldelim();
            if (m.interactiveResponseMessage != null && Object.hasOwnProperty.call(m, "interactiveResponseMessage"))
                $root.proto.Message.InteractiveResponseMessage.encode(m.interactiveResponseMessage, w.uint32(386).fork()).ldelim();
            if (m.pollCreationMessage != null && Object.hasOwnProperty.call(m, "pollCreationMessage"))
                $root.proto.Message.PollCreationMessage.encode(m.pollCreationMessage, w.uint32(394).fork()).ldelim();
            if (m.pollUpdateMessage != null && Object.hasOwnProperty.call(m, "pollUpdateMessage"))
                $root.proto.Message.PollUpdateMessage.encode(m.pollUpdateMessage, w.uint32(402).fork()).ldelim();
            if (m.keepInChatMessage != null && Object.hasOwnProperty.call(m, "keepInChatMessage"))
                $root.proto.Message.KeepInChatMessage.encode(m.keepInChatMessage, w.uint32(410).fork()).ldelim();
            if (m.documentWithCaptionMessage != null && Object.hasOwnProperty.call(m, "documentWithCaptionMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.documentWithCaptionMessage, w.uint32(426).fork()).ldelim();
            if (m.requestPhoneNumberMessage != null && Object.hasOwnProperty.call(m, "requestPhoneNumberMessage"))
                $root.proto.Message.RequestPhoneNumberMessage.encode(m.requestPhoneNumberMessage, w.uint32(434).fork()).ldelim();
            if (m.viewOnceMessageV2 != null && Object.hasOwnProperty.call(m, "viewOnceMessageV2"))
                $root.proto.Message.FutureProofMessage.encode(m.viewOnceMessageV2, w.uint32(442).fork()).ldelim();
            if (m.encReactionMessage != null && Object.hasOwnProperty.call(m, "encReactionMessage"))
                $root.proto.Message.EncReactionMessage.encode(m.encReactionMessage, w.uint32(450).fork()).ldelim();
            if (m.editedMessage != null && Object.hasOwnProperty.call(m, "editedMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.editedMessage, w.uint32(466).fork()).ldelim();
            if (m.viewOnceMessageV2Extension != null && Object.hasOwnProperty.call(m, "viewOnceMessageV2Extension"))
                $root.proto.Message.FutureProofMessage.encode(m.viewOnceMessageV2Extension, w.uint32(474).fork()).ldelim();
            if (m.pollCreationMessageV2 != null && Object.hasOwnProperty.call(m, "pollCreationMessageV2"))
                $root.proto.Message.PollCreationMessage.encode(m.pollCreationMessageV2, w.uint32(482).fork()).ldelim();
            if (m.scheduledCallCreationMessage != null && Object.hasOwnProperty.call(m, "scheduledCallCreationMessage"))
                $root.proto.Message.ScheduledCallCreationMessage.encode(m.scheduledCallCreationMessage, w.uint32(490).fork()).ldelim();
            if (m.groupMentionedMessage != null && Object.hasOwnProperty.call(m, "groupMentionedMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.groupMentionedMessage, w.uint32(498).fork()).ldelim();
            if (m.pinInChatMessage != null && Object.hasOwnProperty.call(m, "pinInChatMessage"))
                $root.proto.Message.PinInChatMessage.encode(m.pinInChatMessage, w.uint32(506).fork()).ldelim();
            if (m.pollCreationMessageV3 != null && Object.hasOwnProperty.call(m, "pollCreationMessageV3"))
                $root.proto.Message.PollCreationMessage.encode(m.pollCreationMessageV3, w.uint32(514).fork()).ldelim();
            if (m.scheduledCallEditMessage != null && Object.hasOwnProperty.call(m, "scheduledCallEditMessage"))
                $root.proto.Message.ScheduledCallEditMessage.encode(m.scheduledCallEditMessage, w.uint32(522).fork()).ldelim();
            if (m.ptvMessage != null && Object.hasOwnProperty.call(m, "ptvMessage"))
                $root.proto.Message.VideoMessage.encode(m.ptvMessage, w.uint32(530).fork()).ldelim();
            if (m.botInvokeMessage != null && Object.hasOwnProperty.call(m, "botInvokeMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.botInvokeMessage, w.uint32(538).fork()).ldelim();
            if (m.callLogMesssage != null && Object.hasOwnProperty.call(m, "callLogMesssage"))
                $root.proto.Message.CallLogMessage.encode(m.callLogMesssage, w.uint32(554).fork()).ldelim();
            if (m.messageHistoryBundle != null && Object.hasOwnProperty.call(m, "messageHistoryBundle"))
                $root.proto.Message.MessageHistoryBundle.encode(m.messageHistoryBundle, w.uint32(562).fork()).ldelim();
            if (m.encCommentMessage != null && Object.hasOwnProperty.call(m, "encCommentMessage"))
                $root.proto.Message.EncCommentMessage.encode(m.encCommentMessage, w.uint32(570).fork()).ldelim();
            if (m.bcallMessage != null && Object.hasOwnProperty.call(m, "bcallMessage"))
                $root.proto.Message.BCallMessage.encode(m.bcallMessage, w.uint32(578).fork()).ldelim();
            if (m.lottieStickerMessage != null && Object.hasOwnProperty.call(m, "lottieStickerMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.lottieStickerMessage, w.uint32(594).fork()).ldelim();
            if (m.eventMessage != null && Object.hasOwnProperty.call(m, "eventMessage"))
                $root.proto.Message.EventMessage.encode(m.eventMessage, w.uint32(602).fork()).ldelim();
            if (m.encEventResponseMessage != null && Object.hasOwnProperty.call(m, "encEventResponseMessage"))
                $root.proto.Message.EncEventResponseMessage.encode(m.encEventResponseMessage, w.uint32(610).fork()).ldelim();
            if (m.commentMessage != null && Object.hasOwnProperty.call(m, "commentMessage"))
                $root.proto.Message.CommentMessage.encode(m.commentMessage, w.uint32(618).fork()).ldelim();
            if (m.newsletterAdminInviteMessage != null && Object.hasOwnProperty.call(m, "newsletterAdminInviteMessage"))
                $root.proto.Message.NewsletterAdminInviteMessage.encode(m.newsletterAdminInviteMessage, w.uint32(626).fork()).ldelim();
            if (m.placeholderMessage != null && Object.hasOwnProperty.call(m, "placeholderMessage"))
                $root.proto.Message.PlaceholderMessage.encode(m.placeholderMessage, w.uint32(642).fork()).ldelim();
            if (m.secretEncryptedMessage != null && Object.hasOwnProperty.call(m, "secretEncryptedMessage"))
                $root.proto.Message.SecretEncryptedMessage.encode(m.secretEncryptedMessage, w.uint32(658).fork()).ldelim();
            if (m.albumMessage != null && Object.hasOwnProperty.call(m, "albumMessage"))
                $root.proto.Message.AlbumMessage.encode(m.albumMessage, w.uint32(666).fork()).ldelim();
            if (m.eventCoverImage != null && Object.hasOwnProperty.call(m, "eventCoverImage"))
                $root.proto.Message.FutureProofMessage.encode(m.eventCoverImage, w.uint32(682).fork()).ldelim();
            if (m.stickerPackMessage != null && Object.hasOwnProperty.call(m, "stickerPackMessage"))
                $root.proto.Message.StickerPackMessage.encode(m.stickerPackMessage, w.uint32(690).fork()).ldelim();
            if (m.statusMentionMessage != null && Object.hasOwnProperty.call(m, "statusMentionMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.statusMentionMessage, w.uint32(698).fork()).ldelim();
            if (m.pollResultSnapshotMessage != null && Object.hasOwnProperty.call(m, "pollResultSnapshotMessage"))
                $root.proto.Message.PollResultSnapshotMessage.encode(m.pollResultSnapshotMessage, w.uint32(706).fork()).ldelim();
            if (m.pollCreationOptionImageMessage != null && Object.hasOwnProperty.call(m, "pollCreationOptionImageMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.pollCreationOptionImageMessage, w.uint32(722).fork()).ldelim();
            if (m.associatedChildMessage != null && Object.hasOwnProperty.call(m, "associatedChildMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.associatedChildMessage, w.uint32(730).fork()).ldelim();
            if (m.groupStatusMentionMessage != null && Object.hasOwnProperty.call(m, "groupStatusMentionMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.groupStatusMentionMessage, w.uint32(738).fork()).ldelim();
            if (m.pollCreationMessageV4 != null && Object.hasOwnProperty.call(m, "pollCreationMessageV4"))
                $root.proto.Message.FutureProofMessage.encode(m.pollCreationMessageV4, w.uint32(746).fork()).ldelim();
            if (m.pollCreationMessageV5 != null && Object.hasOwnProperty.call(m, "pollCreationMessageV5"))
                $root.proto.Message.FutureProofMessage.encode(m.pollCreationMessageV5, w.uint32(754).fork()).ldelim();
            if (m.statusAddYours != null && Object.hasOwnProperty.call(m, "statusAddYours"))
                $root.proto.Message.FutureProofMessage.encode(m.statusAddYours, w.uint32(762).fork()).ldelim();
            if (m.groupStatusMessage != null && Object.hasOwnProperty.call(m, "groupStatusMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.groupStatusMessage, w.uint32(770).fork()).ldelim();
            if (m.richResponseMessage != null && Object.hasOwnProperty.call(m, "richResponseMessage"))
                $root.proto.AIRichResponseMessage.encode(m.richResponseMessage, w.uint32(778).fork()).ldelim();
            if (m.statusNotificationMessage != null && Object.hasOwnProperty.call(m, "statusNotificationMessage"))
                $root.proto.Message.StatusNotificationMessage.encode(m.statusNotificationMessage, w.uint32(786).fork()).ldelim();
            if (m.limitSharingMessage != null && Object.hasOwnProperty.call(m, "limitSharingMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.limitSharingMessage, w.uint32(794).fork()).ldelim();
            if (m.botTaskMessage != null && Object.hasOwnProperty.call(m, "botTaskMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.botTaskMessage, w.uint32(802).fork()).ldelim();
            if (m.questionMessage != null && Object.hasOwnProperty.call(m, "questionMessage"))
                $root.proto.Message.FutureProofMessage.encode(m.questionMessage, w.uint32(810).fork()).ldelim();
            if (m.messageHistoryNotice != null && Object.hasOwnProperty.call(m, "messageHistoryNotice"))
                $root.proto.Message.MessageHistoryNotice.encode(m.messageHistoryNotice, w.uint32(818).fork()).ldelim();
            return w;
        };

        Message.decode = function decode(r, l, e) {
            if (!(r instanceof $Reader))
                r = $Reader.create(r);
            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message();
            while (r.pos < c) {
                var t = r.uint32();
                if (t === e)
                    break;
                switch (t >>> 3) {
                case 1: {
                        m.conversation = r.string();
                        break;
                    }
                case 2: {
                        m.senderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.decode(r, r.uint32());
                        break;
                    }
                case 3: {
                        m.imageMessage = $root.proto.Message.ImageMessage.decode(r, r.uint32());
                        break;
                    }
                case 4: {
                        m.contactMessage = $root.proto.Message.ContactMessage.decode(r, r.uint32());
                        break;
                    }
                case 5: {
                        m.locationMessage = $root.proto.Message.LocationMessage.decode(r, r.uint32());
                        break;
                    }
                case 6: {
                        m.extendedTextMessage = $root.proto.Message.ExtendedTextMessage.decode(r, r.uint32());
                        break;
                    }
                case 7: {
                        m.documentMessage = $root.proto.Message.DocumentMessage.decode(r, r.uint32());
                        break;
                    }
                case 8: {
                        m.audioMessage = $root.proto.Message.AudioMessage.decode(r, r.uint32());
                        break;
                    }
                case 9: {
                        m.videoMessage = $root.proto.Message.VideoMessage.decode(r, r.uint32());
                        break;
                    }
                case 10: {
                        m.call = $root.proto.Message.Call.decode(r, r.uint32());
                        break;
                    }
                case 11: {
                        m.chat = $root.proto.Message.Chat.decode(r, r.uint32());
                        break;
                    }
                case 12: {
                        m.protocolMessage = $root.proto.Message.ProtocolMessage.decode(r, r.uint32());
                        break;
                    }
                case 13: {
                        m.contactsArrayMessage = $root.proto.Message.ContactsArrayMessage.decode(r, r.uint32());
                        break;
                    }
                case 14: {
                        m.highlyStructuredMessage = $root.proto.Message.HighlyStructuredMessage.decode(r, r.uint32());
                        break;
                    }
                case 15: {
                        m.fastRatchetKeySenderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.decode(r, r.uint32());
                        break;
                    }
                case 16: {
                        m.sendPaymentMessage = $root.proto.Message.SendPaymentMessage.decode(r, r.uint32());
                        break;
                    }
                case 18: {
                        m.liveLocationMessage = $root.proto.Message.LiveLocationMessage.decode(r, r.uint32());
                        break;
                    }
                case 22: {
                        m.requestPaymentMessage = $root.proto.Message.RequestPaymentMessage.decode(r, r.uint32());
                        break;
                    }
                case 23: {
                        m.declinePaymentRequestMessage = $root.proto.Message.DeclinePaymentRequestMessage.decode(r, r.uint32());
                        break;
                    }
                case 24: {
                        m.cancelPaymentRequestMessage = $root.proto.Message.CancelPaymentRequestMessage.decode(r, r.uint32());
                        break;
                    }
                case 25: {
                        m.templateMessage = $root.proto.Message.TemplateMessage.decode(r, r.uint32());
                        break;
                    }
                case 26: {
                        m.stickerMessage = $root.proto.Message.StickerMessage.decode(r, r.uint32());
                        break;
                    }
                case 28: {
                        m.groupInviteMessage = $root.proto.Message.GroupInviteMessage.decode(r, r.uint32());
                        break;
                    }
                case 29: {
                        m.templateButtonReplyMessage = $root.proto.Message.TemplateButtonReplyMessage.decode(r, r.uint32());
                        break;
                    }
                case 30: {
                        m.productMessage = $root.proto.Message.ProductMessage.decode(r, r.uint32());
                        break;
                    }
                case 31: {
                        m.deviceSentMessage = $root.proto.Message.DeviceSentMessage.decode(r, r.uint32());
                        break;
                    }
                case 35: {
                        m.messageContextInfo = $root.proto.MessageContextInfo.decode(r, r.uint32());
                        break;
                    }
                case 36: {
                        m.listMessage = $root.proto.Message.ListMessage.decode(r, r.uint32());
                        break;
                    }
                case 37: {
                        m.viewOnceMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 38: {
                        m.orderMessage = $root.proto.Message.OrderMessage.decode(r, r.uint32());
                        break;
                    }
                case 39: {
                        m.listResponseMessage = $root.proto.Message.ListResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 40: {
                        m.ephemeralMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 41: {
                        m.invoiceMessage = $root.proto.Message.InvoiceMessage.decode(r, r.uint32());
                        break;
                    }
                case 42: {
                        m.buttonsMessage = $root.proto.Message.ButtonsMessage.decode(r, r.uint32());
                        break;
                    }
                case 43: {
                        m.buttonsResponseMessage = $root.proto.Message.ButtonsResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 44: {
                        m.paymentInviteMessage = $root.proto.Message.PaymentInviteMessage.decode(r, r.uint32());
                        break;
                    }
                case 45: {
                        m.interactiveMessage = $root.proto.Message.InteractiveMessage.decode(r, r.uint32());
                        break;
                    }
                case 46: {
                        m.reactionMessage = $root.proto.Message.ReactionMessage.decode(r, r.uint32());
                        break;
                    }
                case 47: {
                        m.stickerSyncRmrMessage = $root.proto.Message.StickerSyncRMRMessage.decode(r, r.uint32());
                        break;
                    }
                case 48: {
                        m.interactiveResponseMessage = $root.proto.Message.InteractiveResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 49: {
                        m.pollCreationMessage = $root.proto.Message.PollCreationMessage.decode(r, r.uint32());
                        break;
                    }
                case 50: {
                        m.pollUpdateMessage = $root.proto.Message.PollUpdateMessage.decode(r, r.uint32());
                        break;
                    }
                case 51: {
                        m.keepInChatMessage = $root.proto.Message.KeepInChatMessage.decode(r, r.uint32());
                        break;
                    }
                case 53: {
                        m.documentWithCaptionMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 54: {
                        m.requestPhoneNumberMessage = $root.proto.Message.RequestPhoneNumberMessage.decode(r, r.uint32());
                        break;
                    }
                case 55: {
                        m.viewOnceMessageV2 = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 56: {
                        m.encReactionMessage = $root.proto.Message.EncReactionMessage.decode(r, r.uint32());
                        break;
                    }
                case 58: {
                        m.editedMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 59: {
                        m.viewOnceMessageV2Extension = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 60: {
                        m.pollCreationMessageV2 = $root.proto.Message.PollCreationMessage.decode(r, r.uint32());
                        break;
                    }
                case 61: {
                        m.scheduledCallCreationMessage = $root.proto.Message.ScheduledCallCreationMessage.decode(r, r.uint32());
                        break;
                    }
                case 62: {
                        m.groupMentionedMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 63: {
                        m.pinInChatMessage = $root.proto.Message.PinInChatMessage.decode(r, r.uint32());
                        break;
                    }
                case 64: {
                        m.pollCreationMessageV3 = $root.proto.Message.PollCreationMessage.decode(r, r.uint32());
                        break;
                    }
                case 65: {
                        m.scheduledCallEditMessage = $root.proto.Message.ScheduledCallEditMessage.decode(r, r.uint32());
                        break;
                    }
                case 66: {
                        m.ptvMessage = $root.proto.Message.VideoMessage.decode(r, r.uint32());
                        break;
                    }
                case 67: {
                        m.botInvokeMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 69: {
                        m.callLogMesssage = $root.proto.Message.CallLogMessage.decode(r, r.uint32());
                        break;
                    }
                case 70: {
                        m.messageHistoryBundle = $root.proto.Message.MessageHistoryBundle.decode(r, r.uint32());
                        break;
                    }
                case 71: {
                        m.encCommentMessage = $root.proto.Message.EncCommentMessage.decode(r, r.uint32());
                        break;
                    }
                case 72: {
                        m.bcallMessage = $root.proto.Message.BCallMessage.decode(r, r.uint32());
                        break;
                    }
                case 74: {
                        m.lottieStickerMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 75: {
                        m.eventMessage = $root.proto.Message.EventMessage.decode(r, r.uint32());
                        break;
                    }
                case 76: {
                        m.encEventResponseMessage = $root.proto.Message.EncEventResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 77: {
                        m.commentMessage = $root.proto.Message.CommentMessage.decode(r, r.uint32());
                        break;
                    }
                case 78: {
                        m.newsletterAdminInviteMessage = $root.proto.Message.NewsletterAdminInviteMessage.decode(r, r.uint32());
                        break;
                    }
                case 80: {
                        m.placeholderMessage = $root.proto.Message.PlaceholderMessage.decode(r, r.uint32());
                        break;
                    }
                case 82: {
                        m.secretEncryptedMessage = $root.proto.Message.SecretEncryptedMessage.decode(r, r.uint32());
                        break;
                    }
                case 83: {
                        m.albumMessage = $root.proto.Message.AlbumMessage.decode(r, r.uint32());
                        break;
                    }
                case 85: {
                        m.eventCoverImage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 86: {
                        m.stickerPackMessage = $root.proto.Message.StickerPackMessage.decode(r, r.uint32());
                        break;
                    }
                case 87: {
                        m.statusMentionMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 88: {
                        m.pollResultSnapshotMessage = $root.proto.Message.PollResultSnapshotMessage.decode(r, r.uint32());
                        break;
                    }
                case 90: {
                        m.pollCreationOptionImageMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 91: {
                        m.associatedChildMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 92: {
                        m.groupStatusMentionMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 93: {
                        m.pollCreationMessageV4 = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 94: {
                        m.pollCreationMessageV5 = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 95: {
                        m.statusAddYours = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 96: {
                        m.groupStatusMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 97: {
                        m.richResponseMessage = $root.proto.AIRichResponseMessage.decode(r, r.uint32());
                        break;
                    }
                case 98: {
                        m.statusNotificationMessage = $root.proto.Message.StatusNotificationMessage.decode(r, r.uint32());
                        break;
                    }
                case 99: {
                        m.limitSharingMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 100: {
                        m.botTaskMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 101: {
                        m.questionMessage = $root.proto.Message.FutureProofMessage.decode(r, r.uint32());
                        break;
                    }
                case 102: {
                        m.messageHistoryNotice = $root.proto.Message.MessageHistoryNotice.decode(r, r.uint32());
                        break;
                    }
                default:
                    r.skipType(t & 7);
                    break;
                }
            }
            return m;
        };

        Message.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
            if (typeUrlPrefix === undefined) {
                typeUrlPrefix = "type.googleapis.com";
            }
            return typeUrlPrefix + "/proto.Message";
        };

        Message.AlbumMessage = (function() {

            function AlbumMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AlbumMessage.prototype.expectedImageCount = 0;
            AlbumMessage.prototype.expectedVideoCount = 0;
            AlbumMessage.prototype.contextInfo = null;

            AlbumMessage.create = function create(properties) {
                return new AlbumMessage(properties);
            };

            AlbumMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.expectedImageCount != null && Object.hasOwnProperty.call(m, "expectedImageCount"))
                    w.uint32(16).uint32(m.expectedImageCount);
                if (m.expectedVideoCount != null && Object.hasOwnProperty.call(m, "expectedVideoCount"))
                    w.uint32(24).uint32(m.expectedVideoCount);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            AlbumMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AlbumMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 2: {
                            m.expectedImageCount = r.uint32();
                            break;
                        }
                    case 3: {
                            m.expectedVideoCount = r.uint32();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AlbumMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AlbumMessage";
            };

            return AlbumMessage;
        })();

        Message.AppStateFatalExceptionNotification = (function() {

            function AppStateFatalExceptionNotification(p) {
                this.collectionNames = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateFatalExceptionNotification.prototype.collectionNames = $util.emptyArray;
            AppStateFatalExceptionNotification.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            AppStateFatalExceptionNotification.create = function create(properties) {
                return new AppStateFatalExceptionNotification(properties);
            };

            AppStateFatalExceptionNotification.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.collectionNames != null && m.collectionNames.length) {
                    for (var i = 0; i < m.collectionNames.length; ++i)
                        w.uint32(10).string(m.collectionNames[i]);
                }
                if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                    w.uint32(16).int64(m.timestamp);
                return w;
            };

            AppStateFatalExceptionNotification.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateFatalExceptionNotification();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.collectionNames && m.collectionNames.length))
                                m.collectionNames = [];
                            m.collectionNames.push(r.string());
                            break;
                        }
                    case 2: {
                            m.timestamp = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateFatalExceptionNotification.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateFatalExceptionNotification";
            };

            return AppStateFatalExceptionNotification;
        })();

        Message.AppStateSyncKey = (function() {

            function AppStateSyncKey(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateSyncKey.prototype.keyId = null;
            AppStateSyncKey.prototype.keyData = null;

            AppStateSyncKey.create = function create(properties) {
                return new AppStateSyncKey(properties);
            };

            AppStateSyncKey.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.keyId != null && Object.hasOwnProperty.call(m, "keyId"))
                    $root.proto.Message.AppStateSyncKeyId.encode(m.keyId, w.uint32(10).fork()).ldelim();
                if (m.keyData != null && Object.hasOwnProperty.call(m, "keyData"))
                    $root.proto.Message.AppStateSyncKeyData.encode(m.keyData, w.uint32(18).fork()).ldelim();
                return w;
            };

            AppStateSyncKey.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateSyncKey();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.keyId = $root.proto.Message.AppStateSyncKeyId.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.keyData = $root.proto.Message.AppStateSyncKeyData.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateSyncKey.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateSyncKey";
            };

            return AppStateSyncKey;
        })();

        Message.AppStateSyncKeyData = (function() {

            function AppStateSyncKeyData(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateSyncKeyData.prototype.keyData = $util.newBuffer([]);
            AppStateSyncKeyData.prototype.fingerprint = null;
            AppStateSyncKeyData.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            AppStateSyncKeyData.create = function create(properties) {
                return new AppStateSyncKeyData(properties);
            };

            AppStateSyncKeyData.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.keyData != null && Object.hasOwnProperty.call(m, "keyData"))
                    w.uint32(10).bytes(m.keyData);
                if (m.fingerprint != null && Object.hasOwnProperty.call(m, "fingerprint"))
                    $root.proto.Message.AppStateSyncKeyFingerprint.encode(m.fingerprint, w.uint32(18).fork()).ldelim();
                if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                    w.uint32(24).int64(m.timestamp);
                return w;
            };

            AppStateSyncKeyData.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateSyncKeyData();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.keyData = r.bytes();
                            break;
                        }
                    case 2: {
                            m.fingerprint = $root.proto.Message.AppStateSyncKeyFingerprint.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.timestamp = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateSyncKeyData.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateSyncKeyData";
            };

            return AppStateSyncKeyData;
        })();

        Message.AppStateSyncKeyFingerprint = (function() {

            function AppStateSyncKeyFingerprint(p) {
                this.deviceIndexes = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateSyncKeyFingerprint.prototype.rawId = 0;
            AppStateSyncKeyFingerprint.prototype.currentIndex = 0;
            AppStateSyncKeyFingerprint.prototype.deviceIndexes = $util.emptyArray;

            AppStateSyncKeyFingerprint.create = function create(properties) {
                return new AppStateSyncKeyFingerprint(properties);
            };

            AppStateSyncKeyFingerprint.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.rawId != null && Object.hasOwnProperty.call(m, "rawId"))
                    w.uint32(8).uint32(m.rawId);
                if (m.currentIndex != null && Object.hasOwnProperty.call(m, "currentIndex"))
                    w.uint32(16).uint32(m.currentIndex);
                if (m.deviceIndexes != null && m.deviceIndexes.length) {
                    w.uint32(26).fork();
                    for (var i = 0; i < m.deviceIndexes.length; ++i)
                        w.uint32(m.deviceIndexes[i]);
                    w.ldelim();
                }
                return w;
            };

            AppStateSyncKeyFingerprint.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateSyncKeyFingerprint();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.rawId = r.uint32();
                            break;
                        }
                    case 2: {
                            m.currentIndex = r.uint32();
                            break;
                        }
                    case 3: {
                            if (!(m.deviceIndexes && m.deviceIndexes.length))
                                m.deviceIndexes = [];
                            if ((t & 7) === 2) {
                                var c2 = r.uint32() + r.pos;
                                while (r.pos < c2)
                                    m.deviceIndexes.push(r.uint32());
                            } else
                                m.deviceIndexes.push(r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateSyncKeyFingerprint.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateSyncKeyFingerprint";
            };

            return AppStateSyncKeyFingerprint;
        })();

        Message.AppStateSyncKeyId = (function() {

            function AppStateSyncKeyId(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateSyncKeyId.prototype.keyId = $util.newBuffer([]);

            AppStateSyncKeyId.create = function create(properties) {
                return new AppStateSyncKeyId(properties);
            };

            AppStateSyncKeyId.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.keyId != null && Object.hasOwnProperty.call(m, "keyId"))
                    w.uint32(10).bytes(m.keyId);
                return w;
            };

            AppStateSyncKeyId.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateSyncKeyId();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.keyId = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateSyncKeyId.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateSyncKeyId";
            };

            return AppStateSyncKeyId;
        })();

        Message.AppStateSyncKeyRequest = (function() {

            function AppStateSyncKeyRequest(p) {
                this.keyIds = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateSyncKeyRequest.prototype.keyIds = $util.emptyArray;

            AppStateSyncKeyRequest.create = function create(properties) {
                return new AppStateSyncKeyRequest(properties);
            };

            AppStateSyncKeyRequest.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.keyIds != null && m.keyIds.length) {
                    for (var i = 0; i < m.keyIds.length; ++i)
                        $root.proto.Message.AppStateSyncKeyId.encode(m.keyIds[i], w.uint32(10).fork()).ldelim();
                }
                return w;
            };

            AppStateSyncKeyRequest.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateSyncKeyRequest();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.keyIds && m.keyIds.length))
                                m.keyIds = [];
                            m.keyIds.push($root.proto.Message.AppStateSyncKeyId.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateSyncKeyRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateSyncKeyRequest";
            };

            return AppStateSyncKeyRequest;
        })();

        Message.AppStateSyncKeyShare = (function() {

            function AppStateSyncKeyShare(p) {
                this.keys = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AppStateSyncKeyShare.prototype.keys = $util.emptyArray;

            AppStateSyncKeyShare.create = function create(properties) {
                return new AppStateSyncKeyShare(properties);
            };

            AppStateSyncKeyShare.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.keys != null && m.keys.length) {
                    for (var i = 0; i < m.keys.length; ++i)
                        $root.proto.Message.AppStateSyncKey.encode(m.keys[i], w.uint32(10).fork()).ldelim();
                }
                return w;
            };

            AppStateSyncKeyShare.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AppStateSyncKeyShare();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.keys && m.keys.length))
                                m.keys = [];
                            m.keys.push($root.proto.Message.AppStateSyncKey.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AppStateSyncKeyShare.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AppStateSyncKeyShare";
            };

            return AppStateSyncKeyShare;
        })();

        Message.AudioMessage = (function() {

            function AudioMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            AudioMessage.prototype.url = "";
            AudioMessage.prototype.mimetype = "";
            AudioMessage.prototype.fileSha256 = $util.newBuffer([]);
            AudioMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            AudioMessage.prototype.seconds = 0;
            AudioMessage.prototype.ptt = false;
            AudioMessage.prototype.mediaKey = $util.newBuffer([]);
            AudioMessage.prototype.fileEncSha256 = $util.newBuffer([]);
            AudioMessage.prototype.directPath = "";
            AudioMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            AudioMessage.prototype.contextInfo = null;
            AudioMessage.prototype.streamingSidecar = $util.newBuffer([]);
            AudioMessage.prototype.waveform = $util.newBuffer([]);
            AudioMessage.prototype.backgroundArgb = 0;
            AudioMessage.prototype.viewOnce = false;
            AudioMessage.prototype.accessibilityLabel = "";

            AudioMessage.create = function create(properties) {
                return new AudioMessage(properties);
            };

            AudioMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(10).string(m.url);
                if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                    w.uint32(18).string(m.mimetype);
                if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                    w.uint32(26).bytes(m.fileSha256);
                if (m.fileLength != null && Object.hasOwnProperty.call(m, "fileLength"))
                    w.uint32(32).uint64(m.fileLength);
                if (m.seconds != null && Object.hasOwnProperty.call(m, "seconds"))
                    w.uint32(40).uint32(m.seconds);
                if (m.ptt != null && Object.hasOwnProperty.call(m, "ptt"))
                    w.uint32(48).bool(m.ptt);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(58).bytes(m.mediaKey);
                if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                    w.uint32(66).bytes(m.fileEncSha256);
                if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                    w.uint32(74).string(m.directPath);
                if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                    w.uint32(80).int64(m.mediaKeyTimestamp);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                if (m.streamingSidecar != null && Object.hasOwnProperty.call(m, "streamingSidecar"))
                    w.uint32(146).bytes(m.streamingSidecar);
                if (m.waveform != null && Object.hasOwnProperty.call(m, "waveform"))
                    w.uint32(154).bytes(m.waveform);
                if (m.backgroundArgb != null && Object.hasOwnProperty.call(m, "backgroundArgb"))
                    w.uint32(165).fixed32(m.backgroundArgb);
                if (m.viewOnce != null && Object.hasOwnProperty.call(m, "viewOnce"))
                    w.uint32(168).bool(m.viewOnce);
                if (m.accessibilityLabel != null && Object.hasOwnProperty.call(m, "accessibilityLabel"))
                    w.uint32(178).string(m.accessibilityLabel);
                return w;
            };

            AudioMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.AudioMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.url = r.string();
                            break;
                        }
                    case 2: {
                            m.mimetype = r.string();
                            break;
                        }
                    case 3: {
                            m.fileSha256 = r.bytes();
                            break;
                        }
                    case 4: {
                            m.fileLength = r.uint64();
                            break;
                        }
                    case 5: {
                            m.seconds = r.uint32();
                            break;
                        }
                    case 6: {
                            m.ptt = r.bool();
                            break;
                        }
                    case 7: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 8: {
                            m.fileEncSha256 = r.bytes();
                            break;
                        }
                    case 9: {
                            m.directPath = r.string();
                            break;
                        }
                    case 10: {
                            m.mediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 18: {
                            m.streamingSidecar = r.bytes();
                            break;
                        }
                    case 19: {
                            m.waveform = r.bytes();
                            break;
                        }
                    case 20: {
                            m.backgroundArgb = r.fixed32();
                            break;
                        }
                    case 21: {
                            m.viewOnce = r.bool();
                            break;
                        }
                    case 22: {
                            m.accessibilityLabel = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            AudioMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.AudioMessage";
            };

            return AudioMessage;
        })();

        Message.BCallMessage = (function() {

            function BCallMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BCallMessage.prototype.sessionId = "";
            BCallMessage.prototype.mediaType = 0;
            BCallMessage.prototype.masterKey = $util.newBuffer([]);
            BCallMessage.prototype.caption = "";

            BCallMessage.create = function create(properties) {
                return new BCallMessage(properties);
            };

            BCallMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.sessionId != null && Object.hasOwnProperty.call(m, "sessionId"))
                    w.uint32(10).string(m.sessionId);
                if (m.mediaType != null && Object.hasOwnProperty.call(m, "mediaType"))
                    w.uint32(16).int32(m.mediaType);
                if (m.masterKey != null && Object.hasOwnProperty.call(m, "masterKey"))
                    w.uint32(26).bytes(m.masterKey);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(34).string(m.caption);
                return w;
            };

            BCallMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.BCallMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.sessionId = r.string();
                            break;
                        }
                    case 2: {
                            m.mediaType = r.int32();
                            break;
                        }
                    case 3: {
                            m.masterKey = r.bytes();
                            break;
                        }
                    case 4: {
                            m.caption = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BCallMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.BCallMessage";
            };

            BCallMessage.MediaType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "AUDIO"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return BCallMessage;
        })();

        Message.BotFeedbackMessage = (function() {

            function BotFeedbackMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            BotFeedbackMessage.prototype.messageKey = null;
            BotFeedbackMessage.prototype.kind = 0;
            BotFeedbackMessage.prototype.text = "";
            BotFeedbackMessage.prototype.kindNegative = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            BotFeedbackMessage.prototype.kindPositive = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            BotFeedbackMessage.prototype.kindReport = 0;

            BotFeedbackMessage.create = function create(properties) {
                return new BotFeedbackMessage(properties);
            };

            BotFeedbackMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                    $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
                if (m.kind != null && Object.hasOwnProperty.call(m, "kind"))
                    w.uint32(16).int32(m.kind);
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(26).string(m.text);
                if (m.kindNegative != null && Object.hasOwnProperty.call(m, "kindNegative"))
                    w.uint32(32).uint64(m.kindNegative);
                if (m.kindPositive != null && Object.hasOwnProperty.call(m, "kindPositive"))
                    w.uint32(40).uint64(m.kindPositive);
                if (m.kindReport != null && Object.hasOwnProperty.call(m, "kindReport"))
                    w.uint32(48).int32(m.kindReport);
                return w;
            };

            BotFeedbackMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.BotFeedbackMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.kind = r.int32();
                            break;
                        }
                    case 3: {
                            m.text = r.string();
                            break;
                        }
                    case 4: {
                            m.kindNegative = r.uint64();
                            break;
                        }
                    case 5: {
                            m.kindPositive = r.uint64();
                            break;
                        }
                    case 6: {
                            m.kindReport = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            BotFeedbackMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.BotFeedbackMessage";
            };

            BotFeedbackMessage.BotFeedbackKind = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "BOT_FEEDBACK_POSITIVE"] = 0;
                values[valuesById[1] = "BOT_FEEDBACK_NEGATIVE_GENERIC"] = 1;
                values[valuesById[2] = "BOT_FEEDBACK_NEGATIVE_HELPFUL"] = 2;
                values[valuesById[3] = "BOT_FEEDBACK_NEGATIVE_INTERESTING"] = 3;
                values[valuesById[4] = "BOT_FEEDBACK_NEGATIVE_ACCURATE"] = 4;
                values[valuesById[5] = "BOT_FEEDBACK_NEGATIVE_SAFE"] = 5;
                values[valuesById[6] = "BOT_FEEDBACK_NEGATIVE_OTHER"] = 6;
                values[valuesById[7] = "BOT_FEEDBACK_NEGATIVE_REFUSED"] = 7;
                values[valuesById[8] = "BOT_FEEDBACK_NEGATIVE_NOT_VISUALLY_APPEALING"] = 8;
                values[valuesById[9] = "BOT_FEEDBACK_NEGATIVE_NOT_RELEVANT_TO_TEXT"] = 9;
                values[valuesById[10] = "BOT_FEEDBACK_NEGATIVE_PERSONALIZED"] = 10;
                values[valuesById[11] = "BOT_FEEDBACK_NEGATIVE_CLARITY"] = 11;
                values[valuesById[12] = "BOT_FEEDBACK_NEGATIVE_DOESNT_LOOK_LIKE_THE_PERSON"] = 12;
                return values;
            })();

            BotFeedbackMessage.BotFeedbackKindMultipleNegative = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_GENERIC"] = 1;
                values[valuesById[2] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_HELPFUL"] = 2;
                values[valuesById[4] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_INTERESTING"] = 4;
                values[valuesById[8] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_ACCURATE"] = 8;
                values[valuesById[16] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_SAFE"] = 16;
                values[valuesById[32] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_OTHER"] = 32;
                values[valuesById[64] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_REFUSED"] = 64;
                values[valuesById[128] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_NOT_VISUALLY_APPEALING"] = 128;
                values[valuesById[256] = "BOT_FEEDBACK_MULTIPLE_NEGATIVE_NOT_RELEVANT_TO_TEXT"] = 256;
                return values;
            })();

            BotFeedbackMessage.BotFeedbackKindMultiplePositive = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "BOT_FEEDBACK_MULTIPLE_POSITIVE_GENERIC"] = 1;
                return values;
            })();

            BotFeedbackMessage.ReportKind = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "GENERIC"] = 0;
                return values;
            })();

            return BotFeedbackMessage;
        })();

        Message.ButtonsMessage = (function() {

            function ButtonsMessage(p) {
                this.buttons = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ButtonsMessage.prototype.contentText = "";
            ButtonsMessage.prototype.footerText = "";
            ButtonsMessage.prototype.contextInfo = null;
            ButtonsMessage.prototype.buttons = $util.emptyArray;
            ButtonsMessage.prototype.headerType = 0;
            ButtonsMessage.prototype.text = null;
            ButtonsMessage.prototype.documentMessage = null;
            ButtonsMessage.prototype.imageMessage = null;
            ButtonsMessage.prototype.videoMessage = null;
            ButtonsMessage.prototype.locationMessage = null;

            let $oneOfFields;

            Object.defineProperty(ButtonsMessage.prototype, "header", {
                get: $util.oneOfGetter($oneOfFields = ["text", "documentMessage", "imageMessage", "videoMessage", "locationMessage"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ButtonsMessage.create = function create(properties) {
                return new ButtonsMessage(properties);
            };

            ButtonsMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.documentMessage != null && Object.hasOwnProperty.call(m, "documentMessage"))
                    $root.proto.Message.DocumentMessage.encode(m.documentMessage, w.uint32(18).fork()).ldelim();
                if (m.imageMessage != null && Object.hasOwnProperty.call(m, "imageMessage"))
                    $root.proto.Message.ImageMessage.encode(m.imageMessage, w.uint32(26).fork()).ldelim();
                if (m.videoMessage != null && Object.hasOwnProperty.call(m, "videoMessage"))
                    $root.proto.Message.VideoMessage.encode(m.videoMessage, w.uint32(34).fork()).ldelim();
                if (m.locationMessage != null && Object.hasOwnProperty.call(m, "locationMessage"))
                    $root.proto.Message.LocationMessage.encode(m.locationMessage, w.uint32(42).fork()).ldelim();
                if (m.contentText != null && Object.hasOwnProperty.call(m, "contentText"))
                    w.uint32(50).string(m.contentText);
                if (m.footerText != null && Object.hasOwnProperty.call(m, "footerText"))
                    w.uint32(58).string(m.footerText);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(66).fork()).ldelim();
                if (m.buttons != null && m.buttons.length) {
                    for (var i = 0; i < m.buttons.length; ++i)
                        $root.proto.Message.ButtonsMessage.Button.encode(m.buttons[i], w.uint32(74).fork()).ldelim();
                }
                if (m.headerType != null && Object.hasOwnProperty.call(m, "headerType"))
                    w.uint32(80).int32(m.headerType);
                return w;
            };

            ButtonsMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ButtonsMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 6: {
                            m.contentText = r.string();
                            break;
                        }
                    case 7: {
                            m.footerText = r.string();
                            break;
                        }
                    case 8: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 9: {
                            if (!(m.buttons && m.buttons.length))
                                m.buttons = [];
                            m.buttons.push($root.proto.Message.ButtonsMessage.Button.decode(r, r.uint32()));
                            break;
                        }
                    case 10: {
                            m.headerType = r.int32();
                            break;
                        }
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            m.documentMessage = $root.proto.Message.DocumentMessage.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.imageMessage = $root.proto.Message.ImageMessage.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.videoMessage = $root.proto.Message.VideoMessage.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.locationMessage = $root.proto.Message.LocationMessage.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ButtonsMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ButtonsMessage";
            };

            ButtonsMessage.Button = (function() {

                function Button(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Button.prototype.buttonId = "";
                Button.prototype.buttonText = null;
                Button.prototype.type = 0;
                Button.prototype.nativeFlowInfo = null;

                Button.create = function create(properties) {
                    return new Button(properties);
                };

                Button.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.buttonId != null && Object.hasOwnProperty.call(m, "buttonId"))
                        w.uint32(10).string(m.buttonId);
                    if (m.buttonText != null && Object.hasOwnProperty.call(m, "buttonText"))
                        $root.proto.Message.ButtonsMessage.Button.ButtonText.encode(m.buttonText, w.uint32(18).fork()).ldelim();
                    if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                        w.uint32(24).int32(m.type);
                    if (m.nativeFlowInfo != null && Object.hasOwnProperty.call(m, "nativeFlowInfo"))
                        $root.proto.Message.ButtonsMessage.Button.NativeFlowInfo.encode(m.nativeFlowInfo, w.uint32(34).fork()).ldelim();
                    return w;
                };

                Button.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ButtonsMessage.Button();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.buttonId = r.string();
                                break;
                            }
                        case 2: {
                                m.buttonText = $root.proto.Message.ButtonsMessage.Button.ButtonText.decode(r, r.uint32());
                                break;
                            }
                        case 3: {
                                m.type = r.int32();
                                break;
                            }
                        case 4: {
                                m.nativeFlowInfo = $root.proto.Message.ButtonsMessage.Button.NativeFlowInfo.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Button.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ButtonsMessage.Button";
                };

                Button.ButtonText = (function() {

                    function ButtonText(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    ButtonText.prototype.displayText = "";

                    ButtonText.create = function create(properties) {
                        return new ButtonText(properties);
                    };

                    ButtonText.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.displayText != null && Object.hasOwnProperty.call(m, "displayText"))
                            w.uint32(10).string(m.displayText);
                        return w;
                    };

                    ButtonText.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ButtonsMessage.Button.ButtonText();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.displayText = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    ButtonText.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.ButtonsMessage.Button.ButtonText";
                    };

                    return ButtonText;
                })();

                Button.NativeFlowInfo = (function() {

                    function NativeFlowInfo(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    NativeFlowInfo.prototype.name = "";
                    NativeFlowInfo.prototype.paramsJson = "";

                    NativeFlowInfo.create = function create(properties) {
                        return new NativeFlowInfo(properties);
                    };

                    NativeFlowInfo.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                            w.uint32(10).string(m.name);
                        if (m.paramsJson != null && Object.hasOwnProperty.call(m, "paramsJson"))
                            w.uint32(18).string(m.paramsJson);
                        return w;
                    };

                    NativeFlowInfo.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ButtonsMessage.Button.NativeFlowInfo();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.name = r.string();
                                    break;
                                }
                            case 2: {
                                    m.paramsJson = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    NativeFlowInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.ButtonsMessage.Button.NativeFlowInfo";
                    };

                    return NativeFlowInfo;
                })();

                Button.Type = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "RESPONSE"] = 1;
                    values[valuesById[2] = "NATIVE_FLOW"] = 2;
                    return values;
                })();

                return Button;
            })();

            ButtonsMessage.HeaderType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "EMPTY"] = 1;
                values[valuesById[2] = "TEXT"] = 2;
                values[valuesById[3] = "DOCUMENT"] = 3;
                values[valuesById[4] = "IMAGE"] = 4;
                values[valuesById[5] = "VIDEO"] = 5;
                values[valuesById[6] = "LOCATION"] = 6;
                return values;
            })();

            return ButtonsMessage;
        })();

        Message.ButtonsResponseMessage = (function() {

            function ButtonsResponseMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ButtonsResponseMessage.prototype.selectedButtonId = "";
            ButtonsResponseMessage.prototype.contextInfo = null;
            ButtonsResponseMessage.prototype.type = 0;
            ButtonsResponseMessage.prototype.selectedDisplayText = null;

            let $oneOfFields;

            Object.defineProperty(ButtonsResponseMessage.prototype, "response", {
                get: $util.oneOfGetter($oneOfFields = ["selectedDisplayText"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            ButtonsResponseMessage.create = function create(properties) {
                return new ButtonsResponseMessage(properties);
            };

            ButtonsResponseMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.selectedButtonId != null && Object.hasOwnProperty.call(m, "selectedButtonId"))
                    w.uint32(10).string(m.selectedButtonId);
                if (m.selectedDisplayText != null && Object.hasOwnProperty.call(m, "selectedDisplayText"))
                    w.uint32(18).string(m.selectedDisplayText);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(26).fork()).ldelim();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(32).int32(m.type);
                return w;
            };

            ButtonsResponseMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ButtonsResponseMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.selectedButtonId = r.string();
                            break;
                        }
                    case 3: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.type = r.int32();
                            break;
                        }
                    case 2: {
                            m.selectedDisplayText = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ButtonsResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ButtonsResponseMessage";
            };

            ButtonsResponseMessage.Type = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "DISPLAY_TEXT"] = 1;
                return values;
            })();

            return ButtonsResponseMessage;
        })();

        Message.Call = (function() {

            function Call(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            Call.prototype.callKey = $util.newBuffer([]);
            Call.prototype.conversionSource = "";
            Call.prototype.conversionData = $util.newBuffer([]);
            Call.prototype.conversionDelaySeconds = 0;
            Call.prototype.ctwaSignals = "";
            Call.prototype.ctwaPayload = $util.newBuffer([]);
            Call.prototype.contextInfo = null;

            Call.create = function create(properties) {
                return new Call(properties);
            };

            Call.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.callKey != null && Object.hasOwnProperty.call(m, "callKey"))
                    w.uint32(10).bytes(m.callKey);
                if (m.conversionSource != null && Object.hasOwnProperty.call(m, "conversionSource"))
                    w.uint32(18).string(m.conversionSource);
                if (m.conversionData != null && Object.hasOwnProperty.call(m, "conversionData"))
                    w.uint32(26).bytes(m.conversionData);
                if (m.conversionDelaySeconds != null && Object.hasOwnProperty.call(m, "conversionDelaySeconds"))
                    w.uint32(32).uint32(m.conversionDelaySeconds);
                if (m.ctwaSignals != null && Object.hasOwnProperty.call(m, "ctwaSignals"))
                    w.uint32(42).string(m.ctwaSignals);
                if (m.ctwaPayload != null && Object.hasOwnProperty.call(m, "ctwaPayload"))
                    w.uint32(50).bytes(m.ctwaPayload);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(58).fork()).ldelim();
                return w;
            };

            Call.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.Call();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.callKey = r.bytes();
                            break;
                        }
                    case 2: {
                            m.conversionSource = r.string();
                            break;
                        }
                    case 3: {
                            m.conversionData = r.bytes();
                            break;
                        }
                    case 4: {
                            m.conversionDelaySeconds = r.uint32();
                            break;
                        }
                    case 5: {
                            m.ctwaSignals = r.string();
                            break;
                        }
                    case 6: {
                            m.ctwaPayload = r.bytes();
                            break;
                        }
                    case 7: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            Call.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.Call";
            };

            return Call;
        })();

        Message.CallLogMessage = (function() {

            function CallLogMessage(p) {
                this.participants = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            CallLogMessage.prototype.isVideo = false;
            CallLogMessage.prototype.callOutcome = 0;
            CallLogMessage.prototype.durationSecs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            CallLogMessage.prototype.callType = 0;
            CallLogMessage.prototype.participants = $util.emptyArray;

            CallLogMessage.create = function create(properties) {
                return new CallLogMessage(properties);
            };

            CallLogMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.isVideo != null && Object.hasOwnProperty.call(m, "isVideo"))
                    w.uint32(8).bool(m.isVideo);
                if (m.callOutcome != null && Object.hasOwnProperty.call(m, "callOutcome"))
                    w.uint32(16).int32(m.callOutcome);
                if (m.durationSecs != null && Object.hasOwnProperty.call(m, "durationSecs"))
                    w.uint32(24).int64(m.durationSecs);
                if (m.callType != null && Object.hasOwnProperty.call(m, "callType"))
                    w.uint32(32).int32(m.callType);
                if (m.participants != null && m.participants.length) {
                    for (var i = 0; i < m.participants.length; ++i)
                        $root.proto.Message.CallLogMessage.CallParticipant.encode(m.participants[i], w.uint32(42).fork()).ldelim();
                }
                return w;
            };

            CallLogMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.CallLogMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.isVideo = r.bool();
                            break;
                        }
                    case 2: {
                            m.callOutcome = r.int32();
                            break;
                        }
                    case 3: {
                            m.durationSecs = r.int64();
                            break;
                        }
                    case 4: {
                            m.callType = r.int32();
                            break;
                        }
                    case 5: {
                            if (!(m.participants && m.participants.length))
                                m.participants = [];
                            m.participants.push($root.proto.Message.CallLogMessage.CallParticipant.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            CallLogMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.CallLogMessage";
            };

            CallLogMessage.CallOutcome = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "CONNECTED"] = 0;
                values[valuesById[1] = "MISSED"] = 1;
                values[valuesById[2] = "FAILED"] = 2;
                values[valuesById[3] = "REJECTED"] = 3;
                values[valuesById[4] = "ACCEPTED_ELSEWHERE"] = 4;
                values[valuesById[5] = "ONGOING"] = 5;
                values[valuesById[6] = "SILENCED_BY_DND"] = 6;
                values[valuesById[7] = "SILENCED_UNKNOWN_CALLER"] = 7;
                return values;
            })();

            CallLogMessage.CallParticipant = (function() {

                function CallParticipant(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CallParticipant.prototype.jid = "";
                CallParticipant.prototype.callOutcome = 0;

                CallParticipant.create = function create(properties) {
                    return new CallParticipant(properties);
                };

                CallParticipant.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.jid != null && Object.hasOwnProperty.call(m, "jid"))
                        w.uint32(10).string(m.jid);
                    if (m.callOutcome != null && Object.hasOwnProperty.call(m, "callOutcome"))
                        w.uint32(16).int32(m.callOutcome);
                    return w;
                };

                CallParticipant.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.CallLogMessage.CallParticipant();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.jid = r.string();
                                break;
                            }
                        case 2: {
                                m.callOutcome = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CallParticipant.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.CallLogMessage.CallParticipant";
                };

                return CallParticipant;
            })();

            CallLogMessage.CallType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "REGULAR"] = 0;
                values[valuesById[1] = "SCHEDULED_CALL"] = 1;
                values[valuesById[2] = "VOICE_CHAT"] = 2;
                return values;
            })();

            return CallLogMessage;
        })();

        Message.CancelPaymentRequestMessage = (function() {

            function CancelPaymentRequestMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            CancelPaymentRequestMessage.prototype.key = null;

            CancelPaymentRequestMessage.create = function create(properties) {
                return new CancelPaymentRequestMessage(properties);
            };

            CancelPaymentRequestMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                    $root.proto.MessageKey.encode(m.key, w.uint32(10).fork()).ldelim();
                return w;
            };

            CancelPaymentRequestMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.CancelPaymentRequestMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.key = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            CancelPaymentRequestMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.CancelPaymentRequestMessage";
            };

            return CancelPaymentRequestMessage;
        })();

        Message.Chat = (function() {

            function Chat(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            Chat.prototype.displayName = "";
            Chat.prototype.id = "";

            Chat.create = function create(properties) {
                return new Chat(properties);
            };

            Chat.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.displayName != null && Object.hasOwnProperty.call(m, "displayName"))
                    w.uint32(10).string(m.displayName);
                if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                    w.uint32(18).string(m.id);
                return w;
            };

            Chat.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.Chat();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.displayName = r.string();
                            break;
                        }
                    case 2: {
                            m.id = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            Chat.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.Chat";
            };

            return Chat;
        })();

        Message.CloudAPIThreadControlNotification = (function() {

            function CloudAPIThreadControlNotification(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            CloudAPIThreadControlNotification.prototype.status = 0;
            CloudAPIThreadControlNotification.prototype.senderNotificationTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            CloudAPIThreadControlNotification.prototype.consumerLid = "";
            CloudAPIThreadControlNotification.prototype.consumerPhoneNumber = "";
            CloudAPIThreadControlNotification.prototype.notificationContent = null;

            CloudAPIThreadControlNotification.create = function create(properties) {
                return new CloudAPIThreadControlNotification(properties);
            };

            CloudAPIThreadControlNotification.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.status != null && Object.hasOwnProperty.call(m, "status"))
                    w.uint32(8).int32(m.status);
                if (m.senderNotificationTimestampMs != null && Object.hasOwnProperty.call(m, "senderNotificationTimestampMs"))
                    w.uint32(16).int64(m.senderNotificationTimestampMs);
                if (m.consumerLid != null && Object.hasOwnProperty.call(m, "consumerLid"))
                    w.uint32(26).string(m.consumerLid);
                if (m.consumerPhoneNumber != null && Object.hasOwnProperty.call(m, "consumerPhoneNumber"))
                    w.uint32(34).string(m.consumerPhoneNumber);
                if (m.notificationContent != null && Object.hasOwnProperty.call(m, "notificationContent"))
                    $root.proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent.encode(m.notificationContent, w.uint32(42).fork()).ldelim();
                return w;
            };

            CloudAPIThreadControlNotification.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.CloudAPIThreadControlNotification();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.status = r.int32();
                            break;
                        }
                    case 2: {
                            m.senderNotificationTimestampMs = r.int64();
                            break;
                        }
                    case 3: {
                            m.consumerLid = r.string();
                            break;
                        }
                    case 4: {
                            m.consumerPhoneNumber = r.string();
                            break;
                        }
                    case 5: {
                            m.notificationContent = $root.proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            CloudAPIThreadControlNotification.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.CloudAPIThreadControlNotification";
            };

            CloudAPIThreadControlNotification.CloudAPIThreadControl = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "CONTROL_PASSED"] = 1;
                values[valuesById[2] = "CONTROL_TAKEN"] = 2;
                return values;
            })();

            CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent = (function() {

                function CloudAPIThreadControlNotificationContent(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CloudAPIThreadControlNotificationContent.prototype.handoffNotificationText = "";
                CloudAPIThreadControlNotificationContent.prototype.extraJson = "";

                CloudAPIThreadControlNotificationContent.create = function create(properties) {
                    return new CloudAPIThreadControlNotificationContent(properties);
                };

                CloudAPIThreadControlNotificationContent.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.handoffNotificationText != null && Object.hasOwnProperty.call(m, "handoffNotificationText"))
                        w.uint32(10).string(m.handoffNotificationText);
                    if (m.extraJson != null && Object.hasOwnProperty.call(m, "extraJson"))
                        w.uint32(18).string(m.extraJson);
                    return w;
                };

                CloudAPIThreadControlNotificationContent.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.handoffNotificationText = r.string();
                                break;
                            }
                        case 2: {
                                m.extraJson = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CloudAPIThreadControlNotificationContent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent";
                };

                return CloudAPIThreadControlNotificationContent;
            })();

            return CloudAPIThreadControlNotification;
        })();

        Message.CommentMessage = (function() {

            function CommentMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            CommentMessage.prototype.message = null;
            CommentMessage.prototype.targetMessageKey = null;

            CommentMessage.create = function create(properties) {
                return new CommentMessage(properties);
            };

            CommentMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                    $root.proto.Message.encode(m.message, w.uint32(10).fork()).ldelim();
                if (m.targetMessageKey != null && Object.hasOwnProperty.call(m, "targetMessageKey"))
                    $root.proto.MessageKey.encode(m.targetMessageKey, w.uint32(18).fork()).ldelim();
                return w;
            };

            CommentMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.CommentMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.message = $root.proto.Message.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.targetMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            CommentMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.CommentMessage";
            };

            return CommentMessage;
        })();

        Message.ContactMessage = (function() {

            function ContactMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ContactMessage.prototype.displayName = "";
            ContactMessage.prototype.vcard = "";
            ContactMessage.prototype.contextInfo = null;

            ContactMessage.create = function create(properties) {
                return new ContactMessage(properties);
            };

            ContactMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.displayName != null && Object.hasOwnProperty.call(m, "displayName"))
                    w.uint32(10).string(m.displayName);
                if (m.vcard != null && Object.hasOwnProperty.call(m, "vcard"))
                    w.uint32(130).string(m.vcard);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            ContactMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ContactMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.displayName = r.string();
                            break;
                        }
                    case 16: {
                            m.vcard = r.string();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ContactMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ContactMessage";
            };

            return ContactMessage;
        })();

        Message.ContactsArrayMessage = (function() {

            function ContactsArrayMessage(p) {
                this.contacts = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ContactsArrayMessage.prototype.displayName = "";
            ContactsArrayMessage.prototype.contacts = $util.emptyArray;
            ContactsArrayMessage.prototype.contextInfo = null;

            ContactsArrayMessage.create = function create(properties) {
                return new ContactsArrayMessage(properties);
            };

            ContactsArrayMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.displayName != null && Object.hasOwnProperty.call(m, "displayName"))
                    w.uint32(10).string(m.displayName);
                if (m.contacts != null && m.contacts.length) {
                    for (var i = 0; i < m.contacts.length; ++i)
                        $root.proto.Message.ContactMessage.encode(m.contacts[i], w.uint32(18).fork()).ldelim();
                }
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            ContactsArrayMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ContactsArrayMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.displayName = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.contacts && m.contacts.length))
                                m.contacts = [];
                            m.contacts.push($root.proto.Message.ContactMessage.decode(r, r.uint32()));
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ContactsArrayMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ContactsArrayMessage";
            };

            return ContactsArrayMessage;
        })();

        Message.DeclinePaymentRequestMessage = (function() {

            function DeclinePaymentRequestMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DeclinePaymentRequestMessage.prototype.key = null;

            DeclinePaymentRequestMessage.create = function create(properties) {
                return new DeclinePaymentRequestMessage(properties);
            };

            DeclinePaymentRequestMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                    $root.proto.MessageKey.encode(m.key, w.uint32(10).fork()).ldelim();
                return w;
            };

            DeclinePaymentRequestMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.DeclinePaymentRequestMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.key = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DeclinePaymentRequestMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.DeclinePaymentRequestMessage";
            };

            return DeclinePaymentRequestMessage;
        })();

        Message.DeviceSentMessage = (function() {

            function DeviceSentMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DeviceSentMessage.prototype.destinationJid = "";
            DeviceSentMessage.prototype.message = null;
            DeviceSentMessage.prototype.phash = "";

            DeviceSentMessage.create = function create(properties) {
                return new DeviceSentMessage(properties);
            };

            DeviceSentMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.destinationJid != null && Object.hasOwnProperty.call(m, "destinationJid"))
                    w.uint32(10).string(m.destinationJid);
                if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                    $root.proto.Message.encode(m.message, w.uint32(18).fork()).ldelim();
                if (m.phash != null && Object.hasOwnProperty.call(m, "phash"))
                    w.uint32(26).string(m.phash);
                return w;
            };

            DeviceSentMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.DeviceSentMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.destinationJid = r.string();
                            break;
                        }
                    case 2: {
                            m.message = $root.proto.Message.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.phash = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DeviceSentMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.DeviceSentMessage";
            };

            return DeviceSentMessage;
        })();

        Message.DocumentMessage = (function() {

            function DocumentMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            DocumentMessage.prototype.url = "";
            DocumentMessage.prototype.mimetype = "";
            DocumentMessage.prototype.title = "";
            DocumentMessage.prototype.fileSha256 = $util.newBuffer([]);
            DocumentMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            DocumentMessage.prototype.pageCount = 0;
            DocumentMessage.prototype.mediaKey = $util.newBuffer([]);
            DocumentMessage.prototype.fileName = "";
            DocumentMessage.prototype.fileEncSha256 = $util.newBuffer([]);
            DocumentMessage.prototype.directPath = "";
            DocumentMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            DocumentMessage.prototype.contactVcard = false;
            DocumentMessage.prototype.thumbnailDirectPath = "";
            DocumentMessage.prototype.thumbnailSha256 = $util.newBuffer([]);
            DocumentMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);
            DocumentMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            DocumentMessage.prototype.contextInfo = null;
            DocumentMessage.prototype.thumbnailHeight = 0;
            DocumentMessage.prototype.thumbnailWidth = 0;
            DocumentMessage.prototype.caption = "";
            DocumentMessage.prototype.accessibilityLabel = "";

            DocumentMessage.create = function create(properties) {
                return new DocumentMessage(properties);
            };

            DocumentMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(10).string(m.url);
                if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                    w.uint32(18).string(m.mimetype);
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(26).string(m.title);
                if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                    w.uint32(34).bytes(m.fileSha256);
                if (m.fileLength != null && Object.hasOwnProperty.call(m, "fileLength"))
                    w.uint32(40).uint64(m.fileLength);
                if (m.pageCount != null && Object.hasOwnProperty.call(m, "pageCount"))
                    w.uint32(48).uint32(m.pageCount);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(58).bytes(m.mediaKey);
                if (m.fileName != null && Object.hasOwnProperty.call(m, "fileName"))
                    w.uint32(66).string(m.fileName);
                if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                    w.uint32(74).bytes(m.fileEncSha256);
                if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                    w.uint32(82).string(m.directPath);
                if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                    w.uint32(88).int64(m.mediaKeyTimestamp);
                if (m.contactVcard != null && Object.hasOwnProperty.call(m, "contactVcard"))
                    w.uint32(96).bool(m.contactVcard);
                if (m.thumbnailDirectPath != null && Object.hasOwnProperty.call(m, "thumbnailDirectPath"))
                    w.uint32(106).string(m.thumbnailDirectPath);
                if (m.thumbnailSha256 != null && Object.hasOwnProperty.call(m, "thumbnailSha256"))
                    w.uint32(114).bytes(m.thumbnailSha256);
                if (m.thumbnailEncSha256 != null && Object.hasOwnProperty.call(m, "thumbnailEncSha256"))
                    w.uint32(122).bytes(m.thumbnailEncSha256);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                if (m.thumbnailHeight != null && Object.hasOwnProperty.call(m, "thumbnailHeight"))
                    w.uint32(144).uint32(m.thumbnailHeight);
                if (m.thumbnailWidth != null && Object.hasOwnProperty.call(m, "thumbnailWidth"))
                    w.uint32(152).uint32(m.thumbnailWidth);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(162).string(m.caption);
                if (m.accessibilityLabel != null && Object.hasOwnProperty.call(m, "accessibilityLabel"))
                    w.uint32(170).string(m.accessibilityLabel);
                return w;
            };

            DocumentMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.DocumentMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.url = r.string();
                            break;
                        }
                    case 2: {
                            m.mimetype = r.string();
                            break;
                        }
                    case 3: {
                            m.title = r.string();
                            break;
                        }
                    case 4: {
                            m.fileSha256 = r.bytes();
                            break;
                        }
                    case 5: {
                            m.fileLength = r.uint64();
                            break;
                        }
                    case 6: {
                            m.pageCount = r.uint32();
                            break;
                        }
                    case 7: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 8: {
                            m.fileName = r.string();
                            break;
                        }
                    case 9: {
                            m.fileEncSha256 = r.bytes();
                            break;
                        }
                    case 10: {
                            m.directPath = r.string();
                            break;
                        }
                    case 11: {
                            m.mediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 12: {
                            m.contactVcard = r.bool();
                            break;
                        }
                    case 13: {
                            m.thumbnailDirectPath = r.string();
                            break;
                        }
                    case 14: {
                            m.thumbnailSha256 = r.bytes();
                            break;
                        }
                    case 15: {
                            m.thumbnailEncSha256 = r.bytes();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 18: {
                            m.thumbnailHeight = r.uint32();
                            break;
                        }
                    case 19: {
                            m.thumbnailWidth = r.uint32();
                            break;
                        }
                    case 20: {
                            m.caption = r.string();
                            break;
                        }
                    case 21: {
                            m.accessibilityLabel = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            DocumentMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.DocumentMessage";
            };

            return DocumentMessage;
        })();

        Message.EncCommentMessage = (function() {

            function EncCommentMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            EncCommentMessage.prototype.targetMessageKey = null;
            EncCommentMessage.prototype.encPayload = $util.newBuffer([]);
            EncCommentMessage.prototype.encIv = $util.newBuffer([]);

            EncCommentMessage.create = function create(properties) {
                return new EncCommentMessage(properties);
            };

            EncCommentMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.targetMessageKey != null && Object.hasOwnProperty.call(m, "targetMessageKey"))
                    $root.proto.MessageKey.encode(m.targetMessageKey, w.uint32(10).fork()).ldelim();
                if (m.encPayload != null && Object.hasOwnProperty.call(m, "encPayload"))
                    w.uint32(18).bytes(m.encPayload);
                if (m.encIv != null && Object.hasOwnProperty.call(m, "encIv"))
                    w.uint32(26).bytes(m.encIv);
                return w;
            };

            EncCommentMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.EncCommentMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.targetMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.encPayload = r.bytes();
                            break;
                        }
                    case 3: {
                            m.encIv = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            EncCommentMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.EncCommentMessage";
            };

            return EncCommentMessage;
        })();

        Message.EncEventResponseMessage = (function() {

            function EncEventResponseMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            EncEventResponseMessage.prototype.eventCreationMessageKey = null;
            EncEventResponseMessage.prototype.encPayload = $util.newBuffer([]);
            EncEventResponseMessage.prototype.encIv = $util.newBuffer([]);

            EncEventResponseMessage.create = function create(properties) {
                return new EncEventResponseMessage(properties);
            };

            EncEventResponseMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.eventCreationMessageKey != null && Object.hasOwnProperty.call(m, "eventCreationMessageKey"))
                    $root.proto.MessageKey.encode(m.eventCreationMessageKey, w.uint32(10).fork()).ldelim();
                if (m.encPayload != null && Object.hasOwnProperty.call(m, "encPayload"))
                    w.uint32(18).bytes(m.encPayload);
                if (m.encIv != null && Object.hasOwnProperty.call(m, "encIv"))
                    w.uint32(26).bytes(m.encIv);
                return w;
            };

            EncEventResponseMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.EncEventResponseMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.eventCreationMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.encPayload = r.bytes();
                            break;
                        }
                    case 3: {
                            m.encIv = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            EncEventResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.EncEventResponseMessage";
            };

            return EncEventResponseMessage;
        })();

        Message.EncReactionMessage = (function() {

            function EncReactionMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            EncReactionMessage.prototype.targetMessageKey = null;
            EncReactionMessage.prototype.encPayload = $util.newBuffer([]);
            EncReactionMessage.prototype.encIv = $util.newBuffer([]);

            EncReactionMessage.create = function create(properties) {
                return new EncReactionMessage(properties);
            };

            EncReactionMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.targetMessageKey != null && Object.hasOwnProperty.call(m, "targetMessageKey"))
                    $root.proto.MessageKey.encode(m.targetMessageKey, w.uint32(10).fork()).ldelim();
                if (m.encPayload != null && Object.hasOwnProperty.call(m, "encPayload"))
                    w.uint32(18).bytes(m.encPayload);
                if (m.encIv != null && Object.hasOwnProperty.call(m, "encIv"))
                    w.uint32(26).bytes(m.encIv);
                return w;
            };

            EncReactionMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.EncReactionMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.targetMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.encPayload = r.bytes();
                            break;
                        }
                    case 3: {
                            m.encIv = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            EncReactionMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.EncReactionMessage";
            };

            return EncReactionMessage;
        })();

        Message.EventMessage = (function() {

            function EventMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            EventMessage.prototype.contextInfo = null;
            EventMessage.prototype.isCanceled = false;
            EventMessage.prototype.name = "";
            EventMessage.prototype.description = "";
            EventMessage.prototype.location = null;
            EventMessage.prototype.joinLink = "";
            EventMessage.prototype.startTime = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            EventMessage.prototype.endTime = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            EventMessage.prototype.extraGuestsAllowed = false;
            EventMessage.prototype.isScheduleCall = false;

            EventMessage.create = function create(properties) {
                return new EventMessage(properties);
            };

            EventMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(10).fork()).ldelim();
                if (m.isCanceled != null && Object.hasOwnProperty.call(m, "isCanceled"))
                    w.uint32(16).bool(m.isCanceled);
                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                    w.uint32(26).string(m.name);
                if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                    w.uint32(34).string(m.description);
                if (m.location != null && Object.hasOwnProperty.call(m, "location"))
                    $root.proto.Message.LocationMessage.encode(m.location, w.uint32(42).fork()).ldelim();
                if (m.joinLink != null && Object.hasOwnProperty.call(m, "joinLink"))
                    w.uint32(50).string(m.joinLink);
                if (m.startTime != null && Object.hasOwnProperty.call(m, "startTime"))
                    w.uint32(56).int64(m.startTime);
                if (m.endTime != null && Object.hasOwnProperty.call(m, "endTime"))
                    w.uint32(64).int64(m.endTime);
                if (m.extraGuestsAllowed != null && Object.hasOwnProperty.call(m, "extraGuestsAllowed"))
                    w.uint32(72).bool(m.extraGuestsAllowed);
                if (m.isScheduleCall != null && Object.hasOwnProperty.call(m, "isScheduleCall"))
                    w.uint32(80).bool(m.isScheduleCall);
                return w;
            };

            EventMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.EventMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.isCanceled = r.bool();
                            break;
                        }
                    case 3: {
                            m.name = r.string();
                            break;
                        }
                    case 4: {
                            m.description = r.string();
                            break;
                        }
                    case 5: {
                            m.location = $root.proto.Message.LocationMessage.decode(r, r.uint32());
                            break;
                        }
                    case 6: {
                            m.joinLink = r.string();
                            break;
                        }
                    case 7: {
                            m.startTime = r.int64();
                            break;
                        }
                    case 8: {
                            m.endTime = r.int64();
                            break;
                        }
                    case 9: {
                            m.extraGuestsAllowed = r.bool();
                            break;
                        }
                    case 10: {
                            m.isScheduleCall = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            EventMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.EventMessage";
            };

            return EventMessage;
        })();

        Message.EventResponseMessage = (function() {

            function EventResponseMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            EventResponseMessage.prototype.response = 0;
            EventResponseMessage.prototype.timestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            EventResponseMessage.prototype.extraGuestCount = 0;

            EventResponseMessage.create = function create(properties) {
                return new EventResponseMessage(properties);
            };

            EventResponseMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.response != null && Object.hasOwnProperty.call(m, "response"))
                    w.uint32(8).int32(m.response);
                if (m.timestampMs != null && Object.hasOwnProperty.call(m, "timestampMs"))
                    w.uint32(16).int64(m.timestampMs);
                if (m.extraGuestCount != null && Object.hasOwnProperty.call(m, "extraGuestCount"))
                    w.uint32(24).int32(m.extraGuestCount);
                return w;
            };

            EventResponseMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.EventResponseMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.response = r.int32();
                            break;
                        }
                    case 2: {
                            m.timestampMs = r.int64();
                            break;
                        }
                    case 3: {
                            m.extraGuestCount = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            EventResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.EventResponseMessage";
            };

            EventResponseMessage.EventResponseType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "GOING"] = 1;
                values[valuesById[2] = "NOT_GOING"] = 2;
                values[valuesById[3] = "MAYBE"] = 3;
                return values;
            })();

            return EventResponseMessage;
        })();

        Message.ExtendedTextMessage = (function() {

            function ExtendedTextMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ExtendedTextMessage.prototype.text = "";
            ExtendedTextMessage.prototype.matchedText = "";
            ExtendedTextMessage.prototype.description = "";
            ExtendedTextMessage.prototype.title = "";
            ExtendedTextMessage.prototype.textArgb = 0;
            ExtendedTextMessage.prototype.backgroundArgb = 0;
            ExtendedTextMessage.prototype.font = 0;
            ExtendedTextMessage.prototype.previewType = 0;
            ExtendedTextMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            ExtendedTextMessage.prototype.contextInfo = null;
            ExtendedTextMessage.prototype.doNotPlayInline = false;
            ExtendedTextMessage.prototype.thumbnailDirectPath = "";
            ExtendedTextMessage.prototype.thumbnailSha256 = $util.newBuffer([]);
            ExtendedTextMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);
            ExtendedTextMessage.prototype.mediaKey = $util.newBuffer([]);
            ExtendedTextMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            ExtendedTextMessage.prototype.thumbnailHeight = 0;
            ExtendedTextMessage.prototype.thumbnailWidth = 0;
            ExtendedTextMessage.prototype.inviteLinkGroupType = 0;
            ExtendedTextMessage.prototype.inviteLinkParentGroupSubjectV2 = "";
            ExtendedTextMessage.prototype.inviteLinkParentGroupThumbnailV2 = $util.newBuffer([]);
            ExtendedTextMessage.prototype.inviteLinkGroupTypeV2 = 0;
            ExtendedTextMessage.prototype.viewOnce = false;
            ExtendedTextMessage.prototype.videoHeight = 0;
            ExtendedTextMessage.prototype.videoWidth = 0;
            ExtendedTextMessage.prototype.faviconMMSMetadata = null;
            ExtendedTextMessage.prototype.linkPreviewMetadata = null;
            ExtendedTextMessage.prototype.paymentLinkMetadata = null;

            ExtendedTextMessage.create = function create(properties) {
                return new ExtendedTextMessage(properties);
            };

            ExtendedTextMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                    w.uint32(10).string(m.text);
                if (m.matchedText != null && Object.hasOwnProperty.call(m, "matchedText"))
                    w.uint32(18).string(m.matchedText);
                if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                    w.uint32(42).string(m.description);
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(50).string(m.title);
                if (m.textArgb != null && Object.hasOwnProperty.call(m, "textArgb"))
                    w.uint32(61).fixed32(m.textArgb);
                if (m.backgroundArgb != null && Object.hasOwnProperty.call(m, "backgroundArgb"))
                    w.uint32(69).fixed32(m.backgroundArgb);
                if (m.font != null && Object.hasOwnProperty.call(m, "font"))
                    w.uint32(72).int32(m.font);
                if (m.previewType != null && Object.hasOwnProperty.call(m, "previewType"))
                    w.uint32(80).int32(m.previewType);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                if (m.doNotPlayInline != null && Object.hasOwnProperty.call(m, "doNotPlayInline"))
                    w.uint32(144).bool(m.doNotPlayInline);
                if (m.thumbnailDirectPath != null && Object.hasOwnProperty.call(m, "thumbnailDirectPath"))
                    w.uint32(154).string(m.thumbnailDirectPath);
                if (m.thumbnailSha256 != null && Object.hasOwnProperty.call(m, "thumbnailSha256"))
                    w.uint32(162).bytes(m.thumbnailSha256);
                if (m.thumbnailEncSha256 != null && Object.hasOwnProperty.call(m, "thumbnailEncSha256"))
                    w.uint32(170).bytes(m.thumbnailEncSha256);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(178).bytes(m.mediaKey);
                if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                    w.uint32(184).int64(m.mediaKeyTimestamp);
                if (m.thumbnailHeight != null && Object.hasOwnProperty.call(m, "thumbnailHeight"))
                    w.uint32(192).uint32(m.thumbnailHeight);
                if (m.thumbnailWidth != null && Object.hasOwnProperty.call(m, "thumbnailWidth"))
                    w.uint32(200).uint32(m.thumbnailWidth);
                if (m.inviteLinkGroupType != null && Object.hasOwnProperty.call(m, "inviteLinkGroupType"))
                    w.uint32(208).int32(m.inviteLinkGroupType);
                if (m.inviteLinkParentGroupSubjectV2 != null && Object.hasOwnProperty.call(m, "inviteLinkParentGroupSubjectV2"))
                    w.uint32(218).string(m.inviteLinkParentGroupSubjectV2);
                if (m.inviteLinkParentGroupThumbnailV2 != null && Object.hasOwnProperty.call(m, "inviteLinkParentGroupThumbnailV2"))
                    w.uint32(226).bytes(m.inviteLinkParentGroupThumbnailV2);
                if (m.inviteLinkGroupTypeV2 != null && Object.hasOwnProperty.call(m, "inviteLinkGroupTypeV2"))
                    w.uint32(232).int32(m.inviteLinkGroupTypeV2);
                if (m.viewOnce != null && Object.hasOwnProperty.call(m, "viewOnce"))
                    w.uint32(240).bool(m.viewOnce);
                if (m.videoHeight != null && Object.hasOwnProperty.call(m, "videoHeight"))
                    w.uint32(248).uint32(m.videoHeight);
                if (m.videoWidth != null && Object.hasOwnProperty.call(m, "videoWidth"))
                    w.uint32(256).uint32(m.videoWidth);
                if (m.faviconMMSMetadata != null && Object.hasOwnProperty.call(m, "faviconMMSMetadata"))
                    $root.proto.Message.MMSThumbnailMetadata.encode(m.faviconMMSMetadata, w.uint32(266).fork()).ldelim();
                if (m.linkPreviewMetadata != null && Object.hasOwnProperty.call(m, "linkPreviewMetadata"))
                    $root.proto.Message.LinkPreviewMetadata.encode(m.linkPreviewMetadata, w.uint32(274).fork()).ldelim();
                if (m.paymentLinkMetadata != null && Object.hasOwnProperty.call(m, "paymentLinkMetadata"))
                    $root.proto.Message.PaymentLinkMetadata.encode(m.paymentLinkMetadata, w.uint32(282).fork()).ldelim();
                return w;
            };

            ExtendedTextMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ExtendedTextMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.text = r.string();
                            break;
                        }
                    case 2: {
                            m.matchedText = r.string();
                            break;
                        }
                    case 5: {
                            m.description = r.string();
                            break;
                        }
                    case 6: {
                            m.title = r.string();
                            break;
                        }
                    case 7: {
                            m.textArgb = r.fixed32();
                            break;
                        }
                    case 8: {
                            m.backgroundArgb = r.fixed32();
                            break;
                        }
                    case 9: {
                            m.font = r.int32();
                            break;
                        }
                    case 10: {
                            m.previewType = r.int32();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 18: {
                            m.doNotPlayInline = r.bool();
                            break;
                        }
                    case 19: {
                            m.thumbnailDirectPath = r.string();
                            break;
                        }
                    case 20: {
                            m.thumbnailSha256 = r.bytes();
                            break;
                        }
                    case 21: {
                            m.thumbnailEncSha256 = r.bytes();
                            break;
                        }
                    case 22: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 23: {
                            m.mediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 24: {
                            m.thumbnailHeight = r.uint32();
                            break;
                        }
                    case 25: {
                            m.thumbnailWidth = r.uint32();
                            break;
                        }
                    case 26: {
                            m.inviteLinkGroupType = r.int32();
                            break;
                        }
                    case 27: {
                            m.inviteLinkParentGroupSubjectV2 = r.string();
                            break;
                        }
                    case 28: {
                            m.inviteLinkParentGroupThumbnailV2 = r.bytes();
                            break;
                        }
                    case 29: {
                            m.inviteLinkGroupTypeV2 = r.int32();
                            break;
                        }
                    case 30: {
                            m.viewOnce = r.bool();
                            break;
                        }
                    case 31: {
                            m.videoHeight = r.uint32();
                            break;
                        }
                    case 32: {
                            m.videoWidth = r.uint32();
                            break;
                        }
                    case 33: {
                            m.faviconMMSMetadata = $root.proto.Message.MMSThumbnailMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 34: {
                            m.linkPreviewMetadata = $root.proto.Message.LinkPreviewMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 35: {
                            m.paymentLinkMetadata = $root.proto.Message.PaymentLinkMetadata.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ExtendedTextMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ExtendedTextMessage";
            };

            ExtendedTextMessage.FontType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "SYSTEM"] = 0;
                values[valuesById[1] = "SYSTEM_TEXT"] = 1;
                values[valuesById[2] = "FB_SCRIPT"] = 2;
                values[valuesById[6] = "SYSTEM_BOLD"] = 6;
                values[valuesById[7] = "MORNINGBREEZE_REGULAR"] = 7;
                values[valuesById[8] = "CALISTOGA_REGULAR"] = 8;
                values[valuesById[9] = "EXO2_EXTRABOLD"] = 9;
                values[valuesById[10] = "COURIERPRIME_BOLD"] = 10;
                return values;
            })();

            ExtendedTextMessage.InviteLinkGroupType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "DEFAULT"] = 0;
                values[valuesById[1] = "PARENT"] = 1;
                values[valuesById[2] = "SUB"] = 2;
                values[valuesById[3] = "DEFAULT_SUB"] = 3;
                return values;
            })();

            ExtendedTextMessage.PreviewType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "VIDEO"] = 1;
                values[valuesById[4] = "PLACEHOLDER"] = 4;
                values[valuesById[5] = "IMAGE"] = 5;
                values[valuesById[6] = "PAYMENT_LINKS"] = 6;
                values[valuesById[7] = "PROFILE"] = 7;
                return values;
            })();

            return ExtendedTextMessage;
        })();

        Message.FullHistorySyncOnDemandRequestMetadata = (function() {

            function FullHistorySyncOnDemandRequestMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            FullHistorySyncOnDemandRequestMetadata.prototype.requestId = "";

            FullHistorySyncOnDemandRequestMetadata.create = function create(properties) {
                return new FullHistorySyncOnDemandRequestMetadata(properties);
            };

            FullHistorySyncOnDemandRequestMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.requestId != null && Object.hasOwnProperty.call(m, "requestId"))
                    w.uint32(10).string(m.requestId);
                return w;
            };

            FullHistorySyncOnDemandRequestMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.FullHistorySyncOnDemandRequestMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.requestId = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            FullHistorySyncOnDemandRequestMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.FullHistorySyncOnDemandRequestMetadata";
            };

            return FullHistorySyncOnDemandRequestMetadata;
        })();

        Message.FutureProofMessage = (function() {

            function FutureProofMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            FutureProofMessage.prototype.message = null;

            FutureProofMessage.create = function create(properties) {
                return new FutureProofMessage(properties);
            };

            FutureProofMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                    $root.proto.Message.encode(m.message, w.uint32(10).fork()).ldelim();
                return w;
            };

            FutureProofMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.FutureProofMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.message = $root.proto.Message.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            FutureProofMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.FutureProofMessage";
            };

            return FutureProofMessage;
        })();

        Message.GroupInviteMessage = (function() {

            function GroupInviteMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            GroupInviteMessage.prototype.groupJid = "";
            GroupInviteMessage.prototype.inviteCode = "";
            GroupInviteMessage.prototype.inviteExpiration = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            GroupInviteMessage.prototype.groupName = "";
            GroupInviteMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            GroupInviteMessage.prototype.caption = "";
            GroupInviteMessage.prototype.contextInfo = null;
            GroupInviteMessage.prototype.groupType = 0;

            GroupInviteMessage.create = function create(properties) {
                return new GroupInviteMessage(properties);
            };

            GroupInviteMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.groupJid != null && Object.hasOwnProperty.call(m, "groupJid"))
                    w.uint32(10).string(m.groupJid);
                if (m.inviteCode != null && Object.hasOwnProperty.call(m, "inviteCode"))
                    w.uint32(18).string(m.inviteCode);
                if (m.inviteExpiration != null && Object.hasOwnProperty.call(m, "inviteExpiration"))
                    w.uint32(24).int64(m.inviteExpiration);
                if (m.groupName != null && Object.hasOwnProperty.call(m, "groupName"))
                    w.uint32(34).string(m.groupName);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(42).bytes(m.jpegThumbnail);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(50).string(m.caption);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(58).fork()).ldelim();
                if (m.groupType != null && Object.hasOwnProperty.call(m, "groupType"))
                    w.uint32(64).int32(m.groupType);
                return w;
            };

            GroupInviteMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.GroupInviteMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.groupJid = r.string();
                            break;
                        }
                    case 2: {
                            m.inviteCode = r.string();
                            break;
                        }
                    case 3: {
                            m.inviteExpiration = r.int64();
                            break;
                        }
                    case 4: {
                            m.groupName = r.string();
                            break;
                        }
                    case 5: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 6: {
                            m.caption = r.string();
                            break;
                        }
                    case 7: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 8: {
                            m.groupType = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            GroupInviteMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.GroupInviteMessage";
            };

            GroupInviteMessage.GroupType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "DEFAULT"] = 0;
                values[valuesById[1] = "PARENT"] = 1;
                return values;
            })();

            return GroupInviteMessage;
        })();

        Message.HighlyStructuredMessage = (function() {

            function HighlyStructuredMessage(p) {
                this.params = [];
                this.localizableParams = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HighlyStructuredMessage.prototype.namespace = "";
            HighlyStructuredMessage.prototype.elementName = "";
            HighlyStructuredMessage.prototype.params = $util.emptyArray;
            HighlyStructuredMessage.prototype.fallbackLg = "";
            HighlyStructuredMessage.prototype.fallbackLc = "";
            HighlyStructuredMessage.prototype.localizableParams = $util.emptyArray;
            HighlyStructuredMessage.prototype.deterministicLg = "";
            HighlyStructuredMessage.prototype.deterministicLc = "";
            HighlyStructuredMessage.prototype.hydratedHsm = null;

            HighlyStructuredMessage.create = function create(properties) {
                return new HighlyStructuredMessage(properties);
            };

            HighlyStructuredMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.namespace != null && Object.hasOwnProperty.call(m, "namespace"))
                    w.uint32(10).string(m.namespace);
                if (m.elementName != null && Object.hasOwnProperty.call(m, "elementName"))
                    w.uint32(18).string(m.elementName);
                if (m.params != null && m.params.length) {
                    for (var i = 0; i < m.params.length; ++i)
                        w.uint32(26).string(m.params[i]);
                }
                if (m.fallbackLg != null && Object.hasOwnProperty.call(m, "fallbackLg"))
                    w.uint32(34).string(m.fallbackLg);
                if (m.fallbackLc != null && Object.hasOwnProperty.call(m, "fallbackLc"))
                    w.uint32(42).string(m.fallbackLc);
                if (m.localizableParams != null && m.localizableParams.length) {
                    for (var i = 0; i < m.localizableParams.length; ++i)
                        $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.encode(m.localizableParams[i], w.uint32(50).fork()).ldelim();
                }
                if (m.deterministicLg != null && Object.hasOwnProperty.call(m, "deterministicLg"))
                    w.uint32(58).string(m.deterministicLg);
                if (m.deterministicLc != null && Object.hasOwnProperty.call(m, "deterministicLc"))
                    w.uint32(66).string(m.deterministicLc);
                if (m.hydratedHsm != null && Object.hasOwnProperty.call(m, "hydratedHsm"))
                    $root.proto.Message.TemplateMessage.encode(m.hydratedHsm, w.uint32(74).fork()).ldelim();
                return w;
            };

            HighlyStructuredMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HighlyStructuredMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.namespace = r.string();
                            break;
                        }
                    case 2: {
                            m.elementName = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.params && m.params.length))
                                m.params = [];
                            m.params.push(r.string());
                            break;
                        }
                    case 4: {
                            m.fallbackLg = r.string();
                            break;
                        }
                    case 5: {
                            m.fallbackLc = r.string();
                            break;
                        }
                    case 6: {
                            if (!(m.localizableParams && m.localizableParams.length))
                                m.localizableParams = [];
                            m.localizableParams.push($root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.decode(r, r.uint32()));
                            break;
                        }
                    case 7: {
                            m.deterministicLg = r.string();
                            break;
                        }
                    case 8: {
                            m.deterministicLc = r.string();
                            break;
                        }
                    case 9: {
                            m.hydratedHsm = $root.proto.Message.TemplateMessage.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HighlyStructuredMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.HighlyStructuredMessage";
            };

            HighlyStructuredMessage.HSMLocalizableParameter = (function() {

                function HSMLocalizableParameter(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                HSMLocalizableParameter.prototype["default"] = "";
                HSMLocalizableParameter.prototype.currency = null;
                HSMLocalizableParameter.prototype.dateTime = null;

                let $oneOfFields;

                Object.defineProperty(HSMLocalizableParameter.prototype, "paramOneof", {
                    get: $util.oneOfGetter($oneOfFields = ["currency", "dateTime"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                HSMLocalizableParameter.create = function create(properties) {
                    return new HSMLocalizableParameter(properties);
                };

                HSMLocalizableParameter.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m["default"] != null && Object.hasOwnProperty.call(m, "default"))
                        w.uint32(10).string(m["default"]);
                    if (m.currency != null && Object.hasOwnProperty.call(m, "currency"))
                        $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency.encode(m.currency, w.uint32(18).fork()).ldelim();
                    if (m.dateTime != null && Object.hasOwnProperty.call(m, "dateTime"))
                        $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.encode(m.dateTime, w.uint32(26).fork()).ldelim();
                    return w;
                };

                HSMLocalizableParameter.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m["default"] = r.string();
                                break;
                            }
                        case 2: {
                                m.currency = $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency.decode(r, r.uint32());
                                break;
                            }
                        case 3: {
                                m.dateTime = $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                HSMLocalizableParameter.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.HighlyStructuredMessage.HSMLocalizableParameter";
                };

                HSMLocalizableParameter.HSMCurrency = (function() {

                    function HSMCurrency(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    HSMCurrency.prototype.currencyCode = "";
                    HSMCurrency.prototype.amount1000 = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

                    HSMCurrency.create = function create(properties) {
                        return new HSMCurrency(properties);
                    };

                    HSMCurrency.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.currencyCode != null && Object.hasOwnProperty.call(m, "currencyCode"))
                            w.uint32(10).string(m.currencyCode);
                        if (m.amount1000 != null && Object.hasOwnProperty.call(m, "amount1000"))
                            w.uint32(16).int64(m.amount1000);
                        return w;
                    };

                    HSMCurrency.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.currencyCode = r.string();
                                    break;
                                }
                            case 2: {
                                    m.amount1000 = r.int64();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    HSMCurrency.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMCurrency";
                    };

                    return HSMCurrency;
                })();

                HSMLocalizableParameter.HSMDateTime = (function() {

                    function HSMDateTime(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    HSMDateTime.prototype.component = null;
                    HSMDateTime.prototype.unixEpoch = null;

                    let $oneOfFields;

                    Object.defineProperty(HSMDateTime.prototype, "datetimeOneof", {
                        get: $util.oneOfGetter($oneOfFields = ["component", "unixEpoch"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });

                    HSMDateTime.create = function create(properties) {
                        return new HSMDateTime(properties);
                    };

                    HSMDateTime.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.component != null && Object.hasOwnProperty.call(m, "component"))
                            $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.encode(m.component, w.uint32(10).fork()).ldelim();
                        if (m.unixEpoch != null && Object.hasOwnProperty.call(m, "unixEpoch"))
                            $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch.encode(m.unixEpoch, w.uint32(18).fork()).ldelim();
                        return w;
                    };

                    HSMDateTime.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.component = $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent.decode(r, r.uint32());
                                    break;
                                }
                            case 2: {
                                    m.unixEpoch = $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch.decode(r, r.uint32());
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    HSMDateTime.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime";
                    };

                    HSMDateTime.HSMDateTimeComponent = (function() {

                        function HSMDateTimeComponent(p) {
                            if (p)
                                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                    if (p[ks[i]] != null)
                                        this[ks[i]] = p[ks[i]];
                        }

                        HSMDateTimeComponent.prototype.dayOfWeek = 1;
                        HSMDateTimeComponent.prototype.year = 0;
                        HSMDateTimeComponent.prototype.month = 0;
                        HSMDateTimeComponent.prototype.dayOfMonth = 0;
                        HSMDateTimeComponent.prototype.hour = 0;
                        HSMDateTimeComponent.prototype.minute = 0;
                        HSMDateTimeComponent.prototype.calendar = 1;

                        HSMDateTimeComponent.create = function create(properties) {
                            return new HSMDateTimeComponent(properties);
                        };

                        HSMDateTimeComponent.encode = function encode(m, w) {
                            if (!w)
                                w = $Writer.create();
                            if (m.dayOfWeek != null && Object.hasOwnProperty.call(m, "dayOfWeek"))
                                w.uint32(8).int32(m.dayOfWeek);
                            if (m.year != null && Object.hasOwnProperty.call(m, "year"))
                                w.uint32(16).uint32(m.year);
                            if (m.month != null && Object.hasOwnProperty.call(m, "month"))
                                w.uint32(24).uint32(m.month);
                            if (m.dayOfMonth != null && Object.hasOwnProperty.call(m, "dayOfMonth"))
                                w.uint32(32).uint32(m.dayOfMonth);
                            if (m.hour != null && Object.hasOwnProperty.call(m, "hour"))
                                w.uint32(40).uint32(m.hour);
                            if (m.minute != null && Object.hasOwnProperty.call(m, "minute"))
                                w.uint32(48).uint32(m.minute);
                            if (m.calendar != null && Object.hasOwnProperty.call(m, "calendar"))
                                w.uint32(56).int32(m.calendar);
                            return w;
                        };

                        HSMDateTimeComponent.decode = function decode(r, l, e) {
                            if (!(r instanceof $Reader))
                                r = $Reader.create(r);
                            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent();
                            while (r.pos < c) {
                                var t = r.uint32();
                                if (t === e)
                                    break;
                                switch (t >>> 3) {
                                case 1: {
                                        m.dayOfWeek = r.int32();
                                        break;
                                    }
                                case 2: {
                                        m.year = r.uint32();
                                        break;
                                    }
                                case 3: {
                                        m.month = r.uint32();
                                        break;
                                    }
                                case 4: {
                                        m.dayOfMonth = r.uint32();
                                        break;
                                    }
                                case 5: {
                                        m.hour = r.uint32();
                                        break;
                                    }
                                case 6: {
                                        m.minute = r.uint32();
                                        break;
                                    }
                                case 7: {
                                        m.calendar = r.int32();
                                        break;
                                    }
                                default:
                                    r.skipType(t & 7);
                                    break;
                                }
                            }
                            return m;
                        };

                        HSMDateTimeComponent.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeComponent";
                        };

                        HSMDateTimeComponent.CalendarType = (function() {
                            const valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[1] = "GREGORIAN"] = 1;
                            values[valuesById[2] = "SOLAR_HIJRI"] = 2;
                            return values;
                        })();

                        HSMDateTimeComponent.DayOfWeekType = (function() {
                            const valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[1] = "MONDAY"] = 1;
                            values[valuesById[2] = "TUESDAY"] = 2;
                            values[valuesById[3] = "WEDNESDAY"] = 3;
                            values[valuesById[4] = "THURSDAY"] = 4;
                            values[valuesById[5] = "FRIDAY"] = 5;
                            values[valuesById[6] = "SATURDAY"] = 6;
                            values[valuesById[7] = "SUNDAY"] = 7;
                            return values;
                        })();

                        return HSMDateTimeComponent;
                    })();

                    HSMDateTime.HSMDateTimeUnixEpoch = (function() {

                        function HSMDateTimeUnixEpoch(p) {
                            if (p)
                                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                    if (p[ks[i]] != null)
                                        this[ks[i]] = p[ks[i]];
                        }

                        HSMDateTimeUnixEpoch.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

                        HSMDateTimeUnixEpoch.create = function create(properties) {
                            return new HSMDateTimeUnixEpoch(properties);
                        };

                        HSMDateTimeUnixEpoch.encode = function encode(m, w) {
                            if (!w)
                                w = $Writer.create();
                            if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                                w.uint32(8).int64(m.timestamp);
                            return w;
                        };

                        HSMDateTimeUnixEpoch.decode = function decode(r, l, e) {
                            if (!(r instanceof $Reader))
                                r = $Reader.create(r);
                            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch();
                            while (r.pos < c) {
                                var t = r.uint32();
                                if (t === e)
                                    break;
                                switch (t >>> 3) {
                                case 1: {
                                        m.timestamp = r.int64();
                                        break;
                                    }
                                default:
                                    r.skipType(t & 7);
                                    break;
                                }
                            }
                            return m;
                        };

                        HSMDateTimeUnixEpoch.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/proto.Message.HighlyStructuredMessage.HSMLocalizableParameter.HSMDateTime.HSMDateTimeUnixEpoch";
                        };

                        return HSMDateTimeUnixEpoch;
                    })();

                    return HSMDateTime;
                })();

                return HSMLocalizableParameter;
            })();

            return HighlyStructuredMessage;
        })();

        Message.HistorySyncNotification = (function() {

            function HistorySyncNotification(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            HistorySyncNotification.prototype.fileSha256 = $util.newBuffer([]);
            HistorySyncNotification.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            HistorySyncNotification.prototype.mediaKey = $util.newBuffer([]);
            HistorySyncNotification.prototype.fileEncSha256 = $util.newBuffer([]);
            HistorySyncNotification.prototype.directPath = "";
            HistorySyncNotification.prototype.syncType = 0;
            HistorySyncNotification.prototype.chunkOrder = 0;
            HistorySyncNotification.prototype.originalMessageId = "";
            HistorySyncNotification.prototype.progress = 0;
            HistorySyncNotification.prototype.oldestMsgInChunkTimestampSec = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            HistorySyncNotification.prototype.initialHistBootstrapInlinePayload = $util.newBuffer([]);
            HistorySyncNotification.prototype.peerDataRequestSessionId = "";
            HistorySyncNotification.prototype.fullHistorySyncOnDemandRequestMetadata = null;
            HistorySyncNotification.prototype.encHandle = "";

            HistorySyncNotification.create = function create(properties) {
                return new HistorySyncNotification(properties);
            };

            HistorySyncNotification.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                    w.uint32(10).bytes(m.fileSha256);
                if (m.fileLength != null && Object.hasOwnProperty.call(m, "fileLength"))
                    w.uint32(16).uint64(m.fileLength);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(26).bytes(m.mediaKey);
                if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                    w.uint32(34).bytes(m.fileEncSha256);
                if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                    w.uint32(42).string(m.directPath);
                if (m.syncType != null && Object.hasOwnProperty.call(m, "syncType"))
                    w.uint32(48).int32(m.syncType);
                if (m.chunkOrder != null && Object.hasOwnProperty.call(m, "chunkOrder"))
                    w.uint32(56).uint32(m.chunkOrder);
                if (m.originalMessageId != null && Object.hasOwnProperty.call(m, "originalMessageId"))
                    w.uint32(66).string(m.originalMessageId);
                if (m.progress != null && Object.hasOwnProperty.call(m, "progress"))
                    w.uint32(72).uint32(m.progress);
                if (m.oldestMsgInChunkTimestampSec != null && Object.hasOwnProperty.call(m, "oldestMsgInChunkTimestampSec"))
                    w.uint32(80).int64(m.oldestMsgInChunkTimestampSec);
                if (m.initialHistBootstrapInlinePayload != null && Object.hasOwnProperty.call(m, "initialHistBootstrapInlinePayload"))
                    w.uint32(90).bytes(m.initialHistBootstrapInlinePayload);
                if (m.peerDataRequestSessionId != null && Object.hasOwnProperty.call(m, "peerDataRequestSessionId"))
                    w.uint32(98).string(m.peerDataRequestSessionId);
                if (m.fullHistorySyncOnDemandRequestMetadata != null && Object.hasOwnProperty.call(m, "fullHistorySyncOnDemandRequestMetadata"))
                    $root.proto.Message.FullHistorySyncOnDemandRequestMetadata.encode(m.fullHistorySyncOnDemandRequestMetadata, w.uint32(106).fork()).ldelim();
                if (m.encHandle != null && Object.hasOwnProperty.call(m, "encHandle"))
                    w.uint32(114).string(m.encHandle);
                return w;
            };

            HistorySyncNotification.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.HistorySyncNotification();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.fileSha256 = r.bytes();
                            break;
                        }
                    case 2: {
                            m.fileLength = r.uint64();
                            break;
                        }
                    case 3: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 4: {
                            m.fileEncSha256 = r.bytes();
                            break;
                        }
                    case 5: {
                            m.directPath = r.string();
                            break;
                        }
                    case 6: {
                            m.syncType = r.int32();
                            break;
                        }
                    case 7: {
                            m.chunkOrder = r.uint32();
                            break;
                        }
                    case 8: {
                            m.originalMessageId = r.string();
                            break;
                        }
                    case 9: {
                            m.progress = r.uint32();
                            break;
                        }
                    case 10: {
                            m.oldestMsgInChunkTimestampSec = r.int64();
                            break;
                        }
                    case 11: {
                            m.initialHistBootstrapInlinePayload = r.bytes();
                            break;
                        }
                    case 12: {
                            m.peerDataRequestSessionId = r.string();
                            break;
                        }
                    case 13: {
                            m.fullHistorySyncOnDemandRequestMetadata = $root.proto.Message.FullHistorySyncOnDemandRequestMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 14: {
                            m.encHandle = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            HistorySyncNotification.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.HistorySyncNotification";
            };

            HistorySyncNotification.HistorySyncType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "INITIAL_BOOTSTRAP"] = 0;
                values[valuesById[1] = "INITIAL_STATUS_V3"] = 1;
                values[valuesById[2] = "FULL"] = 2;
                values[valuesById[3] = "RECENT"] = 3;
                values[valuesById[4] = "PUSH_NAME"] = 4;
                values[valuesById[5] = "NON_BLOCKING_DATA"] = 5;
                values[valuesById[6] = "ON_DEMAND"] = 6;
                values[valuesById[7] = "NO_HISTORY"] = 7;
                return values;
            })();

            return HistorySyncNotification;
        })();

        Message.ImageMessage = (function() {

            function ImageMessage(p) {
                this.interactiveAnnotations = [];
                this.scanLengths = [];
                this.annotations = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ImageMessage.prototype.url = "";
            ImageMessage.prototype.mimetype = "";
            ImageMessage.prototype.caption = "";
            ImageMessage.prototype.fileSha256 = $util.newBuffer([]);
            ImageMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
            ImageMessage.prototype.height = 0;
            ImageMessage.prototype.width = 0;
            ImageMessage.prototype.mediaKey = $util.newBuffer([]);
            ImageMessage.prototype.fileEncSha256 = $util.newBuffer([]);
            ImageMessage.prototype.interactiveAnnotations = $util.emptyArray;
            ImageMessage.prototype.directPath = "";
            ImageMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            ImageMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            ImageMessage.prototype.contextInfo = null;
            ImageMessage.prototype.firstScanSidecar = $util.newBuffer([]);
            ImageMessage.prototype.firstScanLength = 0;
            ImageMessage.prototype.experimentGroupId = 0;
            ImageMessage.prototype.scansSidecar = $util.newBuffer([]);
            ImageMessage.prototype.scanLengths = $util.emptyArray;
            ImageMessage.prototype.midQualityFileSha256 = $util.newBuffer([]);
            ImageMessage.prototype.midQualityFileEncSha256 = $util.newBuffer([]);
            ImageMessage.prototype.viewOnce = false;
            ImageMessage.prototype.thumbnailDirectPath = "";
            ImageMessage.prototype.thumbnailSha256 = $util.newBuffer([]);
            ImageMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);
            ImageMessage.prototype.staticUrl = "";
            ImageMessage.prototype.annotations = $util.emptyArray;
            ImageMessage.prototype.imageSourceType = 0;
            ImageMessage.prototype.accessibilityLabel = "";

            ImageMessage.create = function create(properties) {
                return new ImageMessage(properties);
            };

            ImageMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(10).string(m.url);
                if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                    w.uint32(18).string(m.mimetype);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(26).string(m.caption);
                if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                    w.uint32(34).bytes(m.fileSha256);
                if (m.fileLength != null && Object.hasOwnProperty.call(m, "fileLength"))
                    w.uint32(40).uint64(m.fileLength);
                if (m.height != null && Object.hasOwnProperty.call(m, "height"))
                    w.uint32(48).uint32(m.height);
                if (m.width != null && Object.hasOwnProperty.call(m, "width"))
                    w.uint32(56).uint32(m.width);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(66).bytes(m.mediaKey);
                if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                    w.uint32(74).bytes(m.fileEncSha256);
                if (m.interactiveAnnotations != null && m.interactiveAnnotations.length) {
                    for (var i = 0; i < m.interactiveAnnotations.length; ++i)
                        $root.proto.InteractiveAnnotation.encode(m.interactiveAnnotations[i], w.uint32(82).fork()).ldelim();
                }
                if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                    w.uint32(90).string(m.directPath);
                if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                    w.uint32(96).int64(m.mediaKeyTimestamp);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                if (m.firstScanSidecar != null && Object.hasOwnProperty.call(m, "firstScanSidecar"))
                    w.uint32(146).bytes(m.firstScanSidecar);
                if (m.firstScanLength != null && Object.hasOwnProperty.call(m, "firstScanLength"))
                    w.uint32(152).uint32(m.firstScanLength);
                if (m.experimentGroupId != null && Object.hasOwnProperty.call(m, "experimentGroupId"))
                    w.uint32(160).uint32(m.experimentGroupId);
                if (m.scansSidecar != null && Object.hasOwnProperty.call(m, "scansSidecar"))
                    w.uint32(170).bytes(m.scansSidecar);
                if (m.scanLengths != null && m.scanLengths.length) {
                    for (var i = 0; i < m.scanLengths.length; ++i)
                        w.uint32(176).uint32(m.scanLengths[i]);
                }
                if (m.midQualityFileSha256 != null && Object.hasOwnProperty.call(m, "midQualityFileSha256"))
                    w.uint32(186).bytes(m.midQualityFileSha256);
                if (m.midQualityFileEncSha256 != null && Object.hasOwnProperty.call(m, "midQualityFileEncSha256"))
                    w.uint32(194).bytes(m.midQualityFileEncSha256);
                if (m.viewOnce != null && Object.hasOwnProperty.call(m, "viewOnce"))
                    w.uint32(200).bool(m.viewOnce);
                if (m.thumbnailDirectPath != null && Object.hasOwnProperty.call(m, "thumbnailDirectPath"))
                    w.uint32(210).string(m.thumbnailDirectPath);
                if (m.thumbnailSha256 != null && Object.hasOwnProperty.call(m, "thumbnailSha256"))
                    w.uint32(218).bytes(m.thumbnailSha256);
                if (m.thumbnailEncSha256 != null && Object.hasOwnProperty.call(m, "thumbnailEncSha256"))
                    w.uint32(226).bytes(m.thumbnailEncSha256);
                if (m.staticUrl != null && Object.hasOwnProperty.call(m, "staticUrl"))
                    w.uint32(234).string(m.staticUrl);
                if (m.annotations != null && m.annotations.length) {
                    for (var i = 0; i < m.annotations.length; ++i)
                        $root.proto.InteractiveAnnotation.encode(m.annotations[i], w.uint32(242).fork()).ldelim();
                }
                if (m.imageSourceType != null && Object.hasOwnProperty.call(m, "imageSourceType"))
                    w.uint32(248).int32(m.imageSourceType);
                if (m.accessibilityLabel != null && Object.hasOwnProperty.call(m, "accessibilityLabel"))
                    w.uint32(258).string(m.accessibilityLabel);
                return w;
            };

            ImageMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ImageMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.url = r.string();
                            break;
                        }
                    case 2: {
                            m.mimetype = r.string();
                            break;
                        }
                    case 3: {
                            m.caption = r.string();
                            break;
                        }
                    case 4: {
                            m.fileSha256 = r.bytes();
                            break;
                        }
                    case 5: {
                            m.fileLength = r.uint64();
                            break;
                        }
                    case 6: {
                            m.height = r.uint32();
                            break;
                        }
                    case 7: {
                            m.width = r.uint32();
                            break;
                        }
                    case 8: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 9: {
                            m.fileEncSha256 = r.bytes();
                            break;
                        }
                    case 10: {
                            if (!(m.interactiveAnnotations && m.interactiveAnnotations.length))
                                m.interactiveAnnotations = [];
                            m.interactiveAnnotations.push($root.proto.InteractiveAnnotation.decode(r, r.uint32()));
                            break;
                        }
                    case 11: {
                            m.directPath = r.string();
                            break;
                        }
                    case 12: {
                            m.mediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 18: {
                            m.firstScanSidecar = r.bytes();
                            break;
                        }
                    case 19: {
                            m.firstScanLength = r.uint32();
                            break;
                        }
                    case 20: {
                            m.experimentGroupId = r.uint32();
                            break;
                        }
                    case 21: {
                            m.scansSidecar = r.bytes();
                            break;
                        }
                    case 22: {
                            if (!(m.scanLengths && m.scanLengths.length))
                                m.scanLengths = [];
                            if ((t & 7) === 2) {
                                var c2 = r.uint32() + r.pos;
                                while (r.pos < c2)
                                    m.scanLengths.push(r.uint32());
                            } else
                                m.scanLengths.push(r.uint32());
                            break;
                        }
                    case 23: {
                            m.midQualityFileSha256 = r.bytes();
                            break;
                        }
                    case 24: {
                            m.midQualityFileEncSha256 = r.bytes();
                            break;
                        }
                    case 25: {
                            m.viewOnce = r.bool();
                            break;
                        }
                    case 26: {
                            m.thumbnailDirectPath = r.string();
                            break;
                        }
                    case 27: {
                            m.thumbnailSha256 = r.bytes();
                            break;
                        }
                    case 28: {
                            m.thumbnailEncSha256 = r.bytes();
                            break;
                        }
                    case 29: {
                            m.staticUrl = r.string();
                            break;
                        }
                    case 30: {
                            if (!(m.annotations && m.annotations.length))
                                m.annotations = [];
                            m.annotations.push($root.proto.InteractiveAnnotation.decode(r, r.uint32()));
                            break;
                        }
                    case 31: {
                            m.imageSourceType = r.int32();
                            break;
                        }
                    case 32: {
                            m.accessibilityLabel = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ImageMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ImageMessage";
            };

            ImageMessage.ImageSourceType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "USER_IMAGE"] = 0;
                values[valuesById[1] = "AI_GENERATED"] = 1;
                values[valuesById[2] = "AI_MODIFIED"] = 2;
                values[valuesById[3] = "RASTERIZED_TEXT_STATUS"] = 3;
                return values;
            })();

            return ImageMessage;
        })();

        Message.InitialSecurityNotificationSettingSync = (function() {

            function InitialSecurityNotificationSettingSync(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InitialSecurityNotificationSettingSync.prototype.securityNotificationEnabled = false;

            InitialSecurityNotificationSettingSync.create = function create(properties) {
                return new InitialSecurityNotificationSettingSync(properties);
            };

            InitialSecurityNotificationSettingSync.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.securityNotificationEnabled != null && Object.hasOwnProperty.call(m, "securityNotificationEnabled"))
                    w.uint32(8).bool(m.securityNotificationEnabled);
                return w;
            };

            InitialSecurityNotificationSettingSync.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InitialSecurityNotificationSettingSync();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.securityNotificationEnabled = r.bool();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InitialSecurityNotificationSettingSync.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.InitialSecurityNotificationSettingSync";
            };

            return InitialSecurityNotificationSettingSync;
        })();

        Message.InteractiveMessage = (function() {

            function InteractiveMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InteractiveMessage.prototype.header = null;
            InteractiveMessage.prototype.body = null;
            InteractiveMessage.prototype.footer = null;
            InteractiveMessage.prototype.contextInfo = null;
            InteractiveMessage.prototype.urlTrackingMap = null;
            InteractiveMessage.prototype.shopStorefrontMessage = null;
            InteractiveMessage.prototype.collectionMessage = null;
            InteractiveMessage.prototype.nativeFlowMessage = null;
            InteractiveMessage.prototype.carouselMessage = null;

            let $oneOfFields;

            Object.defineProperty(InteractiveMessage.prototype, "interactiveMessage", {
                get: $util.oneOfGetter($oneOfFields = ["shopStorefrontMessage", "collectionMessage", "nativeFlowMessage", "carouselMessage"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            InteractiveMessage.create = function create(properties) {
                return new InteractiveMessage(properties);
            };

            InteractiveMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.header != null && Object.hasOwnProperty.call(m, "header"))
                    $root.proto.Message.InteractiveMessage.Header.encode(m.header, w.uint32(10).fork()).ldelim();
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    $root.proto.Message.InteractiveMessage.Body.encode(m.body, w.uint32(18).fork()).ldelim();
                if (m.footer != null && Object.hasOwnProperty.call(m, "footer"))
                    $root.proto.Message.InteractiveMessage.Footer.encode(m.footer, w.uint32(26).fork()).ldelim();
                if (m.shopStorefrontMessage != null && Object.hasOwnProperty.call(m, "shopStorefrontMessage"))
                    $root.proto.Message.InteractiveMessage.ShopMessage.encode(m.shopStorefrontMessage, w.uint32(34).fork()).ldelim();
                if (m.collectionMessage != null && Object.hasOwnProperty.call(m, "collectionMessage"))
                    $root.proto.Message.InteractiveMessage.CollectionMessage.encode(m.collectionMessage, w.uint32(42).fork()).ldelim();
                if (m.nativeFlowMessage != null && Object.hasOwnProperty.call(m, "nativeFlowMessage"))
                    $root.proto.Message.InteractiveMessage.NativeFlowMessage.encode(m.nativeFlowMessage, w.uint32(50).fork()).ldelim();
                if (m.carouselMessage != null && Object.hasOwnProperty.call(m, "carouselMessage"))
                    $root.proto.Message.InteractiveMessage.CarouselMessage.encode(m.carouselMessage, w.uint32(58).fork()).ldelim();
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(122).fork()).ldelim();
                if (m.urlTrackingMap != null && Object.hasOwnProperty.call(m, "urlTrackingMap"))
                    $root.proto.UrlTrackingMap.encode(m.urlTrackingMap, w.uint32(130).fork()).ldelim();
                return w;
            };

            InteractiveMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.header = $root.proto.Message.InteractiveMessage.Header.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.body = $root.proto.Message.InteractiveMessage.Body.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.footer = $root.proto.Message.InteractiveMessage.Footer.decode(r, r.uint32());
                            break;
                        }
                    case 15: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 16: {
                            m.urlTrackingMap = $root.proto.UrlTrackingMap.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.shopStorefrontMessage = $root.proto.Message.InteractiveMessage.ShopMessage.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.collectionMessage = $root.proto.Message.InteractiveMessage.CollectionMessage.decode(r, r.uint32());
                            break;
                        }
                    case 6: {
                            m.nativeFlowMessage = $root.proto.Message.InteractiveMessage.NativeFlowMessage.decode(r, r.uint32());
                            break;
                        }
                    case 7: {
                            m.carouselMessage = $root.proto.Message.InteractiveMessage.CarouselMessage.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InteractiveMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.InteractiveMessage";
            };

            InteractiveMessage.Body = (function() {

                function Body(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Body.prototype.text = "";

                Body.create = function create(properties) {
                    return new Body(properties);
                };

                Body.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                        w.uint32(10).string(m.text);
                    return w;
                };

                Body.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.Body();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.text = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Body.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.Body";
                };

                return Body;
            })();

            InteractiveMessage.CarouselMessage = (function() {

                function CarouselMessage(p) {
                    this.cards = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CarouselMessage.prototype.cards = $util.emptyArray;
                CarouselMessage.prototype.messageVersion = 0;

                CarouselMessage.create = function create(properties) {
                    return new CarouselMessage(properties);
                };

                CarouselMessage.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.cards != null && m.cards.length) {
                        for (var i = 0; i < m.cards.length; ++i)
                            $root.proto.Message.InteractiveMessage.encode(m.cards[i], w.uint32(10).fork()).ldelim();
                    }
                    if (m.messageVersion != null && Object.hasOwnProperty.call(m, "messageVersion"))
                        w.uint32(16).int32(m.messageVersion);
                    return w;
                };

                CarouselMessage.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.CarouselMessage();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                if (!(m.cards && m.cards.length))
                                    m.cards = [];
                                m.cards.push($root.proto.Message.InteractiveMessage.decode(r, r.uint32()));
                                break;
                            }
                        case 2: {
                                m.messageVersion = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CarouselMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.CarouselMessage";
                };

                return CarouselMessage;
            })();

            InteractiveMessage.CollectionMessage = (function() {

                function CollectionMessage(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CollectionMessage.prototype.bizJid = "";
                CollectionMessage.prototype.id = "";
                CollectionMessage.prototype.messageVersion = 0;

                CollectionMessage.create = function create(properties) {
                    return new CollectionMessage(properties);
                };

                CollectionMessage.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.bizJid != null && Object.hasOwnProperty.call(m, "bizJid"))
                        w.uint32(10).string(m.bizJid);
                    if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                        w.uint32(18).string(m.id);
                    if (m.messageVersion != null && Object.hasOwnProperty.call(m, "messageVersion"))
                        w.uint32(24).int32(m.messageVersion);
                    return w;
                };

                CollectionMessage.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.CollectionMessage();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.bizJid = r.string();
                                break;
                            }
                        case 2: {
                                m.id = r.string();
                                break;
                            }
                        case 3: {
                                m.messageVersion = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CollectionMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.CollectionMessage";
                };

                return CollectionMessage;
            })();

            InteractiveMessage.Footer = (function() {

                function Footer(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Footer.prototype.text = "";

                Footer.create = function create(properties) {
                    return new Footer(properties);
                };

                Footer.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                        w.uint32(10).string(m.text);
                    return w;
                };

                Footer.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.Footer();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.text = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Footer.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.Footer";
                };

                return Footer;
            })();

            InteractiveMessage.Header = (function() {

                function Header(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Header.prototype.title = "";
                Header.prototype.subtitle = "";
                Header.prototype.hasMediaAttachment = false;
                Header.prototype.documentMessage = null;
                Header.prototype.imageMessage = null;
                Header.prototype.jpegThumbnail = null;
                Header.prototype.videoMessage = null;
                Header.prototype.locationMessage = null;
                Header.prototype.productMessage = null;

                let $oneOfFields;

                Object.defineProperty(Header.prototype, "media", {
                    get: $util.oneOfGetter($oneOfFields = ["documentMessage", "imageMessage", "jpegThumbnail", "videoMessage", "locationMessage", "productMessage"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                Header.create = function create(properties) {
                    return new Header(properties);
                };

                Header.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.subtitle != null && Object.hasOwnProperty.call(m, "subtitle"))
                        w.uint32(18).string(m.subtitle);
                    if (m.documentMessage != null && Object.hasOwnProperty.call(m, "documentMessage"))
                        $root.proto.Message.DocumentMessage.encode(m.documentMessage, w.uint32(26).fork()).ldelim();
                    if (m.imageMessage != null && Object.hasOwnProperty.call(m, "imageMessage"))
                        $root.proto.Message.ImageMessage.encode(m.imageMessage, w.uint32(34).fork()).ldelim();
                    if (m.hasMediaAttachment != null && Object.hasOwnProperty.call(m, "hasMediaAttachment"))
                        w.uint32(40).bool(m.hasMediaAttachment);
                    if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                        w.uint32(50).bytes(m.jpegThumbnail);
                    if (m.videoMessage != null && Object.hasOwnProperty.call(m, "videoMessage"))
                        $root.proto.Message.VideoMessage.encode(m.videoMessage, w.uint32(58).fork()).ldelim();
                    if (m.locationMessage != null && Object.hasOwnProperty.call(m, "locationMessage"))
                        $root.proto.Message.LocationMessage.encode(m.locationMessage, w.uint32(66).fork()).ldelim();
                    if (m.productMessage != null && Object.hasOwnProperty.call(m, "productMessage"))
                        $root.proto.Message.ProductMessage.encode(m.productMessage, w.uint32(74).fork()).ldelim();
                    return w;
                };

                Header.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.Header();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.subtitle = r.string();
                                break;
                            }
                        case 5: {
                                m.hasMediaAttachment = r.bool();
                                break;
                            }
                        case 3: {
                                m.documentMessage = $root.proto.Message.DocumentMessage.decode(r, r.uint32());
                                break;
                            }
                        case 4: {
                                m.imageMessage = $root.proto.Message.ImageMessage.decode(r, r.uint32());
                                break;
                            }
                        case 6: {
                                m.jpegThumbnail = r.bytes();
                                break;
                            }
                        case 7: {
                                m.videoMessage = $root.proto.Message.VideoMessage.decode(r, r.uint32());
                                break;
                            }
                        case 8: {
                                m.locationMessage = $root.proto.Message.LocationMessage.decode(r, r.uint32());
                                break;
                            }
                        case 9: {
                                m.productMessage = $root.proto.Message.ProductMessage.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Header.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.Header";
                };

                return Header;
            })();

            InteractiveMessage.NativeFlowMessage = (function() {

                function NativeFlowMessage(p) {
                    this.buttons = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                NativeFlowMessage.prototype.buttons = $util.emptyArray;
                NativeFlowMessage.prototype.messageParamsJson = "";
                NativeFlowMessage.prototype.messageVersion = 0;

                NativeFlowMessage.create = function create(properties) {
                    return new NativeFlowMessage(properties);
                };

                NativeFlowMessage.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.buttons != null && m.buttons.length) {
                        for (var i = 0; i < m.buttons.length; ++i)
                            $root.proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton.encode(m.buttons[i], w.uint32(10).fork()).ldelim();
                    }
                    if (m.messageParamsJson != null && Object.hasOwnProperty.call(m, "messageParamsJson"))
                        w.uint32(18).string(m.messageParamsJson);
                    if (m.messageVersion != null && Object.hasOwnProperty.call(m, "messageVersion"))
                        w.uint32(24).int32(m.messageVersion);
                    return w;
                };

                NativeFlowMessage.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.NativeFlowMessage();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                if (!(m.buttons && m.buttons.length))
                                    m.buttons = [];
                                m.buttons.push($root.proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton.decode(r, r.uint32()));
                                break;
                            }
                        case 2: {
                                m.messageParamsJson = r.string();
                                break;
                            }
                        case 3: {
                                m.messageVersion = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                NativeFlowMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.NativeFlowMessage";
                };

                NativeFlowMessage.NativeFlowButton = (function() {

                    function NativeFlowButton(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    NativeFlowButton.prototype.name = "";
                    NativeFlowButton.prototype.buttonParamsJson = "";

                    NativeFlowButton.create = function create(properties) {
                        return new NativeFlowButton(properties);
                    };

                    NativeFlowButton.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                            w.uint32(10).string(m.name);
                        if (m.buttonParamsJson != null && Object.hasOwnProperty.call(m, "buttonParamsJson"))
                            w.uint32(18).string(m.buttonParamsJson);
                        return w;
                    };

                    NativeFlowButton.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.name = r.string();
                                    break;
                                }
                            case 2: {
                                    m.buttonParamsJson = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    NativeFlowButton.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.InteractiveMessage.NativeFlowMessage.NativeFlowButton";
                    };

                    return NativeFlowButton;
                })();

                return NativeFlowMessage;
            })();

            InteractiveMessage.ShopMessage = (function() {

                function ShopMessage(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                ShopMessage.prototype.id = "";
                ShopMessage.prototype.surface = 0;
                ShopMessage.prototype.messageVersion = 0;

                ShopMessage.create = function create(properties) {
                    return new ShopMessage(properties);
                };

                ShopMessage.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.id != null && Object.hasOwnProperty.call(m, "id"))
                        w.uint32(10).string(m.id);
                    if (m.surface != null && Object.hasOwnProperty.call(m, "surface"))
                        w.uint32(16).int32(m.surface);
                    if (m.messageVersion != null && Object.hasOwnProperty.call(m, "messageVersion"))
                        w.uint32(24).int32(m.messageVersion);
                    return w;
                };

                ShopMessage.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveMessage.ShopMessage();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.id = r.string();
                                break;
                            }
                        case 2: {
                                m.surface = r.int32();
                                break;
                            }
                        case 3: {
                                m.messageVersion = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                ShopMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveMessage.ShopMessage";
                };

                ShopMessage.Surface = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN_SURFACE"] = 0;
                    values[valuesById[1] = "FB"] = 1;
                    values[valuesById[2] = "IG"] = 2;
                    values[valuesById[3] = "WA"] = 3;
                    return values;
                })();

                return ShopMessage;
            })();

            return InteractiveMessage;
        })();

        Message.InteractiveResponseMessage = (function() {

            function InteractiveResponseMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InteractiveResponseMessage.prototype.body = null;
            InteractiveResponseMessage.prototype.contextInfo = null;
            InteractiveResponseMessage.prototype.nativeFlowResponseMessage = null;

            let $oneOfFields;

            Object.defineProperty(InteractiveResponseMessage.prototype, "interactiveResponseMessage", {
                get: $util.oneOfGetter($oneOfFields = ["nativeFlowResponseMessage"]),
                set: $util.oneOfSetter($oneOfFields)
            });

            InteractiveResponseMessage.create = function create(properties) {
                return new InteractiveResponseMessage(properties);
            };

            InteractiveResponseMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    $root.proto.Message.InteractiveResponseMessage.Body.encode(m.body, w.uint32(10).fork()).ldelim();
                if (m.nativeFlowResponseMessage != null && Object.hasOwnProperty.call(m, "nativeFlowResponseMessage"))
                    $root.proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage.encode(m.nativeFlowResponseMessage, w.uint32(18).fork()).ldelim();
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(122).fork()).ldelim();
                return w;
            };

            InteractiveResponseMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveResponseMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.body = $root.proto.Message.InteractiveResponseMessage.Body.decode(r, r.uint32());
                            break;
                        }
                    case 15: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.nativeFlowResponseMessage = $root.proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InteractiveResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.InteractiveResponseMessage";
            };

            InteractiveResponseMessage.Body = (function() {

                function Body(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Body.prototype.text = "";
                Body.prototype.format = 0;

                Body.create = function create(properties) {
                    return new Body(properties);
                };

                Body.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.text != null && Object.hasOwnProperty.call(m, "text"))
                        w.uint32(10).string(m.text);
                    if (m.format != null && Object.hasOwnProperty.call(m, "format"))
                        w.uint32(16).int32(m.format);
                    return w;
                };

                Body.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveResponseMessage.Body();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.text = r.string();
                                break;
                            }
                        case 2: {
                                m.format = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Body.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveResponseMessage.Body";
                };

                Body.Format = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "DEFAULT"] = 0;
                    values[valuesById[1] = "EXTENSIONS_1"] = 1;
                    return values;
                })();

                return Body;
            })();

            InteractiveResponseMessage.NativeFlowResponseMessage = (function() {

                function NativeFlowResponseMessage(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                NativeFlowResponseMessage.prototype.name = "";
                NativeFlowResponseMessage.prototype.paramsJson = "";
                NativeFlowResponseMessage.prototype.version = 0;

                NativeFlowResponseMessage.create = function create(properties) {
                    return new NativeFlowResponseMessage(properties);
                };

                NativeFlowResponseMessage.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                        w.uint32(10).string(m.name);
                    if (m.paramsJson != null && Object.hasOwnProperty.call(m, "paramsJson"))
                        w.uint32(18).string(m.paramsJson);
                    if (m.version != null && Object.hasOwnProperty.call(m, "version"))
                        w.uint32(24).int32(m.version);
                    return w;
                };

                NativeFlowResponseMessage.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.name = r.string();
                                break;
                            }
                        case 2: {
                                m.paramsJson = r.string();
                                break;
                            }
                        case 3: {
                                m.version = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                NativeFlowResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.InteractiveResponseMessage.NativeFlowResponseMessage";
                };

                return NativeFlowResponseMessage;
            })();

            return InteractiveResponseMessage;
        })();

        Message.InvoiceMessage = (function() {

            function InvoiceMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            InvoiceMessage.prototype.note = "";
            InvoiceMessage.prototype.token = "";
            InvoiceMessage.prototype.attachmentType = 0;
            InvoiceMessage.prototype.attachmentMimetype = "";
            InvoiceMessage.prototype.attachmentMediaKey = $util.newBuffer([]);
            InvoiceMessage.prototype.attachmentMediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            InvoiceMessage.prototype.attachmentFileSha256 = $util.newBuffer([]);
            InvoiceMessage.prototype.attachmentFileEncSha256 = $util.newBuffer([]);
            InvoiceMessage.prototype.attachmentDirectPath = "";
            InvoiceMessage.prototype.attachmentJpegThumbnail = $util.newBuffer([]);

            InvoiceMessage.create = function create(properties) {
                return new InvoiceMessage(properties);
            };

            InvoiceMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.note != null && Object.hasOwnProperty.call(m, "note"))
                    w.uint32(10).string(m.note);
                if (m.token != null && Object.hasOwnProperty.call(m, "token"))
                    w.uint32(18).string(m.token);
                if (m.attachmentType != null && Object.hasOwnProperty.call(m, "attachmentType"))
                    w.uint32(24).int32(m.attachmentType);
                if (m.attachmentMimetype != null && Object.hasOwnProperty.call(m, "attachmentMimetype"))
                    w.uint32(34).string(m.attachmentMimetype);
                if (m.attachmentMediaKey != null && Object.hasOwnProperty.call(m, "attachmentMediaKey"))
                    w.uint32(42).bytes(m.attachmentMediaKey);
                if (m.attachmentMediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "attachmentMediaKeyTimestamp"))
                    w.uint32(48).int64(m.attachmentMediaKeyTimestamp);
                if (m.attachmentFileSha256 != null && Object.hasOwnProperty.call(m, "attachmentFileSha256"))
                    w.uint32(58).bytes(m.attachmentFileSha256);
                if (m.attachmentFileEncSha256 != null && Object.hasOwnProperty.call(m, "attachmentFileEncSha256"))
                    w.uint32(66).bytes(m.attachmentFileEncSha256);
                if (m.attachmentDirectPath != null && Object.hasOwnProperty.call(m, "attachmentDirectPath"))
                    w.uint32(74).string(m.attachmentDirectPath);
                if (m.attachmentJpegThumbnail != null && Object.hasOwnProperty.call(m, "attachmentJpegThumbnail"))
                    w.uint32(82).bytes(m.attachmentJpegThumbnail);
                return w;
            };

            InvoiceMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.InvoiceMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.note = r.string();
                            break;
                        }
                    case 2: {
                            m.token = r.string();
                            break;
                        }
                    case 3: {
                            m.attachmentType = r.int32();
                            break;
                        }
                    case 4: {
                            m.attachmentMimetype = r.string();
                            break;
                        }
                    case 5: {
                            m.attachmentMediaKey = r.bytes();
                            break;
                        }
                    case 6: {
                            m.attachmentMediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 7: {
                            m.attachmentFileSha256 = r.bytes();
                            break;
                        }
                    case 8: {
                            m.attachmentFileEncSha256 = r.bytes();
                            break;
                        }
                    case 9: {
                            m.attachmentDirectPath = r.string();
                            break;
                        }
                    case 10: {
                            m.attachmentJpegThumbnail = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            InvoiceMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.InvoiceMessage";
            };

            InvoiceMessage.AttachmentType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "IMAGE"] = 0;
                values[valuesById[1] = "PDF"] = 1;
                return values;
            })();

            return InvoiceMessage;
        })();

        Message.KeepInChatMessage = (function() {

            function KeepInChatMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            KeepInChatMessage.prototype.key = null;
            KeepInChatMessage.prototype.keepType = 0;
            KeepInChatMessage.prototype.timestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            KeepInChatMessage.create = function create(properties) {
                return new KeepInChatMessage(properties);
            };

            KeepInChatMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                    $root.proto.MessageKey.encode(m.key, w.uint32(10).fork()).ldelim();
                if (m.keepType != null && Object.hasOwnProperty.call(m, "keepType"))
                    w.uint32(16).int32(m.keepType);
                if (m.timestampMs != null && Object.hasOwnProperty.call(m, "timestampMs"))
                    w.uint32(24).int64(m.timestampMs);
                return w;
            };

            KeepInChatMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.KeepInChatMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.key = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.keepType = r.int32();
                            break;
                        }
                    case 3: {
                            m.timestampMs = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            KeepInChatMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.KeepInChatMessage";
            };

            return KeepInChatMessage;
        })();

        Message.LinkPreviewMetadata = (function() {

            function LinkPreviewMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            LinkPreviewMetadata.prototype.paymentLinkMetadata = null;
            LinkPreviewMetadata.prototype.urlMetadata = null;
            LinkPreviewMetadata.prototype.fbExperimentId = 0;

            LinkPreviewMetadata.create = function create(properties) {
                return new LinkPreviewMetadata(properties);
            };

            LinkPreviewMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.paymentLinkMetadata != null && Object.hasOwnProperty.call(m, "paymentLinkMetadata"))
                    $root.proto.Message.PaymentLinkMetadata.encode(m.paymentLinkMetadata, w.uint32(10).fork()).ldelim();
                if (m.urlMetadata != null && Object.hasOwnProperty.call(m, "urlMetadata"))
                    $root.proto.Message.URLMetadata.encode(m.urlMetadata, w.uint32(18).fork()).ldelim();
                if (m.fbExperimentId != null && Object.hasOwnProperty.call(m, "fbExperimentId"))
                    w.uint32(24).uint32(m.fbExperimentId);
                return w;
            };

            LinkPreviewMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.LinkPreviewMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.paymentLinkMetadata = $root.proto.Message.PaymentLinkMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.urlMetadata = $root.proto.Message.URLMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.fbExperimentId = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            LinkPreviewMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.LinkPreviewMetadata";
            };

            return LinkPreviewMetadata;
        })();

        Message.ListMessage = (function() {

            function ListMessage(p) {
                this.sections = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ListMessage.prototype.title = "";
            ListMessage.prototype.description = "";
            ListMessage.prototype.buttonText = "";
            ListMessage.prototype.listType = 0;
            ListMessage.prototype.sections = $util.emptyArray;
            ListMessage.prototype.productListInfo = null;
            ListMessage.prototype.footerText = "";
            ListMessage.prototype.contextInfo = null;

            ListMessage.create = function create(properties) {
                return new ListMessage(properties);
            };

            ListMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                    w.uint32(18).string(m.description);
                if (m.buttonText != null && Object.hasOwnProperty.call(m, "buttonText"))
                    w.uint32(26).string(m.buttonText);
                if (m.listType != null && Object.hasOwnProperty.call(m, "listType"))
                    w.uint32(32).int32(m.listType);
                if (m.sections != null && m.sections.length) {
                    for (var i = 0; i < m.sections.length; ++i)
                        $root.proto.Message.ListMessage.Section.encode(m.sections[i], w.uint32(42).fork()).ldelim();
                }
                if (m.productListInfo != null && Object.hasOwnProperty.call(m, "productListInfo"))
                    $root.proto.Message.ListMessage.ProductListInfo.encode(m.productListInfo, w.uint32(50).fork()).ldelim();
                if (m.footerText != null && Object.hasOwnProperty.call(m, "footerText"))
                    w.uint32(58).string(m.footerText);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(66).fork()).ldelim();
                return w;
            };

            ListMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    case 2: {
                            m.description = r.string();
                            break;
                        }
                    case 3: {
                            m.buttonText = r.string();
                            break;
                        }
                    case 4: {
                            m.listType = r.int32();
                            break;
                        }
                    case 5: {
                            if (!(m.sections && m.sections.length))
                                m.sections = [];
                            m.sections.push($root.proto.Message.ListMessage.Section.decode(r, r.uint32()));
                            break;
                        }
                    case 6: {
                            m.productListInfo = $root.proto.Message.ListMessage.ProductListInfo.decode(r, r.uint32());
                            break;
                        }
                    case 7: {
                            m.footerText = r.string();
                            break;
                        }
                    case 8: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ListMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ListMessage";
            };

            ListMessage.ListType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "SINGLE_SELECT"] = 1;
                values[valuesById[2] = "PRODUCT_LIST"] = 2;
                return values;
            })();

            ListMessage.Product = (function() {

                function Product(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Product.prototype.productId = "";

                Product.create = function create(properties) {
                    return new Product(properties);
                };

                Product.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.productId != null && Object.hasOwnProperty.call(m, "productId"))
                        w.uint32(10).string(m.productId);
                    return w;
                };

                Product.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage.Product();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.productId = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Product.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListMessage.Product";
                };

                return Product;
            })();

            ListMessage.ProductListHeaderImage = (function() {

                function ProductListHeaderImage(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                ProductListHeaderImage.prototype.productId = "";
                ProductListHeaderImage.prototype.jpegThumbnail = $util.newBuffer([]);

                ProductListHeaderImage.create = function create(properties) {
                    return new ProductListHeaderImage(properties);
                };

                ProductListHeaderImage.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.productId != null && Object.hasOwnProperty.call(m, "productId"))
                        w.uint32(10).string(m.productId);
                    if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                        w.uint32(18).bytes(m.jpegThumbnail);
                    return w;
                };

                ProductListHeaderImage.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage.ProductListHeaderImage();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.productId = r.string();
                                break;
                            }
                        case 2: {
                                m.jpegThumbnail = r.bytes();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                ProductListHeaderImage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListMessage.ProductListHeaderImage";
                };

                return ProductListHeaderImage;
            })();

            ListMessage.ProductListInfo = (function() {

                function ProductListInfo(p) {
                    this.productSections = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                ProductListInfo.prototype.productSections = $util.emptyArray;
                ProductListInfo.prototype.headerImage = null;
                ProductListInfo.prototype.businessOwnerJid = "";

                ProductListInfo.create = function create(properties) {
                    return new ProductListInfo(properties);
                };

                ProductListInfo.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.productSections != null && m.productSections.length) {
                        for (var i = 0; i < m.productSections.length; ++i)
                            $root.proto.Message.ListMessage.ProductSection.encode(m.productSections[i], w.uint32(10).fork()).ldelim();
                    }
                    if (m.headerImage != null && Object.hasOwnProperty.call(m, "headerImage"))
                        $root.proto.Message.ListMessage.ProductListHeaderImage.encode(m.headerImage, w.uint32(18).fork()).ldelim();
                    if (m.businessOwnerJid != null && Object.hasOwnProperty.call(m, "businessOwnerJid"))
                        w.uint32(26).string(m.businessOwnerJid);
                    return w;
                };

                ProductListInfo.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage.ProductListInfo();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                if (!(m.productSections && m.productSections.length))
                                    m.productSections = [];
                                m.productSections.push($root.proto.Message.ListMessage.ProductSection.decode(r, r.uint32()));
                                break;
                            }
                        case 2: {
                                m.headerImage = $root.proto.Message.ListMessage.ProductListHeaderImage.decode(r, r.uint32());
                                break;
                            }
                        case 3: {
                                m.businessOwnerJid = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                ProductListInfo.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListMessage.ProductListInfo";
                };

                return ProductListInfo;
            })();

            ListMessage.ProductSection = (function() {

                function ProductSection(p) {
                    this.products = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                ProductSection.prototype.title = "";
                ProductSection.prototype.products = $util.emptyArray;

                ProductSection.create = function create(properties) {
                    return new ProductSection(properties);
                };

                ProductSection.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.products != null && m.products.length) {
                        for (var i = 0; i < m.products.length; ++i)
                            $root.proto.Message.ListMessage.Product.encode(m.products[i], w.uint32(18).fork()).ldelim();
                    }
                    return w;
                };

                ProductSection.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage.ProductSection();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                if (!(m.products && m.products.length))
                                    m.products = [];
                                m.products.push($root.proto.Message.ListMessage.Product.decode(r, r.uint32()));
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                ProductSection.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListMessage.ProductSection";
                };

                return ProductSection;
            })();

            ListMessage.Row = (function() {

                function Row(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Row.prototype.title = "";
                Row.prototype.description = "";
                Row.prototype.rowId = "";

                Row.create = function create(properties) {
                    return new Row(properties);
                };

                Row.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                        w.uint32(18).string(m.description);
                    if (m.rowId != null && Object.hasOwnProperty.call(m, "rowId"))
                        w.uint32(26).string(m.rowId);
                    return w;
                };

                Row.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage.Row();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                m.description = r.string();
                                break;
                            }
                        case 3: {
                                m.rowId = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Row.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListMessage.Row";
                };

                return Row;
            })();

            ListMessage.Section = (function() {

                function Section(p) {
                    this.rows = [];
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Section.prototype.title = "";
                Section.prototype.rows = $util.emptyArray;

                Section.create = function create(properties) {
                    return new Section(properties);
                };

                Section.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(10).string(m.title);
                    if (m.rows != null && m.rows.length) {
                        for (var i = 0; i < m.rows.length; ++i)
                            $root.proto.Message.ListMessage.Row.encode(m.rows[i], w.uint32(18).fork()).ldelim();
                    }
                    return w;
                };

                Section.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListMessage.Section();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.title = r.string();
                                break;
                            }
                        case 2: {
                                if (!(m.rows && m.rows.length))
                                    m.rows = [];
                                m.rows.push($root.proto.Message.ListMessage.Row.decode(r, r.uint32()));
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Section.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListMessage.Section";
                };

                return Section;
            })();

            return ListMessage;
        })();

        Message.ListResponseMessage = (function() {

            function ListResponseMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ListResponseMessage.prototype.title = "";
            ListResponseMessage.prototype.listType = 0;
            ListResponseMessage.prototype.singleSelectReply = null;
            ListResponseMessage.prototype.contextInfo = null;
            ListResponseMessage.prototype.description = "";

            ListResponseMessage.create = function create(properties) {
                return new ListResponseMessage(properties);
            };

            ListResponseMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                    w.uint32(10).string(m.title);
                if (m.listType != null && Object.hasOwnProperty.call(m, "listType"))
                    w.uint32(16).int32(m.listType);
                if (m.singleSelectReply != null && Object.hasOwnProperty.call(m, "singleSelectReply"))
                    $root.proto.Message.ListResponseMessage.SingleSelectReply.encode(m.singleSelectReply, w.uint32(26).fork()).ldelim();
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(34).fork()).ldelim();
                if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                    w.uint32(42).string(m.description);
                return w;
            };

            ListResponseMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListResponseMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.title = r.string();
                            break;
                        }
                    case 2: {
                            m.listType = r.int32();
                            break;
                        }
                    case 3: {
                            m.singleSelectReply = $root.proto.Message.ListResponseMessage.SingleSelectReply.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.description = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ListResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ListResponseMessage";
            };

            ListResponseMessage.ListType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "SINGLE_SELECT"] = 1;
                return values;
            })();

            ListResponseMessage.SingleSelectReply = (function() {

                function SingleSelectReply(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                SingleSelectReply.prototype.selectedRowId = "";

                SingleSelectReply.create = function create(properties) {
                    return new SingleSelectReply(properties);
                };

                SingleSelectReply.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.selectedRowId != null && Object.hasOwnProperty.call(m, "selectedRowId"))
                        w.uint32(10).string(m.selectedRowId);
                    return w;
                };

                SingleSelectReply.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ListResponseMessage.SingleSelectReply();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.selectedRowId = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                SingleSelectReply.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ListResponseMessage.SingleSelectReply";
                };

                return SingleSelectReply;
            })();

            return ListResponseMessage;
        })();

        Message.LiveLocationMessage = (function() {

            function LiveLocationMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            LiveLocationMessage.prototype.degreesLatitude = 0;
            LiveLocationMessage.prototype.degreesLongitude = 0;
            LiveLocationMessage.prototype.accuracyInMeters = 0;
            LiveLocationMessage.prototype.speedInMps = 0;
            LiveLocationMessage.prototype.degreesClockwiseFromMagneticNorth = 0;
            LiveLocationMessage.prototype.caption = "";
            LiveLocationMessage.prototype.sequenceNumber = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            LiveLocationMessage.prototype.timeOffset = 0;
            LiveLocationMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            LiveLocationMessage.prototype.contextInfo = null;

            LiveLocationMessage.create = function create(properties) {
                return new LiveLocationMessage(properties);
            };

            LiveLocationMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.degreesLatitude != null && Object.hasOwnProperty.call(m, "degreesLatitude"))
                    w.uint32(9).double(m.degreesLatitude);
                if (m.degreesLongitude != null && Object.hasOwnProperty.call(m, "degreesLongitude"))
                    w.uint32(17).double(m.degreesLongitude);
                if (m.accuracyInMeters != null && Object.hasOwnProperty.call(m, "accuracyInMeters"))
                    w.uint32(24).uint32(m.accuracyInMeters);
                if (m.speedInMps != null && Object.hasOwnProperty.call(m, "speedInMps"))
                    w.uint32(37).float(m.speedInMps);
                if (m.degreesClockwiseFromMagneticNorth != null && Object.hasOwnProperty.call(m, "degreesClockwiseFromMagneticNorth"))
                    w.uint32(40).uint32(m.degreesClockwiseFromMagneticNorth);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(50).string(m.caption);
                if (m.sequenceNumber != null && Object.hasOwnProperty.call(m, "sequenceNumber"))
                    w.uint32(56).int64(m.sequenceNumber);
                if (m.timeOffset != null && Object.hasOwnProperty.call(m, "timeOffset"))
                    w.uint32(64).uint32(m.timeOffset);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            LiveLocationMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.LiveLocationMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.degreesLatitude = r.double();
                            break;
                        }
                    case 2: {
                            m.degreesLongitude = r.double();
                            break;
                        }
                    case 3: {
                            m.accuracyInMeters = r.uint32();
                            break;
                        }
                    case 4: {
                            m.speedInMps = r.float();
                            break;
                        }
                    case 5: {
                            m.degreesClockwiseFromMagneticNorth = r.uint32();
                            break;
                        }
                    case 6: {
                            m.caption = r.string();
                            break;
                        }
                    case 7: {
                            m.sequenceNumber = r.int64();
                            break;
                        }
                    case 8: {
                            m.timeOffset = r.uint32();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            LiveLocationMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.LiveLocationMessage";
            };

            return LiveLocationMessage;
        })();

        Message.LocationMessage = (function() {

            function LocationMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            LocationMessage.prototype.degreesLatitude = 0;
            LocationMessage.prototype.degreesLongitude = 0;
            LocationMessage.prototype.name = "";
            LocationMessage.prototype.address = "";
            LocationMessage.prototype.url = "";
            LocationMessage.prototype.isLive = false;
            LocationMessage.prototype.accuracyInMeters = 0;
            LocationMessage.prototype.speedInMps = 0;
            LocationMessage.prototype.degreesClockwiseFromMagneticNorth = 0;
            LocationMessage.prototype.comment = "";
            LocationMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            LocationMessage.prototype.contextInfo = null;

            LocationMessage.create = function create(properties) {
                return new LocationMessage(properties);
            };

            LocationMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.degreesLatitude != null && Object.hasOwnProperty.call(m, "degreesLatitude"))
                    w.uint32(9).double(m.degreesLatitude);
                if (m.degreesLongitude != null && Object.hasOwnProperty.call(m, "degreesLongitude"))
                    w.uint32(17).double(m.degreesLongitude);
                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                    w.uint32(26).string(m.name);
                if (m.address != null && Object.hasOwnProperty.call(m, "address"))
                    w.uint32(34).string(m.address);
                if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                    w.uint32(42).string(m.url);
                if (m.isLive != null && Object.hasOwnProperty.call(m, "isLive"))
                    w.uint32(48).bool(m.isLive);
                if (m.accuracyInMeters != null && Object.hasOwnProperty.call(m, "accuracyInMeters"))
                    w.uint32(56).uint32(m.accuracyInMeters);
                if (m.speedInMps != null && Object.hasOwnProperty.call(m, "speedInMps"))
                    w.uint32(69).float(m.speedInMps);
                if (m.degreesClockwiseFromMagneticNorth != null && Object.hasOwnProperty.call(m, "degreesClockwiseFromMagneticNorth"))
                    w.uint32(72).uint32(m.degreesClockwiseFromMagneticNorth);
                if (m.comment != null && Object.hasOwnProperty.call(m, "comment"))
                    w.uint32(90).string(m.comment);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(130).bytes(m.jpegThumbnail);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            LocationMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.LocationMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.degreesLatitude = r.double();
                            break;
                        }
                    case 2: {
                            m.degreesLongitude = r.double();
                            break;
                        }
                    case 3: {
                            m.name = r.string();
                            break;
                        }
                    case 4: {
                            m.address = r.string();
                            break;
                        }
                    case 5: {
                            m.url = r.string();
                            break;
                        }
                    case 6: {
                            m.isLive = r.bool();
                            break;
                        }
                    case 7: {
                            m.accuracyInMeters = r.uint32();
                            break;
                        }
                    case 8: {
                            m.speedInMps = r.float();
                            break;
                        }
                    case 9: {
                            m.degreesClockwiseFromMagneticNorth = r.uint32();
                            break;
                        }
                    case 11: {
                            m.comment = r.string();
                            break;
                        }
                    case 16: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            LocationMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.LocationMessage";
            };

            return LocationMessage;
        })();

        Message.MMSThumbnailMetadata = (function() {

            function MMSThumbnailMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            MMSThumbnailMetadata.prototype.thumbnailDirectPath = "";
            MMSThumbnailMetadata.prototype.thumbnailSha256 = $util.newBuffer([]);
            MMSThumbnailMetadata.prototype.thumbnailEncSha256 = $util.newBuffer([]);
            MMSThumbnailMetadata.prototype.mediaKey = $util.newBuffer([]);
            MMSThumbnailMetadata.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            MMSThumbnailMetadata.prototype.thumbnailHeight = 0;
            MMSThumbnailMetadata.prototype.thumbnailWidth = 0;

            MMSThumbnailMetadata.create = function create(properties) {
                return new MMSThumbnailMetadata(properties);
            };

            MMSThumbnailMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.thumbnailDirectPath != null && Object.hasOwnProperty.call(m, "thumbnailDirectPath"))
                    w.uint32(10).string(m.thumbnailDirectPath);
                if (m.thumbnailSha256 != null && Object.hasOwnProperty.call(m, "thumbnailSha256"))
                    w.uint32(18).bytes(m.thumbnailSha256);
                if (m.thumbnailEncSha256 != null && Object.hasOwnProperty.call(m, "thumbnailEncSha256"))
                    w.uint32(26).bytes(m.thumbnailEncSha256);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(34).bytes(m.mediaKey);
                if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                    w.uint32(40).int64(m.mediaKeyTimestamp);
                if (m.thumbnailHeight != null && Object.hasOwnProperty.call(m, "thumbnailHeight"))
                    w.uint32(48).uint32(m.thumbnailHeight);
                if (m.thumbnailWidth != null && Object.hasOwnProperty.call(m, "thumbnailWidth"))
                    w.uint32(56).uint32(m.thumbnailWidth);
                return w;
            };

            MMSThumbnailMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.MMSThumbnailMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.thumbnailDirectPath = r.string();
                            break;
                        }
                    case 2: {
                            m.thumbnailSha256 = r.bytes();
                            break;
                        }
                    case 3: {
                            m.thumbnailEncSha256 = r.bytes();
                            break;
                        }
                    case 4: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 5: {
                            m.mediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 6: {
                            m.thumbnailHeight = r.uint32();
                            break;
                        }
                    case 7: {
                            m.thumbnailWidth = r.uint32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            MMSThumbnailMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.MMSThumbnailMetadata";
            };

            return MMSThumbnailMetadata;
        })();

        Message.MessageHistoryBundle = (function() {

            function MessageHistoryBundle(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            MessageHistoryBundle.prototype.mimetype = "";
            MessageHistoryBundle.prototype.fileSha256 = $util.newBuffer([]);
            MessageHistoryBundle.prototype.mediaKey = $util.newBuffer([]);
            MessageHistoryBundle.prototype.fileEncSha256 = $util.newBuffer([]);
            MessageHistoryBundle.prototype.directPath = "";
            MessageHistoryBundle.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            MessageHistoryBundle.prototype.contextInfo = null;
            MessageHistoryBundle.prototype.messageHistoryMetadata = null;

            MessageHistoryBundle.create = function create(properties) {
                return new MessageHistoryBundle(properties);
            };

            MessageHistoryBundle.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.mimetype != null && Object.hasOwnProperty.call(m, "mimetype"))
                    w.uint32(10).string(m.mimetype);
                if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                    w.uint32(18).bytes(m.fileSha256);
                if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                    w.uint32(26).bytes(m.mediaKey);
                if (m.fileEncSha256 != null && Object.hasOwnProperty.call(m, "fileEncSha256"))
                    w.uint32(34).bytes(m.fileEncSha256);
                if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                    w.uint32(42).string(m.directPath);
                if (m.mediaKeyTimestamp != null && Object.hasOwnProperty.call(m, "mediaKeyTimestamp"))
                    w.uint32(48).int64(m.mediaKeyTimestamp);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(58).fork()).ldelim();
                if (m.messageHistoryMetadata != null && Object.hasOwnProperty.call(m, "messageHistoryMetadata"))
                    $root.proto.Message.MessageHistoryMetadata.encode(m.messageHistoryMetadata, w.uint32(66).fork()).ldelim();
                return w;
            };

            MessageHistoryBundle.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.MessageHistoryBundle();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.mimetype = r.string();
                            break;
                        }
                    case 2: {
                            m.fileSha256 = r.bytes();
                            break;
                        }
                    case 3: {
                            m.mediaKey = r.bytes();
                            break;
                        }
                    case 4: {
                            m.fileEncSha256 = r.bytes();
                            break;
                        }
                    case 5: {
                            m.directPath = r.string();
                            break;
                        }
                    case 6: {
                            m.mediaKeyTimestamp = r.int64();
                            break;
                        }
                    case 7: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 8: {
                            m.messageHistoryMetadata = $root.proto.Message.MessageHistoryMetadata.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            MessageHistoryBundle.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.MessageHistoryBundle";
            };

            return MessageHistoryBundle;
        })();

        Message.MessageHistoryMetadata = (function() {

            function MessageHistoryMetadata(p) {
                this.historyReceivers = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            MessageHistoryMetadata.prototype.historyReceivers = $util.emptyArray;
            MessageHistoryMetadata.prototype.firstMessageTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            MessageHistoryMetadata.prototype.messageCount = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            MessageHistoryMetadata.create = function create(properties) {
                return new MessageHistoryMetadata(properties);
            };

            MessageHistoryMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.historyReceivers != null && m.historyReceivers.length) {
                    for (var i = 0; i < m.historyReceivers.length; ++i)
                        w.uint32(10).string(m.historyReceivers[i]);
                }
                if (m.firstMessageTimestamp != null && Object.hasOwnProperty.call(m, "firstMessageTimestamp"))
                    w.uint32(16).int64(m.firstMessageTimestamp);
                if (m.messageCount != null && Object.hasOwnProperty.call(m, "messageCount"))
                    w.uint32(24).int64(m.messageCount);
                return w;
            };

            MessageHistoryMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.MessageHistoryMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.historyReceivers && m.historyReceivers.length))
                                m.historyReceivers = [];
                            m.historyReceivers.push(r.string());
                            break;
                        }
                    case 2: {
                            m.firstMessageTimestamp = r.int64();
                            break;
                        }
                    case 3: {
                            m.messageCount = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            MessageHistoryMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.MessageHistoryMetadata";
            };

            return MessageHistoryMetadata;
        })();

        Message.MessageHistoryNotice = (function() {

            function MessageHistoryNotice(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            MessageHistoryNotice.prototype.contextInfo = null;
            MessageHistoryNotice.prototype.messageHistoryMetadata = null;

            MessageHistoryNotice.create = function create(properties) {
                return new MessageHistoryNotice(properties);
            };

            MessageHistoryNotice.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(10).fork()).ldelim();
                if (m.messageHistoryMetadata != null && Object.hasOwnProperty.call(m, "messageHistoryMetadata"))
                    $root.proto.Message.MessageHistoryMetadata.encode(m.messageHistoryMetadata, w.uint32(18).fork()).ldelim();
                return w;
            };

            MessageHistoryNotice.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.MessageHistoryNotice();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.messageHistoryMetadata = $root.proto.Message.MessageHistoryMetadata.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            MessageHistoryNotice.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.MessageHistoryNotice";
            };

            return MessageHistoryNotice;
        })();

        Message.NewsletterAdminInviteMessage = (function() {

            function NewsletterAdminInviteMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            NewsletterAdminInviteMessage.prototype.newsletterJid = "";
            NewsletterAdminInviteMessage.prototype.newsletterName = "";
            NewsletterAdminInviteMessage.prototype.jpegThumbnail = $util.newBuffer([]);
            NewsletterAdminInviteMessage.prototype.caption = "";
            NewsletterAdminInviteMessage.prototype.inviteExpiration = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            NewsletterAdminInviteMessage.prototype.contextInfo = null;

            NewsletterAdminInviteMessage.create = function create(properties) {
                return new NewsletterAdminInviteMessage(properties);
            };

            NewsletterAdminInviteMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.newsletterJid != null && Object.hasOwnProperty.call(m, "newsletterJid"))
                    w.uint32(10).string(m.newsletterJid);
                if (m.newsletterName != null && Object.hasOwnProperty.call(m, "newsletterName"))
                    w.uint32(18).string(m.newsletterName);
                if (m.jpegThumbnail != null && Object.hasOwnProperty.call(m, "jpegThumbnail"))
                    w.uint32(26).bytes(m.jpegThumbnail);
                if (m.caption != null && Object.hasOwnProperty.call(m, "caption"))
                    w.uint32(34).string(m.caption);
                if (m.inviteExpiration != null && Object.hasOwnProperty.call(m, "inviteExpiration"))
                    w.uint32(40).int64(m.inviteExpiration);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(50).fork()).ldelim();
                return w;
            };

            NewsletterAdminInviteMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.NewsletterAdminInviteMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.newsletterJid = r.string();
                            break;
                        }
                    case 2: {
                            m.newsletterName = r.string();
                            break;
                        }
                    case 3: {
                            m.jpegThumbnail = r.bytes();
                            break;
                        }
                    case 4: {
                            m.caption = r.string();
                            break;
                        }
                    case 5: {
                            m.inviteExpiration = r.int64();
                            break;
                        }
                    case 6: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            NewsletterAdminInviteMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.NewsletterAdminInviteMessage";
            };

            return NewsletterAdminInviteMessage;
        })();

        Message.OrderMessage = (function() {

            function OrderMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            OrderMessage.prototype.orderId = "";
            OrderMessage.prototype.thumbnail = $util.newBuffer([]);
            OrderMessage.prototype.itemCount = 0;
            OrderMessage.prototype.status = 1;
            OrderMessage.prototype.surface = 1;
            OrderMessage.prototype.message = "";
            OrderMessage.prototype.orderTitle = "";
            OrderMessage.prototype.sellerJid = "";
            OrderMessage.prototype.token = "";
            OrderMessage.prototype.totalAmount1000 = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
            OrderMessage.prototype.totalCurrencyCode = "";
            OrderMessage.prototype.contextInfo = null;
            OrderMessage.prototype.messageVersion = 0;
            OrderMessage.prototype.orderRequestMessageId = null;
            OrderMessage.prototype.catalogType = "";

            OrderMessage.create = function create(properties) {
                return new OrderMessage(properties);
            };

            OrderMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.orderId != null && Object.hasOwnProperty.call(m, "orderId"))
                    w.uint32(10).string(m.orderId);
                if (m.thumbnail != null && Object.hasOwnProperty.call(m, "thumbnail"))
                    w.uint32(18).bytes(m.thumbnail);
                if (m.itemCount != null && Object.hasOwnProperty.call(m, "itemCount"))
                    w.uint32(24).int32(m.itemCount);
                if (m.status != null && Object.hasOwnProperty.call(m, "status"))
                    w.uint32(32).int32(m.status);
                if (m.surface != null && Object.hasOwnProperty.call(m, "surface"))
                    w.uint32(40).int32(m.surface);
                if (m.message != null && Object.hasOwnProperty.call(m, "message"))
                    w.uint32(50).string(m.message);
                if (m.orderTitle != null && Object.hasOwnProperty.call(m, "orderTitle"))
                    w.uint32(58).string(m.orderTitle);
                if (m.sellerJid != null && Object.hasOwnProperty.call(m, "sellerJid"))
                    w.uint32(66).string(m.sellerJid);
                if (m.token != null && Object.hasOwnProperty.call(m, "token"))
                    w.uint32(74).string(m.token);
                if (m.totalAmount1000 != null && Object.hasOwnProperty.call(m, "totalAmount1000"))
                    w.uint32(80).int64(m.totalAmount1000);
                if (m.totalCurrencyCode != null && Object.hasOwnProperty.call(m, "totalCurrencyCode"))
                    w.uint32(90).string(m.totalCurrencyCode);
                if (m.messageVersion != null && Object.hasOwnProperty.call(m, "messageVersion"))
                    w.uint32(96).int32(m.messageVersion);
                if (m.orderRequestMessageId != null && Object.hasOwnProperty.call(m, "orderRequestMessageId"))
                    $root.proto.MessageKey.encode(m.orderRequestMessageId, w.uint32(106).fork()).ldelim();
                if (m.catalogType != null && Object.hasOwnProperty.call(m, "catalogType"))
                    w.uint32(122).string(m.catalogType);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            OrderMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.OrderMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.orderId = r.string();
                            break;
                        }
                    case 2: {
                            m.thumbnail = r.bytes();
                            break;
                        }
                    case 3: {
                            m.itemCount = r.int32();
                            break;
                        }
                    case 4: {
                            m.status = r.int32();
                            break;
                        }
                    case 5: {
                            m.surface = r.int32();
                            break;
                        }
                    case 6: {
                            m.message = r.string();
                            break;
                        }
                    case 7: {
                            m.orderTitle = r.string();
                            break;
                        }
                    case 8: {
                            m.sellerJid = r.string();
                            break;
                        }
                    case 9: {
                            m.token = r.string();
                            break;
                        }
                    case 10: {
                            m.totalAmount1000 = r.int64();
                            break;
                        }
                    case 11: {
                            m.totalCurrencyCode = r.string();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 12: {
                            m.messageVersion = r.int32();
                            break;
                        }
                    case 13: {
                            m.orderRequestMessageId = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 15: {
                            m.catalogType = r.string();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            OrderMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.OrderMessage";
            };

            OrderMessage.OrderStatus = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "INQUIRY"] = 1;
                values[valuesById[2] = "ACCEPTED"] = 2;
                values[valuesById[3] = "DECLINED"] = 3;
                return values;
            })();

            OrderMessage.OrderSurface = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[1] = "CATALOG"] = 1;
                return values;
            })();

            return OrderMessage;
        })();

        Message.PaymentInviteMessage = (function() {

            function PaymentInviteMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PaymentInviteMessage.prototype.serviceType = 0;
            PaymentInviteMessage.prototype.expiryTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            PaymentInviteMessage.create = function create(properties) {
                return new PaymentInviteMessage(properties);
            };

            PaymentInviteMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.serviceType != null && Object.hasOwnProperty.call(m, "serviceType"))
                    w.uint32(8).int32(m.serviceType);
                if (m.expiryTimestamp != null && Object.hasOwnProperty.call(m, "expiryTimestamp"))
                    w.uint32(16).int64(m.expiryTimestamp);
                return w;
            };

            PaymentInviteMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PaymentInviteMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.serviceType = r.int32();
                            break;
                        }
                    case 2: {
                            m.expiryTimestamp = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PaymentInviteMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PaymentInviteMessage";
            };

            PaymentInviteMessage.ServiceType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN"] = 0;
                values[valuesById[1] = "FBPAY"] = 1;
                values[valuesById[2] = "NOVI"] = 2;
                values[valuesById[3] = "UPI"] = 3;
                return values;
            })();

            return PaymentInviteMessage;
        })();

        Message.PaymentLinkMetadata = (function() {

            function PaymentLinkMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PaymentLinkMetadata.prototype.button = null;
            PaymentLinkMetadata.prototype.header = null;

            PaymentLinkMetadata.create = function create(properties) {
                return new PaymentLinkMetadata(properties);
            };

            PaymentLinkMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.button != null && Object.hasOwnProperty.call(m, "button"))
                    $root.proto.Message.PaymentLinkMetadata.PaymentLinkButton.encode(m.button, w.uint32(10).fork()).ldelim();
                if (m.header != null && Object.hasOwnProperty.call(m, "header"))
                    $root.proto.Message.PaymentLinkMetadata.PaymentLinkHeader.encode(m.header, w.uint32(18).fork()).ldelim();
                return w;
            };

            PaymentLinkMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PaymentLinkMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.button = $root.proto.Message.PaymentLinkMetadata.PaymentLinkButton.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.header = $root.proto.Message.PaymentLinkMetadata.PaymentLinkHeader.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PaymentLinkMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PaymentLinkMetadata";
            };

            PaymentLinkMetadata.PaymentLinkButton = (function() {

                function PaymentLinkButton(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                PaymentLinkButton.prototype.displayText = "";

                PaymentLinkButton.create = function create(properties) {
                    return new PaymentLinkButton(properties);
                };

                PaymentLinkButton.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.displayText != null && Object.hasOwnProperty.call(m, "displayText"))
                        w.uint32(10).string(m.displayText);
                    return w;
                };

                PaymentLinkButton.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PaymentLinkMetadata.PaymentLinkButton();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.displayText = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                PaymentLinkButton.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PaymentLinkMetadata.PaymentLinkButton";
                };

                return PaymentLinkButton;
            })();

            PaymentLinkMetadata.PaymentLinkHeader = (function() {

                function PaymentLinkHeader(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                PaymentLinkHeader.prototype.headerType = 0;

                PaymentLinkHeader.create = function create(properties) {
                    return new PaymentLinkHeader(properties);
                };

                PaymentLinkHeader.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.headerType != null && Object.hasOwnProperty.call(m, "headerType"))
                        w.uint32(8).int32(m.headerType);
                    return w;
                };

                PaymentLinkHeader.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PaymentLinkMetadata.PaymentLinkHeader();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.headerType = r.int32();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                PaymentLinkHeader.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PaymentLinkMetadata.PaymentLinkHeader";
                };

                PaymentLinkHeader.PaymentLinkHeaderType = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "LINK_PREVIEW"] = 0;
                    values[valuesById[1] = "ORDER"] = 1;
                    return values;
                })();

                return PaymentLinkHeader;
            })();

            return PaymentLinkMetadata;
        })();

        Message.PeerDataOperationRequestMessage = (function() {

            function PeerDataOperationRequestMessage(p) {
                this.requestStickerReupload = [];
                this.requestUrlPreview = [];
                this.placeholderMessageResendRequest = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PeerDataOperationRequestMessage.prototype.peerDataOperationRequestType = 0;
            PeerDataOperationRequestMessage.prototype.requestStickerReupload = $util.emptyArray;
            PeerDataOperationRequestMessage.prototype.requestUrlPreview = $util.emptyArray;
            PeerDataOperationRequestMessage.prototype.historySyncOnDemandRequest = null;
            PeerDataOperationRequestMessage.prototype.placeholderMessageResendRequest = $util.emptyArray;
            PeerDataOperationRequestMessage.prototype.fullHistorySyncOnDemandRequest = null;
            PeerDataOperationRequestMessage.prototype.syncdCollectionFatalRecoveryRequest = null;

            PeerDataOperationRequestMessage.create = function create(properties) {
                return new PeerDataOperationRequestMessage(properties);
            };

            PeerDataOperationRequestMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.peerDataOperationRequestType != null && Object.hasOwnProperty.call(m, "peerDataOperationRequestType"))
                    w.uint32(8).int32(m.peerDataOperationRequestType);
                if (m.requestStickerReupload != null && m.requestStickerReupload.length) {
                    for (var i = 0; i < m.requestStickerReupload.length; ++i)
                        $root.proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload.encode(m.requestStickerReupload[i], w.uint32(18).fork()).ldelim();
                }
                if (m.requestUrlPreview != null && m.requestUrlPreview.length) {
                    for (var i = 0; i < m.requestUrlPreview.length; ++i)
                        $root.proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview.encode(m.requestUrlPreview[i], w.uint32(26).fork()).ldelim();
                }
                if (m.historySyncOnDemandRequest != null && Object.hasOwnProperty.call(m, "historySyncOnDemandRequest"))
                    $root.proto.Message.PeerDataOperationRequestMessage.HistorySyncOnDemandRequest.encode(m.historySyncOnDemandRequest, w.uint32(34).fork()).ldelim();
                if (m.placeholderMessageResendRequest != null && m.placeholderMessageResendRequest.length) {
                    for (var i = 0; i < m.placeholderMessageResendRequest.length; ++i)
                        $root.proto.Message.PeerDataOperationRequestMessage.PlaceholderMessageResendRequest.encode(m.placeholderMessageResendRequest[i], w.uint32(42).fork()).ldelim();
                }
                if (m.fullHistorySyncOnDemandRequest != null && Object.hasOwnProperty.call(m, "fullHistorySyncOnDemandRequest"))
                    $root.proto.Message.PeerDataOperationRequestMessage.FullHistorySyncOnDemandRequest.encode(m.fullHistorySyncOnDemandRequest, w.uint32(50).fork()).ldelim();
                if (m.syncdCollectionFatalRecoveryRequest != null && Object.hasOwnProperty.call(m, "syncdCollectionFatalRecoveryRequest"))
                    $root.proto.Message.PeerDataOperationRequestMessage.SyncDCollectionFatalRecoveryRequest.encode(m.syncdCollectionFatalRecoveryRequest, w.uint32(58).fork()).ldelim();
                return w;
            };

            PeerDataOperationRequestMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.peerDataOperationRequestType = r.int32();
                            break;
                        }
                    case 2: {
                            if (!(m.requestStickerReupload && m.requestStickerReupload.length))
                                m.requestStickerReupload = [];
                            m.requestStickerReupload.push($root.proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload.decode(r, r.uint32()));
                            break;
                        }
                    case 3: {
                            if (!(m.requestUrlPreview && m.requestUrlPreview.length))
                                m.requestUrlPreview = [];
                            m.requestUrlPreview.push($root.proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview.decode(r, r.uint32()));
                            break;
                        }
                    case 4: {
                            m.historySyncOnDemandRequest = $root.proto.Message.PeerDataOperationRequestMessage.HistorySyncOnDemandRequest.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            if (!(m.placeholderMessageResendRequest && m.placeholderMessageResendRequest.length))
                                m.placeholderMessageResendRequest = [];
                            m.placeholderMessageResendRequest.push($root.proto.Message.PeerDataOperationRequestMessage.PlaceholderMessageResendRequest.decode(r, r.uint32()));
                            break;
                        }
                    case 6: {
                            m.fullHistorySyncOnDemandRequest = $root.proto.Message.PeerDataOperationRequestMessage.FullHistorySyncOnDemandRequest.decode(r, r.uint32());
                            break;
                        }
                    case 7: {
                            m.syncdCollectionFatalRecoveryRequest = $root.proto.Message.PeerDataOperationRequestMessage.SyncDCollectionFatalRecoveryRequest.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PeerDataOperationRequestMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage";
            };

            PeerDataOperationRequestMessage.FullHistorySyncOnDemandRequest = (function() {

                function FullHistorySyncOnDemandRequest(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                FullHistorySyncOnDemandRequest.prototype.requestMetadata = null;
                FullHistorySyncOnDemandRequest.prototype.historySyncConfig = null;

                FullHistorySyncOnDemandRequest.create = function create(properties) {
                    return new FullHistorySyncOnDemandRequest(properties);
                };

                FullHistorySyncOnDemandRequest.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.requestMetadata != null && Object.hasOwnProperty.call(m, "requestMetadata"))
                        $root.proto.Message.FullHistorySyncOnDemandRequestMetadata.encode(m.requestMetadata, w.uint32(10).fork()).ldelim();
                    if (m.historySyncConfig != null && Object.hasOwnProperty.call(m, "historySyncConfig"))
                        $root.proto.DeviceProps.HistorySyncConfig.encode(m.historySyncConfig, w.uint32(18).fork()).ldelim();
                    return w;
                };

                FullHistorySyncOnDemandRequest.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage.FullHistorySyncOnDemandRequest();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.requestMetadata = $root.proto.Message.FullHistorySyncOnDemandRequestMetadata.decode(r, r.uint32());
                                break;
                            }
                        case 2: {
                                m.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                FullHistorySyncOnDemandRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage.FullHistorySyncOnDemandRequest";
                };

                return FullHistorySyncOnDemandRequest;
            })();

            PeerDataOperationRequestMessage.HistorySyncOnDemandRequest = (function() {

                function HistorySyncOnDemandRequest(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                HistorySyncOnDemandRequest.prototype.chatJid = "";
                HistorySyncOnDemandRequest.prototype.oldestMsgId = "";
                HistorySyncOnDemandRequest.prototype.oldestMsgFromMe = false;
                HistorySyncOnDemandRequest.prototype.onDemandMsgCount = 0;
                HistorySyncOnDemandRequest.prototype.oldestMsgTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
                HistorySyncOnDemandRequest.prototype.accountLid = "";

                HistorySyncOnDemandRequest.create = function create(properties) {
                    return new HistorySyncOnDemandRequest(properties);
                };

                HistorySyncOnDemandRequest.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.chatJid != null && Object.hasOwnProperty.call(m, "chatJid"))
                        w.uint32(10).string(m.chatJid);
                    if (m.oldestMsgId != null && Object.hasOwnProperty.call(m, "oldestMsgId"))
                        w.uint32(18).string(m.oldestMsgId);
                    if (m.oldestMsgFromMe != null && Object.hasOwnProperty.call(m, "oldestMsgFromMe"))
                        w.uint32(24).bool(m.oldestMsgFromMe);
                    if (m.onDemandMsgCount != null && Object.hasOwnProperty.call(m, "onDemandMsgCount"))
                        w.uint32(32).int32(m.onDemandMsgCount);
                    if (m.oldestMsgTimestampMs != null && Object.hasOwnProperty.call(m, "oldestMsgTimestampMs"))
                        w.uint32(40).int64(m.oldestMsgTimestampMs);
                    if (m.accountLid != null && Object.hasOwnProperty.call(m, "accountLid"))
                        w.uint32(50).string(m.accountLid);
                    return w;
                };

                HistorySyncOnDemandRequest.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage.HistorySyncOnDemandRequest();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.chatJid = r.string();
                                break;
                            }
                        case 2: {
                                m.oldestMsgId = r.string();
                                break;
                            }
                        case 3: {
                                m.oldestMsgFromMe = r.bool();
                                break;
                            }
                        case 4: {
                                m.onDemandMsgCount = r.int32();
                                break;
                            }
                        case 5: {
                                m.oldestMsgTimestampMs = r.int64();
                                break;
                            }
                        case 6: {
                                m.accountLid = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                HistorySyncOnDemandRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage.HistorySyncOnDemandRequest";
                };

                return HistorySyncOnDemandRequest;
            })();

            PeerDataOperationRequestMessage.PlaceholderMessageResendRequest = (function() {

                function PlaceholderMessageResendRequest(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                PlaceholderMessageResendRequest.prototype.messageKey = null;

                PlaceholderMessageResendRequest.create = function create(properties) {
                    return new PlaceholderMessageResendRequest(properties);
                };

                PlaceholderMessageResendRequest.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.messageKey != null && Object.hasOwnProperty.call(m, "messageKey"))
                        $root.proto.MessageKey.encode(m.messageKey, w.uint32(10).fork()).ldelim();
                    return w;
                };

                PlaceholderMessageResendRequest.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage.PlaceholderMessageResendRequest();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.messageKey = $root.proto.MessageKey.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                PlaceholderMessageResendRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage.PlaceholderMessageResendRequest";
                };

                return PlaceholderMessageResendRequest;
            })();

            PeerDataOperationRequestMessage.RequestStickerReupload = (function() {

                function RequestStickerReupload(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                RequestStickerReupload.prototype.fileSha256 = "";

                RequestStickerReupload.create = function create(properties) {
                    return new RequestStickerReupload(properties);
                };

                RequestStickerReupload.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.fileSha256 != null && Object.hasOwnProperty.call(m, "fileSha256"))
                        w.uint32(10).string(m.fileSha256);
                    return w;
                };

                RequestStickerReupload.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.fileSha256 = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                RequestStickerReupload.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage.RequestStickerReupload";
                };

                return RequestStickerReupload;
            })();

            PeerDataOperationRequestMessage.RequestUrlPreview = (function() {

                function RequestUrlPreview(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                RequestUrlPreview.prototype.url = "";
                RequestUrlPreview.prototype.includeHqThumbnail = false;

                RequestUrlPreview.create = function create(properties) {
                    return new RequestUrlPreview(properties);
                };

                RequestUrlPreview.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                        w.uint32(10).string(m.url);
                    if (m.includeHqThumbnail != null && Object.hasOwnProperty.call(m, "includeHqThumbnail"))
                        w.uint32(16).bool(m.includeHqThumbnail);
                    return w;
                };

                RequestUrlPreview.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.url = r.string();
                                break;
                            }
                        case 2: {
                                m.includeHqThumbnail = r.bool();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                RequestUrlPreview.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage.RequestUrlPreview";
                };

                return RequestUrlPreview;
            })();

            PeerDataOperationRequestMessage.SyncDCollectionFatalRecoveryRequest = (function() {

                function SyncDCollectionFatalRecoveryRequest(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                SyncDCollectionFatalRecoveryRequest.prototype.collectionName = "";
                SyncDCollectionFatalRecoveryRequest.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

                SyncDCollectionFatalRecoveryRequest.create = function create(properties) {
                    return new SyncDCollectionFatalRecoveryRequest(properties);
                };

                SyncDCollectionFatalRecoveryRequest.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.collectionName != null && Object.hasOwnProperty.call(m, "collectionName"))
                        w.uint32(10).string(m.collectionName);
                    if (m.timestamp != null && Object.hasOwnProperty.call(m, "timestamp"))
                        w.uint32(16).int64(m.timestamp);
                    return w;
                };

                SyncDCollectionFatalRecoveryRequest.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestMessage.SyncDCollectionFatalRecoveryRequest();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.collectionName = r.string();
                                break;
                            }
                        case 2: {
                                m.timestamp = r.int64();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                SyncDCollectionFatalRecoveryRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestMessage.SyncDCollectionFatalRecoveryRequest";
                };

                return SyncDCollectionFatalRecoveryRequest;
            })();

            return PeerDataOperationRequestMessage;
        })();

        Message.PeerDataOperationRequestResponseMessage = (function() {

            function PeerDataOperationRequestResponseMessage(p) {
                this.peerDataOperationResult = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PeerDataOperationRequestResponseMessage.prototype.peerDataOperationRequestType = 0;
            PeerDataOperationRequestResponseMessage.prototype.stanzaId = "";
            PeerDataOperationRequestResponseMessage.prototype.peerDataOperationResult = $util.emptyArray;

            PeerDataOperationRequestResponseMessage.create = function create(properties) {
                return new PeerDataOperationRequestResponseMessage(properties);
            };

            PeerDataOperationRequestResponseMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.peerDataOperationRequestType != null && Object.hasOwnProperty.call(m, "peerDataOperationRequestType"))
                    w.uint32(8).int32(m.peerDataOperationRequestType);
                if (m.stanzaId != null && Object.hasOwnProperty.call(m, "stanzaId"))
                    w.uint32(18).string(m.stanzaId);
                if (m.peerDataOperationResult != null && m.peerDataOperationResult.length) {
                    for (var i = 0; i < m.peerDataOperationResult.length; ++i)
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.encode(m.peerDataOperationResult[i], w.uint32(26).fork()).ldelim();
                }
                return w;
            };

            PeerDataOperationRequestResponseMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.peerDataOperationRequestType = r.int32();
                            break;
                        }
                    case 2: {
                            m.stanzaId = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.peerDataOperationResult && m.peerDataOperationResult.length))
                                m.peerDataOperationResult = [];
                            m.peerDataOperationResult.push($root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.decode(r, r.uint32()));
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PeerDataOperationRequestResponseMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage";
            };

            PeerDataOperationRequestResponseMessage.PeerDataOperationResult = (function() {

                function PeerDataOperationResult(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                PeerDataOperationResult.prototype.mediaUploadResult = 0;
                PeerDataOperationResult.prototype.stickerMessage = null;
                PeerDataOperationResult.prototype.linkPreviewResponse = null;
                PeerDataOperationResult.prototype.placeholderMessageResendResponse = null;
                PeerDataOperationResult.prototype.waffleNonceFetchRequestResponse = null;
                PeerDataOperationResult.prototype.fullHistorySyncOnDemandRequestResponse = null;
                PeerDataOperationResult.prototype.companionMetaNonceFetchRequestResponse = null;
                PeerDataOperationResult.prototype.syncdSnapshotFatalRecoveryResponse = null;

                PeerDataOperationResult.create = function create(properties) {
                    return new PeerDataOperationResult(properties);
                };

                PeerDataOperationResult.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.mediaUploadResult != null && Object.hasOwnProperty.call(m, "mediaUploadResult"))
                        w.uint32(8).int32(m.mediaUploadResult);
                    if (m.stickerMessage != null && Object.hasOwnProperty.call(m, "stickerMessage"))
                        $root.proto.Message.StickerMessage.encode(m.stickerMessage, w.uint32(18).fork()).ldelim();
                    if (m.linkPreviewResponse != null && Object.hasOwnProperty.call(m, "linkPreviewResponse"))
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.encode(m.linkPreviewResponse, w.uint32(26).fork()).ldelim();
                    if (m.placeholderMessageResendResponse != null && Object.hasOwnProperty.call(m, "placeholderMessageResendResponse"))
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.PlaceholderMessageResendResponse.encode(m.placeholderMessageResendResponse, w.uint32(34).fork()).ldelim();
                    if (m.waffleNonceFetchRequestResponse != null && Object.hasOwnProperty.call(m, "waffleNonceFetchRequestResponse"))
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.WaffleNonceFetchResponse.encode(m.waffleNonceFetchRequestResponse, w.uint32(42).fork()).ldelim();
                    if (m.fullHistorySyncOnDemandRequestResponse != null && Object.hasOwnProperty.call(m, "fullHistorySyncOnDemandRequestResponse"))
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.FullHistorySyncOnDemandRequestResponse.encode(m.fullHistorySyncOnDemandRequestResponse, w.uint32(50).fork()).ldelim();
                    if (m.companionMetaNonceFetchRequestResponse != null && Object.hasOwnProperty.call(m, "companionMetaNonceFetchRequestResponse"))
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.CompanionMetaNonceFetchResponse.encode(m.companionMetaNonceFetchRequestResponse, w.uint32(58).fork()).ldelim();
                    if (m.syncdSnapshotFatalRecoveryResponse != null && Object.hasOwnProperty.call(m, "syncdSnapshotFatalRecoveryResponse"))
                        $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.SyncDSnapshotFatalRecoveryResponse.encode(m.syncdSnapshotFatalRecoveryResponse, w.uint32(66).fork()).ldelim();
                    return w;
                };

                PeerDataOperationResult.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.mediaUploadResult = r.int32();
                                break;
                            }
                        case 2: {
                                m.stickerMessage = $root.proto.Message.StickerMessage.decode(r, r.uint32());
                                break;
                            }
                        case 3: {
                                m.linkPreviewResponse = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.decode(r, r.uint32());
                                break;
                            }
                        case 4: {
                                m.placeholderMessageResendResponse = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.PlaceholderMessageResendResponse.decode(r, r.uint32());
                                break;
                            }
                        case 5: {
                                m.waffleNonceFetchRequestResponse = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.WaffleNonceFetchResponse.decode(r, r.uint32());
                                break;
                            }
                        case 6: {
                                m.fullHistorySyncOnDemandRequestResponse = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.FullHistorySyncOnDemandRequestResponse.decode(r, r.uint32());
                                break;
                            }
                        case 7: {
                                m.companionMetaNonceFetchRequestResponse = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.CompanionMetaNonceFetchResponse.decode(r, r.uint32());
                                break;
                            }
                        case 8: {
                                m.syncdSnapshotFatalRecoveryResponse = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.SyncDSnapshotFatalRecoveryResponse.decode(r, r.uint32());
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                PeerDataOperationResult.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult";
                };

                PeerDataOperationResult.CompanionMetaNonceFetchResponse = (function() {

                    function CompanionMetaNonceFetchResponse(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    CompanionMetaNonceFetchResponse.prototype.nonce = "";

                    CompanionMetaNonceFetchResponse.create = function create(properties) {
                        return new CompanionMetaNonceFetchResponse(properties);
                    };

                    CompanionMetaNonceFetchResponse.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.nonce != null && Object.hasOwnProperty.call(m, "nonce"))
                            w.uint32(10).string(m.nonce);
                        return w;
                    };

                    CompanionMetaNonceFetchResponse.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.CompanionMetaNonceFetchResponse();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.nonce = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    CompanionMetaNonceFetchResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.CompanionMetaNonceFetchResponse";
                    };

                    return CompanionMetaNonceFetchResponse;
                })();

                PeerDataOperationResult.FullHistorySyncOnDemandRequestResponse = (function() {

                    function FullHistorySyncOnDemandRequestResponse(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    FullHistorySyncOnDemandRequestResponse.prototype.requestMetadata = null;
                    FullHistorySyncOnDemandRequestResponse.prototype.responseCode = 0;

                    FullHistorySyncOnDemandRequestResponse.create = function create(properties) {
                        return new FullHistorySyncOnDemandRequestResponse(properties);
                    };

                    FullHistorySyncOnDemandRequestResponse.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.requestMetadata != null && Object.hasOwnProperty.call(m, "requestMetadata"))
                            $root.proto.Message.FullHistorySyncOnDemandRequestMetadata.encode(m.requestMetadata, w.uint32(10).fork()).ldelim();
                        if (m.responseCode != null && Object.hasOwnProperty.call(m, "responseCode"))
                            w.uint32(16).int32(m.responseCode);
                        return w;
                    };

                    FullHistorySyncOnDemandRequestResponse.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.FullHistorySyncOnDemandRequestResponse();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.requestMetadata = $root.proto.Message.FullHistorySyncOnDemandRequestMetadata.decode(r, r.uint32());
                                    break;
                                }
                            case 2: {
                                    m.responseCode = r.int32();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    FullHistorySyncOnDemandRequestResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.FullHistorySyncOnDemandRequestResponse";
                    };

                    return FullHistorySyncOnDemandRequestResponse;
                })();

                PeerDataOperationResult.FullHistorySyncOnDemandResponseCode = (function() {
                    const valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "REQUEST_SUCCESS"] = 0;
                    values[valuesById[1] = "REQUEST_TIME_EXPIRED"] = 1;
                    values[valuesById[2] = "DECLINED_SHARING_HISTORY"] = 2;
                    values[valuesById[3] = "GENERIC_ERROR"] = 3;
                    values[valuesById[4] = "ERROR_REQUEST_ON_NON_SMB_PRIMARY"] = 4;
                    values[valuesById[5] = "ERROR_HOSTED_DEVICE_NOT_CONNECTED"] = 5;
                    values[valuesById[6] = "ERROR_HOSTED_DEVICE_LOGIN_TIME_NOT_SET"] = 6;
                    return values;
                })();

                PeerDataOperationResult.LinkPreviewResponse = (function() {

                    function LinkPreviewResponse(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    LinkPreviewResponse.prototype.url = "";
                    LinkPreviewResponse.prototype.title = "";
                    LinkPreviewResponse.prototype.description = "";
                    LinkPreviewResponse.prototype.thumbData = $util.newBuffer([]);
                    LinkPreviewResponse.prototype.matchText = "";
                    LinkPreviewResponse.prototype.previewType = "";
                    LinkPreviewResponse.prototype.hqThumbnail = null;

                    LinkPreviewResponse.create = function create(properties) {
                        return new LinkPreviewResponse(properties);
                    };

                    LinkPreviewResponse.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                            w.uint32(10).string(m.url);
                        if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                            w.uint32(18).string(m.title);
                        if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                            w.uint32(26).string(m.description);
                        if (m.thumbData != null && Object.hasOwnProperty.call(m, "thumbData"))
                            w.uint32(34).bytes(m.thumbData);
                        if (m.matchText != null && Object.hasOwnProperty.call(m, "matchText"))
                            w.uint32(50).string(m.matchText);
                        if (m.previewType != null && Object.hasOwnProperty.call(m, "previewType"))
                            w.uint32(58).string(m.previewType);
                        if (m.hqThumbnail != null && Object.hasOwnProperty.call(m, "hqThumbnail"))
                            $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.LinkPreviewHighQualityThumbnail.encode(m.hqThumbnail, w.uint32(66).fork()).ldelim();
                        return w;
                    };

                    LinkPreviewResponse.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.url = r.string();
                                    break;
                                }
                            case 2: {
                                    m.title = r.string();
                                    break;
                                }
                            case 3: {
                                    m.description = r.string();
                                    break;
                                }
                            case 4: {
                                    m.thumbData = r.bytes();
                                    break;
                                }
                            case 6: {
                                    m.matchText = r.string();
                                    break;
                                }
                            case 7: {
                                    m.previewType = r.string();
                                    break;
                                }
                            case 8: {
                                    m.hqThumbnail = $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.LinkPreviewHighQualityThumbnail.decode(r, r.uint32());
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    LinkPreviewResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse";
                    };

                    LinkPreviewResponse.LinkPreviewHighQualityThumbnail = (function() {

                        function LinkPreviewHighQualityThumbnail(p) {
                            if (p)
                                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                    if (p[ks[i]] != null)
                                        this[ks[i]] = p[ks[i]];
                        }

                        LinkPreviewHighQualityThumbnail.prototype.directPath = "";
                        LinkPreviewHighQualityThumbnail.prototype.thumbHash = "";
                        LinkPreviewHighQualityThumbnail.prototype.encThumbHash = "";
                        LinkPreviewHighQualityThumbnail.prototype.mediaKey = $util.newBuffer([]);
                        LinkPreviewHighQualityThumbnail.prototype.mediaKeyTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
                        LinkPreviewHighQualityThumbnail.prototype.thumbWidth = 0;
                        LinkPreviewHighQualityThumbnail.prototype.thumbHeight = 0;

                        LinkPreviewHighQualityThumbnail.create = function create(properties) {
                            return new LinkPreviewHighQualityThumbnail(properties);
                        };

                        LinkPreviewHighQualityThumbnail.encode = function encode(m, w) {
                            if (!w)
                                w = $Writer.create();
                            if (m.directPath != null && Object.hasOwnProperty.call(m, "directPath"))
                                w.uint32(10).string(m.directPath);
                            if (m.thumbHash != null && Object.hasOwnProperty.call(m, "thumbHash"))
                                w.uint32(18).string(m.thumbHash);
                            if (m.encThumbHash != null && Object.hasOwnProperty.call(m, "encThumbHash"))
                                w.uint32(26).string(m.encThumbHash);
                            if (m.mediaKey != null && Object.hasOwnProperty.call(m, "mediaKey"))
                                w.uint32(34).bytes(m.mediaKey);
                            if (m.mediaKeyTimestampMs != null && Object.hasOwnProperty.call(m, "mediaKeyTimestampMs"))
                                w.uint32(40).int64(m.mediaKeyTimestampMs);
                            if (m.thumbWidth != null && Object.hasOwnProperty.call(m, "thumbWidth"))
                                w.uint32(48).int32(m.thumbWidth);
                            if (m.thumbHeight != null && Object.hasOwnProperty.call(m, "thumbHeight"))
                                w.uint32(56).int32(m.thumbHeight);
                            return w;
                        };

                        LinkPreviewHighQualityThumbnail.decode = function decode(r, l, e) {
                            if (!(r instanceof $Reader))
                                r = $Reader.create(r);
                            var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.LinkPreviewHighQualityThumbnail();
                            while (r.pos < c) {
                                var t = r.uint32();
                                if (t === e)
                                    break;
                                switch (t >>> 3) {
                                case 1: {
                                        m.directPath = r.string();
                                        break;
                                    }
                                case 2: {
                                        m.thumbHash = r.string();
                                        break;
                                    }
                                case 3: {
                                        m.encThumbHash = r.string();
                                        break;
                                    }
                                case 4: {
                                        m.mediaKey = r.bytes();
                                        break;
                                    }
                                case 5: {
                                        m.mediaKeyTimestampMs = r.int64();
                                        break;
                                    }
                                case 6: {
                                        m.thumbWidth = r.int32();
                                        break;
                                    }
                                case 7: {
                                        m.thumbHeight = r.int32();
                                        break;
                                    }
                                default:
                                    r.skipType(t & 7);
                                    break;
                                }
                            }
                            return m;
                        };

                        LinkPreviewHighQualityThumbnail.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.LinkPreviewResponse.LinkPreviewHighQualityThumbnail";
                        };

                        return LinkPreviewHighQualityThumbnail;
                    })();

                    return LinkPreviewResponse;
                })();

                PeerDataOperationResult.PlaceholderMessageResendResponse = (function() {

                    function PlaceholderMessageResendResponse(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    PlaceholderMessageResendResponse.prototype.webMessageInfoBytes = $util.newBuffer([]);

                    PlaceholderMessageResendResponse.create = function create(properties) {
                        return new PlaceholderMessageResendResponse(properties);
                    };

                    PlaceholderMessageResendResponse.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.webMessageInfoBytes != null && Object.hasOwnProperty.call(m, "webMessageInfoBytes"))
                            w.uint32(10).bytes(m.webMessageInfoBytes);
                        return w;
                    };

                    PlaceholderMessageResendResponse.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.PlaceholderMessageResendResponse();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.webMessageInfoBytes = r.bytes();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    PlaceholderMessageResendResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.PlaceholderMessageResendResponse";
                    };

                    return PlaceholderMessageResendResponse;
                })();

                PeerDataOperationResult.SyncDSnapshotFatalRecoveryResponse = (function() {

                    function SyncDSnapshotFatalRecoveryResponse(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    SyncDSnapshotFatalRecoveryResponse.prototype.collectionSnapshot = $util.newBuffer([]);
                    SyncDSnapshotFatalRecoveryResponse.prototype.isCompressed = false;

                    SyncDSnapshotFatalRecoveryResponse.create = function create(properties) {
                        return new SyncDSnapshotFatalRecoveryResponse(properties);
                    };

                    SyncDSnapshotFatalRecoveryResponse.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.collectionSnapshot != null && Object.hasOwnProperty.call(m, "collectionSnapshot"))
                            w.uint32(10).bytes(m.collectionSnapshot);
                        if (m.isCompressed != null && Object.hasOwnProperty.call(m, "isCompressed"))
                            w.uint32(16).bool(m.isCompressed);
                        return w;
                    };

                    SyncDSnapshotFatalRecoveryResponse.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.SyncDSnapshotFatalRecoveryResponse();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.collectionSnapshot = r.bytes();
                                    break;
                                }
                            case 2: {
                                    m.isCompressed = r.bool();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    SyncDSnapshotFatalRecoveryResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.SyncDSnapshotFatalRecoveryResponse";
                    };

                    return SyncDSnapshotFatalRecoveryResponse;
                })();

                PeerDataOperationResult.WaffleNonceFetchResponse = (function() {

                    function WaffleNonceFetchResponse(p) {
                        if (p)
                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                                if (p[ks[i]] != null)
                                    this[ks[i]] = p[ks[i]];
                    }

                    WaffleNonceFetchResponse.prototype.nonce = "";
                    WaffleNonceFetchResponse.prototype.waEntFbid = "";

                    WaffleNonceFetchResponse.create = function create(properties) {
                        return new WaffleNonceFetchResponse(properties);
                    };

                    WaffleNonceFetchResponse.encode = function encode(m, w) {
                        if (!w)
                            w = $Writer.create();
                        if (m.nonce != null && Object.hasOwnProperty.call(m, "nonce"))
                            w.uint32(10).string(m.nonce);
                        if (m.waEntFbid != null && Object.hasOwnProperty.call(m, "waEntFbid"))
                            w.uint32(18).string(m.waEntFbid);
                        return w;
                    };

                    WaffleNonceFetchResponse.decode = function decode(r, l, e) {
                        if (!(r instanceof $Reader))
                            r = $Reader.create(r);
                        var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.WaffleNonceFetchResponse();
                        while (r.pos < c) {
                            var t = r.uint32();
                            if (t === e)
                                break;
                            switch (t >>> 3) {
                            case 1: {
                                    m.nonce = r.string();
                                    break;
                                }
                            case 2: {
                                    m.waEntFbid = r.string();
                                    break;
                                }
                            default:
                                r.skipType(t & 7);
                                break;
                            }
                        }
                        return m;
                    };

                    WaffleNonceFetchResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/proto.Message.PeerDataOperationRequestResponseMessage.PeerDataOperationResult.WaffleNonceFetchResponse";
                    };

                    return WaffleNonceFetchResponse;
                })();

                return PeerDataOperationResult;
            })();

            return PeerDataOperationRequestResponseMessage;
        })();

        Message.PeerDataOperationRequestType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UPLOAD_STICKER"] = 0;
            values[valuesById[1] = "SEND_RECENT_STICKER_BOOTSTRAP"] = 1;
            values[valuesById[2] = "GENERATE_LINK_PREVIEW"] = 2;
            values[valuesById[3] = "HISTORY_SYNC_ON_DEMAND"] = 3;
            values[valuesById[4] = "PLACEHOLDER_MESSAGE_RESEND"] = 4;
            values[valuesById[5] = "WAFFLE_LINKING_NONCE_FETCH"] = 5;
            values[valuesById[6] = "FULL_HISTORY_SYNC_ON_DEMAND"] = 6;
            values[valuesById[7] = "COMPANION_META_NONCE_FETCH"] = 7;
            values[valuesById[8] = "COMPANION_SYNCD_SNAPSHOT_FATAL_RECOVERY"] = 8;
            return values;
        })();

        Message.PinInChatMessage = (function() {

            function PinInChatMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PinInChatMessage.prototype.key = null;
            PinInChatMessage.prototype.type = 0;
            PinInChatMessage.prototype.senderTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            PinInChatMessage.create = function create(properties) {
                return new PinInChatMessage(properties);
            };

            PinInChatMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.key != null && Object.hasOwnProperty.call(m, "key"))
                    $root.proto.MessageKey.encode(m.key, w.uint32(10).fork()).ldelim();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(16).int32(m.type);
                if (m.senderTimestampMs != null && Object.hasOwnProperty.call(m, "senderTimestampMs"))
                    w.uint32(24).int64(m.senderTimestampMs);
                return w;
            };

            PinInChatMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PinInChatMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.key = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.type = r.int32();
                            break;
                        }
                    case 3: {
                            m.senderTimestampMs = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PinInChatMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PinInChatMessage";
            };

            PinInChatMessage.Type = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNKNOWN_TYPE"] = 0;
                values[valuesById[1] = "PIN_FOR_ALL"] = 1;
                values[valuesById[2] = "UNPIN_FOR_ALL"] = 2;
                return values;
            })();

            return PinInChatMessage;
        })();

        Message.PlaceholderMessage = (function() {

            function PlaceholderMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PlaceholderMessage.prototype.type = 0;

            PlaceholderMessage.create = function create(properties) {
                return new PlaceholderMessage(properties);
            };

            PlaceholderMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.type != null && Object.hasOwnProperty.call(m, "type"))
                    w.uint32(8).int32(m.type);
                return w;
            };

            PlaceholderMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PlaceholderMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.type = r.int32();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PlaceholderMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PlaceholderMessage";
            };

            PlaceholderMessage.PlaceholderType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "MASK_LINKED_DEVICES"] = 0;
                return values;
            })();

            return PlaceholderMessage;
        })();

        Message.PollContentType = (function() {
            const valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "TEXT"] = 1;
            values[valuesById[2] = "IMAGE"] = 2;
            return values;
        })();

        Message.PollCreationMessage = (function() {

            function PollCreationMessage(p) {
                this.options = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PollCreationMessage.prototype.encKey = $util.newBuffer([]);
            PollCreationMessage.prototype.name = "";
            PollCreationMessage.prototype.options = $util.emptyArray;
            PollCreationMessage.prototype.selectableOptionsCount = 0;
            PollCreationMessage.prototype.contextInfo = null;
            PollCreationMessage.prototype.pollContentType = 0;
            PollCreationMessage.prototype.pollType = 0;
            PollCreationMessage.prototype.correctAnswer = null;

            PollCreationMessage.create = function create(properties) {
                return new PollCreationMessage(properties);
            };

            PollCreationMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.encKey != null && Object.hasOwnProperty.call(m, "encKey"))
                    w.uint32(10).bytes(m.encKey);
                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                    w.uint32(18).string(m.name);
                if (m.options != null && m.options.length) {
                    for (var i = 0; i < m.options.length; ++i)
                        $root.proto.Message.PollCreationMessage.Option.encode(m.options[i], w.uint32(26).fork()).ldelim();
                }
                if (m.selectableOptionsCount != null && Object.hasOwnProperty.call(m, "selectableOptionsCount"))
                    w.uint32(32).uint32(m.selectableOptionsCount);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(42).fork()).ldelim();
                if (m.pollContentType != null && Object.hasOwnProperty.call(m, "pollContentType"))
                    w.uint32(48).int32(m.pollContentType);
                if (m.pollType != null && Object.hasOwnProperty.call(m, "pollType"))
                    w.uint32(56).int32(m.pollType);
                if (m.correctAnswer != null && Object.hasOwnProperty.call(m, "correctAnswer"))
                    $root.proto.Message.PollCreationMessage.Option.encode(m.correctAnswer, w.uint32(66).fork()).ldelim();
                return w;
            };

            PollCreationMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollCreationMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.encKey = r.bytes();
                            break;
                        }
                    case 2: {
                            m.name = r.string();
                            break;
                        }
                    case 3: {
                            if (!(m.options && m.options.length))
                                m.options = [];
                            m.options.push($root.proto.Message.PollCreationMessage.Option.decode(r, r.uint32()));
                            break;
                        }
                    case 4: {
                            m.selectableOptionsCount = r.uint32();
                            break;
                        }
                    case 5: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    case 6: {
                            m.pollContentType = r.int32();
                            break;
                        }
                    case 7: {
                            m.pollType = r.int32();
                            break;
                        }
                    case 8: {
                            m.correctAnswer = $root.proto.Message.PollCreationMessage.Option.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PollCreationMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PollCreationMessage";
            };

            PollCreationMessage.Option = (function() {

                function Option(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                Option.prototype.optionName = "";
                Option.prototype.optionHash = "";

                Option.create = function create(properties) {
                    return new Option(properties);
                };

                Option.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.optionName != null && Object.hasOwnProperty.call(m, "optionName"))
                        w.uint32(10).string(m.optionName);
                    if (m.optionHash != null && Object.hasOwnProperty.call(m, "optionHash"))
                        w.uint32(18).string(m.optionHash);
                    return w;
                };

                Option.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollCreationMessage.Option();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.optionName = r.string();
                                break;
                            }
                        case 2: {
                                m.optionHash = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                Option.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PollCreationMessage.Option";
                };

                return Option;
            })();

            PollCreationMessage.PollType = (function() {
                const valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "POLL"] = 0;
                values[valuesById[1] = "QUIZ"] = 1;
                return values;
            })();

            return PollCreationMessage;
        })();

        Message.PollEncValue = (function() {

            function PollEncValue(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PollEncValue.prototype.encPayload = $util.newBuffer([]);
            PollEncValue.prototype.encIv = $util.newBuffer([]);

            PollEncValue.create = function create(properties) {
                return new PollEncValue(properties);
            };

            PollEncValue.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.encPayload != null && Object.hasOwnProperty.call(m, "encPayload"))
                    w.uint32(10).bytes(m.encPayload);
                if (m.encIv != null && Object.hasOwnProperty.call(m, "encIv"))
                    w.uint32(18).bytes(m.encIv);
                return w;
            };

            PollEncValue.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollEncValue();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.encPayload = r.bytes();
                            break;
                        }
                    case 2: {
                            m.encIv = r.bytes();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PollEncValue.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PollEncValue";
            };

            return PollEncValue;
        })();

        Message.PollResultSnapshotMessage = (function() {

            function PollResultSnapshotMessage(p) {
                this.pollVotes = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PollResultSnapshotMessage.prototype.name = "";
            PollResultSnapshotMessage.prototype.pollVotes = $util.emptyArray;
            PollResultSnapshotMessage.prototype.contextInfo = null;

            PollResultSnapshotMessage.create = function create(properties) {
                return new PollResultSnapshotMessage(properties);
            };

            PollResultSnapshotMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
                    w.uint32(10).string(m.name);
                if (m.pollVotes != null && m.pollVotes.length) {
                    for (var i = 0; i < m.pollVotes.length; ++i)
                        $root.proto.Message.PollResultSnapshotMessage.PollVote.encode(m.pollVotes[i], w.uint32(18).fork()).ldelim();
                }
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(26).fork()).ldelim();
                return w;
            };

            PollResultSnapshotMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollResultSnapshotMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.name = r.string();
                            break;
                        }
                    case 2: {
                            if (!(m.pollVotes && m.pollVotes.length))
                                m.pollVotes = [];
                            m.pollVotes.push($root.proto.Message.PollResultSnapshotMessage.PollVote.decode(r, r.uint32()));
                            break;
                        }
                    case 3: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PollResultSnapshotMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PollResultSnapshotMessage";
            };

            PollResultSnapshotMessage.PollVote = (function() {

                function PollVote(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                PollVote.prototype.optionName = "";
                PollVote.prototype.optionVoteCount = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

                PollVote.create = function create(properties) {
                    return new PollVote(properties);
                };

                PollVote.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.optionName != null && Object.hasOwnProperty.call(m, "optionName"))
                        w.uint32(10).string(m.optionName);
                    if (m.optionVoteCount != null && Object.hasOwnProperty.call(m, "optionVoteCount"))
                        w.uint32(16).int64(m.optionVoteCount);
                    return w;
                };

                PollVote.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollResultSnapshotMessage.PollVote();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.optionName = r.string();
                                break;
                            }
                        case 2: {
                                m.optionVoteCount = r.int64();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                PollVote.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.PollResultSnapshotMessage.PollVote";
                };

                return PollVote;
            })();

            return PollResultSnapshotMessage;
        })();

        Message.PollUpdateMessage = (function() {

            function PollUpdateMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PollUpdateMessage.prototype.pollCreationMessageKey = null;
            PollUpdateMessage.prototype.vote = null;
            PollUpdateMessage.prototype.metadata = null;
            PollUpdateMessage.prototype.senderTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            PollUpdateMessage.create = function create(properties) {
                return new PollUpdateMessage(properties);
            };

            PollUpdateMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.pollCreationMessageKey != null && Object.hasOwnProperty.call(m, "pollCreationMessageKey"))
                    $root.proto.MessageKey.encode(m.pollCreationMessageKey, w.uint32(10).fork()).ldelim();
                if (m.vote != null && Object.hasOwnProperty.call(m, "vote"))
                    $root.proto.Message.PollEncValue.encode(m.vote, w.uint32(18).fork()).ldelim();
                if (m.metadata != null && Object.hasOwnProperty.call(m, "metadata"))
                    $root.proto.Message.PollUpdateMessageMetadata.encode(m.metadata, w.uint32(26).fork()).ldelim();
                if (m.senderTimestampMs != null && Object.hasOwnProperty.call(m, "senderTimestampMs"))
                    w.uint32(32).int64(m.senderTimestampMs);
                return w;
            };

            PollUpdateMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollUpdateMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.pollCreationMessageKey = $root.proto.MessageKey.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.vote = $root.proto.Message.PollEncValue.decode(r, r.uint32());
                            break;
                        }
                    case 3: {
                            m.metadata = $root.proto.Message.PollUpdateMessageMetadata.decode(r, r.uint32());
                            break;
                        }
                    case 4: {
                            m.senderTimestampMs = r.int64();
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PollUpdateMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PollUpdateMessage";
            };

            return PollUpdateMessage;
        })();

        Message.PollUpdateMessageMetadata = (function() {

            function PollUpdateMessageMetadata(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PollUpdateMessageMetadata.create = function create(properties) {
                return new PollUpdateMessageMetadata(properties);
            };

            PollUpdateMessageMetadata.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                return w;
            };

            PollUpdateMessageMetadata.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollUpdateMessageMetadata();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PollUpdateMessageMetadata.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PollUpdateMessageMetadata";
            };

            return PollUpdateMessageMetadata;
        })();

        Message.PollVoteMessage = (function() {

            function PollVoteMessage(p) {
                this.selectedOptions = [];
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            PollVoteMessage.prototype.selectedOptions = $util.emptyArray;

            PollVoteMessage.create = function create(properties) {
                return new PollVoteMessage(properties);
            };

            PollVoteMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.selectedOptions != null && m.selectedOptions.length) {
                    for (var i = 0; i < m.selectedOptions.length; ++i)
                        w.uint32(10).bytes(m.selectedOptions[i]);
                }
                return w;
            };

            PollVoteMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.PollVoteMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            if (!(m.selectedOptions && m.selectedOptions.length))
                                m.selectedOptions = [];
                            m.selectedOptions.push(r.bytes());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            PollVoteMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.PollVoteMessage";
            };

            return PollVoteMessage;
        })();

        Message.ProductMessage = (function() {

            function ProductMessage(p) {
                if (p)
                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                        if (p[ks[i]] != null)
                            this[ks[i]] = p[ks[i]];
            }

            ProductMessage.prototype.product = null;
            ProductMessage.prototype.businessOwnerJid = "";
            ProductMessage.prototype.catalog = null;
            ProductMessage.prototype.body = "";
            ProductMessage.prototype.footer = "";
            ProductMessage.prototype.contextInfo = null;

            ProductMessage.create = function create(properties) {
                return new ProductMessage(properties);
            };

            ProductMessage.encode = function encode(m, w) {
                if (!w)
                    w = $Writer.create();
                if (m.product != null && Object.hasOwnProperty.call(m, "product"))
                    $root.proto.Message.ProductMessage.ProductSnapshot.encode(m.product, w.uint32(10).fork()).ldelim();
                if (m.businessOwnerJid != null && Object.hasOwnProperty.call(m, "businessOwnerJid"))
                    w.uint32(18).string(m.businessOwnerJid);
                if (m.catalog != null && Object.hasOwnProperty.call(m, "catalog"))
                    $root.proto.Message.ProductMessage.CatalogSnapshot.encode(m.catalog, w.uint32(34).fork()).ldelim();
                if (m.body != null && Object.hasOwnProperty.call(m, "body"))
                    w.uint32(42).string(m.body);
                if (m.footer != null && Object.hasOwnProperty.call(m, "footer"))
                    w.uint32(50).string(m.footer);
                if (m.contextInfo != null && Object.hasOwnProperty.call(m, "contextInfo"))
                    $root.proto.ContextInfo.encode(m.contextInfo, w.uint32(138).fork()).ldelim();
                return w;
            };

            ProductMessage.decode = function decode(r, l, e) {
                if (!(r instanceof $Reader))
                    r = $Reader.create(r);
                var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ProductMessage();
                while (r.pos < c) {
                    var t = r.uint32();
                    if (t === e)
                        break;
                    switch (t >>> 3) {
                    case 1: {
                            m.product = $root.proto.Message.ProductMessage.ProductSnapshot.decode(r, r.uint32());
                            break;
                        }
                    case 2: {
                            m.businessOwnerJid = r.string();
                            break;
                        }
                    case 4: {
                            m.catalog = $root.proto.Message.ProductMessage.CatalogSnapshot.decode(r, r.uint32());
                            break;
                        }
                    case 5: {
                            m.body = r.string();
                            break;
                        }
                    case 6: {
                            m.footer = r.string();
                            break;
                        }
                    case 17: {
                            m.contextInfo = $root.proto.ContextInfo.decode(r, r.uint32());
                            break;
                        }
                    default:
                        r.skipType(t & 7);
                        break;
                    }
                }
                return m;
            };

            ProductMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                if (typeUrlPrefix === undefined) {
                    typeUrlPrefix = "type.googleapis.com";
                }
                return typeUrlPrefix + "/proto.Message.ProductMessage";
            };

            ProductMessage.CatalogSnapshot = (function() {

                function CatalogSnapshot(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                CatalogSnapshot.prototype.catalogImage = null;
                CatalogSnapshot.prototype.title = "";
                CatalogSnapshot.prototype.description = "";

                CatalogSnapshot.create = function create(properties) {
                    return new CatalogSnapshot(properties);
                };

                CatalogSnapshot.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.catalogImage != null && Object.hasOwnProperty.call(m, "catalogImage"))
                        $root.proto.Message.ImageMessage.encode(m.catalogImage, w.uint32(10).fork()).ldelim();
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(18).string(m.title);
                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                        w.uint32(26).string(m.description);
                    return w;
                };

                CatalogSnapshot.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ProductMessage.CatalogSnapshot();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.catalogImage = $root.proto.Message.ImageMessage.decode(r, r.uint32());
                                break;
                            }
                        case 2: {
                                m.title = r.string();
                                break;
                            }
                        case 3: {
                                m.description = r.string();
                                break;
                            }
                        default:
                            r.skipType(t & 7);
                            break;
                        }
                    }
                    return m;
                };

                CatalogSnapshot.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                    if (typeUrlPrefix === undefined) {
                        typeUrlPrefix = "type.googleapis.com";
                    }
                    return typeUrlPrefix + "/proto.Message.ProductMessage.CatalogSnapshot";
                };

                return CatalogSnapshot;
            })();

            ProductMessage.ProductSnapshot = (function() {

                function ProductSnapshot(p) {
                    if (p)
                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                            if (p[ks[i]] != null)
                                this[ks[i]] = p[ks[i]];
                }

                ProductSnapshot.prototype.productImage = null;
                ProductSnapshot.prototype.productId = "";
                ProductSnapshot.prototype.title = "";
                ProductSnapshot.prototype.description = "";
                ProductSnapshot.prototype.currencyCode = "";
                ProductSnapshot.prototype.priceAmount1000 = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
                ProductSnapshot.prototype.retailerId = "";
                ProductSnapshot.prototype.url = "";
                ProductSnapshot.prototype.productImageCount = 0;
                ProductSnapshot.prototype.firstImageId = "";
                ProductSnapshot.prototype.salePriceAmount1000 = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
                ProductSnapshot.prototype.signedUrl = "";

                ProductSnapshot.create = function create(properties) {
                    return new ProductSnapshot(properties);
                };

                ProductSnapshot.encode = function encode(m, w) {
                    if (!w)
                        w = $Writer.create();
                    if (m.productImage != null && Object.hasOwnProperty.call(m, "productImage"))
                        $root.proto.Message.ImageMessage.encode(m.productImage, w.uint32(10).fork()).ldelim();
                    if (m.productId != null && Object.hasOwnProperty.call(m, "productId"))
                        w.uint32(18).string(m.productId);
                    if (m.title != null && Object.hasOwnProperty.call(m, "title"))
                        w.uint32(26).string(m.title);
                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
                        w.uint32(34).string(m.description);
                    if (m.currencyCode != null && Object.hasOwnProperty.call(m, "currencyCode"))
                        w.uint32(42).string(m.currencyCode);
                    if (m.priceAmount1000 != null && Object.hasOwnProperty.call(m, "priceAmount1000"))
                        w.uint32(48).int64(m.priceAmount1000);
                    if (m.retailerId != null && Object.hasOwnProperty.call(m, "retailerId"))
                        w.uint32(58).string(m.retailerId);
                    if (m.url != null && Object.hasOwnProperty.call(m, "url"))
                        w.uint32(66).string(m.url);
                    if (m.productImageCount != null && Object.hasOwnProperty.call(m, "productImageCount"))
                        w.uint32(72).uint32(m.productImageCount);
                    if (m.firstImageId != null && Object.hasOwnProperty.call(m, "firstImageId"))
                        w.uint32(90).string(m.firstImageId);
                    if (m.salePriceAmount1000 != null && Object.hasOwnProperty.call(m, "salePriceAmount1000"))
                        w.uint32(96).int64(m.salePriceAmount1000);
                    if (m.signedUrl != null && Object.hasOwnProperty.call(m, "signedUrl"))
                        w.uint32(106).string(m.signedUrl);
                    return w;
                };

                ProductSnapshot.decode = function decode(r, l, e) {
                    if (!(r instanceof $Reader))
                        r = $Reader.create(r);
                    var c = l === undefined ? r.len : r.pos + l, m = new $root.proto.Message.ProductMessage.ProductSnapshot();
                    while (r.pos < c) {
                        var t = r.uint32();
                        if (t === e)
                            break;
                        switch (t >>> 3) {
                        case 1: {
                                m.productImage = $root.proto.Message.ImageMessage.decode(r, r.uint32());
                                break;
                            }
                        case 2: {
                                m.productId = r.string();
                                break;
                            }
                        case 3: {
                